/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.lib.adb.command.parser;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import com.google.common.io.LineProcessor;
import com.google.testing.platform.lib.adb.command.parser.ExecutedTest;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InstrumentationTestRunnerProcessor
implements LineProcessor<List<ExecutedTest>> {
    public static final String INSTRUMENTATION_CODE = "INSTRUMENTATION_CODE:";
    public static final String INSTRUMENTATION_STATUS = "INSTRUMENTATION_STATUS:";
    public static final String INSTRUMENTATION_PREFIX = "INSTRUMENTATION_";
    public static final String INSTRUMENTATION_RESULT = "INSTRUMENTATION_RESULT:";
    public static final String RESULT_STREAM = "INSTRUMENTATION_RESULT: stream=";
    public static final String STATUS_CLASS = "INSTRUMENTATION_STATUS: class=";
    public static final String STATUS_CODE = "INSTRUMENTATION_STATUS_CODE: ";
    public static final String STATUS_CURRENT = "INSTRUMENTATION_STATUS: current=";
    public static final String STATUS_ID = "INSTRUMENTATION_STATUS: id=";
    public static final String STATUS_NUMTESTS = "INSTRUMENTATION_STATUS: numtests=";
    public static final String STATUS_STACK = "INSTRUMENTATION_STATUS: stack=";
    public static final String STATUS_STREAM = "INSTRUMENTATION_STATUS: stream=";
    public static final String STATUS_TEST = "INSTRUMENTATION_STATUS: test=";
    public static final String INSTRUMENTATION_PROCESS_CRASHED = "Test instrumentation process crashed.";
    private static final Pattern INSTRUMENTATION_PROCESS_CRASH_ERROR_PATTERN = Pattern.compile("Check (\\w.*)#(\\w*).txt");
    private ExecutedTest.Builder currentTest = null;
    private final List<ExecutedTest> executedTests = Lists.newArrayList();
    private boolean isInResultsStream = false;
    private boolean isInStack = false;
    private boolean isInStatusStream = false;
    private static final Logger logger = Logger.getLogger(InstrumentationTestRunnerProcessor.class.getName());
    private final EventBus eventBus;

    public InstrumentationTestRunnerProcessor(EventBus eventBus) {
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
    }

    public List<ExecutedTest> getResult() {
        return this.executedTests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean processLine(String line) {
        if (null == this.currentTest) {
            this.currentTest = ExecutedTest.builder();
        }
        if ((this.isInStack || this.isInStatusStream || this.isInResultsStream) && line.startsWith(INSTRUMENTATION_PREFIX)) {
            if (this.isInStack) {
                this.isInStack = false;
            }
            if (this.isInStatusStream) {
                this.isInStatusStream = false;
            }
            if (this.isInResultsStream) {
                this.isInResultsStream = false;
            }
        }
        if (line.startsWith(STATUS_ID)) {
            this.currentTest.setId(line.replace(STATUS_ID, ""));
            this.currentTest.appendAllLines(line);
            return true;
        }
        this.currentTest.appendAllLines(line);
        if (this.isInStack || line.startsWith(STATUS_STACK)) {
            String prefixStrippedLine = line.replace(STATUS_STACK, "");
            this.currentTest.appendStackTrace(prefixStrippedLine);
            this.isInStack = true;
            if (!line.startsWith(STATUS_STACK)) return true;
            this.checkAndHandleInstrumentationProcessCrash(prefixStrippedLine);
            return true;
        }
        if (this.isInStatusStream || line.startsWith(STATUS_STREAM)) {
            this.currentTest.appendStatusStream(line.replace(STATUS_STREAM, ""));
            this.isInStatusStream = true;
            return true;
        }
        if (this.isInResultsStream || line.startsWith(RESULT_STREAM)) {
            this.currentTest.appendResultStream(line.replace(RESULT_STREAM, ""));
            this.isInResultsStream = true;
            return true;
        }
        if (line.startsWith(INSTRUMENTATION_RESULT)) {
            this.currentTest.appendResultStream(line.replace(INSTRUMENTATION_RESULT, ""));
            return true;
        }
        if (line.startsWith(STATUS_CODE)) {
            String statusCode = line.replace(STATUS_CODE, "").trim();
            int statusInt = Integer.parseInt(statusCode);
            try {
                switch (statusInt) {
                    case 1: {
                        this.currentTest.setStatus(ExecutedTest.Status.STARTED);
                        return true;
                    }
                    case 0: {
                        this.currentTest.setStatus(ExecutedTest.Status.PASSED);
                        return true;
                    }
                    case -1: {
                        this.currentTest.setStatus(ExecutedTest.Status.ERROR);
                        return true;
                    }
                    case -2: {
                        this.currentTest.setStatus(ExecutedTest.Status.FAILED);
                        return true;
                    }
                    case -3: {
                        this.currentTest.setStatus(ExecutedTest.Status.IGNORED);
                        return true;
                    }
                    case -4: {
                        this.currentTest.setStatus(ExecutedTest.Status.ASSUMPTION_FAILURE);
                        return true;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("Illegal test instrumentation code: \"%s\"", statusCode));
                    }
                }
            }
            finally {
                if (statusInt == 1) {
                    this.onTestStart(this.currentTest.build());
                } else {
                    this.onTestFinished(this.currentTest.build());
                }
                this.currentTest = null;
            }
        }
        if (line.startsWith(STATUS_NUMTESTS)) {
            this.currentTest.setNumTests(line.replace(STATUS_NUMTESTS, ""));
            return true;
        }
        if (line.startsWith(STATUS_CLASS)) {
            this.currentTest.setTestClass(line.replace(STATUS_CLASS, ""));
            return true;
        }
        if (line.startsWith(STATUS_CURRENT)) {
            this.currentTest.setCurrentTest(line.replace(STATUS_CURRENT, ""));
            return true;
        }
        if (line.startsWith(STATUS_TEST)) {
            this.currentTest.setTestMethod(line.replace(STATUS_TEST, ""));
            return true;
        }
        if (line.startsWith(INSTRUMENTATION_CODE)) {
            return true;
        }
        if (line.contains("Killed")) {
            return true;
        }
        if (line.isEmpty()) {
            return true;
        }
        logger.severe("Line not handled by the parser:\n" + line);
        return true;
    }

    private void checkAndHandleInstrumentationProcessCrash(String line) {
        Matcher matcher;
        if (this.isInStack && line.startsWith(INSTRUMENTATION_PROCESS_CRASHED) && (matcher = INSTRUMENTATION_PROCESS_CRASH_ERROR_PATTERN.matcher(line)).find()) {
            this.currentTest.setTestClass(matcher.group(1));
            this.currentTest.setTestMethod(matcher.group(2));
        }
    }

    private void onTestFinished(ExecutedTest executedTest) {
        this.executedTests.add(executedTest);
        this.eventBus.post((Object)executedTest);
    }

    private void onTestStart(ExecutedTest executedTest) {
        this.executedTests.add(executedTest);
        this.eventBus.post((Object)executedTest);
    }

    public void register(Object object) {
        this.eventBus.register(object);
    }

    public void unregister(Object object) {
        this.eventBus.unregister(object);
    }
}

