/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.lib.adb.command.parser;

import com.google.auto.value.AutoValue;
import com.google.testing.platform.lib.adb.command.parser.AutoValue_ExecutedTest;
import java.util.Objects;
import javax.annotation.Nullable;

@AutoValue
public abstract class ExecutedTest {
    ExecutedTest() {
    }

    public abstract String getAllLines();

    @Nullable
    public abstract String getCurrentTest();

    @Nullable
    public abstract String getNumTests();

    @Nullable
    public abstract String getId();

    public abstract String getStackTrace();

    @Nullable
    public abstract Status getStatus();

    @Nullable
    public abstract String getTestClass();

    @Nullable
    public abstract String getTestMethod();

    public abstract String getTestResult();

    public abstract String getTestStatusStream();

    public final boolean equals(Object other) {
        if (!(other instanceof ExecutedTest)) {
            return false;
        }
        ExecutedTest otherExecutedTest = (ExecutedTest)other;
        return Objects.equals(this.getCurrentTest(), otherExecutedTest.getCurrentTest()) && Objects.equals(this.getNumTests(), otherExecutedTest.getNumTests()) && Objects.equals(this.getId(), otherExecutedTest.getId()) && Objects.equals(this.getStackTrace(), otherExecutedTest.getStackTrace()) && Objects.equals((Object)this.getStatus(), (Object)otherExecutedTest.getStatus()) && Objects.equals(this.getTestClass(), otherExecutedTest.getTestClass()) && Objects.equals(this.getTestMethod(), otherExecutedTest.getTestMethod()) && Objects.equals(this.getTestStatusStream(), otherExecutedTest.getTestStatusStream());
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.getCurrentTest(), this.getNumTests(), this.getId(), this.getStackTrace(), this.getStatus(), this.getTestClass(), this.getTestMethod(), this.getTestStatusStream()});
    }

    public static Builder builder() {
        return new AutoValue_ExecutedTest.Builder().setId(null).setCurrentTest(null).setNumTests(null).setTestClass(null).setTestMethod(null);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        private final StringBuilder allLinesBuilder = new StringBuilder();
        private final StringBuilder testResultBuilder = new StringBuilder();
        private final StringBuilder stackTraceBuilder = new StringBuilder();
        private final StringBuilder testStatusStreamBuilder = new StringBuilder();

        public abstract Builder setId(@Nullable String var1);

        public abstract Builder setCurrentTest(@Nullable String var1);

        public abstract Builder setNumTests(@Nullable String var1);

        public abstract Builder setTestClass(@Nullable String var1);

        public abstract Builder setTestMethod(@Nullable String var1);

        abstract Builder setAllLines(String var1);

        abstract Builder setTestResult(String var1);

        abstract Builder setStackTrace(String var1);

        abstract Builder setTestStatusStream(String var1);

        public Builder appendAllLines(String allLines) {
            Builder.appendToStringBuilder(this.allLinesBuilder, allLines);
            return this;
        }

        public Builder appendResultStream(String testResult) {
            Builder.appendToStringBuilder(this.testResultBuilder, testResult);
            return this;
        }

        public Builder appendStackTrace(String stackTrace) {
            Builder.appendToStringBuilder(this.stackTraceBuilder, stackTrace);
            return this;
        }

        public Builder appendStatusStream(String testStatusStream) {
            Builder.appendToStringBuilder(this.testStatusStreamBuilder, testStatusStream);
            return this;
        }

        public abstract Builder setStatus(@Nullable Status var1);

        public abstract ExecutedTest autoBuild();

        public ExecutedTest build() {
            this.setAllLines(this.allLinesBuilder.toString());
            this.setTestResult(this.testResultBuilder.toString());
            this.setStackTrace(this.stackTraceBuilder.toString());
            this.setTestStatusStream(this.testStatusStreamBuilder.toString());
            return this.autoBuild();
        }

        private static void appendToStringBuilder(StringBuilder sb, String text) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(text);
        }
    }

    public static enum Status {
        ERROR,
        FAILED,
        PASSED,
        STARTED,
        IGNORED,
        ASSUMPTION_FAILURE;

    }
}

