/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.lib.adb.command.parser;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.LineProcessor;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AndroidPropertyProcessor
implements LineProcessor<ImmutableMap<String, String>> {
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("^\\[([\\w.\\-]+)\\]:\\s\\[(.*)\\]$");
    private static final Logger logger = Logger.getLogger(AndroidPropertyProcessor.class.getName());
    private final Map<String, String> properties = Maps.newHashMap();

    public boolean processLine(String line) {
        Matcher matcher = PROPERTY_PATTERN.matcher(line.trim());
        if (matcher.matches()) {
            this.properties.put(matcher.group(1), matcher.group(2));
        } else {
            logger.warning(String.format("Line '%s' doesnt match regexp '%s'. Discarding.", line, PROPERTY_PATTERN));
        }
        return true;
    }

    public ImmutableMap<String, String> getResult() {
        return ImmutableMap.copyOf(this.properties);
    }
}

