/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.lib.adb.command.io;

import com.google.testing.platform.lib.adb.command.inject.AdbConfig;
import com.google.testing.platform.lib.adb.command.io.LogWriter;
import com.google.testing.platform.lib.adb.command.io.LogWriterException;
import com.google.testing.platform.lib.adb.command.io.OutputsLogWriterKt;
import com.google.testing.platform.lib.logging.jvm.LoggerExtKt;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/google/testing/platform/lib/adb/command/io/OutputsLogWriter;", "Lcom/google/testing/platform/lib/adb/command/io/LogWriter;", "config", "Lcom/google/testing/platform/lib/adb/command/inject/AdbConfig;", "(Lcom/google/testing/platform/lib/adb/command/inject/AdbConfig;)V", "logPath", "Ljava/io/File;", "getLogPath", "()Ljava/io/File;", "write", "", "lines", "", "Companion", "lib_java_com_google_testing_platform_lib_adb_command_io-outputs_log_writer"})
public final class OutputsLogWriter
implements LogWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File logPath;
    @NotNull
    private static final Logger logger = LoggerExtKt.getLogger(Companion);

    @Inject
    public OutputsLogWriter(@NotNull AdbConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.logPath = new File(config.getTestOutputPath());
    }

    @Override
    @NotNull
    public File getLogPath() {
        return this.logPath;
    }

    @Override
    public void write(@NotNull String lines) {
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        try {
            if (this.getLogPath().exists()) {
                FilesKt.appendText$default((File)this.getLogPath(), (String)(lines + '\n'), null, (int)2, null);
            } else {
                if (!OutputsLogWriterKt.access$ensureDirectoryExists(this.getLogPath())) {
                    logger.warning("Failed to ensure directory exists for path: " + this.getLogPath());
                }
                FilesKt.writeText$default((File)this.getLogPath(), (String)(lines + '\n'), null, (int)2, null);
            }
        }
        catch (IOException ioe) {
            throw new LogWriterException("Failed to write to log: " + this.getLogPath(), ioe);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lcom/google/testing/platform/lib/adb/command/io/OutputsLogWriter$Companion;", "", "()V", "logger", "Ljava/util/logging/Logger;", "getLogger$annotations", "lib_java_com_google_testing_platform_lib_adb_command_io-outputs_log_writer"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLogger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

