/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.platform.lib.adb.command;

import com.google.testing.platform.api.device.CommandResult;
import com.google.testing.platform.lib.adb.command.AdbCommandException;
import com.google.testing.platform.lib.adb.command.DeviceCommandExecutor;
import com.google.testing.platform.lib.adb.command.DeviceEnvVars;
import com.google.testing.platform.lib.adb.command.GetDeviceEnvVariablesCmd;
import com.google.testing.platform.lib.adb.command.parser.ShellVariableParser;
import com.google.testing.platform.lib.logging.jvm.LoggerExtKt;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/google/testing/platform/lib/adb/command/GetDeviceEnvVariablesCmdImpl;", "Lcom/google/testing/platform/lib/adb/command/GetDeviceEnvVariablesCmd;", "commandExecutor", "Lcom/google/testing/platform/lib/adb/command/DeviceCommandExecutor;", "parser", "Lcom/google/testing/platform/lib/adb/command/parser/ShellVariableParser;", "(Lcom/google/testing/platform/lib/adb/command/DeviceCommandExecutor;Lcom/google/testing/platform/lib/adb/command/parser/ShellVariableParser;)V", "execute", "Lcom/google/testing/platform/lib/adb/command/DeviceEnvVars;", "timeout", "Ljava/time/Duration;", "Companion", "lib_java_com_google_testing_platform_lib_adb_command-get_device_env_variables_cmd"})
public final class GetDeviceEnvVariablesCmdImpl
implements GetDeviceEnvVariablesCmd {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DeviceCommandExecutor commandExecutor;
    @NotNull
    private final ShellVariableParser parser;
    @NotNull
    private static final Logger logger = LoggerExtKt.getLogger(Companion);

    @Inject
    public GetDeviceEnvVariablesCmdImpl(@NotNull DeviceCommandExecutor commandExecutor, @NotNull ShellVariableParser parser) {
        Intrinsics.checkNotNullParameter((Object)commandExecutor, (String)"commandExecutor");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        this.commandExecutor = commandExecutor;
        this.parser = parser;
    }

    @Override
    @NotNull
    public DeviceEnvVars execute(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        String[] stringArray = new String[]{"shell", "printenv"};
        CommandResult commandResult = this.commandExecutor.execute(stringArray, timeout);
        int exitCode = commandResult.component1();
        List output = commandResult.component2();
        if (exitCode != 0) {
            throw new AdbCommandException(StringsKt.trimMargin$default((String)("Adb printenv command failed.\n        |Exit Code: " + exitCode + "\"\n        |Output: " + output + "\n        |"), null, (int)1, null), null, 2, null);
        }
        Map deviceVariables = (Map)this.parser.from(output);
        return new DeviceEnvVars(deviceVariables, exitCode);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lcom/google/testing/platform/lib/adb/command/GetDeviceEnvVariablesCmdImpl$Companion;", "", "()V", "logger", "Ljava/util/logging/Logger;", "getLogger$annotations", "lib_java_com_google_testing_platform_lib_adb_command-get_device_env_variables_cmd"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLogger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

