/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers.impl;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.sequentialparsers.LocalParsingResult;
import org.intellij.markdown.parser.sequentialparsers.RangesListBuilder;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.intellij.markdown.parser.sequentialparsers.impl.InlineLinkParser;
import org.intellij.markdown.parser.sequentialparsers.impl.ReferenceLinkParser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/intellij/markdown/parser/sequentialparsers/impl/ImageParser;", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser;", "()V", "parse", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$ParsingResult;", "tokens", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "rangesToGlue", "", "Lkotlin/ranges/IntRange;", "markdown"})
public final class ImageParser
implements SequentialParser {
    @Override
    @NotNull
    public SequentialParser.ParsingResult parse(@NotNull TokensCache tokens, @NotNull List<IntRange> rangesToGlue) {
        Intrinsics.checkNotNullParameter(tokens, "tokens");
        Intrinsics.checkNotNullParameter(rangesToGlue, "rangesToGlue");
        SequentialParser.ParsingResultBuilder result = new SequentialParser.ParsingResultBuilder();
        RangesListBuilder delegateIndices = new RangesListBuilder();
        TokensCache.Iterator iterator2 = new TokensCache.RangesListIterator(tokens, rangesToGlue);
        while (iterator2.getType() != null) {
            if (Intrinsics.areEqual(iterator2.getType(), MarkdownTokenTypes.EXCLAMATION_MARK) && Intrinsics.areEqual(iterator2.rawLookup(1), MarkdownTokenTypes.LBRACKET)) {
                LocalParsingResult link;
                LocalParsingResult localParsingResult = InlineLinkParser.Companion.parseInlineLink(iterator2.advance());
                if (localParsingResult == null) {
                    localParsingResult = ReferenceLinkParser.Companion.parseReferenceLink(iterator2.advance());
                }
                if ((link = localParsingResult) != null) {
                    result = result.withNode(new SequentialParser.Node(new IntRange(iterator2.getIndex(), link.getIteratorPosition().getIndex() + 1), MarkdownElementTypes.IMAGE)).withOtherParsingResult(link);
                    iterator2 = link.getIteratorPosition().advance();
                    continue;
                }
            }
            delegateIndices.put(iterator2.getIndex());
            iterator2 = iterator2.advance();
        }
        return result.withFurtherProcessing(delegateIndices.get());
    }
}

