/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005R\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0014\u0010\u0014\u001a\u00020\u000b2\n\u0010\u0015\u001a\u00060\u0016R\u00020\u0017H$J\u001c\u0010\u0018\u001a\u00020\u000f2\n\u0010\u0015\u001a\u00060\u0016R\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0003H$J\u0006\u0010\u001a\u001a\u00020\u0003J\b\u0010\u001b\u001a\u00020\u0013H$J\b\u0010\u001c\u001a\u00020\u001dH&J\u0012\u0010\u001e\u001a\u00020\u000b2\n\u0010\u0015\u001a\u00060\u0016R\u00020\u0017J\u001a\u0010\u001f\u001a\u00020\u000f2\n\u0010\u0015\u001a\u00060\u0016R\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0003J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000fH\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\u00060\u0005R\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/intellij/markdown/parser/markerblocks/MarkerBlockImpl;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "marker", "Lorg/intellij/markdown/parser/ProductionHolder$Marker;", "Lorg/intellij/markdown/parser/ProductionHolder;", "(Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Lorg/intellij/markdown/parser/ProductionHolder$Marker;)V", "getConstraints", "()Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "lastInterestingOffset", "", "getMarker", "()Lorg/intellij/markdown/parser/ProductionHolder$Marker;", "scheduledResult", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ProcessingResult;", "acceptAction", "", "action", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ClosingAction;", "calcNextInterestingOffset", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "doProcessToken", "currentConstraints", "getBlockConstraints", "getDefaultAction", "getDefaultNodeType", "Lorg/intellij/markdown/IElementType;", "getNextInterestingOffset", "processToken", "scheduleProcessingResult", "", "offset", "result", "markdown"})
public abstract class MarkerBlockImpl
implements MarkerBlock {
    @NotNull
    private final MarkdownConstraints constraints;
    @NotNull
    private final ProductionHolder.Marker marker;
    private int lastInterestingOffset;
    @Nullable
    private MarkerBlock.ProcessingResult scheduledResult;

    public MarkerBlockImpl(@NotNull MarkdownConstraints constraints, @NotNull ProductionHolder.Marker marker) {
        Intrinsics.checkNotNullParameter(constraints, "constraints");
        Intrinsics.checkNotNullParameter(marker, "marker");
        this.constraints = constraints;
        this.marker = marker;
        this.lastInterestingOffset = -2;
    }

    @NotNull
    protected final MarkdownConstraints getConstraints() {
        return this.constraints;
    }

    @NotNull
    protected final ProductionHolder.Marker getMarker() {
        return this.marker;
    }

    @Override
    public final int getNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        if (this.scheduledResult != null) {
            return pos.getOffset() + 1;
        }
        if (this.lastInterestingOffset != -1 && this.lastInterestingOffset <= pos.getOffset()) {
            this.lastInterestingOffset = this.calcNextInterestingOffset(pos);
        }
        return this.lastInterestingOffset;
    }

    @Override
    @NotNull
    public final MarkerBlock.ProcessingResult processToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(currentConstraints, "currentConstraints");
        if (this.lastInterestingOffset != pos.getOffset() && this.scheduledResult != null) {
            return MarkerBlock.ProcessingResult.Companion.getCANCEL();
        }
        if (this.lastInterestingOffset == -1 || this.lastInterestingOffset > pos.getOffset()) {
            return MarkerBlock.ProcessingResult.Companion.getPASS();
        }
        if (this.lastInterestingOffset < pos.getOffset() && !this.isInterestingOffset(pos)) {
            return MarkerBlock.ProcessingResult.Companion.getPASS();
        }
        if (this.scheduledResult != null) {
            MarkerBlock.ProcessingResult processingResult = this.scheduledResult;
            Intrinsics.checkNotNull(processingResult);
            return processingResult;
        }
        return this.doProcessToken(pos, currentConstraints);
    }

    @Override
    @NotNull
    public final MarkdownConstraints getBlockConstraints() {
        return this.constraints;
    }

    @Override
    public boolean acceptAction(@NotNull MarkerBlock.ClosingAction action) {
        Intrinsics.checkNotNullParameter((Object)action, "action");
        MarkerBlock.ClosingAction actionToRun = action;
        if (actionToRun == MarkerBlock.ClosingAction.DEFAULT) {
            actionToRun = this.getDefaultAction();
        }
        actionToRun.doAction(this.marker, this.getDefaultNodeType());
        return actionToRun != MarkerBlock.ClosingAction.NOTHING;
    }

    protected final void scheduleProcessingResult(int offset, @NotNull MarkerBlock.ProcessingResult result) {
        Intrinsics.checkNotNullParameter(result, "result");
        this.lastInterestingOffset = offset;
        this.scheduledResult = result;
    }

    @NotNull
    protected abstract MarkerBlock.ClosingAction getDefaultAction();

    @NotNull
    protected abstract MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position var1, @NotNull MarkdownConstraints var2);

    protected abstract int calcNextInterestingOffset(@NotNull LookaheadText.Position var1);

    @NotNull
    public abstract IElementType getDefaultNodeType();
}

