/*
 * Decompiled with CFR 0.152.
 */
package com.google.prefab.ndkbuild;

import com.google.prefab.api.Android;
import com.google.prefab.api.BuildSystemInterface;
import com.google.prefab.api.LibraryReference;
import com.google.prefab.api.Module;
import com.google.prefab.api.NoMatchingLibraryException;
import com.google.prefab.api.Package;
import com.google.prefab.api.PlatformDataInterface;
import com.google.prefab.api.PrebuiltLibrary;
import com.google.prefab.ndkbuild.DuplicateModuleNameException;
import com.google.prefab.ndkbuild.NdkBuildPluginKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J \u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J\u0016\u0010\u001a\u001a\u00020\r2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016J&\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u00062\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150\u001c2\u0006\u0010 \u001a\u00020\u0003H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lcom/google/prefab/ndkbuild/NdkBuildPlugin;", "Lcom/google/prefab/api/BuildSystemInterface;", "outputDirectory", "Ljava/io/File;", "packages", "", "Lcom/google/prefab/api/Package;", "(Ljava/io/File;Ljava/util/List;)V", "getOutputDirectory", "()Ljava/io/File;", "getPackages", "()Ljava/util/List;", "emitDependency", "", "dependency", "", "androidMk", "emitModule", "module", "Lcom/google/prefab/api/Module;", "requirement", "Lcom/google/prefab/api/Android;", "findReferredModule", "reference", "Lcom/google/prefab/api/LibraryReference;", "currentModule", "generate", "requirements", "", "Lcom/google/prefab/api/PlatformDataInterface;", "generatePackage", "pkg", "packageDirectory", "ndk-build-plugin"})
@SourceDebugExtension(value={"SMAP\nNdkBuildPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NdkBuildPlugin.kt\ncom/google/prefab/ndkbuild/NdkBuildPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,261:1\n800#2,11:262\n1045#2:273\n1#3:274\n*S KotlinDebug\n*F\n+ 1 NdkBuildPlugin.kt\ncom/google/prefab/ndkbuild/NdkBuildPlugin\n*L\n61#1:262,11\n113#1:273\n*E\n"})
public final class NdkBuildPlugin
implements BuildSystemInterface {
    @NotNull
    private final File outputDirectory;
    @NotNull
    private final List<Package> packages;

    public NdkBuildPlugin(@NotNull File outputDirectory, @NotNull List<Package> packages2) {
        Intrinsics.checkNotNullParameter(outputDirectory, "outputDirectory");
        Intrinsics.checkNotNullParameter(packages2, "packages");
        this.outputDirectory = outputDirectory;
        this.packages = packages2;
    }

    @Override
    @NotNull
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    @NotNull
    public List<Package> getPackages() {
        return this.packages;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void generate(@NotNull Collection<? extends PlatformDataInterface> requirements) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter(requirements, "requirements");
        Iterable $this$filterIsInstance$iv = requirements;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Android)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List androidRequirements = (List)destination$iv$iv;
        if (!Intrinsics.areEqual(androidRequirements, requirements)) {
            throw new UnsupportedOperationException("ndk-build only supports Android targets");
        }
        Map seenNames = new LinkedHashMap();
        for (Package pkg : this.getPackages()) {
            for (Module module : pkg.getModules()) {
                Module dupModule = (Module)seenNames.get(module.getName());
                if (dupModule != null) {
                    throw new DuplicateModuleNameException(module, dupModule);
                }
                seenNames.put(module.getName(), module);
            }
        }
        this.prepareOutputDirectory(this.getOutputDirectory());
        for (Package pkg : this.getPackages()) {
            File packageDir = FilesKt.resolve(this.getOutputDirectory(), pkg.getName());
            packageDir.mkdir();
            this.generatePackage(pkg, androidRequirements, packageDir);
        }
    }

    private final void generatePackage(Package pkg, Collection<Android> requirements, File packageDirectory) {
        File androidMk = FilesKt.resolve(packageDirectory, "Android.mk");
        FilesKt.writeText$default(androidMk, "LOCAL_PATH := $(call my-dir)\n\n", null, 2, null);
        for (Android requirement : requirements) {
            FilesKt.appendText$default(androidMk, StringsKt.trimIndent("\n                ifeq ($(TARGET_ARCH_ABI)," + requirement.getAbi().getTargetArchAbi() + ")\n\n\n                "), null, 2, null);
            Iterable $this$sortedBy$iv = pkg.getModules();
            boolean $i$f$sortedBy = false;
            for (Module module : CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Module it = (Module)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (Module)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getName()));
                }
            })) {
                this.emitModule(module, requirement, androidMk);
            }
            FilesKt.appendText$default(androidMk, StringsKt.trimIndent("\n                endif  # " + requirement.getAbi().getTargetArchAbi() + "\n\n\n                "), null, 2, null);
        }
        for (String dep : CollectionsKt.sorted((Iterable)pkg.getDependencies())) {
            this.emitDependency(dep, androidMk);
        }
    }

    private final void emitModule(Module module, Android requirement, File androidMk) {
        PrebuiltLibrary prebuilt;
        List ldLibs = new ArrayList();
        List sharedLibraries = new ArrayList();
        List staticLibraries = new ArrayList();
        for (LibraryReference reference : module.linkLibsForPlatform(requirement)) {
            if (reference instanceof LibraryReference.Literal) {
                ldLibs.add(((LibraryReference.Literal)reference).getArg());
                continue;
            }
            Module referredModule = this.findReferredModule(reference, module);
            if (referredModule.isHeaderOnly()) {
                staticLibraries.add(referredModule.getName());
                continue;
            }
            try {
                prebuilt = referredModule.getLibraryFor(requirement);
                File file2 = prebuilt.getPath().toFile();
                Intrinsics.checkNotNullExpressionValue(file2, "toFile(...)");
                String extension = FilesKt.getExtension(file2);
                if (Intrinsics.areEqual(extension, "so")) {
                    sharedLibraries.add(referredModule.getName());
                    continue;
                }
                if (Intrinsics.areEqual(extension, "a")) {
                    staticLibraries.add(referredModule.getName());
                    continue;
                }
                throw new RuntimeException("Unrecognized library extension: " + extension);
            }
            catch (NoMatchingLibraryException ex) {
                System.err.println("Skipping " + module.getCanonicalName() + " because it depends on an incompatible library:");
                System.err.print(ex);
                return;
            }
        }
        String exportLdLibs = ((Object)StringsKt.trimEnd((CharSequence)CollectionsKt.joinToString$default(ldLibs, " ", " ", null, 0, null, null, 60, null))).toString();
        String exportSharedLibraries = ((Object)StringsKt.trimEnd((CharSequence)CollectionsKt.joinToString$default(sharedLibraries, " ", " ", null, 0, null, null, 60, null))).toString();
        String exportStaticLibraries = ((Object)StringsKt.trimEnd((CharSequence)CollectionsKt.joinToString$default(staticLibraries, " ", " ", null, 0, null, null, 60, null))).toString();
        if (module.isHeaderOnly()) {
            String escapedHeaders = NdkBuildPluginKt.sanitize(module.getIncludePath());
            FilesKt.appendText$default(androidMk, StringsKt.trimIndent("\n                include $(CLEAR_VARS)\n                LOCAL_MODULE := " + module.getName() + "\n                LOCAL_EXPORT_C_INCLUDES := " + escapedHeaders + "\n                LOCAL_EXPORT_SHARED_LIBRARIES :=" + exportSharedLibraries + "\n                LOCAL_EXPORT_STATIC_LIBRARIES :=" + exportStaticLibraries + "\n                LOCAL_EXPORT_LDLIBS :=" + exportLdLibs + "\n                include $(BUILD_STATIC_LIBRARY)\n    \n    \n                "), null, 2, null);
        } else {
            try {
                String string;
                prebuilt = module.getLibraryFor(requirement);
                String escapedLibrary = NdkBuildPluginKt.sanitize(prebuilt.getPath());
                String escapedHeaders = NdkBuildPluginKt.sanitize(prebuilt.getIncludePath());
                File file3 = prebuilt.getPath().toFile();
                Intrinsics.checkNotNullExpressionValue(file3, "toFile(...)");
                String extension = FilesKt.getExtension(file3);
                if (Intrinsics.areEqual(extension, "so")) {
                    string = "PREBUILT_SHARED_LIBRARY";
                } else if (Intrinsics.areEqual(extension, "a")) {
                    string = "PREBUILT_STATIC_LIBRARY";
                } else {
                    throw new RuntimeException("Unrecognized library extension: " + extension);
                }
                String prebuiltType = string;
                FilesKt.appendText$default(androidMk, StringsKt.trimIndent("\n                    include $(CLEAR_VARS)\n                    LOCAL_MODULE := " + module.getName() + "\n                    LOCAL_SRC_FILES := " + escapedLibrary + "\n                    LOCAL_EXPORT_C_INCLUDES := " + escapedHeaders + "\n                    LOCAL_EXPORT_SHARED_LIBRARIES :=" + exportSharedLibraries + "\n                    LOCAL_EXPORT_STATIC_LIBRARIES :=" + exportStaticLibraries + "\n                    LOCAL_EXPORT_LDLIBS :=" + exportLdLibs + "\n                    include $(" + prebuiltType + ")\n\n\n                    "), null, 2, null);
            }
            catch (NoMatchingLibraryException ex) {
                System.err.println(ex);
            }
        }
    }

    private final void emitDependency(String dependency, File androidMk) {
        FilesKt.appendText$default(androidMk, StringsKt.trimIndent("\n            $(call import-module,prefab/" + dependency + ")\n\n            "), null, 2, null);
    }

    private final Module findReferredModule(LibraryReference reference, Module currentModule) {
        Module module;
        LibraryReference libraryReference = reference;
        if (libraryReference instanceof LibraryReference.Local) {
            List<Module> list;
            Object v0;
            Package it;
            block14: {
                Iterable iterable = this.getPackages();
                for (Object object : iterable) {
                    it = (Package)object;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getName(), currentModule.getPkg().getName())) continue;
                    v0 = object;
                    break block14;
                }
                v0 = null;
            }
            Package package_ = v0;
            if (package_ != null && (list = package_.getModules()) != null) {
                Package package_2;
                block15: {
                    Object object;
                    Iterable iterable = list;
                    object = iterable.iterator();
                    while (object.hasNext()) {
                        it = object.next();
                        Module it2 = (Module)((Object)it);
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it2.getName(), ((LibraryReference.Local)reference).getName())) continue;
                        package_2 = it;
                        break block15;
                    }
                    package_2 = null;
                }
                module = (Module)((Object)package_2);
            } else {
                module = null;
            }
        } else if (libraryReference instanceof LibraryReference.External) {
            List<Module> list;
            Object v3;
            block16: {
                Iterable iterable = this.getPackages();
                for (Object object : iterable) {
                    Package it = (Package)object;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getName(), ((LibraryReference.External)reference).getPkg())) continue;
                    v3 = object;
                    break block16;
                }
                v3 = null;
            }
            Package package_ = v3;
            if (package_ != null && (list = package_.getModules()) != null) {
                Object v4;
                block17: {
                    Object object;
                    Iterable iterable = list;
                    object = iterable.iterator();
                    while (object.hasNext()) {
                        Object e = object.next();
                        Module it = (Module)e;
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getName(), ((LibraryReference.External)reference).getModule())) continue;
                        v4 = e;
                        break block17;
                    }
                    v4 = null;
                }
                module = v4;
            } else {
                module = null;
            }
        } else {
            if (libraryReference instanceof LibraryReference.Literal) {
                throw new IllegalArgumentException("Literal library references do not have types");
            }
            throw new NoWhenBranchMatchedException();
        }
        if (module == null) {
            throw new RuntimeException("Could not find a module matching " + reference);
        }
        return module;
    }

    @Override
    public void prepareOutputDirectory(@NotNull File output2) {
        BuildSystemInterface.DefaultImpls.prepareOutputDirectory(this, output2);
    }
}

