/*
 * Decompiled with CFR 0.152.
 */
package com.google.prefab.cli;

import com.github.ajalt.clikt.core.CliktCommand;
import com.github.ajalt.clikt.core.UsageError;
import com.github.ajalt.clikt.parameters.arguments.ArgumentKt;
import com.github.ajalt.clikt.parameters.groups.ChoiceGroupKt;
import com.github.ajalt.clikt.parameters.options.OptionWithValues;
import com.github.ajalt.clikt.parameters.options.OptionWithValuesKt;
import com.github.ajalt.clikt.parameters.types.FileKt;
import com.google.prefab.api.Android;
import com.google.prefab.api.BuildSystemInterface;
import com.google.prefab.api.BuildSystemProvider;
import com.google.prefab.api.Package;
import com.google.prefab.api.PlatformDataInterface;
import com.google.prefab.cli.AndroidConfig;
import com.google.prefab.cli.BuildSystemRegistry;
import com.google.prefab.cli.DuplicatePackageNamesException;
import com.google.prefab.cli.FatalApplicationError;
import com.google.prefab.cli.PlatformConfig;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020)0 2\u0006\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020-H\u0004R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000b\u0010\fR!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R!\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0013\u001a\u0004\b\u0017\u0010\u0018R\u001b\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\b\u001a\u0004\b\u001c\u0010\u001dR!\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u0013\u001a\u0004\b\"\u0010#R!\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\b\u001a\u0004\b&\u0010\u0018\u00a8\u0006/"}, d2={"Lcom/google/prefab/cli/Cli;", "Lcom/github/ajalt/clikt/core/CliktCommand;", "()V", "buildSystem", "", "getBuildSystem", "()Ljava/lang/String;", "buildSystem$delegate", "Lkotlin/properties/ReadOnlyProperty;", "output", "Ljava/io/File;", "getOutput", "()Ljava/io/File;", "output$delegate", "packagePaths", "", "getPackagePaths", "()Ljava/util/Set;", "packagePaths$delegate", "Lkotlin/Lazy;", "packages", "", "Lcom/google/prefab/api/Package;", "getPackages", "()Ljava/util/List;", "packages$delegate", "platform", "Lcom/google/prefab/cli/PlatformConfig;", "getPlatform", "()Lcom/google/prefab/cli/PlatformConfig;", "platform$delegate", "platformRequirements", "", "Lcom/google/prefab/api/PlatformDataInterface;", "getPlatformRequirements", "()Ljava/util/Collection;", "platformRequirements$delegate", "rawPackagePaths", "getRawPackagePaths", "rawPackagePaths$delegate", "makeAndroidRequirements", "Lcom/google/prefab/api/Android;", "config", "Lcom/google/prefab/cli/AndroidConfig;", "run", "", "validate", "cli"})
@SourceDebugExtension(value={"SMAP\nCli.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Cli.kt\ncom/google/prefab/cli/Cli\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,208:1\n11065#2:209\n11400#2,3:210\n1549#3:213\n1620#3,3:214\n*S KotlinDebug\n*F\n+ 1 Cli.kt\ncom/google/prefab/cli/Cli\n*L\n146#1:209\n146#1:210,3\n191#1:213\n191#1:214,3\n*E\n"})
public class Cli
extends CliktCommand {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ReadOnlyProperty buildSystem$delegate = OptionWithValuesKt.required(OptionWithValuesKt.option$default(this, new String[0], "Generate integration for the given build system.", null, false, null, null, null, null, false, 508, null)).provideDelegate(this, (KProperty<?>)$$delegatedProperties[0]);
    @NotNull
    private final ReadOnlyProperty output$delegate = OptionWithValuesKt.required(FileKt.file$default(OptionWithValuesKt.option$default(this, new String[0], "Output path for generated build system integration.", null, false, null, null, null, null, false, 508, null), false, false, false, false, false, false, 61, null)).provideDelegate(this, (KProperty<?>)$$delegatedProperties[1]);
    @NotNull
    private final ReadOnlyProperty platform$delegate;
    @NotNull
    private final ReadOnlyProperty rawPackagePaths$delegate;
    @NotNull
    private final Lazy packagePaths$delegate;
    @NotNull
    private final Lazy packages$delegate;
    @NotNull
    private final Lazy platformRequirements$delegate;

    public Cli() {
        super("https://google.github.io/prefab/", null, "prefab", false, false, null, null, false, false, false, 1018, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to("android", new AndroidConfig())};
        this.platform$delegate = ChoiceGroupKt.required(ChoiceGroupKt.groupChoice((OptionWithValues<String, String, String>)OptionWithValuesKt.option$default(this, new String[0], "Target platform. Only 'android' is currently supported.", null, false, null, null, null, null, false, 508, null), pairArray)).provideDelegate(this, (KProperty<?>)$$delegatedProperties[2]);
        this.rawPackagePaths$delegate = (ReadOnlyProperty)ArgumentKt.multiple$default(FileKt.file$default(ArgumentKt.argument$default(this, "PACKAGE_PATH", null, null, null, 14, null), false, false, false, false, true, false, 45, null), true, null, 2, null).provideDelegate(this, $$delegatedProperties[3]);
        this.packagePaths$delegate = LazyKt.lazy((Function0)new Function0<Set<? extends File>>(this){
            final /* synthetic */ Cli this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Set<File> invoke() {
                return CollectionsKt.toSet(Cli.access$getRawPackagePaths(this.this$0));
            }
        });
        this.packages$delegate = LazyKt.lazy((Function0)new Function0<List<? extends Package>>(this){
            final /* synthetic */ Cli this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Package> invoke() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = Cli.access$getPackagePaths(this.this$0);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    File file2 = (File)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Path path2 = it.toPath();
                    Intrinsics.checkNotNullExpressionValue(path2, "toPath(...)");
                    collection.add(new Package(path2));
                }
                return (List)destination$iv$iv;
            }
        });
        this.platformRequirements$delegate = LazyKt.lazy((Function0)new Function0<Collection<? extends Android>>(this){
            final /* synthetic */ Cli this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Collection<Android> invoke() {
                PlatformConfig it = Cli.access$getPlatform(this.this$0);
                if (!(it instanceof AndroidConfig)) {
                    throw new NoWhenBranchMatchedException();
                }
                return Cli.access$makeAndroidRequirements(this.this$0, (AndroidConfig)it);
            }
        });
    }

    private final String getBuildSystem() {
        return (String)this.buildSystem$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final File getOutput() {
        return (File)this.output$delegate.getValue(this, $$delegatedProperties[1]);
    }

    private final PlatformConfig getPlatform() {
        return (PlatformConfig)this.platform$delegate.getValue(this, $$delegatedProperties[2]);
    }

    private final List<File> getRawPackagePaths() {
        return (List)this.rawPackagePaths$delegate.getValue(this, $$delegatedProperties[3]);
    }

    private final Set<File> getPackagePaths() {
        Lazy lazy = this.packagePaths$delegate;
        return (Set)lazy.getValue();
    }

    private final List<Package> getPackages() {
        Lazy lazy = this.packages$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<Android> makeAndroidRequirements(AndroidConfig config) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String abi = config.getAbi();
        String osVersion = config.getOsVersion();
        Android.Stl stl = Android.Stl.Companion.fromString(config.getStl());
        int ndkVersion = config.getNdkVersion();
        if (abi != null) {
            return CollectionsKt.listOf(new Android(Android.Abi.Companion.fromString(abi), Integer.parseInt(osVersion), stl, ndkVersion));
        }
        Android.Abi[] abiArray = Android.Abi.values();
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var14_14 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Android((Android.Abi)it, Integer.parseInt(osVersion), stl, ndkVersion));
        }
        return (List)destination$iv$iv;
    }

    private final Collection<PlatformDataInterface> getPlatformRequirements() {
        Lazy lazy = this.platformRequirements$delegate;
        return (Collection)lazy.getValue();
    }

    protected final void validate() {
        this.getPlatformRequirements();
        if (!BuildSystemRegistry.INSTANCE.supports(this.getBuildSystem())) {
            throw new UsageError("unsupported build system requested", null, 0, 6, null);
        }
        Map seenPackageNames = new LinkedHashMap();
        for (Package pkg : this.getPackages()) {
            Package seenPackage = (Package)seenPackageNames.get(pkg.getName());
            if (seenPackage != null) {
                throw new DuplicatePackageNamesException(pkg, seenPackage);
            }
            seenPackageNames.put(pkg.getName(), pkg);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        void $this$mapTo$iv$iv;
        this.validate();
        Iterable $this$map$iv = this.getPackages();
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Package package_ = (Package)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        Set knownPackages = CollectionsKt.toSet((List)destination$iv$iv);
        for (Package pkg : this.getPackages()) {
            for (String dep : pkg.getDependencies()) {
                if (knownPackages.contains(dep)) continue;
                throw new FatalApplicationError("Error: " + pkg.getName() + " depends on unknown dependency " + dep);
            }
        }
        BuildSystemProvider buildSystemProvider = BuildSystemRegistry.INSTANCE.find(this.getBuildSystem());
        Intrinsics.checkNotNull(buildSystemProvider);
        BuildSystemInterface buildSystemIntegration = buildSystemProvider.create(this.getOutput(), this.getPackages());
        buildSystemIntegration.generate(this.getPlatformRequirements());
    }

    public static final /* synthetic */ List access$getRawPackagePaths(Cli $this) {
        return $this.getRawPackagePaths();
    }

    public static final /* synthetic */ Set access$getPackagePaths(Cli $this) {
        return $this.getPackagePaths();
    }

    public static final /* synthetic */ PlatformConfig access$getPlatform(Cli $this) {
        return $this.getPlatform();
    }

    public static final /* synthetic */ Collection access$makeAndroidRequirements(Cli $this, AndroidConfig config) {
        return $this.makeAndroidRequirements(config);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Cli.class, "buildSystem", "getBuildSystem()Ljava/lang/String;", 0)), Reflection.property1(new PropertyReference1Impl(Cli.class, "output", "getOutput()Ljava/io/File;", 0)), Reflection.property1(new PropertyReference1Impl(Cli.class, "platform", "getPlatform()Lcom/google/prefab/cli/PlatformConfig;", 0)), Reflection.property1(new PropertyReference1Impl(Cli.class, "rawPackagePaths", "getRawPackagePaths()Ljava/util/List;", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

