/*
 * Decompiled with CFR 0.152.
 */
package com.google.prefab.api;

import com.google.prefab.api.Module;
import com.google.prefab.api.PackageKt;
import com.google.prefab.api.PackageMetadata;
import com.google.prefab.api.PackageMetadataV1;
import com.google.prefab.api.SchemaVersion;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\tR\u0011\u0010\u0011\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcom/google/prefab/api/Package;", "", "path", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "dependencies", "", "", "getDependencies", "()Ljava/util/List;", "metadata", "Lcom/google/prefab/api/PackageMetadataV1;", "moduleDir", "Ljava/io/File;", "modules", "Lcom/google/prefab/api/Module;", "getModules", "name", "getName", "()Ljava/lang/String;", "getPath", "()Ljava/nio/file/Path;", "schemaVersion", "Lcom/google/prefab/api/SchemaVersion;", "version", "getVersion", "api"})
@SourceDebugExtension(value={"SMAP\nPackage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Package.kt\ncom/google/prefab/api/Package\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n3792#2:99\n4307#2,2:100\n1549#3:102\n1620#3,3:103\n*S KotlinDebug\n*F\n+ 1 Package.kt\ncom/google/prefab/api/Package\n*L\n92#1:99\n92#1:100,2\n93#1:102\n93#1:103,3\n*E\n"})
public final class Package {
    @NotNull
    private final Path path;
    @NotNull
    private final PackageMetadataV1 metadata;
    @NotNull
    private final String name;
    @NotNull
    private final List<String> dependencies;
    @Nullable
    private final String version;
    @NotNull
    private final SchemaVersion schemaVersion;
    @NotNull
    private final File moduleDir;
    @NotNull
    private final List<Module> modules;

    /*
     * WARNING - void declaration
     */
    public Package(@NotNull Path path2) {
        Collection destination$iv$iv;
        void it;
        String string;
        Intrinsics.checkNotNullParameter(path2, "path");
        this.path = path2;
        this.metadata = PackageMetadata.Companion.loadAndMigrate(SchemaVersion.Companion.from(this.path), this.path);
        this.name = this.metadata.getName();
        this.dependencies = this.metadata.getDependencies();
        String string2 = string = this.metadata.getVersion();
        Package package_ = this;
        boolean bl2 = false;
        if (!(it == null || PackageKt.isValidVersionForCMake((String)it))) {
            boolean $i$a$-require-Package$version$1$22 = false;
            String $i$a$-require-Package$version$1$22 = "version must be compatible with CMake, if present";
            throw new IllegalArgumentException($i$a$-require-Package$version$1$22.toString());
        }
        package_.version = string;
        this.schemaVersion = SchemaVersion.Companion.from(this.metadata.getSchemaVersion());
        File file2 = this.path.resolve("modules").toFile();
        Intrinsics.checkNotNullExpressionValue(file2, "toFile(...)");
        this.moduleDir = file2;
        File[] fileArray = this.moduleDir.listFiles();
        if (fileArray != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            File it2;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            File[] bl2 = fileArray;
            package_ = this;
            boolean $i$f$filter22 = false;
            void var6_11 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                it2 = element$iv$iv;
                boolean bl3 = false;
                if (!(it2.isDirectory() && !it2.isHidden())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Iterable $i$f$filter22 = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            destination$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it2 = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                Path path3 = it2.toPath();
                Intrinsics.checkNotNullExpressionValue(path3, "toPath(...)");
                collection.add(new Module(path3, this, this.schemaVersion));
            }
        } else {
            throw new RuntimeException("Unable to retrieve file list for " + this.moduleDir);
        }
        package_.modules = (List)destination$iv$iv;
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<String> getDependencies() {
        return this.dependencies;
    }

    @Nullable
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final List<Module> getModules() {
        return this.modules;
    }
}

