/*
 * Decompiled with CFR 0.152.
 */
package com.google.prefab.api;

import com.google.prefab.api.Android;
import com.google.prefab.api.CompatibleLibrary;
import com.google.prefab.api.IncompatibleLibrary;
import com.google.prefab.api.InvalidDirectoryNameException;
import com.google.prefab.api.LibraryReference;
import com.google.prefab.api.LibraryUsabilityResult;
import com.google.prefab.api.MissingArtifactIDException;
import com.google.prefab.api.MissingPlatformIDException;
import com.google.prefab.api.ModuleMetadata;
import com.google.prefab.api.ModuleMetadataV1;
import com.google.prefab.api.NoMatchingLibraryException;
import com.google.prefab.api.Package;
import com.google.prefab.api.PlatformDataInterface;
import com.google.prefab.api.PlatformFactoryInterface;
import com.google.prefab.api.PlatformRegistry;
import com.google.prefab.api.PrebuiltLibrary;
import com.google.prefab.api.SchemaVersion;
import com.google.prefab.api.UnsupportedPlatformException;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020#J\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u00142\u0006\u0010%\u001a\u00020#R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006("}, d2={"Lcom/google/prefab/api/Module;", "", "path", "Ljava/nio/file/Path;", "pkg", "Lcom/google/prefab/api/Package;", "loadSchemaVersion", "Lcom/google/prefab/api/SchemaVersion;", "(Ljava/nio/file/Path;Lcom/google/prefab/api/Package;Lcom/google/prefab/api/SchemaVersion;)V", "canonicalName", "", "getCanonicalName", "()Ljava/lang/String;", "includePath", "getIncludePath", "()Ljava/nio/file/Path;", "isHeaderOnly", "", "()Z", "libraries", "", "Lcom/google/prefab/api/PrebuiltLibrary;", "getLibraries", "()Ljava/util/List;", "metadata", "Lcom/google/prefab/api/ModuleMetadataV1;", "getMetadata$api", "()Lcom/google/prefab/api/ModuleMetadataV1;", "name", "getName", "getPath", "getPkg", "()Lcom/google/prefab/api/Package;", "getLibraryFor", "platformData", "Lcom/google/prefab/api/PlatformDataInterface;", "libraryNameForPlatform", "platform", "linkLibsForPlatform", "Lcom/google/prefab/api/LibraryReference;", "api"})
@SourceDebugExtension(value={"SMAP\nModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Module.kt\ncom/google/prefab/api/Module\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,245:1\n11065#2:246\n11400#2,3:247\n1549#3:250\n1620#3,3:251\n1549#3:254\n1620#3,3:255\n*S KotlinDebug\n*F\n+ 1 Module.kt\ncom/google/prefab/api/Module\n*L\n140#1:246\n140#1:247,3\n225#1:250\n225#1:251,3\n226#1:254\n226#1:255,3\n*E\n"})
public final class Module {
    @NotNull
    private final Path path;
    @NotNull
    private final Package pkg;
    @NotNull
    private final ModuleMetadataV1 metadata;
    @NotNull
    private final String name;
    @NotNull
    private final String canonicalName;
    @NotNull
    private final Path includePath;
    @NotNull
    private final List<PrebuiltLibrary> libraries;
    private final boolean isHeaderOnly;

    /*
     * WARNING - void declaration
     */
    public Module(@NotNull Path path2, @NotNull Package pkg, @NotNull SchemaVersion loadSchemaVersion) {
        List list;
        Intrinsics.checkNotNullParameter(path2, "path");
        Intrinsics.checkNotNullParameter(pkg, "pkg");
        Intrinsics.checkNotNullParameter((Object)loadSchemaVersion, "loadSchemaVersion");
        this.path = path2;
        this.pkg = pkg;
        this.metadata = ModuleMetadata.Companion.loadAndMigrate(loadSchemaVersion, this.path);
        this.name = ((Object)this.path.getFileName()).toString();
        this.canonicalName = "//" + this.pkg.getName() + '/' + this.name;
        Path path3 = this.path.resolve("include");
        Intrinsics.checkNotNullExpressionValue(path3, "resolve(...)");
        this.includePath = path3;
        Module module = this;
        File[] fileArray = this.path.resolve("libs").toFile().listFiles();
        if (fileArray != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            File[] fileArray2 = fileArray;
            Module module2 = module;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                PlatformFactoryInterface platformFactory;
                String[] stringArray;
                void directory;
                void item$iv$iv;
                void var12_13 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String basename = ((Object)directory.toPath().getFileName()).toString();
                List components = StringsKt.split$default((CharSequence)basename, stringArray = new String[]{"."}, false, 2, 2, null);
                if (components.size() != 2) {
                    Path path4 = directory.toPath();
                    Intrinsics.checkNotNullExpressionValue(path4, "toPath(...)");
                    throw new InvalidDirectoryNameException(this, path4);
                }
                if (((CharSequence)components.get(0)).length() == 0) {
                    Path path5 = directory.toPath();
                    Intrinsics.checkNotNullExpressionValue(path5, "toPath(...)");
                    throw new MissingPlatformIDException(this, path5);
                }
                if (((CharSequence)components.get(1)).length() == 0) {
                    Path path6 = directory.toPath();
                    Intrinsics.checkNotNullExpressionValue(path6, "toPath(...)");
                    throw new MissingArtifactIDException(this, path6);
                }
                String platformName = (String)components.get(0);
                if (PlatformRegistry.INSTANCE.find(platformName) == null) {
                    throw new UnsupportedPlatformException(this, platformName);
                }
                Path path7 = directory.toPath();
                Intrinsics.checkNotNullExpressionValue(path7, "toPath(...)");
                collection.add(platformFactory.prebuiltLibraryFromDirectory(path7, this, loadSchemaVersion));
            }
            list = (List)destination$iv$iv;
            module = module2;
        } else {
            list = CollectionsKt.emptyList();
        }
        module.libraries = list;
        this.isHeaderOnly = this.libraries.isEmpty();
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @NotNull
    public final Package getPkg() {
        return this.pkg;
    }

    @NotNull
    public final ModuleMetadataV1 getMetadata$api() {
        return this.metadata;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getCanonicalName() {
        return this.canonicalName;
    }

    @NotNull
    public final Path getIncludePath() {
        return this.includePath;
    }

    @NotNull
    public final List<PrebuiltLibrary> getLibraries() {
        return this.libraries;
    }

    public final boolean isHeaderOnly() {
        return this.isHeaderOnly;
    }

    @NotNull
    public final PrebuiltLibrary getLibraryFor(@NotNull PlatformDataInterface platformData) {
        Intrinsics.checkNotNullParameter(platformData, "platformData");
        List compatible = new ArrayList();
        Map rejections = new LinkedHashMap();
        for (PrebuiltLibrary library : this.libraries) {
            LibraryUsabilityResult result = platformData.checkIfUsable(library);
            if (result instanceof CompatibleLibrary) {
                compatible.add(library);
                continue;
            }
            if (!(result instanceof IncompatibleLibrary)) continue;
            rejections.put(library, ((IncompatibleLibrary)result).getReason());
        }
        if (compatible.isEmpty()) {
            throw new NoMatchingLibraryException(this, MapsKt.toSortedMap(rejections, new Comparator(){

                public final int compare(T a, T b) {
                    PrebuiltLibrary it = (PrebuiltLibrary)a;
                    boolean bl = false;
                    Comparable comparable = it.getPath().getParent().getFileName();
                    it = (PrebuiltLibrary)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)it.getPath().getParent().getFileName());
                }
            }));
        }
        return platformData.findBestMatch(compatible);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LibraryReference> linkLibsForPlatform(@NotNull PlatformDataInterface platform) {
        List list;
        List<String> platformSpecificLibs;
        Intrinsics.checkNotNullParameter(platform, "platform");
        if (!(platform instanceof Android)) {
            throw new IllegalArgumentException("Unrecognized platform: " + platform);
        }
        List<String> list2 = platformSpecificLibs = this.metadata.getAndroid().getExportLibraries();
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(LibraryReference.Companion.fromString((String)it));
            }
            list = (List)destination$iv$iv;
        } else {
            Iterable $this$map$iv = this.metadata.getExportLibraries();
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(LibraryReference.Companion.fromString(it));
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    @NotNull
    public final String libraryNameForPlatform(@NotNull PlatformDataInterface platform) {
        Intrinsics.checkNotNullParameter(platform, "platform");
        if (!(platform instanceof Android)) {
            throw new IllegalArgumentException("Unrecognized platform: " + platform);
        }
        String string = this.metadata.getAndroid().getLibraryName();
        String string2 = string;
        if (string == null && (string2 = this.metadata.getLibraryName()) == null) {
            string2 = "lib" + this.name;
        }
        return string2;
    }
}

