/*
 * Decompiled with CFR 0.152.
 */
package com.google.prefab.api;

import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00032\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Lcom/google/prefab/api/LibraryReference;", "", "()V", "Companion", "External", "Literal", "Local", "Lcom/google/prefab/api/LibraryReference$External;", "Lcom/google/prefab/api/LibraryReference$Literal;", "Lcom/google/prefab/api/LibraryReference$Local;", "api"})
public abstract class LibraryReference {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private LibraryReference() {
    }

    public /* synthetic */ LibraryReference(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/google/prefab/api/LibraryReference$Companion;", "", "()V", "fromString", "Lcom/google/prefab/api/LibraryReference;", "reference", "", "api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LibraryReference fromString(@NotNull String reference) {
            Intrinsics.checkNotNullParameter(reference, "reference");
            return StringsKt.startsWith$default(reference, "//", false, 2, null) ? (LibraryReference)External.Companion.fromString(reference) : (StringsKt.startsWith$default(reference, ":", false, 2, null) ? (LibraryReference)Local.Companion.fromString(reference) : (LibraryReference)Literal.Companion.fromString(reference));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/google/prefab/api/LibraryReference$External;", "Lcom/google/prefab/api/LibraryReference;", "pkg", "", "module", "(Ljava/lang/String;Ljava/lang/String;)V", "getModule", "()Ljava/lang/String;", "getPkg", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "api"})
    public static final class External
    extends LibraryReference {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String pkg;
        @NotNull
        private final String module;

        public External(@NotNull String pkg, @NotNull String module) {
            Intrinsics.checkNotNullParameter(pkg, "pkg");
            Intrinsics.checkNotNullParameter(module, "module");
            super(null);
            this.pkg = pkg;
            this.module = module;
        }

        @NotNull
        public final String getPkg() {
            return this.pkg;
        }

        @NotNull
        public final String getModule() {
            return this.module;
        }

        @NotNull
        public final String component1() {
            return this.pkg;
        }

        @NotNull
        public final String component2() {
            return this.module;
        }

        @NotNull
        public final External copy(@NotNull String pkg, @NotNull String module) {
            Intrinsics.checkNotNullParameter(pkg, "pkg");
            Intrinsics.checkNotNullParameter(module, "module");
            return new External(pkg, module);
        }

        public static /* synthetic */ External copy$default(External external, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = external.pkg;
            }
            if ((n & 2) != 0) {
                string2 = external.module;
            }
            return external.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "External(pkg=" + this.pkg + ", module=" + this.module + ')';
        }

        public int hashCode() {
            int result = this.pkg.hashCode();
            result = result * 31 + this.module.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof External)) {
                return false;
            }
            External external = (External)other;
            if (!Intrinsics.areEqual(this.pkg, external.pkg)) {
                return false;
            }
            return Intrinsics.areEqual(this.module, external.module);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\t"}, d2={"Lcom/google/prefab/api/LibraryReference$External$Companion;", "", "()V", "fromString", "Lcom/google/prefab/api/LibraryReference$External;", "reference", "", "validate", "", "api"})
        @SourceDebugExtension(value={"SMAP\nLibraryReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryReference.kt\ncom/google/prefab/api/LibraryReference$External$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,158:1\n1099#2,3:159\n*S KotlinDebug\n*F\n+ 1 LibraryReference.kt\ncom/google/prefab/api/LibraryReference$External$Companion\n*L\n117#1:159,3\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            private final void validate(String reference) {
                boolean bl = StringsKt.startsWith$default(reference, "//", false, 2, null);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                CharSequence $this$count$iv = reference;
                boolean $i$f$count = false;
                int count$iv = 0;
                for (int i = 0; i < $this$count$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$count$iv.charAt(i);
                    boolean bl2 = false;
                    if (!(it == ':')) continue;
                    ++count$iv;
                }
                if (!(count$iv == 1)) {
                    boolean $i$a$-require-LibraryReference$External$Companion$validate$42 = false;
                    String $i$a$-require-LibraryReference$External$Companion$validate$42 = "Expected exactly one : in external library reference";
                    throw new IllegalArgumentException($i$a$-require-LibraryReference$External$Companion$validate$42.toString());
                }
                String string = reference.substring(2);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                if (!(!StringsKt.contains$default((CharSequence)string, '/', false, 2, null))) {
                    boolean bl3 = false;
                    String string2 = "Expected no / after leading // in external library reference";
                    throw new IllegalArgumentException(string2.toString());
                }
            }

            @NotNull
            public final External fromString(@NotNull String reference) {
                Intrinsics.checkNotNullParameter(reference, "reference");
                this.validate(reference);
                String string = reference.substring(2);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                String[] stringArray = new String[]{":"};
                List list = StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null);
                String pkg = (String)list.get(0);
                String module = (String)list.get(1);
                return new External(pkg, module);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/google/prefab/api/LibraryReference$Literal;", "Lcom/google/prefab/api/LibraryReference;", "arg", "", "(Ljava/lang/String;)V", "getArg", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "api"})
    public static final class Literal
    extends LibraryReference {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String arg;

        public Literal(@NotNull String arg) {
            Intrinsics.checkNotNullParameter(arg, "arg");
            super(null);
            this.arg = arg;
        }

        @NotNull
        public final String getArg() {
            return this.arg;
        }

        @NotNull
        public final String component1() {
            return this.arg;
        }

        @NotNull
        public final Literal copy(@NotNull String arg) {
            Intrinsics.checkNotNullParameter(arg, "arg");
            return new Literal(arg);
        }

        public static /* synthetic */ Literal copy$default(Literal literal, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = literal.arg;
            }
            return literal.copy(string);
        }

        @NotNull
        public String toString() {
            return "Literal(arg=" + this.arg + ')';
        }

        public int hashCode() {
            return this.arg.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Literal)) {
                return false;
            }
            Literal literal = (Literal)other;
            return Intrinsics.areEqual(this.arg, literal.arg);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\t"}, d2={"Lcom/google/prefab/api/LibraryReference$Literal$Companion;", "", "()V", "fromString", "Lcom/google/prefab/api/LibraryReference$Literal;", "reference", "", "validate", "", "api"})
        public static final class Companion {
            private Companion() {
            }

            private final void validate(String reference) {
                if (!(((CharSequence)reference).length() > 0)) {
                    boolean bl = false;
                    String string = "Literal library reference must not be empty";
                    throw new IllegalArgumentException(string.toString());
                }
            }

            @NotNull
            public final Literal fromString(@NotNull String reference) {
                Intrinsics.checkNotNullParameter(reference, "reference");
                this.validate(reference);
                return new Literal(reference);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/google/prefab/api/LibraryReference$Local;", "Lcom/google/prefab/api/LibraryReference;", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "api"})
    public static final class Local
    extends LibraryReference {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;

        public Local(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            super(null);
            this.name = name;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final Local copy(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            return new Local(name);
        }

        public static /* synthetic */ Local copy$default(Local local, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = local.name;
            }
            return local.copy(string);
        }

        @NotNull
        public String toString() {
            return "Local(name=" + this.name + ')';
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Local)) {
                return false;
            }
            Local local = (Local)other;
            return Intrinsics.areEqual(this.name, local.name);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\t"}, d2={"Lcom/google/prefab/api/LibraryReference$Local$Companion;", "", "()V", "fromString", "Lcom/google/prefab/api/LibraryReference$Local;", "reference", "", "validate", "", "api"})
        @SourceDebugExtension(value={"SMAP\nLibraryReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryReference.kt\ncom/google/prefab/api/LibraryReference$Local$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,158:1\n1099#2,3:159\n*S KotlinDebug\n*F\n+ 1 LibraryReference.kt\ncom/google/prefab/api/LibraryReference$Local$Companion\n*L\n76#1:159,3\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            private final void validate(String reference) {
                boolean bl = StringsKt.startsWith$default(reference, ":", false, 2, null);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                CharSequence $this$count$iv = reference;
                boolean $i$f$count = false;
                int count$iv = 0;
                for (int i = 0; i < $this$count$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$count$iv.charAt(i);
                    boolean bl2 = false;
                    if (!(it == ':')) continue;
                    ++count$iv;
                }
                if (!(count$iv == 1)) {
                    boolean bl3 = false;
                    String string = "Expected exactly one : in local library reference";
                    throw new IllegalArgumentException(string.toString());
                }
            }

            @NotNull
            public final Local fromString(@NotNull String reference) {
                Intrinsics.checkNotNullParameter(reference, "reference");
                this.validate(reference);
                String string = reference.substring(1);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                return new Local(string);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

