/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.table;

import com.github.ajalt.mordant.internal.ConstantsKt;
import com.github.ajalt.mordant.rendering.BorderType;
import com.github.ajalt.mordant.rendering.BorderTypeSection;
import com.github.ajalt.mordant.rendering.Line;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.LinesKt;
import com.github.ajalt.mordant.rendering.Span;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.table.Borders;
import com.github.ajalt.mordant.table.Cell;
import com.github.ajalt.mordant.table.TableKt;
import com.github.ajalt.mordant.terminal.Terminal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0081\u0001\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0003\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0003\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u001a\u0010 \u001a\u0004\u0018\u00010\u00042\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000bH\u0002J\b\u0010#\u001a\u00020$H\u0002J(\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000bH\u0002J\u0010\u0010(\u001a\u00020$2\u0006\u0010!\u001a\u00020\u000bH\u0002J7\u0010)\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u000b2\b\u0010+\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0002\u0010,J\u001a\u0010-\u001a\u0004\u0018\u00010\u001f2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000bH\u0002J\u0006\u0010.\u001a\u00020\u0018J,\u0010/\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u00030\u00032\u0006\u0010'\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000bH\u0002J\u001a\u00100\u001a\u0002012\u0006\u0010\"\u001a\u00020\u000b2\b\b\u0002\u00102\u001a\u00020\u0010H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0002\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/github/ajalt/mordant/table/TableRenderer;", "", "rows", "", "Lcom/github/ajalt/mordant/table/Cell;", "Lcom/github/ajalt/mordant/table/ImmutableRow;", "borderType", "Lcom/github/ajalt/mordant/rendering/BorderType;", "borderStyle", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "headerRowCount", "", "footerRowCount", "columnCount", "columnWidths", "columnBorders", "", "rowBorders", "tableBorders", "Lcom/github/ajalt/mordant/table/Borders;", "t", "Lcom/github/ajalt/mordant/terminal/Terminal;", "(Ljava/util/List;Lcom/github/ajalt/mordant/rendering/BorderType;Lcom/github/ajalt/mordant/rendering/TextStyle;IIILjava/util/List;Ljava/util/List;Ljava/util/List;Lcom/github/ajalt/mordant/table/Borders;Lcom/github/ajalt/mordant/terminal/Terminal;)V", "renderedRows", "Lcom/github/ajalt/mordant/rendering/Lines;", "rowCount", "getRowCount", "()I", "rowHeights", "tableLines", "", "Lcom/github/ajalt/mordant/rendering/Span;", "cellAt", "x", "y", "drawBottomBorder", "", "drawCellContent", "tableLineY", "cell", "drawLeftBorderForColumn", "drawTopBorderForCell", "colWidth", "borderTop", "(IIIILjava/lang/Boolean;)I", "getTopLeftCorner", "render", "renderCell", "sectionOfRow", "Lcom/github/ajalt/mordant/rendering/BorderTypeSection;", "allowBottom", "mordant"})
@SourceDebugExtension(value={"SMAP\nTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Table.kt\ncom/github/ajalt/mordant/table/TableRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,451:1\n1549#2:452\n1620#2,2:453\n1559#2:455\n1590#2,3:456\n1593#2:460\n1622#2:461\n1559#2:462\n1590#2,4:463\n1774#2,4:467\n1549#2:471\n1620#2,3:472\n1774#2,4:475\n1774#2,4:479\n1#3:459\n*S KotlinDebug\n*F\n+ 1 Table.kt\ncom/github/ajalt/mordant/table/TableRenderer\n*L\n243#1:452\n243#1:453,2\n244#1:455\n244#1:456,3\n244#1:460\n243#1:461\n253#1:462\n253#1:463,4\n260#1:467,4\n287#1:471\n287#1:472,3\n392#1:475,4\n395#1:479,4\n*E\n"})
final class TableRenderer {
    @NotNull
    private final List<List<Cell>> rows;
    @NotNull
    private final BorderType borderType;
    @NotNull
    private final TextStyle borderStyle;
    private final int headerRowCount;
    private final int footerRowCount;
    private final int columnCount;
    @NotNull
    private final List<Integer> columnWidths;
    @NotNull
    private final List<Boolean> columnBorders;
    @NotNull
    private final List<Boolean> rowBorders;
    @Nullable
    private final Borders tableBorders;
    @NotNull
    private final Terminal t;
    @NotNull
    private final List<List<Lines>> renderedRows;
    @NotNull
    private final List<Integer> rowHeights;
    @NotNull
    private final List<List<Span>> tableLines;

    /*
     * WARNING - void declaration
     */
    public TableRenderer(@NotNull List<? extends List<? extends Cell>> rows, @NotNull BorderType borderType, @NotNull TextStyle borderStyle, int headerRowCount, int footerRowCount, int columnCount, @NotNull List<Integer> columnWidths, @NotNull List<Boolean> columnBorders, @NotNull List<Boolean> rowBorders, @Nullable Borders tableBorders, @NotNull Terminal t) {
        int n;
        void $this$count$iv;
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv;
        Object object;
        int $i$f$mapIndexed;
        Iterable $this$mapIndexed$iv2;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(rows, "rows");
        Intrinsics.checkNotNullParameter(borderType, "borderType");
        Intrinsics.checkNotNullParameter(borderStyle, "borderStyle");
        Intrinsics.checkNotNullParameter(columnWidths, "columnWidths");
        Intrinsics.checkNotNullParameter(columnBorders, "columnBorders");
        Intrinsics.checkNotNullParameter(rowBorders, "rowBorders");
        Intrinsics.checkNotNullParameter(t, "t");
        this.rows = rows;
        this.borderType = borderType;
        this.borderStyle = borderStyle;
        this.headerRowCount = headerRowCount;
        this.footerRowCount = footerRowCount;
        this.columnCount = columnCount;
        this.columnWidths = columnWidths;
        this.columnBorders = columnBorders;
        this.rowBorders = rowBorders;
        this.tableBorders = tableBorders;
        this.t = t;
        Iterable iterable = this.rows;
        TableRenderer tableRenderer = this;
        boolean $i$f$map = false;
        void var14_17 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapIndexedTo$iv$iv2;
            void r;
            List list = (List)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            $this$mapIndexed$iv2 = (Iterable)r;
            $i$f$mapIndexed = 0;
            Iterable iterable2 = $this$mapIndexed$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv2, 10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv2) {
                Lines lines;
                void it;
                int n2;
                if ((n2 = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                object = (Cell)item$iv$iv2;
                int n3 = n2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                if (it instanceof Cell.Content) {
                    void x;
                    Iterable iterable3 = RangesKt.until((int)x, (int)(x + it.getColumnSpan()));
                    int n4 = 0;
                    Iterator iterator2 = iterable3.iterator();
                    while (iterator2.hasNext()) {
                        void it2;
                        int n5;
                        int n6 = n5 = ((IntIterator)iterator2).nextInt();
                        int n7 = n4;
                        boolean bl3 = false;
                        int n8 = ((Number)this.columnWidths.get((int)it2)).intValue();
                        n4 = n7 + n8;
                    }
                    int w = n4;
                    lines = w == 0 ? ConstantsKt.getEMPTY_LINES() : ((Cell.Content)it).getContent().render(this.t, w).withStyle(((Cell.Content)it).getStyle());
                } else {
                    lines = ConstantsKt.getEMPTY_LINES();
                }
                collection2.add(lines);
            }
            collection.add((List)destination$iv$iv2);
        }
        tableRenderer.renderedRows = (List)destination$iv$iv;
        $this$map$iv = this.renderedRows;
        tableRenderer = this;
        boolean $i$f$mapIndexed2 = false;
        $this$mapTo$iv$iv = $this$mapIndexed$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            Object object2;
            void r;
            int n9;
            if ((n9 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            $this$mapIndexed$iv2 = (List)item$iv$iv;
            $i$f$mapIndexed = n9;
            collection = destination$iv$iv;
            boolean bl = false;
            Iterator iterator3 = CollectionsKt.withIndex((Iterable)r).iterator();
            if (!iterator3.hasNext()) {
                object2 = null;
            } else {
                void y;
                Object object3 = iterator3.next();
                boolean bl4 = false;
                int x = ((IndexedValue)object3).component1();
                Lines it = (Lines)((IndexedValue)object3).component2();
                Cell cell2 = this.cellAt(x, (int)y);
                object3 = it.getHeight() / (cell2 != null ? cell2.getRowSpan() : 1);
                while (iterator3.hasNext()) {
                    Object object4 = iterator3.next();
                    $i$a$-maxOfOrNull-TableRenderer$rowHeights$1$1 = false;
                    int x2 = ((IndexedValue)object4).component1();
                    Lines it3 = (Lines)((IndexedValue)object4).component2();
                    Cell cell3 = this.cellAt(x2, (int)y);
                    object4 = it3.getHeight() / (cell3 != null ? cell3.getRowSpan() : 1);
                    if (object3.compareTo(object4) >= 0) continue;
                    object3 = object4;
                }
                object2 = object3;
            }
            object = (Integer)object2;
            collection.add(object != null ? RangesKt.coerceAtLeast((Integer)object, 1) : 1);
        }
        tableRenderer.rowHeights = (List)destination$iv$iv;
        $this$mapIndexed$iv = this.rowBorders;
        int n10 = CollectionsKt.sumOfInt((Iterable<Integer>)this.rowHeights);
        tableRenderer = this;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                boolean it = (Boolean)element$iv;
                boolean bl = false;
                if (!it || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int n11 = n;
        int n12 = n10 + n11;
        ArrayList<List> arrayList = new ArrayList<List>(n12);
        int n13 = 0;
        while (n13 < n12) {
            int n14;
            int element$iv = n14 = n13++;
            ArrayList<List> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(new ArrayList());
        }
        tableRenderer.tableLines = arrayList;
    }

    private final int getRowCount() {
        return this.rows.size();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Lines render() {
        void $this$mapTo$iv$iv;
        List row2;
        int n = this.columnWidths.size();
        for (int x = 0; x < n; ++x) {
            this.drawLeftBorderForColumn(x);
            int colWidth = ((Number)this.columnWidths.get(x)).intValue();
            int tableLineY = 0;
            Iterator<List<Cell>> iterator2 = this.rows.iterator();
            int n2 = 0;
            while (iterator2.hasNext()) {
                int y = n2++;
                row2 = iterator2.next();
                int rowHeight = ((Number)this.rowHeights.get(y)).intValue();
                Cell cell2 = (Cell)CollectionsKt.getOrNull(row2, x);
                if (cell2 == null) {
                    cell2 = Cell.Empty.INSTANCE;
                }
                Cell cell3 = cell2;
                tableLineY += this.drawTopBorderForCell(tableLineY, x, y, colWidth, cell3.getBorderTop());
                this.drawCellContent(tableLineY, cell3, x, y);
                tableLineY += rowHeight;
            }
        }
        this.drawLeftBorderForColumn(this.columnCount);
        this.drawBottomBorder();
        Iterable $this$map$iv = this.tableLines;
        boolean $i$f$map = false;
        Iterable colWidth = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            row2 = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Line((List<Span>)it));
        }
        List list = (List)destination$iv$iv;
        return new Lines(list);
    }

    private final void drawBottomBorder() {
        block5: {
            if (!this.rowBorders.get(this.getRowCount()).booleanValue()) {
                return;
            }
            List<Span> line = this.tableLines.get(CollectionsKt.getLastIndex(this.tableLines));
            int n = this.columnWidths.size();
            for (int x = 0; x < n; ++x) {
                if (this.columnBorders.get(x).booleanValue()) {
                    if (this.getTopLeftCorner(x, this.getRowCount()) != null) {
                        Span it;
                        boolean bl = false;
                        line.add(it);
                    }
                }
                this.drawTopBorderForCell(CollectionsKt.getLastIndex(this.tableLines), x, this.getRowCount(), ((Number)this.columnWidths.get(x)).intValue(), false);
            }
            if (!this.columnBorders.get(this.columnCount).booleanValue()) break block5;
            Span span = this.getTopLeftCorner(this.columnCount, this.getRowCount());
            if (span != null) {
                Span it = span;
                boolean bl = false;
                line.add(it);
            }
        }
    }

    private final void drawCellContent(int tableLineY, Cell cell2, int x, int y) {
        List<List<Span>> lines = this.renderCell(cell2, x, y);
        Iterator<List<Span>> iterator2 = lines.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            List<Span> line = iterator2.next();
            this.tableLines.get(tableLineY + i).addAll((Collection<Span>)line);
        }
    }

    private final int drawTopBorderForCell(int tableLineY, int x, int y, int colWidth, Boolean borderTop) {
        if (!this.rowBorders.get(y).booleanValue()) {
            return 0;
        }
        if (colWidth == 0 || borderTop == null) {
            return 1;
        }
        String string = borderTop != false || y == 0 && TableKt.access$getT(this.tableBorders) || y == this.getRowCount() && TableKt.access$getB(this.tableBorders) || TableKt.access$getB(this.cellAt(x, y - 1)) ? TableRenderer.sectionOfRow$default(this, y, false, 2, null).getEw() : " ";
        this.tableLines.get(tableLineY).add(Span.Companion.word(StringsKt.repeat(string, colWidth), this.borderStyle));
        return 1;
    }

    private final void drawLeftBorderForColumn(int x) {
        if (!this.columnBorders.get(x).booleanValue()) {
            return;
        }
        int tableLineY = 0;
        Iterator<List<Cell>> iterator2 = this.rows.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int topBorderHeight;
            Cell cell2;
            int y = n++;
            List<Cell> row2 = iterator2.next();
            int rowHeight = ((Number)this.rowHeights.get(y)).intValue();
            Cell cell3 = CollectionsKt.getOrNull(row2, x);
            if (cell3 == null) {
                cell3 = cell2 = (Cell)Cell.Empty.INSTANCE;
            }
            if (this.rowBorders.get(y).booleanValue()) {
                if (this.getTopLeftCorner(x, y) != null) {
                    Span it;
                    boolean bl = false;
                    this.tableLines.get(tableLineY).add(it);
                }
            }
            Boolean borderLeft = cell2.getBorderLeft();
            int n2 = topBorderHeight = this.rowBorders.get(y) != false ? 1 : 0;
            if (borderLeft != null) {
                Span border = x == 0 && TableKt.access$getL(this.tableBorders) || x == this.columnCount && TableKt.access$getR(this.tableBorders) || borderLeft != false || TableKt.access$getR(this.cellAt(x - 1, y)) ? Span.Companion.word(this.sectionOfRow(y, false).getNs(), this.borderStyle) : ConstantsKt.getSINGLE_SPACE();
                for (int i = 0; i < rowHeight; ++i) {
                    this.tableLines.get(tableLineY + i + topBorderHeight).add(border);
                }
            }
            tableLineY += rowHeight + topBorderHeight;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<Span>> renderCell(Cell cell2, int x, int y) {
        List<Line> list;
        Cell cell3 = cell2;
        if (cell3 instanceof Cell.SpanRef) {
            list = CollectionsKt.emptyList();
        } else if (cell3 instanceof Cell.Empty) {
            List<Span> space = CollectionsKt.listOf(Span.Companion.space$default(Span.Companion, ((Number)this.columnWidths.get(x)).intValue(), null, 2, null));
            int n = ((Number)this.rowHeights.get(y)).intValue();
            ArrayList<List<Span>> arrayList = new ArrayList<List<Span>>(n);
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4 = n3 = n2++;
                ArrayList<List<Span>> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(space);
            }
            list = (List<Line>)arrayList;
        } else if (cell3 instanceof Cell.Content) {
            int n;
            void $this$count$iv;
            int it;
            int n5;
            void $this$count$iv2;
            int n6;
            int n7;
            Iterable iterable = RangesKt.until(x, x + cell2.getColumnSpan());
            int n8 = 0;
            Iterator iterator2 = iterable.iterator();
            while (iterator2.hasNext()) {
                int n9;
                int it2 = n9 = ((IntIterator)iterator2).nextInt();
                n7 = n8;
                boolean bl = false;
                n6 = ((Number)this.columnWidths.get(it2)).intValue();
                n8 = n7 + n6;
            }
            iterable = RangesKt.until(x + 1, x + cell2.getColumnSpan());
            n7 = n8;
            boolean $i$f$count22 = false;
            if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
                n5 = 0;
            } else {
                int count$iv = 0;
                Iterator iterator3 = $this$count$iv2.iterator();
                while (iterator3.hasNext()) {
                    int element$iv;
                    it = element$iv = ((IntIterator)iterator3).nextInt();
                    boolean bl = false;
                    if (!this.columnBorders.get(it + 1).booleanValue() || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n5 = count$iv;
            }
            n6 = n5;
            int cellWidth2 = RangesKt.coerceAtLeast(n7 + n6, 0);
            Iterable $i$f$count22 = RangesKt.until(y, y + cell2.getRowSpan());
            int count$iv = 0;
            Iterator iterator4 = $i$f$count22.iterator();
            while (iterator4.hasNext()) {
                int n10;
                it = n10 = ((IntIterator)iterator4).nextInt();
                n7 = count$iv;
                boolean bl = false;
                n6 = ((Number)this.rowHeights.get(it)).intValue();
                count$iv = n7 + n6;
            }
            $i$f$count22 = RangesKt.until(y + 1, y + cell2.getRowSpan());
            n7 = count$iv;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv2 = 0;
                Iterator iterator5 = $this$count$iv.iterator();
                while (iterator5.hasNext()) {
                    int element$iv;
                    int it3 = element$iv = ((IntIterator)iterator5).nextInt();
                    boolean bl = false;
                    if (!this.rowBorders.get(it3 + 1).booleanValue() || ++count$iv2 >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv2;
            }
            n6 = n;
            int cellHeight = n7 + n6;
            list = LinesKt.setSize(((Cell.Content)cell2).getContent().render(this.t, cellWidth2).withStyle(((Cell.Content)cell2).getStyle()), cellWidth2, cellHeight, ((Cell.Content)cell2).getVerticalAlign(), ((Cell.Content)cell2).getTextAlign()).getLines();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    private final Cell cellAt(int x, int y) {
        List<Cell> list = CollectionsKt.getOrNull(this.rows, y);
        return list != null ? CollectionsKt.getOrNull(list, x) : null;
    }

    private final Span getTopLeftCorner(int x, int y) {
        Cell tl = this.cellAt(x - 1, y - 1);
        Cell tr = this.cellAt(x, y - 1);
        Cell bl = this.cellAt(x - 1, y);
        Cell br = this.cellAt(x, y);
        if (tl != null || tr != null || bl != null || br != null) {
            Cell cell2 = tl;
            if ((cell2 != null ? cell2.getBorderRight() : null) == null) {
                Cell cell3 = tr;
                if ((cell3 != null ? cell3.getBorderLeft() : null) == null) {
                    Cell cell4 = tr;
                    if ((cell4 != null ? cell4.getBorderBottom() : null) == null) {
                        Cell cell5 = br;
                        if ((cell5 != null ? cell5.getBorderTop() : null) == null) {
                            Cell cell6 = bl;
                            if ((cell6 != null ? cell6.getBorderRight() : null) == null) {
                                Cell cell7 = br;
                                if ((cell7 != null ? cell7.getBorderLeft() : null) == null) {
                                    Cell cell8 = tl;
                                    if ((cell8 != null ? cell8.getBorderBottom() : null) == null) {
                                        Cell cell9 = bl;
                                        if ((cell9 != null ? cell9.getBorderTop() : null) == null) {
                                            return null;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return TableRenderer.sectionOfRow$default(this, y, false, 2, null).getCorner(TableKt.access$getR(tl) || TableKt.access$getL(tr) || y > 0 && (x == 0 && TableKt.access$getL(this.tableBorders) || x == this.columnCount && TableKt.access$getR(this.tableBorders)), TableKt.access$getB(tr) || TableKt.access$getT(br) || x < this.columnCount && (y == 0 && TableKt.access$getT(this.tableBorders) || y == this.getRowCount() && TableKt.access$getB(this.tableBorders)), TableKt.access$getR(bl) || TableKt.access$getL(br) || y < this.getRowCount() && (x == 0 && TableKt.access$getL(this.tableBorders) || x == this.columnCount && TableKt.access$getR(this.tableBorders)), TableKt.access$getB(tl) || TableKt.access$getT(bl) || x > 0 && (y == 0 && TableKt.access$getT(this.tableBorders) || y == this.getRowCount() && TableKt.access$getB(this.tableBorders)), this.borderStyle);
    }

    private final BorderTypeSection sectionOfRow(int y, boolean allowBottom) {
        return y < this.headerRowCount ? this.borderType.getHead() : (allowBottom && this.headerRowCount > 0 && y == this.headerRowCount ? this.borderType.getHeadBottom() : (allowBottom && this.footerRowCount > 0 && y == this.getRowCount() - this.footerRowCount ? this.borderType.getBodyBottom() : (this.footerRowCount == 0 || y < this.getRowCount() - this.footerRowCount ? this.borderType.getBody() : this.borderType.getFoot())));
    }

    static /* synthetic */ BorderTypeSection sectionOfRow$default(TableRenderer tableRenderer, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        return tableRenderer.sectionOfRow(n, bl);
    }
}

