/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.internal.nativeimage;

import com.github.ajalt.mordant.internal.MppImpls;
import com.github.ajalt.mordant.internal.nativeimage.PosixLibC;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.jetbrains.annotations.Nullable;

@Platforms(value={Platform.LINUX.class, Platform.MACOS.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/github/ajalt/mordant/internal/nativeimage/NativeImagePosixMppImpls;", "Lcom/github/ajalt/mordant/internal/MppImpls;", "()V", "getTerminalSize", "Lkotlin/Pair;", "", "stderrInteractive", "", "stdinInteractive", "stdoutInteractive", "mordant"})
public final class NativeImagePosixMppImpls
implements MppImpls {
    @Override
    public boolean stdoutInteractive() {
        return PosixLibC.INSTANCE.isatty(PosixLibC.INSTANCE.STDOUT_FILENO());
    }

    @Override
    public boolean stdinInteractive() {
        return PosixLibC.INSTANCE.isatty(PosixLibC.INSTANCE.STDIN_FILENO());
    }

    @Override
    public boolean stderrInteractive() {
        return PosixLibC.INSTANCE.isatty(PosixLibC.INSTANCE.STDERR_FILENO());
    }

    @Override
    @Nullable
    public Pair<Integer, Integer> getTerminalSize() {
        PosixLibC.winsize size = (PosixLibC.winsize)StackValue.get(PosixLibC.winsize.class);
        return PosixLibC.INSTANCE.ioctl(0, PosixLibC.INSTANCE.TIOCGWINSZ(), size) < 0 ? null : TuplesKt.to(Integer.valueOf(size.getWs_col()), Integer.valueOf(size.getWs_row()));
    }
}

