/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.ColorSpace;
import com.github.ajalt.colormath.internal.ColorSpaceUtilsKt;
import com.github.ajalt.colormath.internal.InternalMathKt;
import com.github.ajalt.colormath.model.Ansi16;
import com.github.ajalt.colormath.model.Ansi256;
import com.github.ajalt.colormath.model.CMYK;
import com.github.ajalt.colormath.model.HPLuv;
import com.github.ajalt.colormath.model.HSL;
import com.github.ajalt.colormath.model.HSLuv;
import com.github.ajalt.colormath.model.HSV;
import com.github.ajalt.colormath.model.HWB;
import com.github.ajalt.colormath.model.ICtCp;
import com.github.ajalt.colormath.model.JzCzHz;
import com.github.ajalt.colormath.model.LAB;
import com.github.ajalt.colormath.model.LCHab;
import com.github.ajalt.colormath.model.LCHuv;
import com.github.ajalt.colormath.model.LUV;
import com.github.ajalt.colormath.model.Oklab;
import com.github.ajalt.colormath.model.Oklch;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.XYZ;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 )2\u00020\u0001:\u0001)B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B'\u0012\u0006\u0010\u0002\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\b\u0012\u0006\u0010\u0005\u001a\u00020\b\u0012\b\b\u0002\u0010\u0006\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0013\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\b2\b\b\u0002\u0010\u0004\u001a\u00020\b2\b\b\u0002\u0010\u0005\u001a\u00020\b2\b\b\u0002\u0010\u0006\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0000H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\t\u0010%\u001a\u00020&H\u00d6\u0001J\b\u0010'\u001a\u00020(H\u0016R\u0011\u0010\u0004\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00000\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006*"}, d2={"Lcom/github/ajalt/colormath/model/JzAzBz;", "Lcom/github/ajalt/colormath/Color;", "j", "", "a", "b", "alpha", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "", "(FFFF)V", "getA", "()F", "getAlpha", "getB", "getJ", "space", "Lcom/github/ajalt/colormath/ColorSpace;", "getSpace", "()Lcom/github/ajalt/colormath/ColorSpace;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toArray", "", "toJzAzBz", "toJzCzHz", "Lcom/github/ajalt/colormath/model/JzCzHz;", "toSRGB", "Lcom/github/ajalt/colormath/model/RGB;", "toString", "", "toXYZ", "Lcom/github/ajalt/colormath/model/XYZ;", "Companion", "colormath"})
@SourceDebugExtension(value={"SMAP\nJzAzBz.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JzAzBz.kt\ncom/github/ajalt/colormath/model/JzAzBz\n+ 2 InternalMath.kt\ncom/github/ajalt/colormath/internal/InternalMathKt\n*L\n1#1,76:1\n31#2,3:77\n*S KotlinDebug\n*F\n+ 1 JzAzBz.kt\ncom/github/ajalt/colormath/model/JzAzBz\n*L\n72#1:77,3\n*E\n"})
public final class JzAzBz
implements Color {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float j;
    private final float a;
    private final float b;
    private final float alpha;
    @NotNull
    private static final List<ColorComponentInfo> components;
    public static final double d0 = 1.6295499532821565E-11;

    public JzAzBz(float j, float a, float b, float alpha) {
        this.j = j;
        this.a = a;
        this.b = b;
        this.alpha = alpha;
    }

    public /* synthetic */ JzAzBz(float f, float f2, float f3, float f4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            f4 = 1.0f;
        }
        this(f, f2, f3, f4);
    }

    public final float getJ() {
        return this.j;
    }

    public final float getA() {
        return this.a;
    }

    public final float getB() {
        return this.b;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    public JzAzBz(@NotNull Number j, @NotNull Number a, @NotNull Number b, @NotNull Number alpha) {
        Intrinsics.checkNotNullParameter(j, "j");
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        Intrinsics.checkNotNullParameter(alpha, "alpha");
        this(j.floatValue(), a.floatValue(), b.floatValue(), alpha.floatValue());
    }

    public /* synthetic */ JzAzBz(Number number, Number number2, Number number3, Number number4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            number4 = Float.valueOf(1.0f);
        }
        this(number, number2, number3, number4);
    }

    @NotNull
    public ColorSpace<JzAzBz> getSpace() {
        return Companion;
    }

    @Override
    @NotNull
    public RGB toSRGB() {
        return this.j == 0.0f ? RGB.Companion.invoke(0.0f, 0.0f, 0.0f, this.getAlpha()) : this.toXYZ().toSRGB();
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        double jz = (double)this.j + 1.6295499532821565E-11;
        double iz = jz / (0.44 + 0.56 * jz);
        double l = JzAzBz.toXYZ$pqInv(iz + 0.1386050432715393 * (double)this.a + 0.05804731615611869 * (double)this.b);
        double m = JzAzBz.toXYZ$pqInv(iz - 0.1386050432715393 * (double)this.a - 0.05804731615611891 * (double)this.b);
        double s = JzAzBz.toXYZ$pqInv(iz - 0.09601924202631895 * (double)this.a - 0.811891896056039 * (double)this.b);
        return XYZ.Companion.invoke(1.661373055774069 * l - 0.9145230923250668 * m + 0.2313620767186147 * s, -0.3250758740427037 * l + 1.571847038366936 * m - 0.218253831867294 * s, -0.09098281098284756 * l - 0.312728290523074 * m + 1.52276656130526 * s, Float.valueOf(this.getAlpha()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JzCzHz toJzCzHz() {
        void h;
        void a$iv;
        float f = this.a;
        float b$iv = this.b;
        boolean $i$f$toPolarModel = false;
        float c$iv = (float)Math.sqrt((double)(a$iv * a$iv + b$iv * b$iv));
        float h$iv = (double)c$iv > -1.0E-7 && (double)c$iv < 1.0E-7 ? Float.NaN : InternalMathKt.radToDeg((float)Math.atan2(b$iv, (double)a$iv));
        float f2 = InternalMathKt.normalizeDeg(h$iv);
        float c = c$iv;
        boolean bl = false;
        return new JzCzHz(this.j, c, (float)h, this.getAlpha());
    }

    @Override
    @NotNull
    public JzAzBz toJzAzBz() {
        return this;
    }

    @Override
    @NotNull
    public float[] toArray() {
        float[] fArray = new float[]{this.j, this.a, this.b, this.getAlpha()};
        return fArray;
    }

    @Override
    @NotNull
    public HSL toHSL() {
        return Color.DefaultImpls.toHSL(this);
    }

    @Override
    @NotNull
    public HSV toHSV() {
        return Color.DefaultImpls.toHSV(this);
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return Color.DefaultImpls.toAnsi16(this);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return Color.DefaultImpls.toAnsi256(this);
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return Color.DefaultImpls.toCMYK(this);
    }

    @Override
    @NotNull
    public LAB toLAB() {
        return Color.DefaultImpls.toLAB(this);
    }

    @Override
    @NotNull
    public LCHab toLCHab() {
        return Color.DefaultImpls.toLCHab(this);
    }

    @Override
    @NotNull
    public LUV toLUV() {
        return Color.DefaultImpls.toLUV(this);
    }

    @Override
    @NotNull
    public LCHuv toLCHuv() {
        return Color.DefaultImpls.toLCHuv(this);
    }

    @Override
    @NotNull
    public HWB toHWB() {
        return Color.DefaultImpls.toHWB(this);
    }

    @Override
    @NotNull
    public Oklab toOklab() {
        return Color.DefaultImpls.toOklab(this);
    }

    @Override
    @NotNull
    public Oklch toOklch() {
        return Color.DefaultImpls.toOklch(this);
    }

    @Override
    @NotNull
    public ICtCp toICtCp() {
        return Color.DefaultImpls.toICtCp(this);
    }

    @Override
    @NotNull
    public HSLuv toHSLuv() {
        return Color.DefaultImpls.toHSLuv(this);
    }

    @Override
    @NotNull
    public HPLuv toHPLuv() {
        return Color.DefaultImpls.toHPLuv(this);
    }

    public final float component1() {
        return this.j;
    }

    public final float component2() {
        return this.a;
    }

    public final float component3() {
        return this.b;
    }

    public final float component4() {
        return this.alpha;
    }

    @NotNull
    public final JzAzBz copy(float j, float a, float b, float alpha) {
        return new JzAzBz(j, a, b, alpha);
    }

    public static /* synthetic */ JzAzBz copy$default(JzAzBz jzAzBz, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 1) != 0) {
            f = jzAzBz.j;
        }
        if ((n & 2) != 0) {
            f2 = jzAzBz.a;
        }
        if ((n & 4) != 0) {
            f3 = jzAzBz.b;
        }
        if ((n & 8) != 0) {
            f4 = jzAzBz.alpha;
        }
        return jzAzBz.copy(f, f2, f3, f4);
    }

    @NotNull
    public String toString() {
        return "JzAzBz(j=" + this.j + ", a=" + this.a + ", b=" + this.b + ", alpha=" + this.alpha + ')';
    }

    public int hashCode() {
        int result = Float.hashCode(this.j);
        result = result * 31 + Float.hashCode(this.a);
        result = result * 31 + Float.hashCode(this.b);
        result = result * 31 + Float.hashCode(this.alpha);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JzAzBz)) {
            return false;
        }
        JzAzBz jzAzBz = (JzAzBz)other;
        if (Float.compare(this.j, jzAzBz.j) != 0) {
            return false;
        }
        if (Float.compare(this.a, jzAzBz.a) != 0) {
            return false;
        }
        if (Float.compare(this.b, jzAzBz.b) != 0) {
            return false;
        }
        return Float.compare(this.alpha, jzAzBz.alpha) == 0;
    }

    private static final double toXYZ$pqInv(double x) {
        double xx = Math.pow(x, 0.007460772656268214);
        double v = 10000.0 * Math.pow((0.8359375 - xx) / (18.6875 * xx - 18.8515625), 6.277394636015326);
        return Double.isNaN(v) ? 0.0 : v;
    }

    static {
        String[] stringArray = new String[]{"Jz", "Az", "Bz"};
        components = ColorSpaceUtilsKt.rectangularComponentInfo(stringArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0013H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/github/ajalt/colormath/model/JzAzBz$Companion;", "Lcom/github/ajalt/colormath/ColorSpace;", "Lcom/github/ajalt/colormath/model/JzAzBz;", "()V", "components", "", "Lcom/github/ajalt/colormath/ColorComponentInfo;", "getComponents", "()Ljava/util/List;", "d0", "", "name", "", "getName", "()Ljava/lang/String;", "convert", "color", "Lcom/github/ajalt/colormath/Color;", "create", "", "colormath"})
    @SourceDebugExtension(value={"SMAP\nJzAzBz.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JzAzBz.kt\ncom/github/ajalt/colormath/model/JzAzBz$Companion\n+ 2 ColorSpaceUtils.kt\ncom/github/ajalt/colormath/internal/ColorSpaceUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n23#2:77\n12#2,13:78\n1#3:91\n*S KotlinDebug\n*F\n+ 1 JzAzBz.kt\ncom/github/ajalt/colormath/model/JzAzBz$Companion\n*L\n35#1:77\n35#1:78,13\n35#1:91\n*E\n"})
    public static final class Companion
    implements ColorSpace<JzAzBz> {
        private Companion() {
        }

        @Override
        @NotNull
        public String getName() {
            return "JzAzBz";
        }

        @Override
        @NotNull
        public List<ColorComponentInfo> getComponents() {
            return components;
        }

        @Override
        @NotNull
        public JzAzBz convert(@NotNull Color color) {
            Intrinsics.checkNotNullParameter(color, "color");
            return color.toJzAzBz();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public JzAzBz create(@NotNull float[] components) {
            void p3;
            void p2;
            void p1;
            float f;
            Intrinsics.checkNotNullParameter(components, "components");
            ColorSpace $this$doCreate$iv = this;
            boolean $i$f$doCreate = false;
            ColorSpace $this$withValidComps$iv$iv = $this$doCreate$iv;
            boolean $i$f$withValidComps = false;
            int size$iv$iv = $this$withValidComps$iv$iv.getComponents().size();
            int n = size$iv$iv - 1;
            int n2 = components.length;
            if (!(n <= n2 ? n2 <= size$iv$iv : false)) {
                boolean bl = false;
                String string = "Invalid component array length: " + components.length + ", expected " + (size$iv$iv - 1) + " or " + size$iv$iv;
                throw new IllegalArgumentException(string.toString());
            }
            float[] it$iv = components;
            boolean bl = false;
            float f2 = components[0];
            float f3 = components[1];
            float f4 = components[2];
            int n3 = 3;
            float[] fArray = components;
            if (n3 <= ArraysKt.getLastIndex(fArray)) {
                f = fArray[n3];
            } else {
                int n4 = n3;
                float f5 = f4;
                float f6 = f3;
                float f7 = f2;
                boolean bl2 = false;
                float f8 = 1.0f;
                f2 = f7;
                f3 = f6;
                f4 = f5;
                f = f8;
            }
            float f9 = f;
            float f10 = f4;
            float f11 = f3;
            float p0 = f2;
            boolean bl3 = false;
            return (JzAzBz)((Color)new JzAzBz(p0, (float)p1, (float)p2, (float)p3));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

