/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.ColorSpace;
import com.github.ajalt.colormath.HueColor;
import com.github.ajalt.colormath.internal.ColorSpaceUtilsKt;
import com.github.ajalt.colormath.model.Ansi16;
import com.github.ajalt.colormath.model.Ansi256;
import com.github.ajalt.colormath.model.CMYK;
import com.github.ajalt.colormath.model.HPLuv;
import com.github.ajalt.colormath.model.HSL;
import com.github.ajalt.colormath.model.HSLuv;
import com.github.ajalt.colormath.model.HSV;
import com.github.ajalt.colormath.model.ICtCp;
import com.github.ajalt.colormath.model.JzAzBz;
import com.github.ajalt.colormath.model.JzCzHz;
import com.github.ajalt.colormath.model.LAB;
import com.github.ajalt.colormath.model.LCHab;
import com.github.ajalt.colormath.model.LCHuv;
import com.github.ajalt.colormath.model.LUV;
import com.github.ajalt.colormath.model.Oklab;
import com.github.ajalt.colormath.model.Oklch;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.XYZ;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0001(B)\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bB'\u0012\u0006\u0010\u0003\u001a\u00020\t\u0012\u0006\u0010\u0005\u001a\u00020\t\u0012\u0006\u0010\u0006\u001a\u00020\t\u0012\b\b\u0002\u0010\u0007\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0014\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0015\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\t2\b\b\u0002\u0010\u0005\u001a\u00020\t2\b\b\u0002\u0010\u0006\u001a\u00020\t2\b\b\u0002\u0010\u0007\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0000H\u0016J\b\u0010$\u001a\u00020%H\u0016J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u0014\u0010\u0007\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u0003\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00000\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\f\u00a8\u0006)"}, d2={"Lcom/github/ajalt/colormath/model/HWB;", "Lcom/github/ajalt/colormath/Color;", "Lcom/github/ajalt/colormath/HueColor;", "h", "", "w", "b", "alpha", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "", "(FFFF)V", "getAlpha", "()F", "getB", "getH", "space", "Lcom/github/ajalt/colormath/ColorSpace;", "getSpace", "()Lcom/github/ajalt/colormath/ColorSpace;", "getW", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toArray", "", "toHSV", "Lcom/github/ajalt/colormath/model/HSV;", "toHWB", "toSRGB", "Lcom/github/ajalt/colormath/model/RGB;", "toString", "", "Companion", "colormath"})
public final class HWB
implements Color,
HueColor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float h;
    private final float w;
    private final float b;
    private final float alpha;
    @NotNull
    private static final List<ColorComponentInfo> components = ColorSpaceUtilsKt.polarComponentInfo("HWB");

    public HWB(float h, float w, float b, float alpha) {
        this.h = h;
        this.w = w;
        this.b = b;
        this.alpha = alpha;
    }

    public /* synthetic */ HWB(float f, float f2, float f3, float f4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            f4 = 1.0f;
        }
        this(f, f2, f3, f4);
    }

    @Override
    public float getH() {
        return this.h;
    }

    public final float getW() {
        return this.w;
    }

    public final float getB() {
        return this.b;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    public HWB(@NotNull Number h, @NotNull Number w, @NotNull Number b, @NotNull Number alpha) {
        Intrinsics.checkNotNullParameter(h, "h");
        Intrinsics.checkNotNullParameter(w, "w");
        Intrinsics.checkNotNullParameter(b, "b");
        Intrinsics.checkNotNullParameter(alpha, "alpha");
        this(h.floatValue(), w.floatValue(), b.floatValue(), alpha.floatValue());
    }

    public /* synthetic */ HWB(Number number, Number number2, Number number3, Number number4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            number4 = Float.valueOf(1.0f);
        }
        this(number, number2, number3, number4);
    }

    @NotNull
    public ColorSpace<HWB> getSpace() {
        return Companion;
    }

    @Override
    @NotNull
    public RGB toSRGB() {
        RGB rGB;
        float h = this.getH() / 60.0f;
        float w = this.w;
        float b = this.b;
        float a = this.getAlpha();
        if (w + b >= 1.0f) {
            float gray = w / (w + b);
            return RGB.Companion.invoke(gray, gray, gray, a);
        }
        float v = 1.0f - b;
        int i = (int)h;
        float f = i % 2 == 1 ? 1.0f - (h - (float)i) : h - (float)i;
        float n = w + f * (v - w);
        switch (i) {
            case 1: {
                rGB = RGB.Companion.invoke(n, v, w, a);
                break;
            }
            case 2: {
                rGB = RGB.Companion.invoke(w, v, n, a);
                break;
            }
            case 3: {
                rGB = RGB.Companion.invoke(w, n, v, a);
                break;
            }
            case 4: {
                rGB = RGB.Companion.invoke(n, w, v, a);
                break;
            }
            case 5: {
                rGB = RGB.Companion.invoke(v, w, n, a);
                break;
            }
            default: {
                rGB = RGB.Companion.invoke(v, n, w, a);
            }
        }
        return rGB;
    }

    @Override
    @NotNull
    public HSV toHSV() {
        float w = this.w / (float)100;
        float b = this.b / (float)100;
        float s = 1.0f - w / (1.0f - b);
        float v = 1.0f - b;
        return new HSV((Number)MathKt.roundToInt(this.getH()), (Number)MathKt.roundToInt(s * (float)100), (Number)MathKt.roundToInt(v * (float)100), Float.valueOf(this.getAlpha()));
    }

    @Override
    @NotNull
    public HWB toHWB() {
        return this;
    }

    @Override
    @NotNull
    public float[] toArray() {
        float[] fArray = new float[]{this.getH(), this.w, this.b, this.getAlpha()};
        return fArray;
    }

    @Override
    @NotNull
    public HSL toHSL() {
        return Color.DefaultImpls.toHSL(this);
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return Color.DefaultImpls.toAnsi16(this);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return Color.DefaultImpls.toAnsi256(this);
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return Color.DefaultImpls.toCMYK(this);
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        return Color.DefaultImpls.toXYZ(this);
    }

    @Override
    @NotNull
    public LAB toLAB() {
        return Color.DefaultImpls.toLAB(this);
    }

    @Override
    @NotNull
    public LCHab toLCHab() {
        return Color.DefaultImpls.toLCHab(this);
    }

    @Override
    @NotNull
    public LUV toLUV() {
        return Color.DefaultImpls.toLUV(this);
    }

    @Override
    @NotNull
    public LCHuv toLCHuv() {
        return Color.DefaultImpls.toLCHuv(this);
    }

    @Override
    @NotNull
    public Oklab toOklab() {
        return Color.DefaultImpls.toOklab(this);
    }

    @Override
    @NotNull
    public Oklch toOklch() {
        return Color.DefaultImpls.toOklch(this);
    }

    @Override
    @NotNull
    public JzAzBz toJzAzBz() {
        return Color.DefaultImpls.toJzAzBz(this);
    }

    @Override
    @NotNull
    public JzCzHz toJzCzHz() {
        return Color.DefaultImpls.toJzCzHz(this);
    }

    @Override
    @NotNull
    public ICtCp toICtCp() {
        return Color.DefaultImpls.toICtCp(this);
    }

    @Override
    @NotNull
    public HSLuv toHSLuv() {
        return Color.DefaultImpls.toHSLuv(this);
    }

    @Override
    @NotNull
    public HPLuv toHPLuv() {
        return Color.DefaultImpls.toHPLuv(this);
    }

    public final float component1() {
        return this.h;
    }

    public final float component2() {
        return this.w;
    }

    public final float component3() {
        return this.b;
    }

    public final float component4() {
        return this.alpha;
    }

    @NotNull
    public final HWB copy(float h, float w, float b, float alpha) {
        return new HWB(h, w, b, alpha);
    }

    public static /* synthetic */ HWB copy$default(HWB hWB, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 1) != 0) {
            f = hWB.h;
        }
        if ((n & 2) != 0) {
            f2 = hWB.w;
        }
        if ((n & 4) != 0) {
            f3 = hWB.b;
        }
        if ((n & 8) != 0) {
            f4 = hWB.alpha;
        }
        return hWB.copy(f, f2, f3, f4);
    }

    @NotNull
    public String toString() {
        return "HWB(h=" + this.h + ", w=" + this.w + ", b=" + this.b + ", alpha=" + this.alpha + ')';
    }

    public int hashCode() {
        int result = Float.hashCode(this.h);
        result = result * 31 + Float.hashCode(this.w);
        result = result * 31 + Float.hashCode(this.b);
        result = result * 31 + Float.hashCode(this.alpha);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HWB)) {
            return false;
        }
        HWB hWB = (HWB)other;
        if (Float.compare(this.h, hWB.h) != 0) {
            return false;
        }
        if (Float.compare(this.w, hWB.w) != 0) {
            return false;
        }
        if (Float.compare(this.b, hWB.b) != 0) {
            return false;
        }
        return Float.compare(this.alpha, hWB.alpha) == 0;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0011H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/github/ajalt/colormath/model/HWB$Companion;", "Lcom/github/ajalt/colormath/ColorSpace;", "Lcom/github/ajalt/colormath/model/HWB;", "()V", "components", "", "Lcom/github/ajalt/colormath/ColorComponentInfo;", "getComponents", "()Ljava/util/List;", "name", "", "getName", "()Ljava/lang/String;", "convert", "color", "Lcom/github/ajalt/colormath/Color;", "create", "", "colormath"})
    @SourceDebugExtension(value={"SMAP\nHWB.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HWB.kt\ncom/github/ajalt/colormath/model/HWB$Companion\n+ 2 ColorSpaceUtils.kt\ncom/github/ajalt/colormath/internal/ColorSpaceUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n23#2:82\n12#2,13:83\n1#3:96\n*S KotlinDebug\n*F\n+ 1 HWB.kt\ncom/github/ajalt/colormath/model/HWB$Companion\n*L\n29#1:82\n29#1:83,13\n29#1:96\n*E\n"})
    public static final class Companion
    implements ColorSpace<HWB> {
        private Companion() {
        }

        @Override
        @NotNull
        public String getName() {
            return "HWB";
        }

        @Override
        @NotNull
        public List<ColorComponentInfo> getComponents() {
            return components;
        }

        @Override
        @NotNull
        public HWB convert(@NotNull Color color) {
            Intrinsics.checkNotNullParameter(color, "color");
            return color.toHWB();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public HWB create(@NotNull float[] components) {
            void p3;
            void p2;
            void p1;
            float f;
            Intrinsics.checkNotNullParameter(components, "components");
            ColorSpace $this$doCreate$iv = this;
            boolean $i$f$doCreate = false;
            ColorSpace $this$withValidComps$iv$iv = $this$doCreate$iv;
            boolean $i$f$withValidComps = false;
            int size$iv$iv = $this$withValidComps$iv$iv.getComponents().size();
            int n = size$iv$iv - 1;
            int n2 = components.length;
            if (!(n <= n2 ? n2 <= size$iv$iv : false)) {
                boolean bl = false;
                String string = "Invalid component array length: " + components.length + ", expected " + (size$iv$iv - 1) + " or " + size$iv$iv;
                throw new IllegalArgumentException(string.toString());
            }
            float[] it$iv = components;
            boolean bl = false;
            float f2 = components[0];
            float f3 = components[1];
            float f4 = components[2];
            int n3 = 3;
            float[] fArray = components;
            if (n3 <= ArraysKt.getLastIndex(fArray)) {
                f = fArray[n3];
            } else {
                int n4 = n3;
                float f5 = f4;
                float f6 = f3;
                float f7 = f2;
                boolean bl2 = false;
                float f8 = 1.0f;
                f2 = f7;
                f3 = f6;
                f4 = f5;
                f = f8;
            }
            float f9 = f;
            float f10 = f4;
            float f11 = f3;
            float p0 = f2;
            boolean bl3 = false;
            return (HWB)((Color)new HWB(p0, (float)p1, (float)p2, (float)p3));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

