/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath;

import com.github.ajalt.colormath.AngleUnit;
import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorKt;
import com.github.ajalt.colormath.HueColor;
import com.github.ajalt.colormath.HueColorKt;
import com.github.ajalt.colormath.RenderCondition;
import com.github.ajalt.colormath.internal.InternalMathKt;
import com.github.ajalt.colormath.model.HSL;
import com.github.ajalt.colormath.model.HWB;
import com.github.ajalt.colormath.model.LAB;
import com.github.ajalt.colormath.model.LABColorSpaces;
import com.github.ajalt.colormath.model.LCHab;
import com.github.ajalt.colormath.model.LCHabColorSpaces;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.RGBColorSpace;
import com.github.ajalt.colormath.model.RGBColorSpaces;
import com.github.ajalt.colormath.model.RGBInt;
import com.github.ajalt.colormath.model.SRGB;
import com.github.ajalt.colormath.model.XYZ;
import com.github.ajalt.colormath.model.XYZColorSpaces;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UByte;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aF\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u000b\u001aH\u0010\u000f\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u000b\u001a\u0016\u0010\u0010\u001a\u00020\u0001*\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u000bH\u0002\u001a$\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u001a,\u0010\u0014\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u001aG\u0010\u0016\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00012\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0018\"\u00020\u00012\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u0013\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0019\u001a$\u0010\u001a\u001a\u00020\u0001*\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a4\u0010\u001c\u001a\u00020\u0001*\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0014\u0010\u001f\u001a\u00020\u0001*\u00020 2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a$\u0010!\u001a\u00020\u0001*\u00020\"2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001c\u0010#\u001a\u00020\u0001*\u00020$2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a4\u0010%\u001a\u00020\u0001*\u00020&2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006)"}, d2={"dashName", "", "Lcom/github/ajalt/colormath/Color;", "getDashName", "(Lcom/github/ajalt/colormath/Color;)Ljava/lang/String;", "formatCssString", "hueUnit", "Lcom/github/ajalt/colormath/AngleUnit;", "renderAlpha", "Lcom/github/ajalt/colormath/RenderCondition;", "unitsPercent", "", "alphaPercent", "legacyName", "legacyFormat", "formatCssStringOrNull", "render", "", "percent", "commas", "renderColorFunction", "name", "renderFunction", "components", "", "(Lcom/github/ajalt/colormath/Color;Ljava/lang/String;[Ljava/lang/String;ZLcom/github/ajalt/colormath/RenderCondition;Z)Ljava/lang/String;", "renderHWB", "Lcom/github/ajalt/colormath/model/HWB;", "renderHsl", "Lcom/github/ajalt/colormath/model/HSL;", "namedHsla", "renderHue", "Lcom/github/ajalt/colormath/HueColor;", "renderLCH", "Lcom/github/ajalt/colormath/model/LCHab;", "renderLab", "Lcom/github/ajalt/colormath/model/LAB;", "renderSRGB", "Lcom/github/ajalt/colormath/model/RGB;", "namedRgba", "rgbPercent", "colormath"})
public final class CssRenderKt {
    @Nullable
    public static final String formatCssStringOrNull(@NotNull Color $this$formatCssStringOrNull, @NotNull AngleUnit hueUnit, @NotNull RenderCondition renderAlpha, boolean unitsPercent, boolean alphaPercent, boolean legacyName, boolean legacyFormat) {
        RGBColorSpace rGBColorSpace;
        Intrinsics.checkNotNullParameter($this$formatCssStringOrNull, "<this>");
        Intrinsics.checkNotNullParameter((Object)hueUnit, "hueUnit");
        Intrinsics.checkNotNullParameter((Object)renderAlpha, "renderAlpha");
        Color color = $this$formatCssStringOrNull;
        return color instanceof RGB ? (Intrinsics.areEqual(rGBColorSpace = ((RGB)$this$formatCssStringOrNull).getSpace(), SRGB.INSTANCE) ? CssRenderKt.renderSRGB((RGB)$this$formatCssStringOrNull, legacyFormat, legacyName, unitsPercent, alphaPercent, renderAlpha) : (Intrinsics.areEqual(rGBColorSpace, RGBColorSpaces.INSTANCE.getDisplayP3()) ? CssRenderKt.renderColorFunction($this$formatCssStringOrNull, "display-p3", unitsPercent, alphaPercent, renderAlpha) : (Intrinsics.areEqual(rGBColorSpace, RGBColorSpaces.INSTANCE.getAdobeRGB()) ? CssRenderKt.renderColorFunction($this$formatCssStringOrNull, "a98-rgb", unitsPercent, alphaPercent, renderAlpha) : (Intrinsics.areEqual(rGBColorSpace, RGBColorSpaces.INSTANCE.getROMM_RGB()) ? CssRenderKt.renderColorFunction($this$formatCssStringOrNull, "prophoto-rgb", unitsPercent, alphaPercent, renderAlpha) : (Intrinsics.areEqual(rGBColorSpace, RGBColorSpaces.INSTANCE.getBT2020()) ? CssRenderKt.renderColorFunction($this$formatCssStringOrNull, "rec2020", unitsPercent, alphaPercent, renderAlpha) : null))))) : (color instanceof HSL ? CssRenderKt.renderHsl((HSL)$this$formatCssStringOrNull, legacyFormat, legacyName, hueUnit, alphaPercent, renderAlpha) : (color instanceof LAB ? CssRenderKt.renderLab((LAB)ColorKt.convertTo($this$formatCssStringOrNull, LABColorSpaces.INSTANCE.getLAB50()), alphaPercent, renderAlpha) : (color instanceof LCHab ? CssRenderKt.renderLCH((LCHab)ColorKt.convertTo($this$formatCssStringOrNull, LCHabColorSpaces.INSTANCE.getLCHab50()), hueUnit, alphaPercent, renderAlpha) : (color instanceof HWB ? CssRenderKt.renderHWB((HWB)$this$formatCssStringOrNull, hueUnit, alphaPercent, renderAlpha) : (color instanceof XYZ ? CssRenderKt.renderColorFunction(((XYZ)$this$formatCssStringOrNull).adaptTo(XYZColorSpaces.INSTANCE.getXYZ50()), "xyz", unitsPercent, alphaPercent, renderAlpha) : null)))));
    }

    public static /* synthetic */ String formatCssStringOrNull$default(Color color, AngleUnit angleUnit, RenderCondition renderCondition, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
        if ((n & 1) != 0) {
            angleUnit = AngleUnit.AUTO;
        }
        if ((n & 2) != 0) {
            renderCondition = RenderCondition.AUTO;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        if ((n & 0x20) != 0) {
            bl4 = false;
        }
        return CssRenderKt.formatCssStringOrNull(color, angleUnit, renderCondition, bl, bl2, bl3, bl4);
    }

    @NotNull
    public static final String formatCssString(@NotNull Color $this$formatCssString, @NotNull AngleUnit hueUnit, @NotNull RenderCondition renderAlpha, boolean unitsPercent, boolean alphaPercent, boolean legacyName, boolean legacyFormat) {
        Intrinsics.checkNotNullParameter($this$formatCssString, "<this>");
        Intrinsics.checkNotNullParameter((Object)hueUnit, "hueUnit");
        Intrinsics.checkNotNullParameter((Object)renderAlpha, "renderAlpha");
        String string = CssRenderKt.formatCssStringOrNull($this$formatCssString, hueUnit, renderAlpha, unitsPercent, alphaPercent, legacyName, legacyFormat);
        if (string == null) {
            string = CssRenderKt.renderColorFunction($this$formatCssString, CssRenderKt.getDashName($this$formatCssString), unitsPercent, alphaPercent, renderAlpha);
        }
        return string;
    }

    public static /* synthetic */ String formatCssString$default(Color color, AngleUnit angleUnit, RenderCondition renderCondition, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
        if ((n & 1) != 0) {
            angleUnit = AngleUnit.AUTO;
        }
        if ((n & 2) != 0) {
            renderCondition = RenderCondition.AUTO;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        if ((n & 0x20) != 0) {
            bl4 = false;
        }
        return CssRenderKt.formatCssString(color, angleUnit, renderCondition, bl, bl2, bl3, bl4);
    }

    private static final String renderSRGB(RGB $this$renderSRGB, boolean commas, boolean namedRgba, boolean rgbPercent, boolean alphaPercent, RenderCondition renderAlpha) {
        String[] stringArray = new String[]{rgbPercent ? CssRenderKt.render($this$renderSRGB.getR(), true) : UByte.toString-impl(RGBInt.getR-w2LRezQ($this$renderSRGB.toRGBInt-RGiG7fk())), rgbPercent ? CssRenderKt.render($this$renderSRGB.getG(), true) : UByte.toString-impl(RGBInt.getG-w2LRezQ($this$renderSRGB.toRGBInt-RGiG7fk())), rgbPercent ? CssRenderKt.render($this$renderSRGB.getB(), true) : UByte.toString-impl(RGBInt.getB-w2LRezQ($this$renderSRGB.toRGBInt-RGiG7fk()))};
        return CssRenderKt.renderFunction($this$renderSRGB, namedRgba ? "rgba" : "rgb", stringArray, alphaPercent, renderAlpha, commas);
    }

    private static final String renderHsl(HSL $this$renderHsl, boolean commas, boolean namedHsla, AngleUnit hueUnit, boolean alphaPercent, RenderCondition renderAlpha) {
        String[] stringArray = new String[]{CssRenderKt.renderHue($this$renderHsl, hueUnit), CssRenderKt.render($this$renderHsl.getS(), true), CssRenderKt.render($this$renderHsl.getL(), true)};
        return CssRenderKt.renderFunction($this$renderHsl, namedHsla ? "hsla" : "hsl", stringArray, alphaPercent, renderAlpha, commas);
    }

    private static final String renderLab(LAB $this$renderLab, boolean alphaPercent, RenderCondition renderAlpha) {
        String[] stringArray = new String[]{CssRenderKt.render($this$renderLab.getL() / (float)100, true), CssRenderKt.render$default($this$renderLab.getA(), false, 1, null), CssRenderKt.render$default($this$renderLab.getB(), false, 1, null)};
        return CssRenderKt.renderFunction$default($this$renderLab, "lab", stringArray, alphaPercent, renderAlpha, false, 16, null);
    }

    private static final String renderLCH(LCHab $this$renderLCH, AngleUnit hueUnit, boolean alphaPercent, RenderCondition renderAlpha) {
        String[] stringArray = new String[]{CssRenderKt.render($this$renderLCH.getL() / (float)100, true), CssRenderKt.render$default($this$renderLCH.getC(), false, 1, null), CssRenderKt.renderHue($this$renderLCH, hueUnit)};
        return CssRenderKt.renderFunction$default($this$renderLCH, "lch", stringArray, alphaPercent, renderAlpha, false, 16, null);
    }

    private static final String renderHWB(HWB $this$renderHWB, AngleUnit hueUnit, boolean alphaPercent, RenderCondition renderAlpha) {
        String[] stringArray = new String[]{CssRenderKt.renderHue($this$renderHWB, hueUnit), CssRenderKt.render($this$renderHWB.getW(), true), CssRenderKt.render($this$renderHWB.getB(), true)};
        return CssRenderKt.renderFunction$default($this$renderHWB, "hwb", stringArray, alphaPercent, renderAlpha, false, 16, null);
    }

    private static final String renderFunction(Color $this$renderFunction, String name, String[] components, boolean alphaPercent, RenderCondition renderAlpha, boolean commas) {
        StringBuilder stringBuilder;
        StringBuilder $this$renderFunction_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String sep = commas ? ", " : " ";
        $this$renderFunction_u24lambda_u240.append(name).append("(");
        ArraysKt.joinTo$default(components, (Appendable)$this$renderFunction_u24lambda_u240, (CharSequence)sep, null, null, 0, null, null, 124, null);
        $this$renderFunction_u24lambda_u240.append(CssRenderKt.renderAlpha($this$renderFunction, commas, renderAlpha, alphaPercent));
        $this$renderFunction_u24lambda_u240.append(")");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    static /* synthetic */ String renderFunction$default(Color color, String string, String[] stringArray, boolean bl, RenderCondition renderCondition, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        return CssRenderKt.renderFunction(color, string, stringArray, bl, renderCondition, bl2);
    }

    private static final String renderHue(HueColor $this$renderHue, AngleUnit hueUnit) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[hueUnit.ordinal()]) {
            case 1: {
                string = CssRenderKt.render$default($this$renderHue.getH(), false, 1, null);
                break;
            }
            case 2: {
                string = CssRenderKt.render$default($this$renderHue.getH(), false, 1, null) + "deg";
                break;
            }
            case 3: {
                string = CssRenderKt.render$default(HueColorKt.hueAsRad($this$renderHue), false, 1, null) + "rad";
                break;
            }
            case 4: {
                string = CssRenderKt.render$default(HueColorKt.hueAsGrad($this$renderHue), false, 1, null) + "grad";
                break;
            }
            case 5: {
                string = CssRenderKt.render$default(HueColorKt.hueAsTurns($this$renderHue), false, 1, null) + "turn";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private static final String renderColorFunction(Color $this$renderColorFunction, String name, boolean unitsPercent, boolean alphaPercent, RenderCondition renderAlpha) {
        StringBuilder stringBuilder;
        StringBuilder $this$renderColorFunction_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$renderColorFunction_u24lambda_u241.append("color(").append(name).append(" ");
        CollectionsKt.joinTo$default(ArraysKt.dropLast($this$renderColorFunction.toArray(), 1), $this$renderColorFunction_u24lambda_u241, " ", null, null, 0, null, new Function1<Float, CharSequence>(unitsPercent){
            final /* synthetic */ boolean $unitsPercent;
            {
                this.$unitsPercent = $unitsPercent;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(float it) {
                return CssRenderKt.access$render(it, this.$unitsPercent);
            }
        }, 60, null);
        $this$renderColorFunction_u24lambda_u241.append(CssRenderKt.renderAlpha($this$renderColorFunction, false, renderAlpha, alphaPercent));
        $this$renderColorFunction_u24lambda_u241.append(")");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private static final String renderAlpha(Color $this$renderAlpha, boolean commas, RenderCondition renderAlpha, boolean alphaPercent) {
        return renderAlpha == RenderCondition.ALWAYS || renderAlpha == RenderCondition.AUTO && !Float.isNaN($this$renderAlpha.getAlpha()) && !($this$renderAlpha.getAlpha() == 1.0f) ? (commas ? ", " : " / ") + CssRenderKt.render(InternalMathKt.nanToOne($this$renderAlpha.getAlpha()), alphaPercent) : "";
    }

    private static final String render(float $this$render, boolean percent) {
        String string;
        boolean bl = percent;
        if (bl) {
            string = "" + MathKt.roundToInt($this$render * (float)100) + '%';
        } else if (!bl) {
            float f = $this$render;
            if (f == 0.0f) {
                string = "0";
            } else if (f == 1.0f) {
                string = "1";
            } else {
                String str = String.valueOf($this$render);
                String s = StringsKt.startsWith$default(str, ".", false, 2, null) ? '0' + str : str;
                int i = StringsKt.indexOf$default((CharSequence)s, '.', 0, false, 6, null);
                if (i < 0) {
                    string = s;
                } else {
                    char[] cArray = new char[]{'0'};
                    String string2 = StringsKt.trimEnd(StringsKt.take(s, i + 5), cArray);
                    cArray = new char[]{'.'};
                    string = StringsKt.trimEnd(string2, cArray);
                }
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    static /* synthetic */ String render$default(float f, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return CssRenderKt.render(f, bl);
    }

    private static final String getDashName(Color $this$dashName) {
        StringBuilder stringBuilder = new StringBuilder().append("--");
        CharSequence charSequence = $this$dashName.getSpace().getName();
        Regex regex = new Regex("\\W");
        String string = "-";
        String string2 = regex.replace(charSequence, string).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        return stringBuilder.append(string2).toString();
    }

    public static final /* synthetic */ String access$render(float $receiver, boolean percent) {
        return CssRenderKt.render($receiver, percent);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AngleUnit.values().length];
            try {
                nArray[AngleUnit.AUTO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AngleUnit.DEGREES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AngleUnit.RADIANS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AngleUnit.GRADIANS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AngleUnit.TURNS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

