/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.PATTERNS;
import com.github.ajalt.colormath.WhitePointColorSpace;
import com.github.ajalt.colormath.internal.CssColors;
import com.github.ajalt.colormath.internal.InternalMathKt;
import com.github.ajalt.colormath.model.HSL;
import com.github.ajalt.colormath.model.HWB;
import com.github.ajalt.colormath.model.LAB;
import com.github.ajalt.colormath.model.LCHab;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.RGBColorSpaces;
import com.github.ajalt.colormath.model.SRGB;
import com.github.ajalt.colormath.model.XYZColorSpaces;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\u0011\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u0010\u0012\u001a\u00020\u00012\b\b\u0002\u0010\u0013\u001a\u00020\u0001H\u0002\u001a \u0010\u0014\u001a\u00020\u0015*\u00020\u00012\b\b\u0002\u0010\u0012\u001a\u00020\u00152\b\b\u0002\u0010\u0013\u001a\u00020\u0015H\u0002\u001a\u0012\u0010\u0016\u001a\u00020\u0005*\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u0005*\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u0003\u00a8\u0006\u0019"}, d2={"alpha", "", "str", "", "color", "Lcom/github/ajalt/colormath/Color;", "match", "Lkotlin/text/MatchResult;", "hsl", "hue", "hwb", "lab", "lch", "number", "percent", "percentOrNumber", "rgb", "clampF", "min", "max", "clampInt", "", "parse", "Lcom/github/ajalt/colormath/Color$Companion;", "parseOrNull", "colormath"})
@SourceDebugExtension(value={"SMAP\nCssParse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CssParse.kt\ncom/github/ajalt/colormath/CssParseKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1#2:157\n1549#3:158\n1620#3,3:159\n*S KotlinDebug\n*F\n+ 1 CssParse.kt\ncom/github/ajalt/colormath/CssParseKt\n*L\n82#1:158\n82#1:159,3\n*E\n"})
public final class CssParseKt {
    @NotNull
    public static final Color parse(@NotNull Color.Companion $this$parse, @NotNull String color) {
        Intrinsics.checkNotNullParameter($this$parse, "<this>");
        Intrinsics.checkNotNullParameter(color, "color");
        Color color2 = CssParseKt.parseOrNull($this$parse, color);
        if (color2 == null) {
            throw new IllegalArgumentException("Invalid color: " + color);
        }
        return color2;
    }

    @Nullable
    public static final Color parseOrNull(@NotNull Color.Companion $this$parseOrNull, @NotNull String color) {
        Object object;
        block31: {
            block33: {
                block32: {
                    Object object2;
                    block30: {
                        Intrinsics.checkNotNullParameter($this$parseOrNull, "<this>");
                        Intrinsics.checkNotNullParameter(color, "color");
                        RGB keywordColor = CssColors.INSTANCE.getColorsByName().get(color);
                        RGB rGB = keywordColor;
                        if (rGB == null) break block30;
                        object = rGB;
                        break block31;
                    }
                    if (!StringsKt.startsWith$default(color, "#", false, 2, null)) break block32;
                    Object object3 = $this$parseOrNull;
                    try {
                        Color.Companion $this$parseOrNull_u24lambda_u240 = object3;
                        boolean bl = false;
                        object2 = Result.constructor-impl(RGB.Companion.invoke(color));
                    }
                    catch (Throwable throwable) {
                        object2 = Result.constructor-impl(ResultKt.createFailure(throwable));
                    }
                    object3 = object2;
                    object = (Color)(Result.isFailure-impl(object3) ? null : object3);
                    break block31;
                }
                object = PATTERNS.INSTANCE.getRGB_1().matchEntire(color);
                if (object == null) break block33;
                Object it = object;
                boolean bl = false;
                Color color2 = CssParseKt.rgb((MatchResult)it);
                object = color2;
                if (color2 != null) break block31;
            }
            MatchResult matchResult = PATTERNS.INSTANCE.getRGB_2().matchEntire(color);
            if (matchResult != null) {
                MatchResult it = matchResult;
                boolean bl = false;
                object = CssParseKt.rgb(it);
            } else {
                Object object4;
                MatchResult matchResult2 = PATTERNS.INSTANCE.getRGB_3().matchEntire(color);
                if (matchResult2 != null) {
                    MatchResult it = matchResult2;
                    boolean bl = false;
                    object4 = CssParseKt.rgb(it);
                } else {
                    object4 = object = null;
                }
                if (object4 == null) {
                    Object object5;
                    MatchResult matchResult3 = PATTERNS.INSTANCE.getRGB_4().matchEntire(color);
                    if (matchResult3 != null) {
                        MatchResult it = matchResult3;
                        boolean bl = false;
                        object5 = CssParseKt.rgb(it);
                    } else {
                        object5 = object = null;
                    }
                    if (object5 == null) {
                        Object object6;
                        MatchResult matchResult4 = PATTERNS.INSTANCE.getHSL_1().matchEntire(color);
                        if (matchResult4 != null) {
                            MatchResult it = matchResult4;
                            boolean bl = false;
                            object6 = CssParseKt.hsl(it);
                        } else {
                            object6 = object = null;
                        }
                        if (object6 == null) {
                            Object object7;
                            MatchResult matchResult5 = PATTERNS.INSTANCE.getHSL_2().matchEntire(color);
                            if (matchResult5 != null) {
                                MatchResult it = matchResult5;
                                boolean bl = false;
                                object7 = CssParseKt.hsl(it);
                            } else {
                                object7 = object = null;
                            }
                            if (object7 == null) {
                                Object object8;
                                MatchResult matchResult6 = PATTERNS.INSTANCE.getLAB().matchEntire(color);
                                if (matchResult6 != null) {
                                    MatchResult it = matchResult6;
                                    boolean bl = false;
                                    object8 = CssParseKt.lab(it);
                                } else {
                                    object8 = object = null;
                                }
                                if (object8 == null) {
                                    Object object9;
                                    MatchResult matchResult7 = PATTERNS.INSTANCE.getLCH().matchEntire(color);
                                    if (matchResult7 != null) {
                                        MatchResult it = matchResult7;
                                        boolean bl = false;
                                        object9 = CssParseKt.lch(it);
                                    } else {
                                        object9 = object = null;
                                    }
                                    if (object9 == null) {
                                        Object object10;
                                        MatchResult matchResult8 = PATTERNS.INSTANCE.getHWB().matchEntire(color);
                                        if (matchResult8 != null) {
                                            MatchResult it = matchResult8;
                                            boolean bl = false;
                                            object10 = CssParseKt.hwb(it);
                                        } else {
                                            object10 = object = null;
                                        }
                                        if (object10 == null) {
                                            MatchResult matchResult9 = PATTERNS.INSTANCE.getCOLOR().matchEntire(color);
                                            if (matchResult9 != null) {
                                                MatchResult it = matchResult9;
                                                boolean bl = false;
                                                object = CssParseKt.color(it);
                                            } else {
                                                object = null;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Color color(MatchResult match) {
        Object object;
        Object object2;
        Float f;
        Object object3;
        int n;
        Object object4;
        Object object5;
        void $this$mapTo$iv$iv;
        WhitePointColorSpace whitePointColorSpace;
        block23: {
            block20: {
                block19: {
                    block22: {
                        block21: {
                            String string = match.getGroupValues().get(1);
                            switch (string.hashCode()) {
                                case -914567506: {
                                    if (string.equals("display-p3")) break;
                                    return null;
                                }
                                case 1080714636: {
                                    if (!string.equals("rec2020")) {
                                        return null;
                                    }
                                    break block19;
                                }
                                case 119193: {
                                    if (!string.equals("xyz")) {
                                        return null;
                                    }
                                    break block20;
                                }
                                case 1873543360: {
                                    if (!string.equals("a98-rgb")) {
                                        return null;
                                    }
                                    break block21;
                                }
                                case 1691026085: {
                                    if (!string.equals("prophoto-rgb")) {
                                        return null;
                                    }
                                    break block22;
                                }
                                case 3538810: {
                                    if (!string.equals("srgb")) return null;
                                    whitePointColorSpace = SRGB.INSTANCE;
                                    break block23;
                                }
                            }
                            whitePointColorSpace = RGBColorSpaces.INSTANCE.getDisplayP3();
                            break block23;
                        }
                        whitePointColorSpace = RGBColorSpaces.INSTANCE.getAdobeRGB();
                        break block23;
                    }
                    whitePointColorSpace = RGBColorSpaces.INSTANCE.getROMM_RGB();
                    break block23;
                }
                whitePointColorSpace = RGBColorSpaces.INSTANCE.getBT2020();
                break block23;
            }
            whitePointColorSpace = XYZColorSpaces.INSTANCE.getXYZ50();
            break block23;
            return null;
        }
        WhitePointColorSpace space = whitePointColorSpace;
        Object object6 = match.getGroupValues().get(2);
        Regex regex = new Regex("\\s+");
        int n2 = 0;
        Iterable $this$map$iv = regex.split((CharSequence)object6, n2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            object5 = destination$iv$iv2;
            boolean bl = false;
            object5.add(Float.valueOf(CssParseKt.clampF$default(CssParseKt.percentOrNumber((String)it), 0.0f, 0.0f, 3, null)));
        }
        List values2 = (List)destination$iv$iv2;
        Object object8 = space;
        object8 = object6 = (Object)new float[4];
        int n3 = 0;
        int n4 = 0;
        List list = values2;
        if (n4 <= CollectionsKt.getLastIndex(list)) {
            object4 = list.get(n4);
        } else {
            int destination$iv$iv2 = n4;
            n = n3;
            object3 = object8;
            object5 = object7;
            boolean bl = false;
            f = Float.valueOf(0.0f);
            Object object8 = object5;
            object8 = object3;
            n3 = n;
            object4 = f;
        }
        object8[n3] = ((Number)object4).floatValue();
        Object object9 = object6;
        int n5 = 1;
        list = values2;
        n4 = 1;
        if (n4 <= CollectionsKt.getLastIndex(list)) {
            object2 = list.get(n4);
        } else {
            int it = n4;
            n = n5;
            object3 = object9;
            object5 = object7;
            boolean bl = false;
            f = Float.valueOf(0.0f);
            Object object9 = object5;
            object9 = object3;
            n5 = n;
            object2 = f;
        }
        object9[n5] = ((Number)object2).floatValue();
        Object object10 = object6;
        int n6 = 2;
        list = values2;
        n4 = 2;
        if (n4 <= CollectionsKt.getLastIndex(list)) {
            object = list.get(n4);
        } else {
            int it = n4;
            n = n6;
            object3 = object10;
            object5 = object7;
            boolean bl = false;
            f = Float.valueOf(0.0f);
            Object object10 = object5;
            object10 = object3;
            n6 = n;
            object = f;
        }
        object10[n6] = ((Number)object).floatValue();
        object6[3] = CssParseKt.alpha(match.getGroupValues().get(3));
        return object7.create((float[])object6);
    }

    private static final Color rgb(MatchResult match) {
        float r = CssParseKt.percentOrNumber(match.getGroupValues().get(1));
        float g = CssParseKt.percentOrNumber(match.getGroupValues().get(2));
        float b = CssParseKt.percentOrNumber(match.getGroupValues().get(3));
        float a = CssParseKt.alpha(match.getGroupValues().get(4));
        return StringsKt.endsWith$default(match.getGroupValues().get(1), "%", false, 2, null) ? (Color)RGB.Companion.invoke(CssParseKt.clampF$default(r, 0.0f, 0.0f, 3, null), CssParseKt.clampF$default(g, 0.0f, 0.0f, 3, null), CssParseKt.clampF$default(b, 0.0f, 0.0f, 3, null), a) : (Color)RGB.Companion.invoke((float)CssParseKt.clampInt$default(r, 0, 0, 3, null) / 255.0f, (float)CssParseKt.clampInt$default(g, 0, 0, 3, null) / 255.0f, (float)CssParseKt.clampInt$default(b, 0, 0, 3, null) / 255.0f, a);
    }

    private static final Color hsl(MatchResult match) {
        float h = CssParseKt.hue(match.getGroupValues().get(1));
        float s = CssParseKt.percent(match.getGroupValues().get(2));
        float l = CssParseKt.percent(match.getGroupValues().get(3));
        float a = CssParseKt.alpha(match.getGroupValues().get(4));
        return new HSL(h, CssParseKt.clampF$default(s, 0.0f, 0.0f, 3, null), CssParseKt.clampF$default(l, 0.0f, 0.0f, 3, null), CssParseKt.clampF$default(a, 0.0f, 0.0f, 3, null));
    }

    private static final Color lab(MatchResult match) {
        float l = CssParseKt.percent(match.getGroupValues().get(1));
        float a = CssParseKt.number(match.getGroupValues().get(2));
        float b = CssParseKt.number(match.getGroupValues().get(3));
        float alpha = CssParseKt.alpha(match.getGroupValues().get(4));
        return LAB.Companion.invoke(RangesKt.coerceAtLeast(l, 0.0f) * 100.0f, a, b, alpha);
    }

    private static final Color lch(MatchResult match) {
        float l = CssParseKt.percent(match.getGroupValues().get(1));
        float c = CssParseKt.number(match.getGroupValues().get(2));
        float h = CssParseKt.hue(match.getGroupValues().get(3));
        float a = CssParseKt.alpha(match.getGroupValues().get(4));
        return LCHab.Companion.invoke(RangesKt.coerceAtLeast(l, 0.0f) * 100.0f, RangesKt.coerceAtLeast(c, 0.0f), h, a);
    }

    private static final Color hwb(MatchResult match) {
        float h = CssParseKt.hue(match.getGroupValues().get(1));
        float w = CssParseKt.percent(match.getGroupValues().get(2));
        float b = CssParseKt.percent(match.getGroupValues().get(3));
        float a = CssParseKt.alpha(match.getGroupValues().get(4));
        return new HWB(h, CssParseKt.clampF$default(w, 0.0f, 0.0f, 3, null), CssParseKt.clampF$default(b, 0.0f, 0.0f, 3, null), a);
    }

    private static final float percent(String str) {
        return Float.parseFloat(StringsKt.dropLast(str, 1)) / 100.0f;
    }

    private static final float number(String str) {
        return Float.parseFloat(str);
    }

    private static final float percentOrNumber(String str) {
        return StringsKt.endsWith$default(str, "%", false, 2, null) ? CssParseKt.percent(str) : CssParseKt.number(str);
    }

    private static final float alpha(String str) {
        return CssParseKt.clampF$default(((CharSequence)str).length() == 0 ? 1.0f : CssParseKt.percentOrNumber(str), 0.0f, 0.0f, 3, null);
    }

    private static final float hue(String str) {
        float deg = StringsKt.endsWith$default(str, "deg", false, 2, null) ? Float.parseFloat(StringsKt.dropLast(str, 3)) : (StringsKt.endsWith$default(str, "grad", false, 2, null) ? InternalMathKt.gradToDeg(Float.parseFloat(StringsKt.dropLast(str, 4))) : (StringsKt.endsWith$default(str, "rad", false, 2, null) ? InternalMathKt.radToDeg(Float.parseFloat(StringsKt.dropLast(str, 3))) : (StringsKt.endsWith$default(str, "turn", false, 2, null) ? InternalMathKt.turnToDeg(Float.parseFloat(StringsKt.dropLast(str, 4))) : Float.parseFloat(str))));
        return InternalMathKt.normalizeDeg(deg);
    }

    private static final int clampInt(float $this$clampInt, int min, int max) {
        return RangesKt.coerceIn(MathKt.roundToInt($this$clampInt), min, max);
    }

    static /* synthetic */ int clampInt$default(float f, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = 255;
        }
        return CssParseKt.clampInt(f, n, n2);
    }

    private static final float clampF(float $this$clampF, float min, float max) {
        return RangesKt.coerceIn($this$clampF, min, max);
    }

    static /* synthetic */ float clampF$default(float f, float f2, float f3, int n, Object object) {
        if ((n & 1) != 0) {
            f2 = 0.0f;
        }
        if ((n & 2) != 0) {
            f3 = 1.0f;
        }
        return CssParseKt.clampF(f, f2, f3);
    }
}

