/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.sat;

import com.google.ortools.sat.AffineExpression;
import com.google.ortools.sat.ConstantExpression;
import com.google.ortools.sat.LinearArgument;
import com.google.ortools.sat.LinearExpr;
import com.google.ortools.sat.WeightedSumExpression;
import java.util.Map;
import java.util.TreeMap;

public final class LinearExprBuilder
implements LinearArgument {
    private final TreeMap<Integer, Long> coefficients = new TreeMap();
    private long offset = 0L;

    LinearExprBuilder() {
    }

    public LinearExprBuilder add(LinearArgument expr) {
        this.addTerm(expr, 1L);
        return this;
    }

    public LinearExprBuilder add(long constant) {
        this.offset += constant;
        return this;
    }

    public LinearExprBuilder addTerm(LinearArgument expr, long coeff) {
        LinearExpr e = expr.build();
        int numElements = e.numElements();
        for (int i = 0; i < numElements; ++i) {
            this.coefficients.merge(e.getVariableIndex(i), e.getCoefficient(i) * coeff, Long::sum);
        }
        this.offset += e.getOffset() * coeff;
        return this;
    }

    public LinearExprBuilder addSum(LinearArgument[] exprs) {
        for (LinearArgument expr : exprs) {
            this.addTerm(expr, 1L);
        }
        return this;
    }

    public LinearExprBuilder addWeightedSum(LinearArgument[] exprs, long[] coeffs) {
        for (int i = 0; i < exprs.length; ++i) {
            this.addTerm(exprs[i], coeffs[i]);
        }
        return this;
    }

    public LinearExprBuilder addWeightedSum(LinearArgument[] exprs, int[] coeffs) {
        for (int i = 0; i < exprs.length; ++i) {
            this.addTerm(exprs[i], coeffs[i]);
        }
        return this;
    }

    @Override
    public LinearExpr build() {
        int numElements = 0;
        int lastVarIndex = -1;
        long lastCoeff = 0L;
        for (Map.Entry<Integer, Long> entry : this.coefficients.entrySet()) {
            if (entry.getValue() == 0L) continue;
            ++numElements;
            lastVarIndex = entry.getKey();
            lastCoeff = entry.getValue();
        }
        if (numElements == 0) {
            return new ConstantExpression(this.offset);
        }
        if (numElements == 1) {
            return new AffineExpression(lastVarIndex, lastCoeff, this.offset);
        }
        int[] varIndices = new int[numElements];
        long[] coeffs = new long[numElements];
        int index = 0;
        for (Map.Entry<Integer, Long> entry : this.coefficients.entrySet()) {
            if (entry.getValue() == 0L) continue;
            varIndices[index] = entry.getKey();
            coeffs[index] = entry.getValue();
            ++index;
        }
        return new WeightedSumExpression(varIndices, coeffs, this.offset);
    }
}

