/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.extensions.auth.helpers.oauth2.draft10;

import com.google.api.client.auth.oauth2.draft10.AccessTokenRequest;
import com.google.api.client.auth.oauth2.draft10.AccessTokenResponse;
import com.google.api.client.auth.oauth2.draft10.AuthorizationRequestUrl;
import com.google.api.client.extensions.auth.helpers.Credential;
import com.google.api.client.extensions.auth.helpers.ThreeLeggedFlow;
import com.google.api.client.extensions.auth.helpers.oauth2.draft10.OAuth2Credential;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.PersistenceManager;
import javax.jdo.annotations.NotPersistent;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;

@Deprecated
@javax.jdo.annotations.PersistenceCapable
public class OAuth2ThreeLeggedFlow
implements ThreeLeggedFlow,
PersistenceCapable {
    @PrimaryKey
    private String userId;
    @Persistent
    private String tokenEndpoint;
    @Persistent
    private String authorizationUrl;
    @Persistent
    private String clientId;
    @Persistent
    private String clientSecret;
    @Persistent
    private String callbackUrl;
    @NotPersistent
    private HttpTransport transport;
    @NotPersistent
    private JsonFactory jsonFactory;
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    public OAuth2ThreeLeggedFlow(String userId, String clientId, String clientSecret, String scope, String callbackUrl, String authorizationEndpoint, String tokenEndpoint) {
        this.userId = userId;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.callbackUrl = callbackUrl;
        this.tokenEndpoint = tokenEndpoint;
        AuthorizationRequestUrl authorizeUrl = new AuthorizationRequestUrl(authorizationEndpoint);
        authorizeUrl.clientId = clientId;
        authorizeUrl.redirectUri = callbackUrl;
        authorizeUrl.scope = scope;
        this.authorizationUrl = authorizeUrl.build();
    }

    public Credential complete(String authorizationCode) throws IOException {
        Preconditions.checkNotNull((Object)this.transport, (Object)"Must call setHttpTransport before calling complete.");
        AccessTokenRequest.AuthorizationCodeGrant request = new AccessTokenRequest.AuthorizationCodeGrant(this.transport, this.jsonFactory, OAuth2ThreeLeggedFlow.jdoGettokenEndpoint(this), OAuth2ThreeLeggedFlow.jdoGetclientId(this), OAuth2ThreeLeggedFlow.jdoGetclientSecret(this), authorizationCode, OAuth2ThreeLeggedFlow.jdoGetcallbackUrl(this));
        AccessTokenResponse response = request.execute();
        OAuth2Credential cred = new OAuth2Credential(OAuth2ThreeLeggedFlow.jdoGetuserId(this), response.accessToken, response.refreshToken);
        cred.initializeForRefresh(OAuth2ThreeLeggedFlow.jdoGetclientId(this), OAuth2ThreeLeggedFlow.jdoGetclientSecret(this), OAuth2ThreeLeggedFlow.jdoGettokenEndpoint(this), this.jsonFactory, this.transport);
        return cred;
    }

    public String getAuthorizationUrl() {
        return OAuth2ThreeLeggedFlow.jdoGetauthorizationUrl(this);
    }

    public Credential loadCredential(PersistenceManager pm) {
        Preconditions.checkNotNull((Object)this.jsonFactory, (Object)"Must call setJsonFactory before calling loadCredential.");
        Preconditions.checkNotNull((Object)this.transport, (Object)"Must call setHttpTransport before calling complete.");
        try {
            OAuth2Credential cred = (OAuth2Credential)pm.getObjectById(OAuth2Credential.class, (Object)OAuth2ThreeLeggedFlow.jdoGetuserId(this));
            cred.initializeForRefresh(OAuth2ThreeLeggedFlow.jdoGetclientId(this), OAuth2ThreeLeggedFlow.jdoGetclientSecret(this), OAuth2ThreeLeggedFlow.jdoGettokenEndpoint(this), this.jsonFactory, this.transport);
            return cred;
        }
        catch (JDOObjectNotFoundException e) {
            return null;
        }
    }

    public void setHttpTransport(HttpTransport transport) {
        this.transport = (HttpTransport)Preconditions.checkNotNull((Object)transport);
    }

    public void setJsonFactory(JsonFactory jsonFactory) {
        this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)jsonFactory);
    }

    static {
        jdoFieldNames = OAuth2ThreeLeggedFlow.__jdoFieldNamesInit();
        jdoFieldTypes = OAuth2ThreeLeggedFlow.__jdoFieldTypesInit();
        jdoFieldFlags = OAuth2ThreeLeggedFlow.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = OAuth2ThreeLeggedFlow.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = OAuth2ThreeLeggedFlow.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)OAuth2ThreeLeggedFlow.___jdo$loadClass("com.google.api.client.extensions.auth.helpers.oauth2.draft10.OAuth2ThreeLeggedFlow"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new OAuth2ThreeLeggedFlow());
    }

    protected OAuth2ThreeLeggedFlow() {
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.StringIdentity");
        }
        StringIdentity o = (StringIdentity)oid;
        fc.storeStringField(5, o.getKey());
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof StringIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.StringIdentity or null");
        }
        StringIdentity o = (StringIdentity)oid;
        this.userId = o.getKey();
    }

    public final void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object object) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with SingleFieldIdentity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        return null;
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        return null;
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        return false;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
    }

    public final Object jdoNewObjectIdInstance() {
        return new StringIdentity(this.getClass(), this.userId);
    }

    public final Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new StringIdentity(this.getClass(), (String)key);
        }
        return new StringIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public boolean jdoIsDetached() {
        return false;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        OAuth2ThreeLeggedFlow result = new OAuth2ThreeLeggedFlow();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        OAuth2ThreeLeggedFlow result = new OAuth2ThreeLeggedFlow();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.authorizationUrl = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.callbackUrl = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.clientId = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.clientSecret = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 4: {
                this.tokenEndpoint = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 5: {
                this.userId = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.authorizationUrl);
                break;
            }
            case 1: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.callbackUrl);
                break;
            }
            case 2: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.clientId);
                break;
            }
            case 3: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.clientSecret);
                break;
            }
            case 4: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.tokenEndpoint);
                break;
            }
            case 5: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.userId);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(OAuth2ThreeLeggedFlow obj, int index) {
        switch (index) {
            case 0: {
                this.authorizationUrl = obj.authorizationUrl;
                break;
            }
            case 1: {
                this.callbackUrl = obj.callbackUrl;
                break;
            }
            case 2: {
                this.clientId = obj.clientId;
                break;
            }
            case 3: {
                this.clientSecret = obj.clientSecret;
                break;
            }
            case 4: {
                this.tokenEndpoint = obj.tokenEndpoint;
                break;
            }
            case 5: {
                this.userId = obj.userId;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof OAuth2ThreeLeggedFlow)) {
            throw new IllegalArgumentException("object is not an object of type com.google.api.client.extensions.auth.helpers.oauth2.draft10.OAuth2ThreeLeggedFlow");
        }
        OAuth2ThreeLeggedFlow other = (OAuth2ThreeLeggedFlow)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"authorizationUrl", "callbackUrl", "clientId", "clientSecret", "tokenEndpoint", "userId"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{OAuth2ThreeLeggedFlow.___jdo$loadClass("java.lang.String"), OAuth2ThreeLeggedFlow.___jdo$loadClass("java.lang.String"), OAuth2ThreeLeggedFlow.___jdo$loadClass("java.lang.String"), OAuth2ThreeLeggedFlow.___jdo$loadClass("java.lang.String"), OAuth2ThreeLeggedFlow.___jdo$loadClass("java.lang.String"), OAuth2ThreeLeggedFlow.___jdo$loadClass("java.lang.String")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{21, 21, 21, 21, 21, 24};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 6;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        OAuth2ThreeLeggedFlow o = (OAuth2ThreeLeggedFlow)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private static String jdoGetauthorizationUrl(OAuth2ThreeLeggedFlow objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 0, objPC.authorizationUrl);
        }
        return objPC.authorizationUrl;
    }

    private static void jdoSetauthorizationUrl(OAuth2ThreeLeggedFlow objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 0, objPC.authorizationUrl, val);
        } else {
            objPC.authorizationUrl = val;
        }
    }

    private static String jdoGetcallbackUrl(OAuth2ThreeLeggedFlow objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 1, objPC.callbackUrl);
        }
        return objPC.callbackUrl;
    }

    private static void jdoSetcallbackUrl(OAuth2ThreeLeggedFlow objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 1, objPC.callbackUrl, val);
        } else {
            objPC.callbackUrl = val;
        }
    }

    private static String jdoGetclientId(OAuth2ThreeLeggedFlow objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 2, objPC.clientId);
        }
        return objPC.clientId;
    }

    private static void jdoSetclientId(OAuth2ThreeLeggedFlow objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 2, objPC.clientId, val);
        } else {
            objPC.clientId = val;
        }
    }

    private static String jdoGetclientSecret(OAuth2ThreeLeggedFlow objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 3, objPC.clientSecret);
        }
        return objPC.clientSecret;
    }

    private static void jdoSetclientSecret(OAuth2ThreeLeggedFlow objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 3, objPC.clientSecret, val);
        } else {
            objPC.clientSecret = val;
        }
    }

    private static String jdoGettokenEndpoint(OAuth2ThreeLeggedFlow objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 4)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 4, objPC.tokenEndpoint);
        }
        return objPC.tokenEndpoint;
    }

    private static void jdoSettokenEndpoint(OAuth2ThreeLeggedFlow objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 4, objPC.tokenEndpoint, val);
        } else {
            objPC.tokenEndpoint = val;
        }
    }

    private static String jdoGetuserId(OAuth2ThreeLeggedFlow objPC) {
        return objPC.userId;
    }

    private static void jdoSetuserId(OAuth2ThreeLeggedFlow objPC, String val) {
        if (objPC.jdoStateManager == null) {
            objPC.userId = val;
        } else {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 5, objPC.userId, val);
        }
    }
}

