/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.extensions.java6.auth.oauth2;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialStore;
import com.google.api.client.auth.oauth2.StoredCredential;
import com.google.api.client.extensions.java6.auth.oauth2.FilePersistedCredentials;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonGenerator;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Charsets;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.store.DataStore;
import com.google.api.client.util.store.DataStoreFactory;
import com.google.api.client.util.store.FileDataStoreFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
@Beta
public class FileCredentialStore
implements CredentialStore {
    private static final Logger LOGGER = Logger.getLogger(FileCredentialStore.class.getName());
    private final JsonFactory jsonFactory;
    private final Lock lock = new ReentrantLock();
    private FilePersistedCredentials credentials = new FilePersistedCredentials();
    private final File file;
    private static final boolean IS_WINDOWS = File.separatorChar == '\\';

    public FileCredentialStore(File file, JsonFactory jsonFactory) throws IOException {
        this.file = (File)Preconditions.checkNotNull((Object)file);
        this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)jsonFactory);
        File parentDir = file.getCanonicalFile().getParentFile();
        if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
            throw new IOException("unable to create parent directory: " + parentDir);
        }
        if (this.isSymbolicLink(file)) {
            throw new IOException("unable to use a symbolic link: " + file);
        }
        if (!file.createNewFile()) {
            this.loadCredentials(file);
        } else {
            if (!(file.setReadable(false, false) && file.setWritable(false, false) && file.setExecutable(false, false))) {
                LOGGER.warning("unable to change file permissions for everybody: " + file);
            }
            if (!file.setReadable(true) || !file.setWritable(true)) {
                throw new IOException("unable to set file permissions: " + file);
            }
            this.save();
        }
    }

    protected boolean isSymbolicLink(File file) throws IOException {
        if (IS_WINDOWS) {
            return false;
        }
        File canonical = file;
        if (file.getParent() != null) {
            canonical = new File(file.getParentFile().getCanonicalFile(), file.getName());
        }
        return !canonical.getCanonicalFile().equals(canonical.getAbsoluteFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String userId, Credential credential) throws IOException {
        this.lock.lock();
        try {
            this.credentials.store(userId, credential);
            this.save();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String userId, Credential credential) throws IOException {
        this.lock.lock();
        try {
            this.credentials.delete(userId);
            this.save();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(String userId, Credential credential) {
        this.lock.lock();
        try {
            boolean bl = this.credentials.load(userId, credential);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCredentials(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            this.credentials = (FilePersistedCredentials)((Object)this.jsonFactory.fromInputStream((InputStream)is, FilePersistedCredentials.class));
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.file);
        try {
            JsonGenerator generator = this.jsonFactory.createJsonGenerator((OutputStream)fos, Charsets.UTF_8);
            generator.serialize((Object)this.credentials);
            generator.close();
        }
        finally {
            fos.close();
        }
    }

    public final void migrateTo(FileDataStoreFactory dataStoreFactory) throws IOException {
        this.migrateTo((DataStore<StoredCredential>)StoredCredential.getDefaultDataStore((DataStoreFactory)dataStoreFactory));
    }

    public final void migrateTo(DataStore<StoredCredential> credentialDataStore) throws IOException {
        this.credentials.migrateTo(credentialDataStore);
    }
}

