/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.vision.common.internal;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.media.Image;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.mlkit.common.MlKitException;
import com.google.mlkit.vision.common.InputImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

@KeepForSdk
public class ImageConvertUtils {
    private static final ImageConvertUtils zza = new ImageConvertUtils();

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NonNull
    @KeepForSdk
    public Bitmap convertJpegToUpRightBitmap(@NonNull Image image, int rotationDegrees) {
        void var1_3;
        boolean bl = image.getFormat() == 256;
        Preconditions.checkArgument((boolean)bl, (Object)"Only JPEG is supported now");
        Bitmap bitmap = var1_3.getPlanes();
        if (bitmap != null && ((Image.Plane[])bitmap).length == 1) {
            void var2_4;
            ByteBuffer byteBuffer = bitmap[0].getBuffer();
            byteBuffer.rewind();
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            Bitmap bitmap2 = bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
            return ImageConvertUtils.zza(bitmap2, (int)var2_4, bitmap.getWidth(), bitmap2.getHeight());
        }
        throw new IllegalArgumentException("Unexpected image format, JPEG should have exactly 1 image plane");
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @KeepForSdk
    public Bitmap convertToUpRightBitmap(@NonNull InputImage inputImage) throws MlKitException {
        void var1_1;
        switch (inputImage.getFormat()) {
            default: {
                throw new MlKitException("Unsupported image format", 13);
            }
            case 842094169: {
                return ImageConvertUtils.yv12ToBitmap((ByteBuffer)Preconditions.checkNotNull((Object)var1_1.getByteBuffer()), var1_1.getWidth(), var1_1.getHeight(), var1_1.getRotationDegrees());
            }
            case 35: {
                ImageConvertUtils imageConvertUtils = this;
                return imageConvertUtils.nv21ToBitmap(imageConvertUtils.yuv420ThreePlanesToNV21((Image.Plane[])Preconditions.checkNotNull((Object)var1_1.getPlanes()), var1_1.getWidth(), var1_1.getHeight()), var1_1.getWidth(), var1_1.getHeight(), var1_1.getRotationDegrees());
            }
            case 17: {
                return this.nv21ToBitmap((ByteBuffer)Preconditions.checkNotNull((Object)var1_1.getByteBuffer()), var1_1.getWidth(), var1_1.getHeight(), var1_1.getRotationDegrees());
            }
            case -1: 
        }
        return ImageConvertUtils.zza((Bitmap)Preconditions.checkNotNull((Object)var1_1.getBitmapInternal()), var1_1.getRotationDegrees(), var1_1.getWidth(), var1_1.getHeight());
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @KeepForSdk
    public Bitmap getUpRightBitmap(@NonNull InputImage inputImage) throws MlKitException {
        void var1_1;
        Bitmap bitmap = inputImage.getBitmapInternal();
        if (bitmap != null) {
            return ImageConvertUtils.zza(bitmap, var1_1.getRotationDegrees(), var1_1.getWidth(), var1_1.getHeight());
        }
        return this.convertToUpRightBitmap((InputImage)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public Bitmap nv21ToBitmap(@NonNull ByteBuffer buffer, int width, int height, int rotationDegrees) throws MlKitException {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        byte[] byArray = ImageConvertUtils.zzb(this.byteBufferToByteArray((ByteBuffer)var1_1), (int)var2_2, (int)var3_3);
        ImageConvertUtils imageConvertUtils = this = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
        return ImageConvertUtils.zza((Bitmap)imageConvertUtils, (int)var4_4, this.getWidth(), imageConvertUtils.getHeight());
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public static Bitmap yv12ToBitmap(@NonNull ByteBuffer buffer, int width, int height, int rotationDegrees) throws MlKitException {
        void var3_3;
        void var2_2;
        void var1_1;
        ByteBuffer byteBuffer;
        byte[] byArray = ImageConvertUtils.zzb(ImageConvertUtils.yv12ToNv21Buffer(byteBuffer, true).array(), (int)var1_1, (int)var2_2);
        ByteBuffer byteBuffer2 = byteBuffer = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
        return ImageConvertUtils.zza((Bitmap)byteBuffer2, (int)var3_3, byteBuffer.getWidth(), byteBuffer2.getHeight());
    }

    @KeepForSdk
    @NonNull
    public static ImageConvertUtils getInstance() {
        return zza;
    }

    @KeepForSdk
    @NonNull
    public static ByteBuffer bufferWithBackingArray(@NonNull ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2;
        if (byteBuffer.hasArray()) {
            return byteBuffer2;
        }
        byteBuffer2.rewind();
        ByteBuffer byteBuffer3 = byteBuffer2;
        byte[] byArray = new byte[byteBuffer3.limit()];
        byteBuffer3.get(byArray);
        return ByteBuffer.wrap(byArray);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    @NonNull
    public ByteBuffer cloneByteBuffer(@NonNull ByteBuffer byteBuffer) {
        void var1_3;
        Preconditions.checkNotNull((Object)byteBuffer);
        int n = var1_3.capacity();
        int n2 = var1_3.position();
        ByteBuffer byteBuffer2 = var1_3.isDirect() ? ByteBuffer.allocateDirect(n) : ByteBuffer.allocate(n);
        byteBuffer2.limit(var1_3.limit());
        byteBuffer2.put((ByteBuffer)var1_3.rewind());
        byteBuffer2.position(n2);
        var1_3.position(n2);
        return byteBuffer2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NonNull
    @KeepForSdk
    public ByteBuffer convertToNv21Buffer(@NonNull InputImage inputImage, boolean requestBackingArray) throws MlKitException {
        switch (inputImage.getFormat()) {
            case 842094169: {
                int n;
                void var1_3;
                return ImageConvertUtils.yv12ToNv21Buffer((ByteBuffer)Preconditions.checkNotNull((Object)var1_3.getByteBuffer()), n != 0);
            }
            case 35: {
                void var1_3;
                return ((ImageConvertUtils)object).yuv420ThreePlanesToNV21((Image.Plane[])Preconditions.checkNotNull((Object)var1_3.getPlanes()), var1_3.getWidth(), var1_3.getHeight());
            }
            case -1: {
                int n;
                void var1_3;
                Object object = (Bitmap)Preconditions.checkNotNull((Object)var1_3.getBitmapInternal());
                if (Build.VERSION.SDK_INT >= 26 && object.getConfig() == Bitmap.Config.HARDWARE) {
                    Object object2 = object;
                    object = object2.copy(Bitmap.Config.ARGB_8888, object2.isMutable());
                }
                int n2 = object.getWidth();
                int n3 = object.getHeight();
                int n4 = n2 * n3;
                int[] nArray = new int[n4];
                int n5 = n2;
                object.getPixels(nArray, 0, n5, 0, 0, n5, n3);
                int n6 = (int)Math.ceil((double)n3 / 2.0);
                int n7 = (int)Math.ceil((double)n2 / 2.0);
                n7 = n4 + (n6 + n6) * n7;
                ByteBuffer byteBuffer = n != 0 ? ByteBuffer.allocate(n7) : ByteBuffer.allocateDirect(n7);
                int n8 = n4;
                n4 = 0;
                n = n8;
                int n9 = 0;
                int n10 = 0;
                while (n10 < n3) {
                    for (int i = 0; i < n2; ++n9, ++i) {
                        int n11 = nArray[n9];
                        int n12 = n11 >> 16;
                        int n13 = n11 >> 8;
                        int n14 = n4 + 1;
                        int n15 = n13 & 0xFF;
                        byteBuffer.put(n4, (byte)Math.min(255, ((n12 &= 0xFF) * 66 + n15 * 129 + (n11 &= 0xFF) * 25 + 128 >> 8) + 16));
                        if (n10 % 2 == 0 && n9 % 2 == 0) {
                            n4 = n15 * 94;
                            int n16 = n12 * 112;
                            int n17 = n16 - n4;
                            int n18 = n11 * 18;
                            n4 = (n12 *= -38) - (n15 *= 74);
                            n4 = n4 + (n11 *= 112) + 128;
                            n4 >>= 8;
                            byteBuffer.put(n++, (byte)Math.min(255, (n17 - n18 + 128 >> 8) + 128));
                            byteBuffer.put(n, (byte)Math.min(255, n4 += 128));
                            ++n;
                        }
                        n4 = n14;
                    }
                    ++n10;
                }
                return byteBuffer;
            }
            case 17: {
                int n;
                void var1_3;
                if (n == false) return (ByteBuffer)Preconditions.checkNotNull((Object)var1_3.getByteBuffer());
                return ImageConvertUtils.bufferWithBackingArray((ByteBuffer)Preconditions.checkNotNull((Object)var1_3.getByteBuffer()));
            }
            default: {
                throw new MlKitException("Unsupported image format", 13);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    @NonNull
    public ByteBuffer yuv420ThreePlanesToNV21(@NonNull Image.Plane[] yuv420888planes, int width, int height) {
        void var2_3;
        void var1_2;
        void var3_4;
        int n;
        int n2 = n = width * var3_4;
        int n3 = n2 / 4;
        byte[] byArray = new byte[n2 + (n3 + n3)];
        ByteBuffer byteBuffer = var1_2[1].getBuffer();
        ByteBuffer byteBuffer2 = var1_2[2].getBuffer();
        int n4 = byteBuffer2.position();
        int n5 = byteBuffer.limit();
        byteBuffer2.position(n4 + 1);
        byteBuffer.limit(n5 + -1);
        int n6 = n;
        int n7 = n6 + n6;
        boolean bl = byteBuffer2.remaining() == n7 / 4 + -2 ? byteBuffer2.compareTo(byteBuffer) == 0 : false;
        byteBuffer2.position(n4);
        byteBuffer.limit(n5);
        if (bl) {
            var1_2[0].getBuffer().get(byArray, 0, n);
            ByteBuffer byteBuffer3 = var1_2[1].getBuffer();
            var1_2[2].getBuffer().get(byArray, n, 1);
            byteBuffer3.get(byArray, n + 1, n7 / 4 + -1);
            return ByteBuffer.wrap(byArray);
        }
        ImageConvertUtils.zzc((Image.Plane)var1_2[0], (int)var2_3, (int)var3_4, byArray, 0, 1);
        ImageConvertUtils.zzc((Image.Plane)var1_2[1], (int)var2_3, (int)var3_4, byArray, n + 1, 2);
        ImageConvertUtils.zzc((Image.Plane)var1_2[2], (int)var2_3, (int)var3_4, byArray, n, 2);
        return ByteBuffer.wrap(byArray);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    @NonNull
    public static ByteBuffer yv12ToNv21Buffer(@NonNull ByteBuffer yv12Buffer, boolean requestBackingArray) {
        void var1_1;
        ByteBuffer byteBuffer;
        yv12Buffer.rewind();
        int n = byteBuffer.limit();
        int n2 = n / 6;
        ByteBuffer byteBuffer2 = var1_1 != false ? ByteBuffer.allocate(n) : ByteBuffer.allocateDirect(n);
        int n3 = 0;
        while (n3 < n2 * 4) {
            int n4 = n3++;
            byteBuffer2.put(n4, byteBuffer.get(n4));
        }
        n = n / 6 * 4;
        n3 = 0;
        while (true) {
            int n5 = n2;
            if (n3 >= n5 + n5) {
                return byteBuffer2;
            }
            byteBuffer2.put(n + n3, byteBuffer.get(n + n3 % 2 * n2 + n3 / 2));
            ++n3;
        }
    }

    private ImageConvertUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public byte[] byteBufferToByteArray(@NonNull ByteBuffer byteBuffer) {
        void var1_1;
        if (byteBuffer.hasArray() && var1_1.arrayOffset() == 0) {
            return var1_1.array();
        }
        var1_1.rewind();
        void v0 = var1_1;
        byte[] byArray = new byte[v0.limit()];
        v0.get(byArray, 0, byArray.length);
        return byArray;
    }

    @NonNull
    public static Bitmap zza(@NonNull Bitmap bitmap, int n, int n2, int n3) {
        if (n == 0) {
            return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n2, (int)n3);
        }
        Matrix matrix = new Matrix();
        matrix.postRotate((float)n);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n2, (int)n3, (Matrix)matrix, (boolean)true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] zzb(@NonNull byte[] object, int n, int n2) throws MlKitException {
        YuvImage yuvImage = new YuvImage((byte[])object, 17, n, n2, null);
        object = new ByteArrayOutputStream;
        ((ByteArrayOutputStream)object)();
        {
            byte[] byArray;
            catch (IOException iOException) {
                Log.w((String)"ImageConvertUtils", (String)"Error closing ByteArrayOutputStream");
                throw new MlKitException("Image conversion error from NV21 format", 13, (Throwable)iOException);
            }
            try {
                yuvImage.compressToJpeg(new Rect(0, 0, n, n2), 100, (OutputStream)object);
                byArray = ((ByteArrayOutputStream)object).toByteArray();
            }
            catch (Throwable throwable) {}
            try {
                ((ByteArrayOutputStream)object).close();
            }
            catch (Throwable throwable2) {
                try {
                    Throwable.class.getDeclaredMethod("addSuppressed", Throwable.class).invoke((Object)throwable, throwable2);
                    throw throwable;
                }
                catch (Exception exception) {
                    throw throwable;
                }
            }
            {
                throw throwable;
            }
            {
                ((ByteArrayOutputStream)object).close();
                return byArray;
            }
        }
    }

    private static final void zzc(Image.Plane plane, int n, int n2, byte[] byArray, int n3, int n4) {
        ByteBuffer byteBuffer = plane.getBuffer();
        byteBuffer.rewind();
        int n5 = (byteBuffer.limit() + plane.getRowStride() + -1) / plane.getRowStride();
        if (n5 == 0) {
            return;
        }
        int n6 = n / (n2 / n5);
        n = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            int n7 = n;
            for (int i = 0; i < n6; ++i) {
                byArray[n3] = byteBuffer.get(n7);
                n3 += n4;
                n7 += plane.getPixelStride();
            }
            n += plane.getRowStride();
        }
    }
}

