/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.vision.common.internal;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.media.Image;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.internal.mlkit_vision_common.zzms;
import com.google.android.gms.internal.mlkit_vision_common.zzmu;
import com.google.android.gms.internal.mlkit_vision_common.zzmw;
import com.google.android.odml.image.BitmapExtractor;
import com.google.android.odml.image.ByteBufferExtractor;
import com.google.android.odml.image.ImageProperties;
import com.google.android.odml.image.MediaImageExtractor;
import com.google.android.odml.image.MlImage;
import com.google.mlkit.vision.common.InputImage;
import java.nio.ByteBuffer;
import java.util.List;

@KeepForSdk
public class CommonConvertUtils {
    @KeepForSdk
    public static int convertToAndroidImageFormat(@InputImage.ImageFormat int imageFormat) {
        switch (imageFormat) {
            default: {
                return 0;
            }
            case 842094169: {
                return 842094169;
            }
            case 35: {
                return 35;
            }
            case 17: 
        }
        return 17;
    }

    @KeepForSdk
    public static int convertToMVRotation(int rotation) {
        switch (rotation) {
            default: {
                int n;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Invalid rotation: ");
                stringBuilder.append(n);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            case 270: {
                return 3;
            }
            case 180: {
                return 2;
            }
            case 90: {
                return 1;
            }
            case 0: 
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Nullable
    @KeepForSdk
    public static InputImage convertMlImagetoInputImage(@NonNull MlImage mlImage) {
        void var0_2;
        Object object = (ImageProperties)mlImage.getContainedImageProperties().get(0);
        switch (object.getStorageType()) {
            default: {
                Object var0_1 = null;
                break;
            }
            case 3: {
                MlImage mlImage2;
                Image image = MediaImageExtractor.extract((MlImage)mlImage2);
                int n = image.getFormat() == 256 ? image.getPlanes()[0].getBuffer().limit() : image.getPlanes()[0].getBuffer().limit() * 3 / 2;
                CommonConvertUtils.zza(image.getFormat(), 5, SystemClock.elapsedRealtime(), mlImage2.getHeight(), mlImage2.getWidth(), n, mlImage2.getRotation());
                InputImage inputImage = InputImage.fromMediaImage(image, mlImage2.getRotation());
                break;
            }
            case 2: {
                MlImage mlImage2;
                ByteBuffer byteBuffer = ByteBufferExtractor.extract((MlImage)mlImage2);
                switch (object.getImageFormat()) {
                    default: {
                        object = null;
                        break;
                    }
                    case 5: {
                        object = 842094169;
                        break;
                    }
                    case 4: {
                        object = 17;
                    }
                }
                if (object != null) {
                    CommonConvertUtils.zza((Integer)object, 3, SystemClock.elapsedRealtime(), mlImage2.getHeight(), mlImage2.getWidth(), byteBuffer.limit(), mlImage2.getRotation());
                    InputImage inputImage = InputImage.fromByteBuffer(byteBuffer, mlImage2.getWidth(), mlImage2.getHeight(), mlImage2.getRotation(), (Integer)object);
                    break;
                }
                Object var0_5 = null;
                break;
            }
            case 1: {
                MlImage mlImage2;
                object = BitmapExtractor.extract((MlImage)mlImage2);
                CommonConvertUtils.zza(-1, 1, SystemClock.elapsedRealtime(), mlImage2.getHeight(), mlImage2.getWidth(), object.getAllocationByteCount(), mlImage2.getRotation());
                InputImage inputImage = InputImage.fromBitmap((Bitmap)object, mlImage2.getRotation());
            }
        }
        if (var0_2 != null) {
            zzmw.zza();
        }
        return var0_2;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static void transformPointArray(@NonNull Point[] pointArray, @NonNull Matrix matrix) {
        void var1_1;
        Point[] pointArray2;
        int n;
        int n2 = pointArray.length;
        float[] fArray = new float[n2 + n2];
        for (n = 0; n < pointArray2.length; ++n) {
            float f = pointArray2[n].x;
            int n3 = n;
            int n4 = n3 + n3;
            fArray[n4] = f;
            fArray[n4 + 1] = pointArray2[n].y;
        }
        var1_1.mapPoints(fArray);
        for (int i = 0; i < pointArray2.length; ++i) {
            int n5 = i;
            n = n5 + n5;
            pointArray2[i].set((int)fArray[n], (int)fArray[n + 1]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static void transformPointF(@NonNull PointF pointF, @NonNull Matrix matrix) {
        void var1_1;
        PointF pointF2;
        float[] fArray = new float[]{pointF2.x, pointF2.y};
        var1_1.mapPoints(fArray);
        pointF2.set(fArray[0], fArray[1]);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static void transformPointList(@NonNull List<PointF> pointList, @NonNull Matrix matrix) {
        void var1_1;
        List<PointF> list;
        int n;
        int n2 = pointList.size();
        float[] fArray = new float[n2 + n2];
        for (n = 0; n < list.size(); ++n) {
            float f = list.get((int)n).x;
            int n3 = n;
            int n4 = n3 + n3;
            fArray[n4] = f;
            fArray[n4 + 1] = list.get((int)n).y;
        }
        var1_1.mapPoints(fArray);
        for (int i = 0; i < list.size(); ++i) {
            int n5 = i;
            n = n5 + n5;
            list.get(i).set(fArray[n], fArray[n + 1]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static void transformRect(@NonNull Rect rect, @NonNull Matrix matrix) {
        void var1_1;
        Rect rect2;
        RectF rectF = new RectF(rect2);
        var1_1.mapRect(rectF);
        rect2.set((int)rectF.left, (int)rectF.top, (int)rectF.right, (int)rectF.bottom);
    }

    private static void zza(int n, int n2, long l, int n3, int n4, int n5, int n6) {
        zzmu.zzb(zzms.zzb("vision-common"), n, n2, l, n3, n4, n5, n6);
    }
}

