/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.vision.common.internal;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.mlkit.common.internal.model.ModelUtils;
import com.google.mlkit.common.model.LocalModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

@WorkerThread
@KeepForSdk
public class AutoMLModelUtils {
    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @NonNull
    public static List<String> readLabelsFile(@NonNull Context context, @NonNull String labelsFilePath, boolean isAsset) throws IOException {
        String string;
        InputStream inputStream;
        void var2_4;
        ArrayList<String> arrayList = new ArrayList<String>();
        inputStream = var2_4 != false ? inputStream.getAssets().open(string) : new FileInputStream(new File(string));
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            string = bufferedReader.readLine();
            while (string != null) {
                arrayList.add(string);
                string = bufferedReader.readLine();
            }
            if (inputStream == null) return arrayList;
        }
        catch (Throwable throwable) {
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
            }
            catch (Throwable throwable2) {
                try {
                    Throwable.class.getDeclaredMethod("addSuppressed", Throwable.class).invoke((Object)throwable, throwable2);
                    throw throwable;
                }
                catch (Exception exception) {
                    throw throwable;
                }
            }
            throw throwable;
        }
        inputStream.close();
        return arrayList;
    }

    private AutoMLModelUtils() {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    @NonNull
    public static String[] getModelAndLabelFilePaths(@NonNull Context context, @NonNull LocalModel localModel, boolean isAsset) throws IOException {
        void var0_3;
        Object[] objectArray;
        String string = isAsset != false ? (String)Preconditions.checkNotNull((Object)objectArray.getAssetFilePath()) : (String)Preconditions.checkNotNull((Object)objectArray.getAbsoluteFilePath());
        if (objectArray.isManifestFile()) {
            Context context2;
            void var2_6;
            ModelUtils.AutoMLManifest autoMLManifest = ModelUtils.parseManifestFile((String)string, (boolean)var2_6, (Context)context2);
            if (autoMLManifest == null) {
                throw new IOException("Failed to parse manifest file.");
            }
            objectArray = new Object[]{"IMAGE_LABELING"};
            Preconditions.checkState((boolean)"IMAGE_LABELING".equals(autoMLManifest.getModelType()), (String)"Model type should be: %s.", (Object[])objectArray);
            string = new File(new File(string).getParent(), autoMLManifest.getModelFile()).toString();
            String string2 = new File(new File(string).getParent(), autoMLManifest.getLabelsFile()).toString();
            return new String[]{string, var0_3};
        } else {
            String string3 = "";
        }
        return new String[]{string, var0_3};
    }
}

