/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.vision.common.internal;

import android.graphics.Matrix;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.mlkit.vision.common.internal.ImageUtils;
import com.google.mlkit.vision.common.internal.zzg;

@KeepForSdk
@SafeParcelable.Class(creator="VisionImageMetadataParcelCreator")
public class VisionImageMetadataParcel
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<VisionImageMetadataParcel> CREATOR;
    @SafeParcelable.Field(id=1)
    @KeepForSdk
    public final int width;
    @SafeParcelable.Field(id=2)
    @KeepForSdk
    public final int height;
    @SafeParcelable.Field(id=4)
    @KeepForSdk
    public final long timestampMillis;
    @SafeParcelable.Field(id=5)
    @KeepForSdk
    public final int rotation;
    @SafeParcelable.Field(id=3)
    public final int zza;

    @Nullable
    @KeepForSdk
    public Matrix getUprightRotationMatrix() {
        return ImageUtils.getInstance().getUprightRotationMatrix(this.width, this.height, this.rotation);
    }

    static {
        zzg zzg2;
        CREATOR = zzg2 = new zzg();
    }

    @SafeParcelable.Constructor
    public VisionImageMetadataParcel(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) int n2, @SafeParcelable.Param(id=3) int n3, @SafeParcelable.Param(id=4) long l, @SafeParcelable.Param(id=5) int n4) {
        this.width = n;
        this.height = n2;
        this.zza = n3;
        this.timestampMillis = l;
        this.rotation = n4;
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)1, (int)this.width);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)2, (int)this.height);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)3, (int)this.zza);
        SafeParcelWriter.writeLong((Parcel)parcel, (int)4, (long)this.timestampMillis);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)5, (int)this.rotation);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n);
    }
}

