/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.vision.common.internal;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.media.Image;
import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.GmsLogger;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.mlkit_vision_common.zzji;
import com.google.android.gms.tasks.CancellationToken;
import com.google.android.gms.tasks.CancellationTokenSource;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.android.odml.image.MlImage;
import com.google.mlkit.common.MlKitException;
import com.google.mlkit.common.sdkinternal.MLTask;
import com.google.mlkit.common.sdkinternal.MLTaskInput;
import com.google.mlkit.vision.common.InputImage;
import com.google.mlkit.vision.common.internal.CommonConvertUtils;
import com.google.mlkit.vision.common.internal.zza;
import com.google.mlkit.vision.common.internal.zzb;
import com.google.mlkit.vision.common.internal.zzc;
import com.google.mlkit.vision.common.internal.zzd;
import com.google.mlkit.vision.common.internal.zze;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

@KeepForSdk
public class MobileVisionBase<DetectionResultT>
implements Closeable,
LifecycleObserver {
    private static final GmsLogger zzb;
    private final AtomicBoolean zzc;
    private final MLTask zzd;
    private final CancellationTokenSource zze;
    private final Executor zzf;
    private final Task zzg;
    public static final /* synthetic */ int zza;

    @KeepForSdk
    @NonNull
    public synchronized Task<Void> getInitTaskBase() {
        return this.zzg;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public Task<DetectionResultT> process(@NonNull Bitmap bitmap, int rotationDegrees) {
        void var2_2;
        void var1_1;
        return this.processBase(InputImage.fromBitmap((Bitmap)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public Task<DetectionResultT> process(@NonNull Image image, int rotationDegrees) {
        void var2_2;
        void var1_1;
        return this.processBase(InputImage.fromMediaImage((Image)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public Task<DetectionResultT> process(@NonNull Image image, int rotationDegrees, @NonNull Matrix coordinatesMatrix) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.processBase(InputImage.fromMediaImage((Image)var1_1, (int)var2_2, (Matrix)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public Task<DetectionResultT> process(@NonNull ByteBuffer byteBuffer, int width, int height, int rotationDegrees, int format) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return this.processBase(InputImage.fromByteBuffer((ByteBuffer)var1_1, (int)var2_2, (int)var3_3, (int)var4_4, (int)var5_5));
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public synchronized Task<DetectionResultT> processBase(@NonNull MlImage image) {
        void var1_1;
        MobileVisionBase mobileVisionBase;
        Preconditions.checkNotNull((Object)image, (Object)"MlImage can not be null");
        if (mobileVisionBase.zzc.get()) {
            mobileVisionBase = new MlKitException("This detector is already closed!", 14);
            return Tasks.forException((Exception)((Object)mobileVisionBase));
        }
        if (var1_1.getWidth() >= 32 && var1_1.getHeight() >= 32) {
            var1_1.getInternal().acquire();
            Object object = mobileVisionBase.zzd;
            Executor executor = mobileVisionBase.zzf;
            zzc zzc2 = new zzc(mobileVisionBase, (MlImage)var1_1);
            mobileVisionBase = mobileVisionBase.zze;
            mobileVisionBase = mobileVisionBase.getToken();
            mobileVisionBase = object.callAfterLoad(executor, (Callable)zzc2, (CancellationToken)mobileVisionBase);
            object = new zza((MlImage)var1_1);
            return mobileVisionBase.addOnCompleteListener((OnCompleteListener)object);
        }
        mobileVisionBase = new MlKitException("MlImage width and height should be at least 32!", 3);
        return Tasks.forException((Exception)((Object)mobileVisionBase));
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public synchronized Task<DetectionResultT> processBase(@NonNull InputImage image) {
        void var1_1;
        MobileVisionBase mobileVisionBase;
        Preconditions.checkNotNull((Object)image, (Object)"InputImage can not be null");
        if (mobileVisionBase.zzc.get()) {
            mobileVisionBase = new MlKitException("This detector is already closed!", 14);
            return Tasks.forException((Exception)((Object)mobileVisionBase));
        }
        if (var1_1.getWidth() >= 32 && var1_1.getHeight() >= 32) {
            MLTask mLTask = mobileVisionBase.zzd;
            Executor executor = mobileVisionBase.zzf;
            zzd zzd2 = new zzd(mobileVisionBase, (InputImage)var1_1);
            return mLTask.callAfterLoad(executor, (Callable)zzd2, mobileVisionBase.zze.getToken());
        }
        mobileVisionBase = new MlKitException("InputImage width and height should be at least 32!", 3);
        return Tasks.forException((Exception)((Object)mobileVisionBase));
    }

    static {
        GmsLogger gmsLogger;
        zzb = gmsLogger = new GmsLogger("MobileVisionBase", "");
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public MobileVisionBase(@NonNull MLTask<DetectionResultT, InputImage> detectorTaskWithResource, @NonNull Executor executor) {
        void var2_2;
        void var1_1;
        AtomicBoolean atomicBoolean;
        this.zzc = atomicBoolean = new AtomicBoolean(false);
        this.zzd = var1_1;
        this.zze = atomicBoolean;
        this.zzf = var2_2;
        var1_1.pin();
        this.zzg = var1_1.callAfterLoad(this.zzf, (Callable)com.google.mlkit.vision.common.internal.zze.zza, this.zze.getToken()).addOnFailureListener((OnFailureListener)com.google.mlkit.vision.common.internal.zzb.zza);
    }

    @Override
    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    @KeepForSdk
    public synchronized void close() {
        if (!this.zzc.getAndSet(true)) {
            this.zze.cancel();
            this.zzd.unpin(this.zzf);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final /* synthetic */ Object zza(InputImage inputImage) throws Exception {
        zzji zzji2 = zzji.zze("detectorTaskWithResource#run");
        zzji2.zzb();
        try {
            Object object = ((MobileVisionBase)object).zzd.run((MLTaskInput)inputImage);
            zzji2.close();
            return object;
        }
        catch (Throwable throwable) {
            try {
                zzji2.close();
            }
            catch (Throwable throwable2) {
                throw throwable;
            }
            throw throwable;
        }
    }

    final /* synthetic */ Object zzb(MlImage object) throws Exception {
        if ((object = CommonConvertUtils.zza(object)) == null) {
            MobileVisionBase mobileVisionBase = new MlKitException("Current type of MlImage is not supported.", 13);
            throw mobileVisionBase;
        }
        return mobileVisionBase.zzd.run((MLTaskInput)object);
    }

    static /* synthetic */ void zzc(Exception exception) {
        zzb.e("MobileVisionBase", "Error preloading model resource", (Throwable)exception);
    }
}

