/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.vision.common.internal;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.media.Image;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.internal.mlkit_vision_common.zzkc;
import com.google.android.gms.internal.mlkit_vision_common.zzke;
import com.google.android.odml.image.BitmapExtractor;
import com.google.android.odml.image.ByteBufferExtractor;
import com.google.android.odml.image.ImageProperties;
import com.google.android.odml.image.MediaImageExtractor;
import com.google.android.odml.image.MlImage;
import com.google.mlkit.vision.common.InputImage;
import java.nio.ByteBuffer;
import java.util.List;

@KeepForSdk
public class CommonConvertUtils {
    @KeepForSdk
    public static int convertToAndroidImageFormat(@InputImage.ImageFormat int imageFormat) {
        switch (imageFormat) {
            default: {
                return 0;
            }
            case 842094169: {
                return 842094169;
            }
            case 35: {
                return 35;
            }
            case 17: 
        }
        return 17;
    }

    @KeepForSdk
    public static int convertToMVRotation(int rotation) {
        switch (rotation) {
            default: {
                int n;
                StringBuilder stringBuilder = new StringBuilder(29);
                stringBuilder.append("Invalid rotation: ");
                stringBuilder.append(n);
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(stringBuilder.toString());
                throw illegalArgumentException;
            }
            case 270: {
                return 3;
            }
            case 180: {
                return 2;
            }
            case 90: {
                return 1;
            }
            case 0: 
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static void transformPointArray(@NonNull Point[] pointArray, @NonNull Matrix matrix) {
        void var1_1;
        Point[] pointArray2;
        int n = pointArray.length;
        float[] fArray = new float[n + n];
        for (n = 0; n < pointArray2.length; ++n) {
            int n2 = n + n;
            fArray[n2] = pointArray2[n].x;
            fArray[n2 + 1] = pointArray2[n].y;
        }
        var1_1.mapPoints(fArray);
        for (int i = 0; i < pointArray2.length; ++i) {
            n = i + i;
            pointArray2[i].set((int)fArray[n], (int)fArray[n + 1]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static void transformPointF(@NonNull PointF pointF, @NonNull Matrix matrix) {
        void var1_1;
        PointF pointF2;
        float[] fArray = new float[]{pointF2.x, pointF2.y};
        var1_1.mapPoints(fArray);
        pointF2.set(fArray[0], fArray[1]);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static void transformPointList(@NonNull List<PointF> pointList, @NonNull Matrix matrix) {
        void var1_1;
        List<PointF> list;
        int n = pointList.size();
        float[] fArray = new float[n + n];
        for (n = 0; n < list.size(); ++n) {
            int n2 = n + n;
            fArray[n2] = list.get((int)n).x;
            fArray[n2 + 1] = list.get((int)n).y;
        }
        var1_1.mapPoints(fArray);
        for (int i = 0; i < list.size(); ++i) {
            n = i + i;
            list.get(i).set(fArray[n], fArray[n + 1]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static void transformRect(@NonNull Rect rect, @NonNull Matrix matrix) {
        void var1_1;
        Rect rect2;
        RectF rectF = new RectF(rect2);
        var1_1.mapRect(rectF);
        rect2.set((int)rectF.left, (int)rectF.top, (int)rectF.right, (int)rectF.bottom);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    static InputImage zza(@NonNull MlImage mlImage) {
        Object object = (ImageProperties)mlImage.getContainedImageProperties().get(0);
        switch (object.getStorageType()) {
            case 3: {
                Image image = MediaImageExtractor.extract((MlImage)mlImage);
                int n = image.getFormat() == 256 ? image.getPlanes()[0].getBuffer().limit() : image.getPlanes()[0].getBuffer().limit() * 3 / 2;
                CommonConvertUtils.zzb(image.getFormat(), 5, SystemClock.elapsedRealtime(), mlImage.getHeight(), mlImage.getWidth(), n, mlImage.getRotation());
                return InputImage.fromMediaImage(image, mlImage.getRotation());
            }
            case 2: {
                ByteBuffer byteBuffer = ByteBufferExtractor.extract((MlImage)mlImage);
                switch (object.getImageFormat()) {
                    default: {
                        return null;
                    }
                    case 5: {
                        object = 842094169;
                        break;
                    }
                    case 4: {
                        object = 17;
                    }
                }
                if (object == null) return null;
                CommonConvertUtils.zzb((Integer)object, 3, SystemClock.elapsedRealtime(), mlImage.getHeight(), mlImage.getWidth(), byteBuffer.limit(), mlImage.getRotation());
                return InputImage.fromByteBuffer(byteBuffer, mlImage.getWidth(), mlImage.getHeight(), mlImage.getRotation(), (Integer)object);
            }
            default: {
                return null;
            }
            case 1: 
        }
        object = BitmapExtractor.extract((MlImage)mlImage);
        CommonConvertUtils.zzb(-1, 1, SystemClock.elapsedRealtime(), mlImage.getHeight(), mlImage.getWidth(), object.getAllocationByteCount(), mlImage.getRotation());
        return InputImage.fromBitmap((Bitmap)object, mlImage.getRotation());
    }

    private static void zzb(int n, int n2, long l, int n3, int n4, int n5, int n6) {
        zzke.zzb(zzkc.zzb("vision-common"), n, n2, l, n3, n4, n5, n6);
    }
}

