/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.common.sdkinternal.model;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.mlkit.common.sdkinternal.MLTaskExecutor;
import com.google.mlkit.common.sdkinternal.model.ModelFileHelper;
import com.google.mlkit.common.sdkinternal.model.zza;
import java.io.File;
import java.util.concurrent.Executor;

@KeepForSdk
public abstract class LegacyModelMigrator {
    @KeepForSdk
    @NonNull
    protected final ModelFileHelper modelFileHelper;
    private final TaskCompletionSource zza = new TaskCompletionSource();
    private final Context zzb;
    private final Executor zzc;

    @KeepForSdk
    @NonNull
    public Task<Void> getMigrationTask() {
        return this.zza.getTask();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    @KeepForSdk
    @NonNull
    public File getLegacyRootDir() {
        String string = ((LegacyModelMigrator)this).getLegacyModelDirName();
        if (Build.VERSION.SDK_INT < 21) return ((LegacyModelMigrator)this).zzb.getApplicationContext().getDir(string, 0);
        return new File(((LegacyModelMigrator)this).zzb.getNoBackupFilesDir(), string);
    }

    @VisibleForTesting
    @KeepForSdk
    @NonNull
    protected abstract String getLegacyModelDirName();

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    protected LegacyModelMigrator(@NonNull Context context, @NonNull ModelFileHelper modelFileHelper) {
        void var2_2;
        void var1_1;
        this.zzb = var1_1;
        this.modelFileHelper = var2_2;
        this.zzc = MLTaskExecutor.workerThreadExecutor();
    }

    @KeepForSdk
    protected static void deleteIfEmpty(@NonNull File modelDir) {
        Object object = modelDir.listFiles();
        if (object == null || ((File[])object).length == 0) {
            String string;
            if (!((File)((Object)string)).delete()) {
                string = String.valueOf(String.valueOf(string));
                object = "Error deleting model directory ";
                Log.e((String)"MlKitLegacyMigration", (String)((String)object).concat(string));
                return;
            }
            return;
        }
    }

    @KeepForSdk
    protected abstract void migrateAllModelDirs(@NonNull File var1);

    @KeepForSdk
    @VisibleForTesting
    public static void migrateFile(@NonNull File modelFile, @NonNull File newModelFile) {
        String string;
        String string2;
        if (!modelFile.exists()) {
            return;
        }
        if (!((File)((Object)string2)).exists() && !((File)((Object)string)).renameTo((File)((Object)string2))) {
            String string3 = String.valueOf(string);
            String string4 = String.valueOf(string2);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Error moving model file ");
            stringBuilder.append(string3);
            stringBuilder.append(" to ");
            stringBuilder.append(string4);
            string2 = stringBuilder.toString();
            Log.e((String)"MlKitLegacyMigration", (String)string2);
        }
        if (((File)((Object)string)).exists() && !((File)((Object)string)).delete()) {
            string = String.valueOf(String.valueOf(string));
            string2 = "Error deleting model file ";
            Log.e((String)"MlKitLegacyMigration", (String)string2.concat(string));
            return;
        }
    }

    @KeepForSdk
    public void start() {
        this.zzc.execute(new zza(this));
    }

    @KeepForSdk
    protected static boolean isValidFirebasePersistenceKey(@NonNull String persistenceKey) {
        String[] stringArray = persistenceKey.split("\\+", -1);
        if (stringArray.length != 2) {
            return false;
        }
        try {
            Base64Utils.decodeUrlSafeNoPadding((String)stringArray[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        try {
            Base64Utils.decodeUrlSafeNoPadding((String)stringArray[1]);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    final /* synthetic */ void zza() {
        File file = this.getLegacyRootDir();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                this.migrateAllModelDirs(fileArray[i]);
            }
            LegacyModelMigrator.deleteIfEmpty(file);
        }
        this.zza.setResult(null);
    }
}

