/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.common.sdkinternal.model;

import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.GmsLogger;
import com.google.android.gms.common.internal.Preconditions;
import com.google.mlkit.common.MlKitException;
import com.google.mlkit.common.sdkinternal.model.LocalModelLoader;
import com.google.mlkit.common.sdkinternal.model.RemoteModelLoader;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.List;

@KeepForSdk
@WorkerThread
public class ModelLoader {
    @VisibleForTesting
    @Nullable
    @KeepForSdk
    public final RemoteModelLoader remoteModelLoader;
    @KeepForSdk
    @Nullable
    public final LocalModelLoader localModelLoader;
    @KeepForSdk
    @NonNull
    protected ModelLoadingState modelLoadingState = ModelLoadingState.NO_MODEL_LOADED;
    private static final GmsLogger zza = new GmsLogger("ModelLoader", "");
    @NonNull
    private final ModelLoadingLogger zzb;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public ModelLoader(@Nullable RemoteModelLoader remoteModelLoader, @Nullable LocalModelLoader localModelLoader, @NonNull ModelLoadingLogger logger) {
        void var3_3;
        void var2_2;
        void var1_1;
        boolean bl = var1_1 == null ? var2_2 != null : true;
        Preconditions.checkArgument((boolean)bl, (Object)"At least one of RemoteModelLoader or LocalModelLoader must be non-null.");
        Preconditions.checkNotNull((Object)var3_3);
        this.remoteModelLoader = var1_1;
        this.localModelLoader = var2_2;
        this.zzb = var3_3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public synchronized void loadWithModelContentHandler(@NonNull ModelContentHandler modelContentHandler) throws MlKitException {
        Object object;
        Throwable throwable;
        boolean bl;
        Throwable throwable2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        try {
            bl = ((ModelLoader)object).zzc((ModelContentHandler)((Object)throwable2), arrayList);
            throwable = null;
        }
        catch (Exception exception) {
            bl = false;
        }
        if (bl) {
            ((ModelLoader)object).zzb.logErrorCodes(arrayList);
            ((ModelLoader)object).modelLoadingState = ModelLoadingState.REMOTE_MODEL_LOADED;
            return;
        }
        try {
            bl = ((ModelLoader)object).zzb((ModelContentHandler)((Object)throwable2), arrayList);
            throwable2 = null;
        }
        catch (Exception exception) {
            bl = false;
        }
        if (bl) {
            ((ModelLoader)object).zzb.logErrorCodes(arrayList);
            ((ModelLoader)object).modelLoadingState = ModelLoadingState.LOCAL_MODEL_LOADED;
            return;
        }
        arrayList.add(17);
        ((ModelLoader)object).zzb.logErrorCodes(arrayList);
        ((ModelLoader)object).modelLoadingState = ModelLoadingState.NO_MODEL_LOADED;
        if (throwable != null) {
            object = String.valueOf(((ModelLoader)object).zza());
            throw new MlKitException("Remote model load failed with the model options: ".concat((String)object), 14, throwable);
        }
        if (throwable2 == null) {
            object = String.valueOf(((ModelLoader)object).zza());
            throw new MlKitException("Cannot load any model with the model options: ".concat((String)object), 14);
        }
        object = String.valueOf(super.zza());
        throw new MlKitException("Local model load failed with the model options: ".concat((String)object), 14, throwable2);
    }

    @KeepForSdk
    public synchronized boolean isRemoteModelLoaded() {
        return this.modelLoadingState == ModelLoadingState.REMOTE_MODEL_LOADED;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String zza() {
        Object object = ((ModelLoader)object2).localModelLoader;
        object = object != null ? (((LocalModelLoader)object).getLocalModel().getAssetFilePath() != null ? ((ModelLoader)object2).localModelLoader.getLocalModel().getAssetFilePath() : (((ModelLoader)object2).localModelLoader.getLocalModel().getAbsoluteFilePath() != null ? ((ModelLoader)object2).localModelLoader.getLocalModel().getAbsoluteFilePath() : (((ModelLoader)object2).localModelLoader.getLocalModel().getUri() != null ? ((Uri)Preconditions.checkNotNull((Object)((ModelLoader)object2).localModelLoader.getLocalModel().getUri())).toString() : null))) : null;
        Object object2 = ((ModelLoader)object2).remoteModelLoader;
        object2 = object2 == null ? "unspecified" : ((RemoteModelLoader)object2).getRemoteModel().getUniqueModelNameForPersist();
        Object[] objectArray = new Object[]{object, object2};
        return String.format("Local model path: %s. Remote model name: %s. ", objectArray);
    }

    private final synchronized boolean zzb(ModelContentHandler modelContentHandler, List list) throws MlKitException {
        Object object = ((ModelLoader)object).localModelLoader;
        if (object != null && (object = ((LocalModelLoader)object).load()) != null) {
            try {
                modelContentHandler.constructModel((MappedByteBuffer)object);
            }
            catch (RuntimeException runtimeException) {
                list.add(18);
                throw runtimeException;
            }
            zza.d("ModelLoader", "Local model source is loaded successfully");
            return true;
        }
        return false;
    }

    private final synchronized boolean zzc(ModelContentHandler modelContentHandler, List list) throws MlKitException {
        Object object = ((ModelLoader)object).remoteModelLoader;
        if (object != null) {
            block5: {
                try {
                    object = ((RemoteModelLoader)object).load();
                    if (object == null) break block5;
                }
                catch (MlKitException mlKitException) {
                    zza.d("ModelLoader", "Remote model source can NOT be loaded, try local model.");
                    list.add(20);
                    throw mlKitException;
                }
                try {
                    modelContentHandler.constructModel((MappedByteBuffer)object);
                }
                catch (RuntimeException runtimeException) {
                    list.add(19);
                    throw runtimeException;
                }
                zza.d("ModelLoader", "Remote model source is loaded successfully");
                return true;
            }
            zza.d("ModelLoader", "Remote model source can NOT be loaded, try local model.");
            list.add(21);
        }
        return false;
    }

    @KeepForSdk
    protected static final class ModelLoadingState
    extends Enum<ModelLoadingState> {
        @KeepForSdk
        @NonNull
        public static final /* enum */ ModelLoadingState NO_MODEL_LOADED = new ModelLoadingState();
        @KeepForSdk
        @NonNull
        public static final /* enum */ ModelLoadingState REMOTE_MODEL_LOADED = new ModelLoadingState();
        @KeepForSdk
        @NonNull
        public static final /* enum */ ModelLoadingState LOCAL_MODEL_LOADED = new ModelLoadingState();
        private static final /* synthetic */ ModelLoadingState[] zza;

        static {
            zza = new ModelLoadingState[]{NO_MODEL_LOADED, REMOTE_MODEL_LOADED, LOCAL_MODEL_LOADED};
        }

        @NonNull
        public static ModelLoadingState[] values() {
            return (ModelLoadingState[])zza.clone();
        }
    }

    @KeepForSdk
    public static interface ModelLoadingLogger {
        @KeepForSdk
        public void logErrorCodes(@NonNull List<Integer> var1);
    }

    @KeepForSdk
    public static interface ModelContentHandler {
        @KeepForSdk
        public void constructModel(@NonNull MappedByteBuffer var1) throws MlKitException;
    }
}

