/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.common.sdkinternal.model;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.GmsLogger;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.mlkit_common.zzsh;
import com.google.android.gms.internal.mlkit_common.zzsk;
import com.google.android.gms.internal.mlkit_common.zzss;
import com.google.mlkit.common.MlKitException;
import com.google.mlkit.common.internal.model.zza;
import com.google.mlkit.common.model.CustomRemoteModel;
import com.google.mlkit.common.model.LocalModel;
import com.google.mlkit.common.model.RemoteModel;
import com.google.mlkit.common.sdkinternal.MlKitContext;
import com.google.mlkit.common.sdkinternal.SharedPrefManager;
import com.google.mlkit.common.sdkinternal.model.ModelFileHelper;
import com.google.mlkit.common.sdkinternal.model.ModelInfoRetrieverInterop;
import com.google.mlkit.common.sdkinternal.model.RemoteModelDownloadManager;
import com.google.mlkit.common.sdkinternal.model.RemoteModelFileManager;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

@KeepForSdk
public class CustomModelLoader {
    private static final GmsLogger zza = new GmsLogger("CustomModelLoader", "");
    @GuardedBy(value="CustomModelLoader.class")
    private static final Map zzb = new HashMap();
    private final MlKitContext zzc;
    @Nullable
    private final LocalModel zzd;
    @Nullable
    private final CustomRemoteModel zze;
    @Nullable
    private final RemoteModelDownloadManager zzf;
    @Nullable
    private final RemoteModelFileManager zzg;
    private final zzsh zzh;
    private boolean zzi;

    @VisibleForTesting
    @WorkerThread
    @KeepForSdk
    @Nullable
    public synchronized LocalModel createLocalModelByLatestExistingModel() throws MlKitException {
        zza.d("CustomModelLoader", "Try to get the latest existing model file.");
        File file = ((CustomModelLoader)((Object)file)).zza();
        if (file == null) {
            return null;
        }
        return CustomModelLoader.zzc(file);
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    @WorkerThread
    @KeepForSdk
    @Nullable
    public synchronized LocalModel createLocalModelByNewlyDownloadedModel() throws MlKitException {
        zza.d("CustomModelLoader", "Try to get newly downloaded model file.");
        Comparable<Long> comparable = ((RemoteModelDownloadManager)Preconditions.checkNotNull((Object)((CustomModelLoader)((Object)comparable2)).zzf)).getDownloadingId();
        Object object = ((CustomModelLoader)((Object)comparable2)).zzf.getDownloadingModelHash();
        if (comparable == null || object == null) {
            zza.d("CustomModelLoader", "No new model is downloading.");
            ((CustomModelLoader)((Object)comparable2)).zzb();
            return null;
        }
        Object object2 = ((CustomModelLoader)((Object)comparable2)).zzf.getDownloadingModelStatusCode();
        if (object2 == null) {
            ((CustomModelLoader)((Object)comparable2)).zzb();
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Download Status code: ");
        stringBuilder.append(object2);
        String string = "Download Status code: ".concat(object2.toString());
        zza.d("CustomModelLoader", string);
        if ((Integer)object2 == 8) {
            comparable = ((CustomModelLoader)((Object)comparable2)).zzf.zzi((String)object);
            if (comparable == null) {
                return null;
            }
        } else {
            if ((Integer)object2 != 16) return null;
            object = ((CustomModelLoader)((Object)comparable2)).zze;
            ((CustomModelLoader)((Object)comparable2)).zzh.zze(zzsk.zzg(), (RemoteModel)Preconditions.checkNotNull((Object)object), false, ((CustomModelLoader)((Object)comparable2)).zzf.getFailureReason((Long)comparable));
            ((CustomModelLoader)((Object)comparable2)).zzb();
            return null;
        }
        object2 = String.valueOf(((File)comparable).getParent());
        string = "Moved the downloaded model to private folder successfully: ";
        zza.d("CustomModelLoader", string.concat((String)object2));
        ((CustomModelLoader)((Object)comparable2)).zzf.updateLatestModelHashAndType((String)object);
        Comparable<Long> comparable2 = comparable;
        if (comparable2 != null) return CustomModelLoader.zzc((File)comparable2);
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    @NonNull
    public static synchronized CustomModelLoader getInstance(@NonNull MlKitContext mlKitContext, @Nullable LocalModel localModel, @Nullable CustomRemoteModel remoteModel) {
        void var2_2;
        void var1_1;
        String string = remoteModel == null ? ((LocalModel)Preconditions.checkNotNull((Object)var1_1)).toString() : var2_2.getUniqueModelNameForPersist();
        if (!zzb.containsKey(string)) {
            MlKitContext mlKitContext2;
            CustomModelLoader customModelLoader = new CustomModelLoader(mlKitContext2, (LocalModel)var1_1, (CustomRemoteModel)var2_2);
            zzb.put(string, customModelLoader);
        }
        return (CustomModelLoader)zzb.get(string);
    }

    /*
     * Enabled aggressive block sorting
     */
    private CustomModelLoader(@NonNull MlKitContext mlKitContext, @Nullable LocalModel localModel, @Nullable CustomRemoteModel customRemoteModel) {
        if (customRemoteModel != null) {
            this.zzg = new RemoteModelFileManager(mlKitContext, customRemoteModel, null, new ModelFileHelper(mlKitContext), new zza(mlKitContext, customRemoteModel.getUniqueModelNameForPersist()));
            this.zzf = RemoteModelDownloadManager.getInstance(mlKitContext, customRemoteModel, new ModelFileHelper(mlKitContext), this.zzg, mlKitContext.get(ModelInfoRetrieverInterop.class));
            this.zzi = true;
        } else {
            this.zzg = null;
            this.zzf = null;
        }
        this.zzc = mlKitContext;
        this.zzd = localModel;
        this.zze = customRemoteModel;
        this.zzh = zzss.zzb("common");
    }

    @VisibleForTesting
    @WorkerThread
    @KeepForSdk
    public void deleteLatestExistingModel() throws MlKitException {
        File file = ((CustomModelLoader)((Object)this_)).zza();
        if (file != null) {
            ((RemoteModelFileManager)Preconditions.checkNotNull((Object)((CustomModelLoader)((Object)this_)).zzg)).zzc(file);
            CustomRemoteModel this_ = ((CustomModelLoader)((Object)this_)).zze;
            SharedPrefManager.getInstance(((CustomModelLoader)((Object)this_)).zzc).clearLatestModelHash((RemoteModel)Preconditions.checkNotNull((Object)this_));
            return;
        }
    }

    @VisibleForTesting
    @WorkerThread
    @KeepForSdk
    public void deleteOldModels(@NonNull LocalModel localModel) throws MlKitException {
        File file;
        file = new File((String)Preconditions.checkNotNull((Object)((LocalModel)((Object)file)).getAbsoluteFilePath())).getParentFile();
        if (((RemoteModelFileManager)Preconditions.checkNotNull((Object)this.zzg)).zzd((File)Preconditions.checkNotNull((Object)file))) {
            zza.d("CustomModelLoader", "All old models are deleted.");
            this.zzg.zza(file);
            return;
        }
        zza.e("CustomModelLoader", "Failed to delete old models");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @WorkerThread
    @KeepForSdk
    public synchronized void load(@NonNull CustomModelLoaderHelper helper) throws MlKitException {
        void var1_1;
        LocalModel localModel = this.zzd;
        if (localModel == null) {
            localModel = this.createLocalModelByNewlyDownloadedModel();
        }
        if (localModel == null) {
            localModel = this.createLocalModelByLatestExistingModel();
        }
        if (localModel == null) {
            throw new MlKitException("Model is not available.", 14);
        }
        while (!var1_1.tryLoad(localModel)) {
            if (this.zze != null) {
                this.deleteLatestExistingModel();
                localModel = this.createLocalModelByLatestExistingModel();
            } else {
                localModel = null;
            }
            if (localModel != null) continue;
            var1_1.logLoad();
            return;
        }
        if (this.zze != null && this.zzi) {
            this.deleteOldModels((LocalModel)Preconditions.checkNotNull((Object)localModel));
            this.zzi = false;
        }
        var1_1.logLoad();
    }

    @Nullable
    @WorkerThread
    private final File zza() throws MlKitException {
        Object object = ((RemoteModelFileManager)Preconditions.checkNotNull((Object)object.zzg)).zzb();
        if (object == null) {
            zza.d("CustomModelLoader", "No existing model file");
            return null;
        }
        File file = new File((String)object);
        if (((File[])Preconditions.checkNotNull((Object)(object = file.listFiles()))).length == 1) {
            return object[0];
        }
        return file;
    }

    @WorkerThread
    private final void zzb() throws MlKitException {
        ((RemoteModelDownloadManager)Preconditions.checkNotNull((Object)this.zzf)).removeOrCancelDownload();
    }

    @WorkerThread
    private static final LocalModel zzc(File file) {
        if (file.isDirectory()) {
            LocalModel.Builder builder = new LocalModel.Builder();
            builder.setAbsoluteManifestFilePath(new File(file.getAbsolutePath(), "manifest.json").toString());
            return builder.build();
        }
        LocalModel.Builder builder = new LocalModel.Builder();
        builder.setAbsoluteFilePath(file.getAbsolutePath());
        return builder.build();
    }

    @KeepForSdk
    public static interface CustomModelLoaderHelper {
        @KeepForSdk
        public void logLoad() throws MlKitException;

        @KeepForSdk
        public boolean tryLoad(@NonNull LocalModel var1) throws MlKitException;
    }
}

