/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.common.sdkinternal;

import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.mlkit_common.zzav;
import com.google.mlkit.common.sdkinternal.zzi;
import com.google.mlkit.common.sdkinternal.zzj;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@KeepForSdk
public class MlKitThreadPool
extends zzav {
    private static final ThreadLocal zza = new ThreadLocal();
    private final ThreadPoolExecutor zzb;

    public MlKitThreadPool() {
        int n;
        ThreadFactory threadFactory = Executors.defaultThreadFactory();
        int n2 = n = Runtime.getRuntime().availableProcessors();
        this.zzb = new ThreadPoolExecutor(n2, n2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new zzj(threadFactory));
        this.zzb.allowCoreThreadTimeOut(true);
    }

    @Override
    public final void execute(@NonNull Runnable runnable) {
        Deque deque = (Deque)zza.get();
        if (deque != null && deque.size() <= 1) {
            MlKitThreadPool.zze(deque, runnable);
            return;
        }
        this.zzb.execute(new zzi(runnable));
    }

    @Override
    @NonNull
    protected final /* synthetic */ Object zza() {
        return this.zzb;
    }

    @Override
    @NonNull
    protected final ExecutorService zzb() {
        return this.zzb;
    }

    static /* synthetic */ void zzc(Runnable runnable) {
        MlKitThreadPool.zze((Deque)zza.get(), runnable);
    }

    static /* synthetic */ void zzd(Runnable runnable) {
        zza.set(new ArrayDeque());
        runnable.run();
    }

    private static void zze(Deque deque, Runnable runnable) {
        Preconditions.checkNotNull((Object)deque);
        deque.add(runnable);
        if (deque.size() <= 1) {
            do {
                runnable.run();
                deque.removeFirst();
            } while ((runnable = (Runnable)deque.peekFirst()) != null);
        }
    }
}

