/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.libraries.barhopper;

import android.graphics.Bitmap;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.internal.mlkit_vision_barcode_bundled.zzds;
import com.google.android.gms.internal.mlkit_vision_barcode_bundled.zzer;
import com.google.android.libraries.barhopper.RecognitionOptions;
import com.google.barhopper.deeplearning.BarhopperV3Options;
import com.google.photos.vision.barhopper.BarhopperProto$BarhopperResponse;
import java.io.Closeable;
import java.nio.ByteBuffer;

public class BarhopperV3
implements Closeable {
    private static final long NULLPTR = 0L;
    private static final String TAG = BarhopperV3.class.getSimpleName();
    private long nativePointer;

    private native long createNative();

    private native long createNativeWithClientOptions(byte[] var1);

    /*
     * WARNING - void declaration
     */
    @NonNull
    public BarhopperProto$BarhopperResponse recognize(@NonNull Bitmap image, @NonNull RecognitionOptions options) {
        void var2_2;
        Bitmap bitmap;
        if (this.nativePointer == 0L) {
            throw new IllegalStateException("Native pointer does not exist.");
        }
        if (bitmap.getConfig() != Bitmap.Config.ARGB_8888) {
            String string = String.valueOf(String.valueOf(bitmap.getConfig()));
            Log.d((String)TAG, (String)"Input bitmap config is not ARGB_8888. Converting it to ARGB_8888 from ".concat(string));
            void v0 = bitmap;
            bitmap = v0.copy(Bitmap.Config.ARGB_8888, v0.isMutable());
        }
        BarhopperV3 barhopperV3 = this;
        return BarhopperV3.toProto(barhopperV3.recognizeBitmapNative(barhopperV3.nativePointer, bitmap, (RecognitionOptions)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public BarhopperProto$BarhopperResponse recognize(int width, int height, @NonNull ByteBuffer image, @NonNull RecognitionOptions options) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        long l = this.nativePointer;
        if (l == 0L) {
            throw new IllegalStateException("Native pointer does not exist.");
        }
        return BarhopperV3.toProto(this.recognizeBufferNative(l, (int)var1_1, (int)var2_2, (ByteBuffer)var3_3, (RecognitionOptions)var4_4));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public BarhopperProto$BarhopperResponse recognize(int width, int height, @NonNull byte[] image, @NonNull RecognitionOptions options) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        long l = this.nativePointer;
        if (l == 0L) {
            throw new IllegalStateException("Native pointer does not exist.");
        }
        return BarhopperV3.toProto(this.recognizeNative(l, (int)var1_1, (int)var2_2, (byte[])var3_3, (RecognitionOptions)var4_4));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public BarhopperProto$BarhopperResponse recognize(int width, int height, int rowStride, @NonNull ByteBuffer image, @NonNull RecognitionOptions options) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        long l = this.nativePointer;
        if (l == 0L) {
            throw new IllegalStateException("Native pointer does not exist.");
        }
        return BarhopperV3.toProto(this.recognizeStridedBufferNative(l, (int)var1_1, (int)var2_2, (int)var3_3, (ByteBuffer)var4_4, (RecognitionOptions)var5_5));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public BarhopperProto$BarhopperResponse recognize(int width, int height, int rowStride, @NonNull byte[] image, @NonNull RecognitionOptions options) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        long l = this.nativePointer;
        if (l == 0L) {
            throw new IllegalStateException("Native pointer does not exist.");
        }
        return BarhopperV3.toProto(this.recognizeStridedNative(l, (int)var1_1, (int)var2_2, (int)var3_3, (byte[])var4_4, (RecognitionOptions)var5_5));
    }

    private static BarhopperProto$BarhopperResponse toProto(byte[] buffer) {
        Object object;
        if (buffer != null) {
            try {
                object = BarhopperProto$BarhopperResponse.zzb(object, zzds.zza());
            }
            catch (zzer zzer2) {
                throw new IllegalStateException("Received unexpected BarhopperResponse buffer: {0}", zzer2);
            }
        } else {
            throw null;
        }
        return object;
    }

    public BarhopperV3() {
        System.loadLibrary("barhopper_v3");
    }

    @Override
    public void close() {
        long l = this.nativePointer;
        if (l != 0L) {
            this.closeNative(l);
            this.nativePointer = 0L;
            return;
        }
    }

    private native void closeNative(long var1);

    public void create() {
        if (this.nativePointer != 0L) {
            Log.w((String)TAG, (String)"Native pointer already exists.");
            return;
        }
        this.nativePointer = this.createNative();
        if (this.nativePointer == 0L) {
            throw new IllegalStateException("Failed to create native pointer.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void create(@NonNull BarhopperV3Options options) {
        void var1_1;
        if (this.nativePointer != 0L) {
            Log.w((String)TAG, (String)"Native pointer already exists.");
            return;
        }
        this.nativePointer = this.createNativeWithClientOptions(var1_1.zzD());
        if (this.nativePointer == 0L) {
            throw new IllegalArgumentException("Failed to create native pointer with client options.");
        }
    }

    private native byte[] recognizeBitmapNative(long var1, Bitmap var3, RecognitionOptions var4);

    private native byte[] recognizeBufferNative(long var1, int var3, int var4, ByteBuffer var5, RecognitionOptions var6);

    private native byte[] recognizeNative(long var1, int var3, int var4, byte[] var5, RecognitionOptions var6);

    private native byte[] recognizeStridedBufferNative(long var1, int var3, int var4, int var5, ByteBuffer var6, RecognitionOptions var7);

    private native byte[] recognizeStridedNative(long var1, int var3, int var4, int var5, byte[] var6, RecognitionOptions var7);
}

