/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.libraries.barhopper;

import android.graphics.Bitmap;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.internal.mlkit_vision_barcode_bundled.zzdj;
import com.google.android.gms.internal.mlkit_vision_barcode_bundled.zzdo;
import com.google.android.gms.internal.mlkit_vision_barcode_bundled.zzeo;
import com.google.android.libraries.barhopper.RecognitionOptions;
import com.google.barhopper.deeplearning.BarhopperV3Options;
import com.google.photos.vision.barhopper.BarhopperProto$BarhopperResponse;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;

public class BarhopperV3
implements Closeable {
    private static final long NULL_NATIVE_CONTEXT = 0L;
    private static final String TAG = BarhopperV3.class.getSimpleName();
    private long nativeContext;

    private native long createNative();

    private native long createNativeWithClientOptions(byte[] var1);

    /*
     * WARNING - void declaration
     */
    @NonNull
    public BarhopperProto$BarhopperResponse recognize(@NonNull Bitmap image, @NonNull RecognitionOptions options) {
        void var2_2;
        Bitmap bitmap;
        if (this.nativeContext == 0L) {
            throw new IllegalStateException("Native context does not exist.");
        }
        if (bitmap.getConfig() != Bitmap.Config.ARGB_8888) {
            String string = String.valueOf(String.valueOf(bitmap.getConfig()));
            Log.d((String)TAG, (String)"Input bitmap config is not ARGB_8888. Converting it to ARGB_8888 from ".concat(string));
            void v0 = bitmap;
            bitmap = v0.copy(Bitmap.Config.ARGB_8888, v0.isMutable());
        }
        BarhopperV3 barhopperV3 = this;
        return BarhopperV3.toProto(barhopperV3.recognizeBitmapNative(barhopperV3.nativeContext, bitmap, (RecognitionOptions)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public BarhopperProto$BarhopperResponse recognize(int width, int height, @NonNull ByteBuffer image, @NonNull RecognitionOptions options) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        long l = this.nativeContext;
        if (l == 0L) {
            throw new IllegalStateException("Native context does not exist.");
        }
        return BarhopperV3.toProto(this.recognizeBufferNative(l, (int)var1_1, (int)var2_2, (ByteBuffer)var3_3, (RecognitionOptions)var4_4));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public BarhopperProto$BarhopperResponse recognize(int width, int height, @NonNull byte[] image, @NonNull RecognitionOptions options) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        long l = this.nativeContext;
        if (l == 0L) {
            throw new IllegalStateException("Native context does not exist.");
        }
        return BarhopperV3.toProto(this.recognizeNative(l, (int)var1_1, (int)var2_2, (byte[])var3_3, (RecognitionOptions)var4_4));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public BarhopperProto$BarhopperResponse recognize(int width, int height, int rowStride, @NonNull ByteBuffer image, @NonNull RecognitionOptions options) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        long l = this.nativeContext;
        if (l == 0L) {
            throw new IllegalStateException("Native context does not exist.");
        }
        return BarhopperV3.toProto(this.recognizeStridedBufferNative(l, (int)var1_1, (int)var2_2, (int)var3_3, (ByteBuffer)var4_4, (RecognitionOptions)var5_5));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public BarhopperProto$BarhopperResponse recognize(int width, int height, int rowStride, @NonNull byte[] image, @NonNull RecognitionOptions options) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        long l = this.nativeContext;
        if (l == 0L) {
            throw new IllegalStateException("Native context does not exist.");
        }
        return BarhopperV3.toProto(this.recognizeStridedNative(l, (int)var1_1, (int)var2_2, (int)var3_3, (byte[])var4_4, (RecognitionOptions)var5_5));
    }

    private static BarhopperProto$BarhopperResponse toProto(byte[] buffer) {
        Object object;
        if (buffer != null) {
            try {
                object = BarhopperProto$BarhopperResponse.zzb(object, zzdo.zza());
            }
            catch (zzeo zzeo2) {
                throw new IllegalStateException("Received unexpected BarhopperResponse buffer: {0}", zzeo2);
            }
        } else {
            throw null;
        }
        return object;
    }

    public BarhopperV3() {
        System.loadLibrary("barhopper_v3");
    }

    @Override
    public void close() {
        long l = this.nativeContext;
        if (l != 0L) {
            this.closeNative(l);
            this.nativeContext = 0L;
            return;
        }
    }

    private native void closeNative(long var1);

    public void create() {
        if (this.nativeContext != 0L) {
            Log.w((String)TAG, (String)"Native context already exists.");
            return;
        }
        this.nativeContext = this.createNative();
        if (this.nativeContext == 0L) {
            throw new IllegalStateException("Failed to create native context.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void create(@NonNull BarhopperV3Options options) {
        if (this.nativeContext == 0L) {
            void var1_2;
            try {
                byte[] byArray = new byte[var1_2.zzE()];
                zzdj zzdj2 = zzdj.zzA(byArray, 0, byArray.length);
                var1_2.zzaa(zzdj2);
                zzdj2.zzB();
                this.nativeContext = this.createNativeWithClientOptions(byArray);
                if (this.nativeContext == 0L) {
                    throw new IllegalArgumentException("Failed to create native context with client options.");
                }
                return;
            }
            catch (IOException iOException) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Serializing ");
                stringBuilder.append(var1_2.getClass().getName());
                stringBuilder.append(" to a byte array threw an IOException (should never happen).");
                throw new RuntimeException(stringBuilder.toString(), iOException);
            }
        }
        Log.w((String)TAG, (String)"Native context already exists.");
    }

    private native byte[] recognizeBitmapNative(long var1, Bitmap var3, RecognitionOptions var4);

    private native byte[] recognizeBufferNative(long var1, int var3, int var4, ByteBuffer var5, RecognitionOptions var6);

    private native byte[] recognizeNative(long var1, int var3, int var4, byte[] var5, RecognitionOptions var6);

    private native byte[] recognizeStridedBufferNative(long var1, int var3, int var4, int var5, ByteBuffer var6, RecognitionOptions var7);

    private native byte[] recognizeStridedNative(long var1, int var3, int var4, int var5, byte[] var6, RecognitionOptions var7);
}

