/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.model;

import com.google.maps.model.AddressComponent;
import com.google.maps.model.AddressType;
import com.google.maps.model.Geometry;
import com.google.maps.model.OpeningHours;
import com.google.maps.model.Photo;
import com.google.maps.model.PlaceEditorialSummary;
import com.google.maps.model.PlaceIdScope;
import com.google.maps.model.PlusCode;
import com.google.maps.model.PriceLevel;
import java.io.Serializable;
import java.net.URL;
import java.time.Instant;
import java.util.Arrays;

public class PlaceDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    public AddressComponent[] addressComponents;
    public String adrAddress;
    public String businessStatus;
    public Boolean curbsidePickup;
    public OpeningHours currentOpeningHours;
    public Boolean delivery;
    public Boolean dineIn;
    public PlaceEditorialSummary editorialSummary;
    public String formattedAddress;
    public String formattedPhoneNumber;
    public Geometry geometry;
    public URL icon;
    public String internationalPhoneNumber;
    public String name;
    public OpeningHours openingHours;
    @Deprecated
    public boolean permanentlyClosed;
    public Photo[] photos;
    public String placeId;
    @Deprecated
    public PlaceIdScope scope;
    public PlusCode plusCode;
    public PriceLevel priceLevel;
    @Deprecated
    public AlternatePlaceIds[] altIds;
    public float rating;
    public Boolean reservable;
    public Review[] reviews;
    public OpeningHours secondaryOpeningHours;
    public Boolean servesBeer;
    public Boolean servesBreakfast;
    public Boolean servesBrunch;
    public Boolean servesDinner;
    public Boolean servesLunch;
    public Boolean servesVegetarianFood;
    public Boolean servesWine;
    public Boolean takeout;
    public AddressType[] types;
    public URL url;
    public int userRatingsTotal;
    public int utcOffset;
    public String vicinity;
    public URL website;
    public Boolean wheelchairAccessibleEntrance;
    public String[] htmlAttributions;

    public String toString() {
        StringBuilder sb = new StringBuilder("[PlaceDetails: ");
        sb.append("\"").append(this.name).append("\"");
        sb.append(" ").append(this.placeId).append(" (").append((Object)this.scope).append(")");
        sb.append(" address=\"").append(this.formattedAddress).append("\"");
        if (this.businessStatus != null) {
            sb.append("businessStatus=").append(this.businessStatus);
        }
        if (this.curbsidePickup != null) {
            sb.append(", curbsidePickup=").append(this.curbsidePickup);
        }
        if (this.currentOpeningHours != null) {
            sb.append(", currentOpeningHours=").append(this.currentOpeningHours);
        }
        if (this.delivery != null) {
            sb.append(", delivery=").append(this.delivery);
        }
        if (this.dineIn != null) {
            sb.append(", dineIn=").append(this.dineIn);
        }
        if (this.editorialSummary != null) {
            sb.append(", editorialSummary=").append(this.editorialSummary);
        }
        sb.append(", geometry=").append(this.geometry);
        if (this.vicinity != null) {
            sb.append(", vicinity=").append(this.vicinity);
        }
        if (this.types != null && this.types.length > 0) {
            sb.append(", types=").append(Arrays.toString(this.types));
        }
        if (this.altIds != null && this.altIds.length > 0) {
            sb.append(", altIds=").append(Arrays.toString(this.altIds));
        }
        if (this.formattedPhoneNumber != null) {
            sb.append(", phone=").append(this.formattedPhoneNumber);
        }
        if (this.internationalPhoneNumber != null) {
            sb.append(", internationalPhoneNumber=").append(this.internationalPhoneNumber);
        }
        if (this.url != null) {
            sb.append(", url=").append(this.url);
        }
        if (this.website != null) {
            sb.append(", website=").append(this.website);
        }
        if (this.icon != null) {
            sb.append(", icon");
        }
        if (this.openingHours != null) {
            sb.append(", openingHours");
            sb.append(", utcOffset=").append(this.utcOffset);
        }
        if (this.priceLevel != null) {
            sb.append(", priceLevel=").append(this.priceLevel);
        }
        sb.append(", rating=").append(this.rating);
        if (this.permanentlyClosed) {
            sb.append(", permanentlyClosed");
        }
        if (this.userRatingsTotal > 0) {
            sb.append(", userRatingsTotal=").append(this.userRatingsTotal);
        }
        if (this.photos != null && this.photos.length > 0) {
            sb.append(", ").append(this.photos.length).append(" photos");
        }
        if (this.reservable != null) {
            sb.append(", reservable=").append(this.reservable);
        }
        if (this.reviews != null && this.reviews.length > 0) {
            sb.append(", ").append(this.reviews.length).append(" reviews");
        }
        if (this.secondaryOpeningHours != null) {
            sb.append(", secondaryOpeningHours=").append(this.secondaryOpeningHours);
        }
        if (this.servesBeer != null) {
            sb.append(", servesBeer=").append(this.servesBeer);
        }
        if (this.servesBreakfast != null) {
            sb.append(", servesBreakfast=").append(this.servesBreakfast);
        }
        if (this.servesBrunch != null) {
            sb.append(", servesBrunch=").append(this.servesBrunch);
        }
        if (this.servesDinner != null) {
            sb.append(", servesDinner=").append(this.servesDinner);
        }
        if (this.servesLunch != null) {
            sb.append(", servesLunch=").append(this.servesLunch);
        }
        if (this.servesVegetarianFood != null) {
            sb.append(", servesVegetarianFood=").append(this.servesVegetarianFood);
        }
        if (this.servesWine != null) {
            sb.append(", servesWine=").append(this.servesWine);
        }
        if (this.takeout != null) {
            sb.append(", takeout=").append(this.takeout);
        }
        if (this.wheelchairAccessibleEntrance != null) {
            sb.append(", wheelchairAccessibleEntrance=").append(this.wheelchairAccessibleEntrance);
        }
        if (this.htmlAttributions != null && this.htmlAttributions.length > 0) {
            sb.append(", ").append(this.htmlAttributions.length).append(" htmlAttributions");
        }
        sb.append("]");
        return sb.toString();
    }

    public static class Review
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public AspectRating[] aspects;
        public String authorName;
        public URL authorUrl;
        public String language;
        public String profilePhotoUrl;
        public int rating;
        public String relativeTimeDescription;
        public String text;
        public Instant time;

        public static class AspectRating
        implements Serializable {
            private static final long serialVersionUID = 1L;
            public RatingType type;
            public int rating;

            public static enum RatingType {
                APPEAL,
                ATMOSPHERE,
                DECOR,
                FACILITIES,
                FOOD,
                OVERALL,
                QUALITY,
                SERVICE,
                UNKNOWN;

            }
        }
    }

    @Deprecated
    public static class AlternatePlaceIds
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String placeId;
        @Deprecated
        public PlaceIdScope scope;

        public String toString() {
            return String.format("%s (%s)", new Object[]{this.placeId, this.scope});
        }
    }
}

