/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps;

import com.google.gson.FieldNamingPolicy;
import com.google.maps.GeoApiContext;
import com.google.maps.PendingResultBase;
import com.google.maps.PlaceAutocompleteRequest;
import com.google.maps.errors.ApiException;
import com.google.maps.internal.ApiConfig;
import com.google.maps.internal.ApiResponse;
import com.google.maps.internal.StringJoin;
import com.google.maps.model.PlaceDetails;

public class PlaceDetailsRequest
extends PendingResultBase<PlaceDetails, PlaceDetailsRequest, Response> {
    static final ApiConfig API_CONFIG = new ApiConfig("/maps/api/place/details/json").fieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);

    public PlaceDetailsRequest(GeoApiContext context) {
        super(context, API_CONFIG, Response.class);
    }

    public PlaceDetailsRequest placeId(String placeId) {
        return (PlaceDetailsRequest)this.param("placeid", placeId);
    }

    public PlaceDetailsRequest sessionToken(PlaceAutocompleteRequest.SessionToken sessionToken) {
        return (PlaceDetailsRequest)this.param("sessiontoken", sessionToken);
    }

    public PlaceDetailsRequest region(String region) {
        return (PlaceDetailsRequest)this.param("region", region);
    }

    public PlaceDetailsRequest reviewsNoTranslations(boolean reviewsNoTranslations) {
        return (PlaceDetailsRequest)this.param("reviews_no_translations", String.valueOf(reviewsNoTranslations));
    }

    public PlaceDetailsRequest reviewsSort(String reviewsSort) {
        return (PlaceDetailsRequest)this.param("reviews_sort", reviewsSort);
    }

    public PlaceDetailsRequest fields(FieldMask ... fields) {
        return (PlaceDetailsRequest)this.param("fields", StringJoin.join(',', fields));
    }

    @Override
    protected void validateRequest() {
        if (!this.params().containsKey("placeid")) {
            throw new IllegalArgumentException("Request must contain 'placeId'.");
        }
    }

    public static enum FieldMask implements StringJoin.UrlValue
    {
        ADDRESS_COMPONENT("address_component"),
        ADR_ADDRESS("adr_address"),
        ALT_ID("alt_id"),
        BUSINESS_STATUS("business_status"),
        CURBSIDE_PICKUP("curbside_pickup"),
        DELIVERY("delivery"),
        DINE_IN("dine_in"),
        EDITORIAL_SUMMARY("editorial_summary"),
        FORMATTED_ADDRESS("formatted_address"),
        FORMATTED_PHONE_NUMBER("formatted_phone_number"),
        GEOMETRY("geometry"),
        GEOMETRY_LOCATION("geometry/location"),
        GEOMETRY_LOCATION_LAT("geometry/location/lat"),
        GEOMETRY_LOCATION_LNG("geometry/location/lng"),
        GEOMETRY_VIEWPORT("geometry/viewport"),
        GEOMETRY_VIEWPORT_NORTHEAST("geometry/viewport/northeast"),
        GEOMETRY_VIEWPORT_NORTHEAST_LAT("geometry/viewport/northeast/lat"),
        GEOMETRY_VIEWPORT_NORTHEAST_LNG("geometry/viewport/northeast/lng"),
        GEOMETRY_VIEWPORT_SOUTHWEST("geometry/viewport/southwest"),
        GEOMETRY_VIEWPORT_SOUTHWEST_LAT("geometry/viewport/southwest/lat"),
        GEOMETRY_VIEWPORT_SOUTHWEST_LNG("geometry/viewport/southwest/lng"),
        ICON("icon"),
        ID("id"),
        INTERNATIONAL_PHONE_NUMBER("international_phone_number"),
        NAME("name"),
        OPENING_HOURS("opening_hours"),
        CURRENT_OPENING_HOURS("current_opening_hours"),
        SECONDARY_OPENING_HOURS("secondary_opening_hours"),
        PERMANENTLY_CLOSED("permanently_closed"),
        USER_RATINGS_TOTAL("user_ratings_total"),
        PHOTOS("photos"),
        PLACE_ID("place_id"),
        PLUS_CODE("plus_code"),
        PRICE_LEVEL("price_level"),
        RATING("rating"),
        REFERENCE("reference"),
        RESERVABLE("reservable"),
        REVIEW("review"),
        REVIEWS("reviews"),
        SCOPE("scope"),
        SERVES_BEER("serves_beer"),
        SERVES_BREAKFAST("serves_breakfast"),
        SERVES_BRUNCH("serves_brunch"),
        SERVES_DINNER("serves_dinner"),
        SERVES_LUNCH("serves_lunch"),
        SERVES_VEGETARIAN_FOOD("serves_vegetarian_food"),
        SERVES_WINE("serves_wine"),
        TAKEOUT("takeout"),
        TYPES("types"),
        URL("url"),
        UTC_OFFSET("utc_offset"),
        VICINITY("vicinity"),
        WEBSITE("website"),
        WHEELCHAIR_ACCESSIBLE_ENTRANCE("wheelchair_accessible_entrance");

        private final String field;

        private FieldMask(String field) {
            this.field = field;
        }

        @Override
        public String toUrlValue() {
            return this.field;
        }
    }

    public static class Response
    implements ApiResponse<PlaceDetails> {
        public String status;
        public PlaceDetails result;
        public String[] htmlAttributions;
        public String errorMessage;

        @Override
        public boolean successful() {
            return "OK".equals(this.status) || "ZERO_RESULTS".equals(this.status);
        }

        @Override
        public PlaceDetails getResult() {
            if (this.result != null) {
                this.result.htmlAttributions = this.htmlAttributions;
            }
            return this.result;
        }

        @Override
        public ApiException getError() {
            if (this.successful()) {
                return null;
            }
            return ApiException.from(this.status, this.errorMessage);
        }
    }
}

