/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps;

import com.google.maps.GeoApiContext;
import com.google.maps.NearestRoadsApiRequest;
import com.google.maps.SnapToRoadsApiRequest;
import com.google.maps.SpeedLimitsApiRequest;
import com.google.maps.errors.ApiError;
import com.google.maps.errors.ApiException;
import com.google.maps.internal.ApiResponse;
import com.google.maps.model.LatLng;
import com.google.maps.model.SnappedPoint;
import com.google.maps.model.SnappedSpeedLimitResult;
import com.google.maps.model.SpeedLimit;

public class RoadsApi {
    static final String API_BASE_URL = "https://roads.googleapis.com";

    private RoadsApi() {
    }

    public static SnapToRoadsApiRequest snapToRoads(GeoApiContext context, LatLng ... path) {
        return RoadsApi.snapToRoads(context, false, path);
    }

    public static SnapToRoadsApiRequest snapToRoads(GeoApiContext context, boolean interpolate, LatLng ... path) {
        return new SnapToRoadsApiRequest(context).path(path).interpolate(interpolate);
    }

    public static SpeedLimitsApiRequest speedLimits(GeoApiContext context, LatLng ... path) {
        return new SpeedLimitsApiRequest(context).path(path);
    }

    public static SpeedLimitsApiRequest speedLimits(GeoApiContext context, String ... placeIds) {
        return new SpeedLimitsApiRequest(context).placeIds(placeIds);
    }

    public static NearestRoadsApiRequest nearestRoads(GeoApiContext context, LatLng ... points) {
        return new NearestRoadsApiRequest(context).points(points);
    }

    public static class SpeedLimitsResponse
    implements ApiResponse<SnappedSpeedLimitResult> {
        private SnappedPoint[] snappedPoints;
        private SpeedLimit[] speedLimits;
        private ApiError error;

        @Override
        public boolean successful() {
            return this.error == null;
        }

        @Override
        public SnappedSpeedLimitResult getResult() {
            SnappedSpeedLimitResult response = new SnappedSpeedLimitResult();
            response.snappedPoints = this.snappedPoints;
            response.speedLimits = this.speedLimits;
            return response;
        }

        @Override
        public ApiException getError() {
            return ApiException.from(this.error.status, this.error.message);
        }
    }

    public static class RoadsResponse
    implements ApiResponse<SnappedPoint[]> {
        private SnappedPoint[] snappedPoints;
        private ApiError error;

        @Override
        public boolean successful() {
            return this.error == null;
        }

        @Override
        public SnappedPoint[] getResult() {
            return this.snappedPoints;
        }

        @Override
        public ApiException getError() {
            return ApiException.from(this.error.status, this.error.message);
        }
    }
}

