/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps;

import com.google.gson.FieldNamingPolicy;
import com.google.maps.GeoApiContext;
import com.google.maps.PendingResultBase;
import com.google.maps.errors.ApiException;
import com.google.maps.internal.ApiConfig;
import com.google.maps.internal.ApiResponse;
import com.google.maps.model.LatLng;
import com.google.maps.model.PlaceType;
import com.google.maps.model.PlacesSearchResponse;
import com.google.maps.model.PlacesSearchResult;
import com.google.maps.model.PriceLevel;

public class RadarSearchRequest
extends PendingResultBase<PlacesSearchResponse, RadarSearchRequest, Response> {
    static final ApiConfig API_CONFIG = new ApiConfig("/maps/api/place/radarsearch/json").fieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);

    protected RadarSearchRequest(GeoApiContext context) {
        super(context, API_CONFIG, Response.class);
    }

    public RadarSearchRequest location(LatLng location) {
        return (RadarSearchRequest)this.param("location", location);
    }

    public RadarSearchRequest radius(int distance) {
        if (distance > 50000) {
            throw new IllegalArgumentException("The maximum allowed radius is 50,000 meters.");
        }
        return (RadarSearchRequest)this.param("radius", String.valueOf(distance));
    }

    public RadarSearchRequest keyword(String keyword) {
        return (RadarSearchRequest)this.param("keyword", keyword);
    }

    public RadarSearchRequest minPrice(PriceLevel priceLevel) {
        return (RadarSearchRequest)this.param("minprice", priceLevel);
    }

    public RadarSearchRequest maxPrice(PriceLevel priceLevel) {
        return (RadarSearchRequest)this.param("maxprice", priceLevel);
    }

    public RadarSearchRequest name(String name) {
        return (RadarSearchRequest)this.param("name", name);
    }

    public RadarSearchRequest openNow(boolean openNow) {
        return (RadarSearchRequest)this.param("opennow", String.valueOf(openNow));
    }

    public RadarSearchRequest type(PlaceType type) {
        return (RadarSearchRequest)this.param("type", type);
    }

    @Override
    protected void validateRequest() {
        if (!(this.params().containsKey("keyword") || this.params().containsKey("name") || this.params().containsKey("type"))) {
            throw new IllegalArgumentException("Request must contain 'keyword', 'name' or 'type'.");
        }
    }

    public static class Response
    implements ApiResponse<PlacesSearchResponse> {
        public String status;
        public String[] htmlAttributions;
        public PlacesSearchResult[] results;
        public String nextPageToken;
        public String errorMessage;

        @Override
        public boolean successful() {
            return "OK".equals(this.status) || "ZERO_RESULTS".equals(this.status);
        }

        @Override
        public PlacesSearchResponse getResult() {
            PlacesSearchResponse result = new PlacesSearchResponse();
            result.htmlAttributions = this.htmlAttributions;
            result.results = this.results;
            result.nextPageToken = this.nextPageToken;
            return result;
        }

        @Override
        public ApiException getError() {
            if (this.successful()) {
                return null;
            }
            return ApiException.from(this.status, this.errorMessage);
        }
    }
}

