/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.addressvalidation.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.maps.addressvalidation.v1.ProvideValidationFeedbackRequest;
import com.google.maps.addressvalidation.v1.ProvideValidationFeedbackResponse;
import com.google.maps.addressvalidation.v1.ValidateAddressRequest;
import com.google.maps.addressvalidation.v1.ValidateAddressResponse;
import com.google.maps.addressvalidation.v1.stub.AddressValidationStub;
import com.google.maps.addressvalidation.v1.stub.AddressValidationStubSettings;
import com.google.maps.addressvalidation.v1.stub.HttpJsonAddressValidationCallableFactory;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonAddressValidationStub
extends AddressValidationStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<ValidateAddressRequest, ValidateAddressResponse> validateAddressMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.maps.addressvalidation.v1.AddressValidation/ValidateAddress").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1:validateAddress", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ValidateAddressResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ProvideValidationFeedbackRequest, ProvideValidationFeedbackResponse> provideValidationFeedbackMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.maps.addressvalidation.v1.AddressValidation/ProvideValidationFeedback").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1:provideValidationFeedback", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ProvideValidationFeedbackResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ValidateAddressRequest, ValidateAddressResponse> validateAddressCallable;
    private final UnaryCallable<ProvideValidationFeedbackRequest, ProvideValidationFeedbackResponse> provideValidationFeedbackCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonAddressValidationStub create(AddressValidationStubSettings settings) throws IOException {
        return new HttpJsonAddressValidationStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonAddressValidationStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonAddressValidationStub(AddressValidationStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonAddressValidationStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonAddressValidationStub(AddressValidationStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonAddressValidationStub(AddressValidationStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonAddressValidationCallableFactory());
    }

    protected HttpJsonAddressValidationStub(AddressValidationStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings validateAddressTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(validateAddressMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings provideValidationFeedbackTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(provideValidationFeedbackMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.validateAddressCallable = callableFactory.createUnaryCallable(validateAddressTransportSettings, settings.validateAddressSettings(), clientContext);
        this.provideValidationFeedbackCallable = callableFactory.createUnaryCallable(provideValidationFeedbackTransportSettings, settings.provideValidationFeedbackSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(validateAddressMethodDescriptor);
        methodDescriptors.add(provideValidationFeedbackMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<ValidateAddressRequest, ValidateAddressResponse> validateAddressCallable() {
        return this.validateAddressCallable;
    }

    @Override
    public UnaryCallable<ProvideValidationFeedbackRequest, ProvideValidationFeedbackResponse> provideValidationFeedbackCallable() {
        return this.provideValidationFeedbackCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

