/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.addressvalidation.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.maps.addressvalidation.v1.ProvideValidationFeedbackRequest;
import com.google.maps.addressvalidation.v1.ProvideValidationFeedbackResponse;
import com.google.maps.addressvalidation.v1.ValidateAddressRequest;
import com.google.maps.addressvalidation.v1.ValidateAddressResponse;
import com.google.maps.addressvalidation.v1.stub.AddressValidationStub;
import com.google.maps.addressvalidation.v1.stub.AddressValidationStubSettings;
import com.google.maps.addressvalidation.v1.stub.GrpcAddressValidationCallableFactory;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcAddressValidationStub
extends AddressValidationStub {
    private static final MethodDescriptor<ValidateAddressRequest, ValidateAddressResponse> validateAddressMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.maps.addressvalidation.v1.AddressValidation/ValidateAddress").setRequestMarshaller(ProtoUtils.marshaller((Message)ValidateAddressRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ValidateAddressResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ProvideValidationFeedbackRequest, ProvideValidationFeedbackResponse> provideValidationFeedbackMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.maps.addressvalidation.v1.AddressValidation/ProvideValidationFeedback").setRequestMarshaller(ProtoUtils.marshaller((Message)ProvideValidationFeedbackRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ProvideValidationFeedbackResponse.getDefaultInstance())).build();
    private final UnaryCallable<ValidateAddressRequest, ValidateAddressResponse> validateAddressCallable;
    private final UnaryCallable<ProvideValidationFeedbackRequest, ProvideValidationFeedbackResponse> provideValidationFeedbackCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAddressValidationStub create(AddressValidationStubSettings settings) throws IOException {
        return new GrpcAddressValidationStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAddressValidationStub create(ClientContext clientContext) throws IOException {
        return new GrpcAddressValidationStub(AddressValidationStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAddressValidationStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAddressValidationStub(AddressValidationStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAddressValidationStub(AddressValidationStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAddressValidationCallableFactory());
    }

    protected GrpcAddressValidationStub(AddressValidationStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings validateAddressTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(validateAddressMethodDescriptor).build();
        GrpcCallSettings provideValidationFeedbackTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(provideValidationFeedbackMethodDescriptor).build();
        this.validateAddressCallable = callableFactory.createUnaryCallable(validateAddressTransportSettings, settings.validateAddressSettings(), clientContext);
        this.provideValidationFeedbackCallable = callableFactory.createUnaryCallable(provideValidationFeedbackTransportSettings, settings.provideValidationFeedbackSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ValidateAddressRequest, ValidateAddressResponse> validateAddressCallable() {
        return this.validateAddressCallable;
    }

    @Override
    public UnaryCallable<ProvideValidationFeedbackRequest, ProvideValidationFeedbackResponse> provideValidationFeedbackCallable() {
        return this.provideValidationFeedbackCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

