/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.compose;

import android.location.Location;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.LayoutDirection;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.IndoorBuilding;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PointOfInterest;
import com.google.maps.android.compose.CameraPositionState;
import com.google.maps.android.compose.MapClickListeners;
import com.google.maps.android.compose.MapNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020'H\u0016J\b\u0010)\u001a\u00020'H\u0016R$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R(\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006*"}, d2={"Lcom/google/maps/android/compose/MapPropertiesNode;", "Lcom/google/maps/android/compose/MapNode;", "map", "Lcom/google/android/gms/maps/GoogleMap;", "cameraPositionState", "Lcom/google/maps/android/compose/CameraPositionState;", "contentDescription", "", "clickListeners", "Lcom/google/maps/android/compose/MapClickListeners;", "density", "Landroidx/compose/ui/unit/Density;", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "(Lcom/google/android/gms/maps/GoogleMap;Lcom/google/maps/android/compose/CameraPositionState;Ljava/lang/String;Lcom/google/maps/android/compose/MapClickListeners;Landroidx/compose/ui/unit/Density;Landroidx/compose/ui/unit/LayoutDirection;)V", "value", "getCameraPositionState", "()Lcom/google/maps/android/compose/CameraPositionState;", "setCameraPositionState", "(Lcom/google/maps/android/compose/CameraPositionState;)V", "getClickListeners", "()Lcom/google/maps/android/compose/MapClickListeners;", "setClickListeners", "(Lcom/google/maps/android/compose/MapClickListeners;)V", "getContentDescription", "()Ljava/lang/String;", "setContentDescription", "(Ljava/lang/String;)V", "getDensity", "()Landroidx/compose/ui/unit/Density;", "setDensity", "(Landroidx/compose/ui/unit/Density;)V", "getLayoutDirection", "()Landroidx/compose/ui/unit/LayoutDirection;", "setLayoutDirection", "(Landroidx/compose/ui/unit/LayoutDirection;)V", "getMap", "()Lcom/google/android/gms/maps/GoogleMap;", "onAttached", "", "onCleared", "onRemoved", "maps-compose_release"})
public final class MapPropertiesNode
implements MapNode {
    @NotNull
    private final GoogleMap map;
    @NotNull
    private MapClickListeners clickListeners;
    @NotNull
    private Density density;
    @NotNull
    private LayoutDirection layoutDirection;
    @Nullable
    private String contentDescription;
    @NotNull
    private CameraPositionState cameraPositionState;

    public MapPropertiesNode(@NotNull GoogleMap map, @NotNull CameraPositionState cameraPositionState, @Nullable String contentDescription, @NotNull MapClickListeners clickListeners, @NotNull Density density, @NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        Intrinsics.checkNotNullParameter((Object)cameraPositionState, (String)"cameraPositionState");
        Intrinsics.checkNotNullParameter((Object)clickListeners, (String)"clickListeners");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
        this.map = map;
        this.clickListeners = clickListeners;
        this.density = density;
        this.layoutDirection = layoutDirection;
        cameraPositionState.setMap$maps_compose_release(this.map);
        if (contentDescription != null) {
            this.map.setContentDescription(contentDescription);
        }
        this.contentDescription = contentDescription;
        this.cameraPositionState = cameraPositionState;
    }

    @NotNull
    public final GoogleMap getMap() {
        return this.map;
    }

    @NotNull
    public final MapClickListeners getClickListeners() {
        return this.clickListeners;
    }

    public final void setClickListeners(@NotNull MapClickListeners mapClickListeners) {
        Intrinsics.checkNotNullParameter((Object)mapClickListeners, (String)"<set-?>");
        this.clickListeners = mapClickListeners;
    }

    @NotNull
    public final Density getDensity() {
        return this.density;
    }

    public final void setDensity(@NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"<set-?>");
        this.density = density;
    }

    @NotNull
    public final LayoutDirection getLayoutDirection() {
        return this.layoutDirection;
    }

    public final void setLayoutDirection(@NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"<set-?>");
        this.layoutDirection = layoutDirection;
    }

    @Nullable
    public final String getContentDescription() {
        return this.contentDescription;
    }

    public final void setContentDescription(@Nullable String value) {
        this.contentDescription = value;
        this.map.setContentDescription(this.contentDescription);
    }

    @NotNull
    public final CameraPositionState getCameraPositionState() {
        return this.cameraPositionState;
    }

    public final void setCameraPositionState(@NotNull CameraPositionState value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (Intrinsics.areEqual((Object)value, (Object)this.cameraPositionState)) {
            return;
        }
        this.cameraPositionState.setMap$maps_compose_release(null);
        this.cameraPositionState = value;
        value.setMap$maps_compose_release(this.map);
    }

    @Override
    public void onAttached() {
        this.map.setOnCameraIdleListener(() -> MapPropertiesNode.onAttached$lambda-0(this));
        this.map.setOnCameraMoveCanceledListener(() -> MapPropertiesNode.onAttached$lambda-1(this));
        this.map.setOnCameraMoveStartedListener(arg_0 -> MapPropertiesNode.onAttached$lambda-2(this, arg_0));
        this.map.setOnCameraMoveListener(() -> MapPropertiesNode.onAttached$lambda-3(this));
        this.map.setOnMapClickListener(arg_0 -> MapPropertiesNode.onAttached$lambda-4(this, arg_0));
        this.map.setOnMapLongClickListener(arg_0 -> MapPropertiesNode.onAttached$lambda-5(this, arg_0));
        this.map.setOnMapLoadedCallback(() -> MapPropertiesNode.onAttached$lambda-6(this));
        this.map.setOnMyLocationButtonClickListener(() -> MapPropertiesNode.onAttached$lambda-7(this));
        this.map.setOnMyLocationClickListener(arg_0 -> MapPropertiesNode.onAttached$lambda-8(this, arg_0));
        this.map.setOnPoiClickListener(arg_0 -> MapPropertiesNode.onAttached$lambda-9(this, arg_0));
        this.map.setOnIndoorStateChangeListener(new GoogleMap.OnIndoorStateChangeListener(this){
            final /* synthetic */ MapPropertiesNode this$0;
            {
                this.this$0 = $receiver;
            }

            public void onIndoorBuildingFocused() {
                this.this$0.getClickListeners().getIndoorStateChangeListener().onIndoorBuildingFocused();
            }

            public void onIndoorLevelActivated(@NotNull IndoorBuilding building) {
                Intrinsics.checkNotNullParameter((Object)building, (String)"building");
                this.this$0.getClickListeners().getIndoorStateChangeListener().onIndoorLevelActivated(building);
            }
        });
    }

    @Override
    public void onRemoved() {
        this.cameraPositionState.setMap$maps_compose_release(null);
    }

    @Override
    public void onCleared() {
        this.cameraPositionState.setMap$maps_compose_release(null);
    }

    private static final void onAttached$lambda-0(MapPropertiesNode this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.cameraPositionState.setMoving$maps_compose_release(false);
        CameraPositionState cameraPositionState = this$0.cameraPositionState;
        CameraPosition cameraPosition = this$0.map.getCameraPosition();
        Intrinsics.checkNotNullExpressionValue((Object)cameraPosition, (String)"map.cameraPosition");
        cameraPositionState.setRawPosition$maps_compose_release(cameraPosition);
    }

    private static final void onAttached$lambda-1(MapPropertiesNode this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.cameraPositionState.setMoving$maps_compose_release(false);
    }

    private static final void onAttached$lambda-2(MapPropertiesNode this$0, int it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.cameraPositionState.setMoving$maps_compose_release(true);
    }

    private static final void onAttached$lambda-3(MapPropertiesNode this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        CameraPositionState cameraPositionState = this$0.cameraPositionState;
        CameraPosition cameraPosition = this$0.map.getCameraPosition();
        Intrinsics.checkNotNullExpressionValue((Object)cameraPosition, (String)"map.cameraPosition");
        cameraPositionState.setRawPosition$maps_compose_release(cameraPosition);
    }

    private static final void onAttached$lambda-4(MapPropertiesNode this$0, LatLng it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.clickListeners.getOnMapClick().invoke((Object)it);
    }

    private static final void onAttached$lambda-5(MapPropertiesNode this$0, LatLng it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.clickListeners.getOnMapLongClick().invoke((Object)it);
    }

    private static final void onAttached$lambda-6(MapPropertiesNode this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.clickListeners.getOnMapLoaded().invoke();
    }

    private static final boolean onAttached$lambda-7(MapPropertiesNode this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return (Boolean)this$0.clickListeners.getOnMyLocationButtonClick().invoke();
    }

    private static final void onAttached$lambda-8(MapPropertiesNode this$0, Location it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.clickListeners.getOnMyLocationClick().invoke((Object)it);
    }

    private static final void onAttached$lambda-9(MapPropertiesNode this$0, PointOfInterest it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.clickListeners.getOnPOIClick().invoke((Object)it);
    }
}

