/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.clustering.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.Projection;
import com.google.android.gms.maps.model.AdvancedMarker;
import com.google.android.gms.maps.model.AdvancedMarkerOptions;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.Marker;
import com.google.maps.android.R;
import com.google.maps.android.clustering.Cluster;
import com.google.maps.android.clustering.ClusterItem;
import com.google.maps.android.clustering.ClusterManager;
import com.google.maps.android.clustering.view.ClusterRenderer;
import com.google.maps.android.collections.MarkerManager;
import com.google.maps.android.projection.Point;
import com.google.maps.android.projection.SphericalMercatorProjection;
import com.google.maps.android.ui.IconGenerator;
import com.google.maps.android.ui.SquareTextView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DefaultAdvancedMarkersClusterRenderer<T extends ClusterItem>
implements ClusterRenderer<T> {
    private final GoogleMap mMap;
    private final IconGenerator mIconGenerator;
    private final ClusterManager<T> mClusterManager;
    private final float mDensity;
    private boolean mAnimate;
    private long mAnimationDurationMs;
    private final Executor mExecutor = Executors.newSingleThreadExecutor();
    private static final int[] BUCKETS = new int[]{10, 20, 50, 100, 200, 500, 1000};
    private ShapeDrawable mColoredCircleBackground;
    private Set<MarkerWithPosition> mMarkers = Collections.newSetFromMap(new ConcurrentHashMap());
    private SparseArray<BitmapDescriptor> mIcons = new SparseArray();
    private MarkerCache<T> mMarkerCache = new MarkerCache();
    private int mMinClusterSize = 4;
    private Set<? extends Cluster<T>> mClusters;
    private MarkerCache<Cluster<T>> mClusterMarkerCache = new MarkerCache();
    private float mZoom;
    private final ViewModifier mViewModifier = new ViewModifier();
    private ClusterManager.OnClusterClickListener<T> mClickListener;
    private ClusterManager.OnClusterInfoWindowClickListener<T> mInfoWindowClickListener;
    private ClusterManager.OnClusterInfoWindowLongClickListener<T> mInfoWindowLongClickListener;
    private ClusterManager.OnClusterItemClickListener<T> mItemClickListener;
    private ClusterManager.OnClusterItemInfoWindowClickListener<T> mItemInfoWindowClickListener;
    private ClusterManager.OnClusterItemInfoWindowLongClickListener<T> mItemInfoWindowLongClickListener;
    private static final TimeInterpolator ANIMATION_INTERP = new DecelerateInterpolator();

    public DefaultAdvancedMarkersClusterRenderer(Context context, GoogleMap map, ClusterManager<T> clusterManager) {
        this.mMap = map;
        this.mAnimate = true;
        this.mAnimationDurationMs = 300L;
        this.mDensity = context.getResources().getDisplayMetrics().density;
        this.mIconGenerator = new IconGenerator(context);
        this.mIconGenerator.setContentView((View)this.makeSquareTextView(context));
        this.mIconGenerator.setTextAppearance(R.style.amu_ClusterIcon_TextAppearance);
        this.mIconGenerator.setBackground((Drawable)this.makeClusterBackground());
        this.mClusterManager = clusterManager;
    }

    @Override
    public void onAdd() {
        this.mClusterManager.getMarkerCollection().setOnMarkerClickListener(new GoogleMap.OnMarkerClickListener(){

            public boolean onMarkerClick(@NonNull Marker marker) {
                return DefaultAdvancedMarkersClusterRenderer.this.mItemClickListener != null && DefaultAdvancedMarkersClusterRenderer.this.mItemClickListener.onClusterItemClick((ClusterItem)DefaultAdvancedMarkersClusterRenderer.this.mMarkerCache.get(marker));
            }
        });
        this.mClusterManager.getMarkerCollection().setOnInfoWindowClickListener(new GoogleMap.OnInfoWindowClickListener(){

            public void onInfoWindowClick(@NonNull Marker marker) {
                if (DefaultAdvancedMarkersClusterRenderer.this.mItemInfoWindowClickListener != null) {
                    DefaultAdvancedMarkersClusterRenderer.this.mItemInfoWindowClickListener.onClusterItemInfoWindowClick((ClusterItem)DefaultAdvancedMarkersClusterRenderer.this.mMarkerCache.get(marker));
                }
            }
        });
        this.mClusterManager.getMarkerCollection().setOnInfoWindowLongClickListener(marker -> {
            if (this.mItemInfoWindowLongClickListener != null) {
                this.mItemInfoWindowLongClickListener.onClusterItemInfoWindowLongClick((ClusterItem)this.mMarkerCache.get(marker));
            }
        });
        this.mClusterManager.getClusterMarkerCollection().setOnMarkerClickListener(marker -> this.mClickListener != null && this.mClickListener.onClusterClick(this.mClusterMarkerCache.get(marker)));
        this.mClusterManager.getClusterMarkerCollection().setOnInfoWindowClickListener(marker -> {
            if (this.mInfoWindowClickListener != null) {
                this.mInfoWindowClickListener.onClusterInfoWindowClick(this.mClusterMarkerCache.get(marker));
            }
        });
        this.mClusterManager.getClusterMarkerCollection().setOnInfoWindowLongClickListener(marker -> {
            if (this.mInfoWindowLongClickListener != null) {
                this.mInfoWindowLongClickListener.onClusterInfoWindowLongClick(this.mClusterMarkerCache.get(marker));
            }
        });
    }

    @Override
    public void onRemove() {
        this.mClusterManager.getMarkerCollection().setOnMarkerClickListener(null);
        this.mClusterManager.getMarkerCollection().setOnInfoWindowClickListener(null);
        this.mClusterManager.getMarkerCollection().setOnInfoWindowLongClickListener(null);
        this.mClusterManager.getClusterMarkerCollection().setOnMarkerClickListener(null);
        this.mClusterManager.getClusterMarkerCollection().setOnInfoWindowClickListener(null);
        this.mClusterManager.getClusterMarkerCollection().setOnInfoWindowLongClickListener(null);
    }

    private LayerDrawable makeClusterBackground() {
        this.mColoredCircleBackground = new ShapeDrawable((Shape)new OvalShape());
        ShapeDrawable outline = new ShapeDrawable((Shape)new OvalShape());
        outline.getPaint().setColor(-2130706433);
        LayerDrawable background = new LayerDrawable(new Drawable[]{outline, this.mColoredCircleBackground});
        int strokeWidth = (int)(this.mDensity * 3.0f);
        background.setLayerInset(1, strokeWidth, strokeWidth, strokeWidth, strokeWidth);
        return background;
    }

    private SquareTextView makeSquareTextView(Context context) {
        SquareTextView squareTextView = new SquareTextView(context);
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -2);
        squareTextView.setLayoutParams(layoutParams);
        squareTextView.setId(R.id.amu_text);
        int twelveDpi = (int)(12.0f * this.mDensity);
        squareTextView.setPadding(twelveDpi, twelveDpi, twelveDpi, twelveDpi);
        return squareTextView;
    }

    @Override
    public int getColor(int clusterSize) {
        float hueRange = 220.0f;
        float sizeRange = 300.0f;
        float size = Math.min((float)clusterSize, 300.0f);
        float hue = (300.0f - size) * (300.0f - size) / 90000.0f * 220.0f;
        return Color.HSVToColor((float[])new float[]{hue, 1.0f, 0.6f});
    }

    @Override
    @StyleRes
    public int getClusterTextAppearance(int clusterSize) {
        return R.style.amu_ClusterIcon_TextAppearance;
    }

    @NonNull
    protected String getClusterText(int bucket) {
        if (bucket < BUCKETS[0]) {
            return String.valueOf(bucket);
        }
        return bucket + "+";
    }

    protected int getBucket(@NonNull Cluster<T> cluster) {
        int size = cluster.getSize();
        if (size <= BUCKETS[0]) {
            return size;
        }
        for (int i = 0; i < BUCKETS.length - 1; ++i) {
            if (size >= BUCKETS[i + 1]) continue;
            return BUCKETS[i];
        }
        return BUCKETS[BUCKETS.length - 1];
    }

    public int getMinClusterSize() {
        return this.mMinClusterSize;
    }

    public void setMinClusterSize(int minClusterSize) {
        this.mMinClusterSize = minClusterSize;
    }

    protected boolean shouldRenderAsCluster(@NonNull Cluster<T> cluster) {
        return cluster.getSize() >= this.mMinClusterSize;
    }

    protected boolean shouldRender(@NonNull Set<? extends Cluster<T>> oldClusters, @NonNull Set<? extends Cluster<T>> newClusters) {
        return !newClusters.equals(oldClusters);
    }

    @Override
    public void onClustersChanged(Set<? extends Cluster<T>> clusters) {
        this.mViewModifier.queue(clusters);
    }

    @Override
    public void setOnClusterClickListener(ClusterManager.OnClusterClickListener<T> listener) {
        this.mClickListener = listener;
    }

    @Override
    public void setOnClusterInfoWindowClickListener(ClusterManager.OnClusterInfoWindowClickListener<T> listener) {
        this.mInfoWindowClickListener = listener;
    }

    @Override
    public void setOnClusterInfoWindowLongClickListener(ClusterManager.OnClusterInfoWindowLongClickListener<T> listener) {
        this.mInfoWindowLongClickListener = listener;
    }

    @Override
    public void setOnClusterItemClickListener(ClusterManager.OnClusterItemClickListener<T> listener) {
        this.mItemClickListener = listener;
    }

    @Override
    public void setOnClusterItemInfoWindowClickListener(ClusterManager.OnClusterItemInfoWindowClickListener<T> listener) {
        this.mItemInfoWindowClickListener = listener;
    }

    @Override
    public void setOnClusterItemInfoWindowLongClickListener(ClusterManager.OnClusterItemInfoWindowLongClickListener<T> listener) {
        this.mItemInfoWindowLongClickListener = listener;
    }

    @Override
    public void setAnimation(boolean animate) {
        this.mAnimate = animate;
    }

    @Override
    public void setAnimationDuration(long animationDurationMs) {
        this.mAnimationDurationMs = animationDurationMs;
    }

    private Set<? extends Cluster<T>> immutableOf(Set<? extends Cluster<T>> clusters) {
        return clusters != null ? Collections.unmodifiableSet(clusters) : Collections.emptySet();
    }

    private static double distanceSquared(com.google.maps.android.geometry.Point a, com.google.maps.android.geometry.Point b) {
        return (a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y);
    }

    private com.google.maps.android.geometry.Point findClosestCluster(List<com.google.maps.android.geometry.Point> markers, com.google.maps.android.geometry.Point point) {
        if (markers == null || markers.isEmpty()) {
            return null;
        }
        int maxDistance = this.mClusterManager.getAlgorithm().getMaxDistanceBetweenClusteredItems();
        double minDistSquared = maxDistance * maxDistance;
        com.google.maps.android.geometry.Point closest = null;
        for (com.google.maps.android.geometry.Point candidate : markers) {
            double dist = DefaultAdvancedMarkersClusterRenderer.distanceSquared(candidate, point);
            if (!(dist < minDistSquared)) continue;
            closest = candidate;
            minDistSquared = dist;
        }
        return closest;
    }

    protected void onBeforeClusterItemRendered(@NonNull T item, @NonNull AdvancedMarkerOptions advancedMarkerOptions) {
        if (item.getTitle() != null && item.getSnippet() != null) {
            advancedMarkerOptions.title(item.getTitle());
            advancedMarkerOptions.snippet(item.getSnippet());
        } else if (item.getTitle() != null) {
            advancedMarkerOptions.title(item.getTitle());
        } else if (item.getSnippet() != null) {
            advancedMarkerOptions.title(item.getSnippet());
        }
    }

    protected void onClusterItemUpdated(@NonNull T item, @NonNull Marker marker) {
        boolean changed = false;
        if (item.getTitle() != null && item.getSnippet() != null) {
            if (!item.getTitle().equals(marker.getTitle())) {
                marker.setTitle(item.getTitle());
                changed = true;
            }
            if (!item.getSnippet().equals(marker.getSnippet())) {
                marker.setSnippet(item.getSnippet());
                changed = true;
            }
        } else if (item.getSnippet() != null && !item.getSnippet().equals(marker.getTitle())) {
            marker.setTitle(item.getSnippet());
            changed = true;
        } else if (item.getTitle() != null && !item.getTitle().equals(marker.getTitle())) {
            marker.setTitle(item.getTitle());
            changed = true;
        }
        if (!marker.getPosition().equals((Object)item.getPosition())) {
            marker.setPosition(item.getPosition());
            if (item.getZIndex() != null) {
                marker.setZIndex(item.getZIndex().floatValue());
            }
            changed = true;
        }
        if (changed && marker.isInfoWindowShown()) {
            marker.showInfoWindow();
        }
    }

    protected void onBeforeClusterRendered(@NonNull Cluster<T> cluster, @NonNull AdvancedMarkerOptions advancedMarkerOptions) {
        advancedMarkerOptions.icon(this.getDescriptorForCluster(cluster));
    }

    @NonNull
    protected BitmapDescriptor getDescriptorForCluster(@NonNull Cluster<T> cluster) {
        int bucket = this.getBucket(cluster);
        BitmapDescriptor descriptor = (BitmapDescriptor)this.mIcons.get(bucket);
        if (descriptor == null) {
            this.mColoredCircleBackground.getPaint().setColor(this.getColor(bucket));
            this.mIconGenerator.setTextAppearance(this.getClusterTextAppearance(bucket));
            descriptor = BitmapDescriptorFactory.fromBitmap((Bitmap)this.mIconGenerator.makeIcon(this.getClusterText(bucket)));
            this.mIcons.put(bucket, (Object)descriptor);
        }
        return descriptor;
    }

    protected void onClusterRendered(@NonNull Cluster<T> cluster, @NonNull Marker marker) {
    }

    protected void onClusterUpdated(@NonNull Cluster<T> cluster, @NonNull AdvancedMarker marker) {
        marker.setIcon(this.getDescriptorForCluster(cluster));
    }

    protected void onClusterItemRendered(@NonNull T clusterItem, @NonNull Marker marker) {
    }

    public Marker getMarker(T clusterItem) {
        return this.mMarkerCache.get(clusterItem);
    }

    public T getClusterItem(Marker marker) {
        return (T)((ClusterItem)this.mMarkerCache.get(marker));
    }

    public Marker getMarker(Cluster<T> cluster) {
        return this.mClusterMarkerCache.get(cluster);
    }

    public Cluster<T> getCluster(Marker marker) {
        return this.mClusterMarkerCache.get(marker);
    }

    private static class MarkerCache<T> {
        private Map<T, Marker> mCache = new HashMap<T, Marker>();
        private Map<Marker, T> mCacheReverse = new HashMap<Marker, T>();

        private MarkerCache() {
        }

        public Marker get(T item) {
            return this.mCache.get(item);
        }

        public T get(Marker m) {
            return this.mCacheReverse.get(m);
        }

        public void put(T item, Marker m) {
            this.mCache.put(item, m);
            this.mCacheReverse.put(m, item);
        }

        public void remove(Marker m) {
            T item = this.mCacheReverse.get(m);
            this.mCacheReverse.remove(m);
            this.mCache.remove(item);
        }
    }

    @SuppressLint(value={"HandlerLeak"})
    private class ViewModifier
    extends Handler {
        private static final int RUN_TASK = 0;
        private static final int TASK_FINISHED = 1;
        private boolean mViewModificationInProgress = false;
        private RenderTask mNextClusters = null;

        private ViewModifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            RenderTask renderTask;
            if (msg.what == 1) {
                this.mViewModificationInProgress = false;
                if (this.mNextClusters != null) {
                    this.sendEmptyMessage(0);
                }
                return;
            }
            this.removeMessages(0);
            if (this.mViewModificationInProgress) {
                return;
            }
            if (this.mNextClusters == null) {
                return;
            }
            Projection projection = DefaultAdvancedMarkersClusterRenderer.this.mMap.getProjection();
            ViewModifier viewModifier = this;
            synchronized (viewModifier) {
                renderTask = this.mNextClusters;
                this.mNextClusters = null;
                this.mViewModificationInProgress = true;
            }
            renderTask.setCallback(() -> this.sendEmptyMessage(1));
            renderTask.setProjection(projection);
            renderTask.setMapZoom(((DefaultAdvancedMarkersClusterRenderer)DefaultAdvancedMarkersClusterRenderer.this).mMap.getCameraPosition().zoom);
            DefaultAdvancedMarkersClusterRenderer.this.mExecutor.execute(renderTask);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queue(Set<? extends Cluster<T>> clusters) {
            ViewModifier viewModifier = this;
            synchronized (viewModifier) {
                this.mNextClusters = new RenderTask(clusters);
            }
            this.sendEmptyMessage(0);
        }
    }

    private class AnimationTask
    extends AnimatorListenerAdapter
    implements ValueAnimator.AnimatorUpdateListener {
        private final MarkerWithPosition markerWithPosition;
        private final Marker marker;
        private final LatLng from;
        private final LatLng to;
        private boolean mRemoveOnComplete;
        private MarkerManager mMarkerManager;

        private AnimationTask(MarkerWithPosition markerWithPosition, LatLng from, LatLng to) {
            this.markerWithPosition = markerWithPosition;
            this.marker = markerWithPosition.marker;
            this.from = from;
            this.to = to;
        }

        public void perform() {
            ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            valueAnimator.setInterpolator(ANIMATION_INTERP);
            valueAnimator.setDuration(DefaultAdvancedMarkersClusterRenderer.this.mAnimationDurationMs);
            valueAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
            valueAnimator.addListener((Animator.AnimatorListener)this);
            valueAnimator.start();
        }

        public void onAnimationEnd(Animator animation) {
            if (this.mRemoveOnComplete) {
                DefaultAdvancedMarkersClusterRenderer.this.mMarkerCache.remove(this.marker);
                DefaultAdvancedMarkersClusterRenderer.this.mClusterMarkerCache.remove(this.marker);
                this.mMarkerManager.remove(this.marker);
            }
            this.markerWithPosition.position = this.to;
        }

        public void removeOnAnimationComplete(MarkerManager markerManager) {
            this.mMarkerManager = markerManager;
            this.mRemoveOnComplete = true;
        }

        public void onAnimationUpdate(ValueAnimator valueAnimator) {
            float fraction = valueAnimator.getAnimatedFraction();
            double lat = (this.to.latitude - this.from.latitude) * (double)fraction + this.from.latitude;
            double lngDelta = this.to.longitude - this.from.longitude;
            if (Math.abs(lngDelta) > 180.0) {
                lngDelta -= Math.signum(lngDelta) * 360.0;
            }
            double lng = lngDelta * (double)fraction + this.from.longitude;
            LatLng position = new LatLng(lat, lng);
            this.marker.setPosition(position);
        }
    }

    private static class MarkerWithPosition {
        private final Marker marker;
        private LatLng position;

        private MarkerWithPosition(Marker marker) {
            this.marker = marker;
            this.position = marker.getPosition();
        }

        public boolean equals(Object other) {
            if (other instanceof MarkerWithPosition) {
                return this.marker.equals((Object)((MarkerWithPosition)other).marker);
            }
            return false;
        }

        public int hashCode() {
            return this.marker.hashCode();
        }
    }

    private class CreateMarkerTask {
        private final Cluster<T> cluster;
        private final Set<MarkerWithPosition> newMarkers;
        private final LatLng animateFrom;

        public CreateMarkerTask(Cluster<T> c, Set<MarkerWithPosition> markersAdded, LatLng animateFrom) {
            this.cluster = c;
            this.newMarkers = markersAdded;
            this.animateFrom = animateFrom;
        }

        private void perform(MarkerModifier markerModifier) {
            MarkerWithPosition markerWithPosition;
            if (!DefaultAdvancedMarkersClusterRenderer.this.shouldRenderAsCluster(this.cluster)) {
                for (ClusterItem item : this.cluster.getItems()) {
                    MarkerWithPosition markerWithPosition2;
                    AdvancedMarker marker = (AdvancedMarker)DefaultAdvancedMarkersClusterRenderer.this.mMarkerCache.get(item);
                    if (marker == null) {
                        AdvancedMarkerOptions advancedMarkerOptions = new AdvancedMarkerOptions();
                        if (this.animateFrom != null) {
                            advancedMarkerOptions.position(this.animateFrom);
                        } else {
                            advancedMarkerOptions.position(item.getPosition());
                            if (item.getZIndex() != null) {
                                advancedMarkerOptions.zIndex(item.getZIndex().floatValue());
                            }
                        }
                        DefaultAdvancedMarkersClusterRenderer.this.onBeforeClusterItemRendered(item, advancedMarkerOptions);
                        marker = (AdvancedMarker)DefaultAdvancedMarkersClusterRenderer.this.mClusterManager.getMarkerCollection().addMarker(advancedMarkerOptions);
                        markerWithPosition2 = new MarkerWithPosition((Marker)marker);
                        DefaultAdvancedMarkersClusterRenderer.this.mMarkerCache.put(item, (Marker)marker);
                        if (this.animateFrom != null) {
                            markerModifier.animate(markerWithPosition2, this.animateFrom, item.getPosition());
                        }
                    } else {
                        markerWithPosition2 = new MarkerWithPosition((Marker)marker);
                        DefaultAdvancedMarkersClusterRenderer.this.onClusterItemUpdated(item, (Marker)marker);
                    }
                    DefaultAdvancedMarkersClusterRenderer.this.onClusterItemRendered(item, (Marker)marker);
                    this.newMarkers.add(markerWithPosition2);
                }
                return;
            }
            AdvancedMarker marker = (AdvancedMarker)DefaultAdvancedMarkersClusterRenderer.this.mClusterMarkerCache.get(this.cluster);
            if (marker == null) {
                AdvancedMarkerOptions advancedMarkerOptions = new AdvancedMarkerOptions().position(this.animateFrom == null ? this.cluster.getPosition() : this.animateFrom);
                DefaultAdvancedMarkersClusterRenderer.this.onBeforeClusterRendered(this.cluster, advancedMarkerOptions);
                Marker object = DefaultAdvancedMarkersClusterRenderer.this.mClusterManager.getClusterMarkerCollection().addMarker(advancedMarkerOptions);
                marker = (AdvancedMarker)object;
                DefaultAdvancedMarkersClusterRenderer.this.mClusterMarkerCache.put(this.cluster, (Marker)marker);
                markerWithPosition = new MarkerWithPosition((Marker)marker);
                if (this.animateFrom != null) {
                    markerModifier.animate(markerWithPosition, this.animateFrom, this.cluster.getPosition());
                }
            } else {
                markerWithPosition = new MarkerWithPosition((Marker)marker);
                DefaultAdvancedMarkersClusterRenderer.this.onClusterUpdated(this.cluster, marker);
            }
            DefaultAdvancedMarkersClusterRenderer.this.onClusterRendered(this.cluster, (Marker)marker);
            this.newMarkers.add(markerWithPosition);
        }
    }

    @SuppressLint(value={"HandlerLeak"})
    private class MarkerModifier
    extends Handler
    implements MessageQueue.IdleHandler {
        private static final int BLANK = 0;
        private final Lock lock;
        private final Condition busyCondition;
        private Queue<CreateMarkerTask> mCreateMarkerTasks;
        private Queue<CreateMarkerTask> mOnScreenCreateMarkerTasks;
        private Queue<Marker> mRemoveMarkerTasks;
        private Queue<Marker> mOnScreenRemoveMarkerTasks;
        private Queue<AnimationTask> mAnimationTasks;
        private boolean mListenerAdded;

        private MarkerModifier() {
            super(Looper.getMainLooper());
            this.lock = new ReentrantLock();
            this.busyCondition = this.lock.newCondition();
            this.mCreateMarkerTasks = new LinkedList<CreateMarkerTask>();
            this.mOnScreenCreateMarkerTasks = new LinkedList<CreateMarkerTask>();
            this.mRemoveMarkerTasks = new LinkedList<Marker>();
            this.mOnScreenRemoveMarkerTasks = new LinkedList<Marker>();
            this.mAnimationTasks = new LinkedList<AnimationTask>();
        }

        public void add(boolean priority, CreateMarkerTask c) {
            this.lock.lock();
            this.sendEmptyMessage(0);
            if (priority) {
                this.mOnScreenCreateMarkerTasks.add(c);
            } else {
                this.mCreateMarkerTasks.add(c);
            }
            this.lock.unlock();
        }

        public void remove(boolean priority, Marker m) {
            this.lock.lock();
            this.sendEmptyMessage(0);
            if (priority) {
                this.mOnScreenRemoveMarkerTasks.add(m);
            } else {
                this.mRemoveMarkerTasks.add(m);
            }
            this.lock.unlock();
        }

        public void animate(MarkerWithPosition marker, LatLng from, LatLng to) {
            this.lock.lock();
            this.mAnimationTasks.add(new AnimationTask(marker, from, to));
            this.lock.unlock();
        }

        public void animateThenRemove(MarkerWithPosition marker, LatLng from, LatLng to) {
            this.lock.lock();
            AnimationTask animationTask = new AnimationTask(marker, from, to);
            animationTask.removeOnAnimationComplete(DefaultAdvancedMarkersClusterRenderer.this.mClusterManager.getMarkerManager());
            this.mAnimationTasks.add(animationTask);
            this.lock.unlock();
        }

        public void handleMessage(Message msg) {
            if (!this.mListenerAdded) {
                Looper.myQueue().addIdleHandler((MessageQueue.IdleHandler)this);
                this.mListenerAdded = true;
            }
            this.removeMessages(0);
            this.lock.lock();
            try {
                for (int i = 0; i < 10; ++i) {
                    this.performNextTask();
                }
                if (!this.isBusy()) {
                    this.mListenerAdded = false;
                    Looper.myQueue().removeIdleHandler((MessageQueue.IdleHandler)this);
                    this.busyCondition.signalAll();
                } else {
                    this.sendEmptyMessageDelayed(0, 10L);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        private void performNextTask() {
            if (!this.mOnScreenRemoveMarkerTasks.isEmpty()) {
                this.removeMarker(this.mOnScreenRemoveMarkerTasks.poll());
            } else if (!this.mAnimationTasks.isEmpty()) {
                this.mAnimationTasks.poll().perform();
            } else if (!this.mOnScreenCreateMarkerTasks.isEmpty()) {
                this.mOnScreenCreateMarkerTasks.poll().perform(this);
            } else if (!this.mCreateMarkerTasks.isEmpty()) {
                this.mCreateMarkerTasks.poll().perform(this);
            } else if (!this.mRemoveMarkerTasks.isEmpty()) {
                this.removeMarker(this.mRemoveMarkerTasks.poll());
            }
        }

        private void removeMarker(Marker m) {
            DefaultAdvancedMarkersClusterRenderer.this.mMarkerCache.remove(m);
            DefaultAdvancedMarkersClusterRenderer.this.mClusterMarkerCache.remove(m);
            DefaultAdvancedMarkersClusterRenderer.this.mClusterManager.getMarkerManager().remove(m);
        }

        public boolean isBusy() {
            try {
                this.lock.lock();
                boolean bl = !this.mCreateMarkerTasks.isEmpty() || !this.mOnScreenCreateMarkerTasks.isEmpty() || !this.mOnScreenRemoveMarkerTasks.isEmpty() || !this.mRemoveMarkerTasks.isEmpty() || !this.mAnimationTasks.isEmpty();
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        public void waitUntilFree() {
            while (this.isBusy()) {
                this.sendEmptyMessage(0);
                this.lock.lock();
                try {
                    if (!this.isBusy()) continue;
                    this.busyCondition.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        public boolean queueIdle() {
            this.sendEmptyMessage(0);
            return true;
        }
    }

    private class RenderTask
    implements Runnable {
        final Set<? extends Cluster<T>> clusters;
        private Runnable mCallback;
        private Projection mProjection;
        private SphericalMercatorProjection mSphericalMercatorProjection;
        private float mMapZoom;

        private RenderTask(Set<? extends Cluster<T>> clusters) {
            this.clusters = clusters;
        }

        public void setCallback(Runnable callback) {
            this.mCallback = callback;
        }

        public void setProjection(Projection projection) {
            this.mProjection = projection;
        }

        public void setMapZoom(float zoom) {
            this.mMapZoom = zoom;
            this.mSphericalMercatorProjection = new SphericalMercatorProjection(256.0 * Math.pow(2.0, Math.min(zoom, DefaultAdvancedMarkersClusterRenderer.this.mZoom)));
        }

        @Override
        @SuppressLint(value={"NewApi"})
        public void run() {
            LatLngBounds visibleBounds;
            if (!DefaultAdvancedMarkersClusterRenderer.this.shouldRender(DefaultAdvancedMarkersClusterRenderer.this.immutableOf(DefaultAdvancedMarkersClusterRenderer.this.mClusters), DefaultAdvancedMarkersClusterRenderer.this.immutableOf(this.clusters))) {
                this.mCallback.run();
                return;
            }
            MarkerModifier markerModifier = new MarkerModifier();
            float zoom = this.mMapZoom;
            boolean zoomingIn = zoom > DefaultAdvancedMarkersClusterRenderer.this.mZoom;
            float zoomDelta = zoom - DefaultAdvancedMarkersClusterRenderer.this.mZoom;
            Set markersToRemove = DefaultAdvancedMarkersClusterRenderer.this.mMarkers;
            try {
                visibleBounds = this.mProjection.getVisibleRegion().latLngBounds;
            }
            catch (Exception e) {
                e.printStackTrace();
                visibleBounds = LatLngBounds.builder().include(new LatLng(0.0, 0.0)).build();
            }
            ArrayList<Point> existingClustersOnScreen = null;
            if (DefaultAdvancedMarkersClusterRenderer.this.mClusters != null && DefaultAdvancedMarkersClusterRenderer.this.mAnimate) {
                existingClustersOnScreen = new ArrayList<Point>();
                for (Object c : DefaultAdvancedMarkersClusterRenderer.this.mClusters) {
                    if (!DefaultAdvancedMarkersClusterRenderer.this.shouldRenderAsCluster(c) || !visibleBounds.contains(c.getPosition())) continue;
                    Point point = this.mSphericalMercatorProjection.toPoint(c.getPosition());
                    existingClustersOnScreen.add(point);
                }
            }
            Set<MarkerWithPosition> newMarkers = Collections.newSetFromMap(new ConcurrentHashMap());
            for (Cluster c : this.clusters) {
                boolean bl = visibleBounds.contains(c.getPosition());
                if (zoomingIn && bl && DefaultAdvancedMarkersClusterRenderer.this.mAnimate) {
                    Point point = this.mSphericalMercatorProjection.toPoint(c.getPosition());
                    com.google.maps.android.geometry.Point closest = DefaultAdvancedMarkersClusterRenderer.this.findClosestCluster(existingClustersOnScreen, point);
                    if (closest != null) {
                        LatLng animateTo = this.mSphericalMercatorProjection.toLatLng(closest);
                        markerModifier.add(true, new CreateMarkerTask(c, newMarkers, animateTo));
                        continue;
                    }
                    markerModifier.add(true, new CreateMarkerTask(c, newMarkers, null));
                    continue;
                }
                markerModifier.add(bl, new CreateMarkerTask(c, newMarkers, null));
            }
            markerModifier.waitUntilFree();
            markersToRemove.removeAll(newMarkers);
            ArrayList<Point> newClustersOnScreen = null;
            if (DefaultAdvancedMarkersClusterRenderer.this.mAnimate) {
                newClustersOnScreen = new ArrayList<Point>();
                for (Cluster cluster : this.clusters) {
                    if (!DefaultAdvancedMarkersClusterRenderer.this.shouldRenderAsCluster(cluster) || !visibleBounds.contains(cluster.getPosition())) continue;
                    Point p = this.mSphericalMercatorProjection.toPoint(cluster.getPosition());
                    newClustersOnScreen.add(p);
                }
            }
            for (MarkerWithPosition markerWithPosition : markersToRemove) {
                boolean onScreen = visibleBounds.contains(markerWithPosition.position);
                if (!zoomingIn && zoomDelta > -3.0f && onScreen && DefaultAdvancedMarkersClusterRenderer.this.mAnimate) {
                    Point point = this.mSphericalMercatorProjection.toPoint(markerWithPosition.position);
                    com.google.maps.android.geometry.Point closest = DefaultAdvancedMarkersClusterRenderer.this.findClosestCluster(newClustersOnScreen, point);
                    if (closest != null) {
                        LatLng animateTo = this.mSphericalMercatorProjection.toLatLng(closest);
                        markerModifier.animateThenRemove(markerWithPosition, markerWithPosition.position, animateTo);
                        continue;
                    }
                    markerModifier.remove(true, markerWithPosition.marker);
                    continue;
                }
                markerModifier.remove(onScreen, markerWithPosition.marker);
            }
            markerModifier.waitUntilFree();
            DefaultAdvancedMarkersClusterRenderer.this.mMarkers = newMarkers;
            DefaultAdvancedMarkersClusterRenderer.this.mClusters = this.clusters;
            DefaultAdvancedMarkersClusterRenderer.this.mZoom = zoom;
            this.mCallback.run();
        }
    }
}

