/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.data;

import androidx.annotation.NonNull;
import com.google.maps.android.data.Geometry;
import java.util.ArrayList;
import java.util.List;

public class MultiGeometry
implements Geometry {
    private String geometryType = "MultiGeometry";
    private List<Geometry> mGeometries;

    public MultiGeometry(List<? extends Geometry> geometries) {
        if (geometries == null) {
            throw new IllegalArgumentException("Geometries cannot be null");
        }
        ArrayList<Geometry> geometriesList = new ArrayList<Geometry>();
        for (Geometry geometry : geometries) {
            geometriesList.add(geometry);
        }
        this.mGeometries = geometriesList;
    }

    @Override
    public String getGeometryType() {
        return this.geometryType;
    }

    public List<Geometry> getGeometryObject() {
        return this.mGeometries;
    }

    public void setGeometryType(String type) {
        this.geometryType = type;
    }

    @NonNull
    public String toString() {
        String typeString = "Geometries=";
        if (this.geometryType.equals("MultiPoint")) {
            typeString = "LineStrings=";
        }
        if (this.geometryType.equals("MultiLineString")) {
            typeString = "points=";
        }
        if (this.geometryType.equals("MultiPolygon")) {
            typeString = "Polygons=";
        }
        StringBuilder sb = new StringBuilder(this.getGeometryType()).append("{");
        sb.append("\n " + typeString).append(this.getGeometryObject());
        sb.append("\n}\n");
        return sb.toString();
    }
}

