/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.clustering.algo;

import com.google.maps.android.clustering.ClusterItem;
import com.google.maps.android.clustering.algo.CentroidNonHierarchicalDistanceBasedAlgorithm;
import com.google.maps.android.clustering.algo.NonHierarchicalDistanceBasedAlgorithm;
import com.google.maps.android.geometry.Bounds;
import com.google.maps.android.quadtree.PointQuadTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class ContinuousZoomEuclideanCentroidAlgorithm<T extends ClusterItem>
extends CentroidNonHierarchicalDistanceBasedAlgorithm<T> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<NonHierarchicalDistanceBasedAlgorithm.QuadItem<T>> getClusteringItems(PointQuadTree<NonHierarchicalDistanceBasedAlgorithm.QuadItem<T>> quadTree, float zoom) {
        double zoomSpecificSpan = (double)this.getMaxDistanceBetweenClusteredItems() / Math.pow(2.0, zoom) / 256.0;
        HashSet visitedCandidates = new HashSet();
        ArrayList<NonHierarchicalDistanceBasedAlgorithm.QuadItem<T>> result = new ArrayList<NonHierarchicalDistanceBasedAlgorithm.QuadItem<T>>();
        PointQuadTree pointQuadTree = this.mQuadTree;
        synchronized (pointQuadTree) {
            for (NonHierarchicalDistanceBasedAlgorithm.QuadItem candidate : this.mItems) {
                if (visitedCandidates.contains(candidate)) continue;
                Bounds searchBounds = this.createBoundsFromSpan(candidate.getPoint(), zoomSpecificSpan);
                ArrayList<NonHierarchicalDistanceBasedAlgorithm.QuadItem> clusterItems = new ArrayList<NonHierarchicalDistanceBasedAlgorithm.QuadItem>();
                for (NonHierarchicalDistanceBasedAlgorithm.QuadItem clusterItem : this.mQuadTree.search(searchBounds)) {
                    double radiusSquared;
                    double distance = this.distanceSquared(clusterItem.getPoint(), candidate.getPoint());
                    if (!(distance < (radiusSquared = Math.pow(zoomSpecificSpan / 2.0, 2.0)))) continue;
                    clusterItems.add(clusterItem);
                }
                visitedCandidates.addAll(clusterItems);
                result.add(candidate);
            }
        }
        return result;
    }
}

