/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.data.kml;

import androidx.annotation.NonNull;
import com.google.android.gms.maps.model.LatLng;
import com.google.maps.android.data.DataPolygon;
import java.util.ArrayList;
import java.util.List;

public class KmlPolygon
implements DataPolygon<ArrayList<ArrayList<LatLng>>> {
    public static final String GEOMETRY_TYPE = "Polygon";
    private final List<LatLng> mOuterBoundaryCoordinates;
    private final List<List<LatLng>> mInnerBoundaryCoordinates;

    public KmlPolygon(List<LatLng> outerBoundaryCoordinates, List<List<LatLng>> innerBoundaryCoordinates) {
        if (outerBoundaryCoordinates == null) {
            throw new IllegalArgumentException("Outer boundary coordinates cannot be null");
        }
        this.mOuterBoundaryCoordinates = outerBoundaryCoordinates;
        this.mInnerBoundaryCoordinates = innerBoundaryCoordinates;
    }

    @Override
    public String getGeometryType() {
        return GEOMETRY_TYPE;
    }

    public List<List<LatLng>> getGeometryObject() {
        ArrayList<List<LatLng>> coordinates = new ArrayList<List<LatLng>>();
        coordinates.add(this.mOuterBoundaryCoordinates);
        if (this.mInnerBoundaryCoordinates != null) {
            coordinates.addAll(this.mInnerBoundaryCoordinates);
        }
        return coordinates;
    }

    @Override
    public List<LatLng> getOuterBoundaryCoordinates() {
        return this.mOuterBoundaryCoordinates;
    }

    @Override
    public List<List<LatLng>> getInnerBoundaryCoordinates() {
        return this.mInnerBoundaryCoordinates;
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder(GEOMETRY_TYPE).append("{");
        sb.append("\n outer coordinates=").append(this.mOuterBoundaryCoordinates);
        sb.append(",\n inner coordinates=").append(this.mInnerBoundaryCoordinates);
        sb.append("\n}\n");
        return sb.toString();
    }
}

