/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.data;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import com.google.android.gms.maps.model.GroundOverlay;
import com.google.android.gms.maps.model.GroundOverlayOptions;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.gms.maps.model.Polygon;
import com.google.android.gms.maps.model.PolygonOptions;
import com.google.android.gms.maps.model.Polyline;
import com.google.android.gms.maps.model.PolylineOptions;
import com.google.maps.android.R;
import com.google.maps.android.collections.GroundOverlayManager;
import com.google.maps.android.collections.MarkerManager;
import com.google.maps.android.collections.PolygonManager;
import com.google.maps.android.collections.PolylineManager;
import com.google.maps.android.data.DataPolygon;
import com.google.maps.android.data.Feature;
import com.google.maps.android.data.Geometry;
import com.google.maps.android.data.Layer;
import com.google.maps.android.data.LineString;
import com.google.maps.android.data.Point;
import com.google.maps.android.data.geojson.BiMultiMap;
import com.google.maps.android.data.geojson.GeoJsonFeature;
import com.google.maps.android.data.geojson.GeoJsonGeometryCollection;
import com.google.maps.android.data.geojson.GeoJsonLineString;
import com.google.maps.android.data.geojson.GeoJsonLineStringStyle;
import com.google.maps.android.data.geojson.GeoJsonMultiLineString;
import com.google.maps.android.data.geojson.GeoJsonMultiPoint;
import com.google.maps.android.data.geojson.GeoJsonMultiPolygon;
import com.google.maps.android.data.geojson.GeoJsonPoint;
import com.google.maps.android.data.geojson.GeoJsonPointStyle;
import com.google.maps.android.data.geojson.GeoJsonPolygon;
import com.google.maps.android.data.geojson.GeoJsonPolygonStyle;
import com.google.maps.android.data.kml.KmlContainer;
import com.google.maps.android.data.kml.KmlGroundOverlay;
import com.google.maps.android.data.kml.KmlMultiGeometry;
import com.google.maps.android.data.kml.KmlPlacemark;
import com.google.maps.android.data.kml.KmlPoint;
import com.google.maps.android.data.kml.KmlStyle;
import com.google.maps.android.data.kml.KmlUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Renderer {
    private static final int MARKER_ICON_SIZE = 32;
    private static final Object FEATURE_NOT_ON_MAP = null;
    private static final DecimalFormat sScaleFormat = new DecimalFormat("#.####");
    private GoogleMap mMap;
    private final BiMultiMap<Feature> mFeatures = new BiMultiMap();
    private HashMap<String, KmlStyle> mStyles;
    private HashMap<String, KmlStyle> mStylesRenderer;
    private HashMap<String, String> mStyleMaps;
    private final BiMultiMap<Feature> mContainerFeatures;
    private HashMap<KmlGroundOverlay, GroundOverlay> mGroundOverlayMap;
    private final Set<String> mMarkerIconUrls;
    private ImagesCache mImagesCache;
    private int mNumActiveDownloads = 0;
    private boolean mLayerOnMap;
    private Context mContext;
    private ArrayList<KmlContainer> mContainers;
    private final GeoJsonPointStyle mDefaultPointStyle;
    private final GeoJsonLineStringStyle mDefaultLineStringStyle;
    private final GeoJsonPolygonStyle mDefaultPolygonStyle;
    private final MarkerManager.Collection mMarkers;
    private final PolygonManager.Collection mPolygons;
    private final PolylineManager.Collection mPolylines;
    private final GroundOverlayManager.Collection mGroundOverlays;

    public Renderer(GoogleMap map, Context context, MarkerManager markerManager, PolygonManager polygonManager, PolylineManager polylineManager, GroundOverlayManager groundOverlayManager, @Nullable ImagesCache imagesCache) {
        this(map, new HashSet<String>(), null, null, null, new BiMultiMap<Feature>(), markerManager, polygonManager, polylineManager, groundOverlayManager);
        this.mContext = context;
        this.mStylesRenderer = new HashMap();
        this.mImagesCache = imagesCache == null ? new ImagesCache() : imagesCache;
    }

    public Renderer(GoogleMap map, HashMap<? extends Feature, Object> features, MarkerManager markerManager, PolygonManager polygonManager, PolylineManager polylineManager, GroundOverlayManager groundOverlayManager) {
        this(map, null, new GeoJsonPointStyle(), new GeoJsonLineStringStyle(), new GeoJsonPolygonStyle(), null, markerManager, polygonManager, polylineManager, groundOverlayManager);
        this.mFeatures.putAll((Map<Feature, ?>)features);
        this.mImagesCache = null;
    }

    private Renderer(GoogleMap map, Set<String> markerIconUrls, GeoJsonPointStyle defaultPointStyle, GeoJsonLineStringStyle defaultLineStringStyle, GeoJsonPolygonStyle defaultPolygonStyle, BiMultiMap<Feature> containerFeatures, MarkerManager markerManager, PolygonManager polygonManager, PolylineManager polylineManager, GroundOverlayManager groundOverlayManager) {
        this.mMap = map;
        this.mLayerOnMap = false;
        this.mMarkerIconUrls = markerIconUrls;
        this.mDefaultPointStyle = defaultPointStyle;
        this.mDefaultLineStringStyle = defaultLineStringStyle;
        this.mDefaultPolygonStyle = defaultPolygonStyle;
        this.mContainerFeatures = containerFeatures;
        if (map != null) {
            if (markerManager == null) {
                markerManager = new MarkerManager(map);
            }
            this.mMarkers = markerManager.newCollection();
            if (polygonManager == null) {
                polygonManager = new PolygonManager(map);
            }
            this.mPolygons = polygonManager.newCollection();
            if (polylineManager == null) {
                polylineManager = new PolylineManager(map);
            }
            this.mPolylines = polylineManager.newCollection();
            if (groundOverlayManager == null) {
                groundOverlayManager = new GroundOverlayManager(map);
            }
            this.mGroundOverlays = groundOverlayManager.newCollection();
        } else {
            this.mMarkers = null;
            this.mPolygons = null;
            this.mPolylines = null;
            this.mGroundOverlays = null;
        }
    }

    public boolean isLayerOnMap() {
        return this.mLayerOnMap;
    }

    protected void setLayerVisibility(boolean layerOnMap) {
        this.mLayerOnMap = layerOnMap;
    }

    public GoogleMap getMap() {
        return this.mMap;
    }

    public void setMap(GoogleMap map) {
        this.mMap = map;
    }

    protected void putContainerFeature(Object mapObject, Feature placemark) {
        this.mContainerFeatures.put(placemark, mapObject);
    }

    public Set<Feature> getFeatures() {
        return this.mFeatures.keySet();
    }

    Feature getFeature(Object mapObject) {
        return this.mFeatures.getKey(mapObject);
    }

    Feature getContainerFeature(Object mapObject) {
        if (this.mContainerFeatures != null) {
            return this.mContainerFeatures.getKey(mapObject);
        }
        return null;
    }

    public Collection<Object> getValues() {
        return this.mFeatures.values();
    }

    protected HashMap<? extends Feature, Object> getAllFeatures() {
        return this.mFeatures;
    }

    protected Set<String> getMarkerIconUrls() {
        return this.mMarkerIconUrls;
    }

    protected HashMap<String, KmlStyle> getStylesRenderer() {
        return this.mStylesRenderer;
    }

    protected HashMap<String, String> getStyleMaps() {
        return this.mStyleMaps;
    }

    protected BitmapDescriptor getCachedMarkerImage(String url, double scale) {
        Bitmap bitmap;
        String scaleString = sScaleFormat.format(scale);
        Map<String, BitmapDescriptor> bitmaps = this.mImagesCache.markerImagesCache.get(url);
        BitmapDescriptor bitmapDescriptor = null;
        if (bitmaps != null) {
            bitmapDescriptor = bitmaps.get(scaleString);
        }
        if (bitmapDescriptor == null && (bitmap = this.mImagesCache.bitmapCache.get(url)) != null) {
            bitmapDescriptor = this.scaleIcon(bitmap, scale);
            this.putMarkerImagesCache(url, scaleString, bitmapDescriptor);
        }
        return bitmapDescriptor;
    }

    private BitmapDescriptor scaleIcon(Bitmap unscaledBitmap, double scale) {
        int height;
        int width;
        int unscaledHeight;
        float density = this.mContext.getResources().getDisplayMetrics().density;
        int minSize = (int)((double)(32.0f * density) * scale);
        int unscaledWidth = unscaledBitmap.getWidth();
        if (unscaledWidth < (unscaledHeight = unscaledBitmap.getHeight())) {
            width = minSize;
            height = (int)((float)(minSize * unscaledHeight) / (float)unscaledWidth);
        } else if (unscaledWidth > unscaledHeight) {
            width = (int)((float)(minSize * unscaledWidth) / (float)unscaledHeight);
            height = minSize;
        } else {
            width = minSize;
            height = minSize;
        }
        Bitmap scaledBitmap = Bitmap.createScaledBitmap((Bitmap)unscaledBitmap, (int)width, (int)height, (boolean)false);
        return BitmapDescriptorFactory.fromBitmap((Bitmap)scaledBitmap);
    }

    protected BitmapDescriptor getCachedGroundOverlayImage(String url) {
        Bitmap bitmap;
        BitmapDescriptor bitmapDescriptor = this.mImagesCache.groundOverlayImagesCache.get(url);
        if (bitmapDescriptor == null && (bitmap = this.mImagesCache.bitmapCache.get(url)) != null) {
            bitmapDescriptor = BitmapDescriptorFactory.fromBitmap((Bitmap)bitmap);
            this.mImagesCache.groundOverlayImagesCache.put(url, bitmapDescriptor);
        }
        return bitmapDescriptor;
    }

    public HashMap<KmlGroundOverlay, GroundOverlay> getGroundOverlayMap() {
        return this.mGroundOverlayMap;
    }

    protected ArrayList<KmlContainer> getContainerList() {
        return this.mContainers;
    }

    protected KmlStyle getPlacemarkStyle(String styleId) {
        KmlStyle style2 = this.mStylesRenderer.get(null);
        if (this.mStylesRenderer.get(styleId) != null) {
            style2 = this.mStylesRenderer.get(styleId);
        }
        return style2;
    }

    GeoJsonPointStyle getDefaultPointStyle() {
        return this.mDefaultPointStyle;
    }

    GeoJsonLineStringStyle getDefaultLineStringStyle() {
        return this.mDefaultLineStringStyle;
    }

    GeoJsonPolygonStyle getDefaultPolygonStyle() {
        return this.mDefaultPolygonStyle;
    }

    protected void putFeatures(Feature feature, Object object) {
        this.mFeatures.put(feature, object);
    }

    protected void putStyles() {
        this.mStylesRenderer.putAll(this.mStyles);
    }

    protected void putStyles(HashMap<String, KmlStyle> styles) {
        this.mStylesRenderer.putAll(styles);
    }

    private void putMarkerImagesCache(String url, String scale, BitmapDescriptor bitmapDescriptor) {
        Map<String, BitmapDescriptor> bitmaps = this.mImagesCache.markerImagesCache.get(url);
        if (bitmaps == null) {
            bitmaps = new HashMap<String, BitmapDescriptor>();
            this.mImagesCache.markerImagesCache.put(url, bitmaps);
        }
        bitmaps.put(scale, bitmapDescriptor);
    }

    protected void cacheBitmap(String url, Bitmap bitmap) {
        this.mImagesCache.bitmapCache.put(url, bitmap);
    }

    protected void downloadStarted() {
        ++this.mNumActiveDownloads;
    }

    protected void downloadFinished() {
        --this.mNumActiveDownloads;
        this.checkClearBitmapCache();
    }

    protected void checkClearBitmapCache() {
        if (this.mNumActiveDownloads == 0 && this.mImagesCache != null && !this.mImagesCache.bitmapCache.isEmpty()) {
            this.mImagesCache.bitmapCache.clear();
        }
    }

    protected boolean hasFeatures() {
        return this.mFeatures.size() > 0;
    }

    protected void removeFeatures(HashMap<? extends Feature, Object> features) {
        this.removeFeatures(features.values());
    }

    private void removeFeatures(Collection features) {
        for (Object mapObject : features) {
            if (mapObject instanceof Collection) {
                this.removeFeatures((Collection)mapObject);
                continue;
            }
            if (mapObject instanceof Marker) {
                this.mMarkers.remove((Marker)mapObject);
                continue;
            }
            if (mapObject instanceof Polyline) {
                this.mPolylines.remove((Polyline)mapObject);
                continue;
            }
            if (!(mapObject instanceof Polygon)) continue;
            this.mPolygons.remove((Polygon)mapObject);
        }
    }

    protected void removeGroundOverlays(HashMap<KmlGroundOverlay, GroundOverlay> groundOverlays) {
        for (GroundOverlay groundOverlay : groundOverlays.values()) {
            if (groundOverlay == null) continue;
            this.mGroundOverlays.remove(groundOverlay);
        }
    }

    protected void removeFeature(Feature feature) {
        if (this.mFeatures.containsKey(feature)) {
            this.removeFromMap(this.mFeatures.remove(feature));
        }
    }

    private void setFeatureDefaultStyles(GeoJsonFeature feature) {
        if (feature.getPointStyle() == null) {
            feature.setPointStyle(this.mDefaultPointStyle);
        }
        if (feature.getLineStringStyle() == null) {
            feature.setLineStringStyle(this.mDefaultLineStringStyle);
        }
        if (feature.getPolygonStyle() == null) {
            feature.setPolygonStyle(this.mDefaultPolygonStyle);
        }
    }

    protected void clearStylesRenderer() {
        this.mStylesRenderer.clear();
    }

    protected void storeData(HashMap<String, KmlStyle> styles, HashMap<String, String> styleMaps, HashMap<KmlPlacemark, Object> features, ArrayList<KmlContainer> folders, HashMap<KmlGroundOverlay, GroundOverlay> groundOverlays) {
        this.mStyles = styles;
        this.mStyleMaps = styleMaps;
        this.mFeatures.putAll((Map<Feature, ?>)features);
        this.mContainers = folders;
        this.mGroundOverlayMap = groundOverlays;
    }

    protected void addFeature(Feature feature) {
        Object mapObject = FEATURE_NOT_ON_MAP;
        if (feature instanceof GeoJsonFeature) {
            this.setFeatureDefaultStyles((GeoJsonFeature)feature);
        }
        if (this.mLayerOnMap) {
            if (this.mFeatures.containsKey(feature)) {
                this.removeFromMap(this.mFeatures.get(feature));
            }
            if (feature.hasGeometry()) {
                if (feature instanceof KmlPlacemark) {
                    boolean isPlacemarkVisible = Renderer.getPlacemarkVisibility(feature);
                    String placemarkId = feature.getId();
                    Geometry geometry = feature.getGeometry();
                    KmlStyle style2 = this.getPlacemarkStyle(placemarkId);
                    KmlStyle inlineStyle = ((KmlPlacemark)feature).getInlineStyle();
                    mapObject = this.addKmlPlacemarkToMap((KmlPlacemark)feature, geometry, style2, inlineStyle, isPlacemarkVisible);
                } else {
                    mapObject = this.addGeoJsonFeatureToMap(feature, feature.getGeometry());
                }
            }
        }
        this.mFeatures.put(feature, mapObject);
    }

    protected void removeFromMap(Object mapObject) {
        if (mapObject instanceof Marker) {
            this.mMarkers.remove((Marker)mapObject);
        } else if (mapObject instanceof Polyline) {
            this.mPolylines.remove((Polyline)mapObject);
        } else if (mapObject instanceof Polygon) {
            this.mPolygons.remove((Polygon)mapObject);
        } else if (mapObject instanceof GroundOverlay) {
            this.mGroundOverlays.remove((GroundOverlay)mapObject);
        } else if (mapObject instanceof ArrayList) {
            for (Object mapObjectElement : (ArrayList)mapObject) {
                this.removeFromMap(mapObjectElement);
            }
        }
    }

    protected Object addGeoJsonFeatureToMap(Feature feature, Geometry geometry) {
        String geometryType;
        switch (geometryType = geometry.getGeometryType()) {
            case "Point": {
                MarkerOptions markerOptions = null;
                if (feature instanceof GeoJsonFeature) {
                    markerOptions = ((GeoJsonFeature)feature).getMarkerOptions();
                } else if (feature instanceof KmlPlacemark) {
                    markerOptions = ((KmlPlacemark)feature).getMarkerOptions();
                }
                return this.addPointToMap(markerOptions, (GeoJsonPoint)geometry);
            }
            case "LineString": {
                PolylineOptions polylineOptions = null;
                if (feature instanceof GeoJsonFeature) {
                    polylineOptions = ((GeoJsonFeature)feature).getPolylineOptions();
                } else if (feature instanceof KmlPlacemark) {
                    polylineOptions = ((KmlPlacemark)feature).getPolylineOptions();
                }
                return this.addLineStringToMap(polylineOptions, (GeoJsonLineString)geometry);
            }
            case "Polygon": {
                PolygonOptions polygonOptions = null;
                if (feature instanceof GeoJsonFeature) {
                    polygonOptions = ((GeoJsonFeature)feature).getPolygonOptions();
                } else if (feature instanceof KmlPlacemark) {
                    polygonOptions = ((KmlPlacemark)feature).getPolygonOptions();
                }
                return this.addPolygonToMap(polygonOptions, (DataPolygon)geometry);
            }
            case "MultiPoint": {
                return this.addMultiPointToMap(((GeoJsonFeature)feature).getPointStyle(), (GeoJsonMultiPoint)geometry);
            }
            case "MultiLineString": {
                return this.addMultiLineStringToMap(((GeoJsonFeature)feature).getLineStringStyle(), (GeoJsonMultiLineString)geometry);
            }
            case "MultiPolygon": {
                return this.addMultiPolygonToMap(((GeoJsonFeature)feature).getPolygonStyle(), (GeoJsonMultiPolygon)geometry);
            }
            case "GeometryCollection": {
                return this.addGeometryCollectionToMap((GeoJsonFeature)feature, ((GeoJsonGeometryCollection)geometry).getGeometries());
            }
        }
        return null;
    }

    protected Object addKmlPlacemarkToMap(KmlPlacemark placemark, Geometry geometry, KmlStyle style2, KmlStyle inlineStyle, boolean isVisible) {
        String geometryType = geometry.getGeometryType();
        boolean hasDrawOrder = placemark.hasProperty("drawOrder");
        float drawOrder = 0.0f;
        if (hasDrawOrder) {
            try {
                drawOrder = Float.parseFloat(placemark.getProperty("drawOrder"));
            }
            catch (NumberFormatException e) {
                hasDrawOrder = false;
            }
        }
        switch (geometryType) {
            case "Point": {
                MarkerOptions markerOptions = style2.getMarkerOptions();
                if (inlineStyle != null) {
                    this.setInlinePointStyle(markerOptions, inlineStyle, style2);
                } else if (style2.getIconUrl() != null) {
                    this.addMarkerIcons(style2.getIconUrl(), style2.getIconScale(), markerOptions);
                }
                Marker marker = this.addPointToMap(markerOptions, (KmlPoint)geometry);
                marker.setVisible(isVisible);
                this.setMarkerInfoWindow(style2, marker, placemark);
                if (hasDrawOrder) {
                    marker.setZIndex(drawOrder);
                }
                return marker;
            }
            case "LineString": {
                PolylineOptions polylineOptions = style2.getPolylineOptions();
                if (inlineStyle != null) {
                    this.setInlineLineStringStyle(polylineOptions, inlineStyle);
                } else if (style2.isLineRandomColorMode()) {
                    polylineOptions.color(KmlStyle.computeRandomColor(polylineOptions.getColor()));
                }
                Polyline polyline = this.addLineStringToMap(polylineOptions, (LineString)geometry);
                polyline.setVisible(isVisible);
                if (hasDrawOrder) {
                    polyline.setZIndex(drawOrder);
                }
                return polyline;
            }
            case "Polygon": {
                PolygonOptions polygonOptions = style2.getPolygonOptions();
                if (inlineStyle != null) {
                    this.setInlinePolygonStyle(polygonOptions, inlineStyle);
                } else if (style2.isPolyRandomColorMode()) {
                    polygonOptions.fillColor(KmlStyle.computeRandomColor(polygonOptions.getFillColor()));
                }
                Polygon polygon = this.addPolygonToMap(polygonOptions, (DataPolygon)geometry);
                polygon.setVisible(isVisible);
                if (hasDrawOrder) {
                    polygon.setZIndex(drawOrder);
                }
                return polygon;
            }
            case "MultiGeometry": {
                return this.addMultiGeometryToMap(placemark, (KmlMultiGeometry)geometry, style2, inlineStyle, isVisible);
            }
        }
        return null;
    }

    private Marker addPointToMap(MarkerOptions markerOptions, Point point) {
        markerOptions.position(point.getGeometryObject());
        return this.mMarkers.addMarker(markerOptions);
    }

    private void setInlinePointStyle(MarkerOptions markerOptions, KmlStyle inlineStyle, KmlStyle defaultStyle) {
        MarkerOptions inlineMarkerOptions = inlineStyle.getMarkerOptions();
        if (inlineStyle.isStyleSet("heading")) {
            markerOptions.rotation(inlineMarkerOptions.getRotation());
        }
        if (inlineStyle.isStyleSet("hotSpot")) {
            markerOptions.anchor(inlineMarkerOptions.getAnchorU(), inlineMarkerOptions.getAnchorV());
        }
        if (inlineStyle.isStyleSet("markerColor")) {
            markerOptions.icon(inlineMarkerOptions.getIcon());
        }
        double scale = inlineStyle.isStyleSet("iconScale") ? inlineStyle.getIconScale() : (defaultStyle.isStyleSet("iconScale") ? defaultStyle.getIconScale() : 1.0);
        if (inlineStyle.isStyleSet("iconUrl")) {
            this.addMarkerIcons(inlineStyle.getIconUrl(), scale, markerOptions);
        } else if (defaultStyle.getIconUrl() != null) {
            this.addMarkerIcons(defaultStyle.getIconUrl(), scale, markerOptions);
        }
    }

    private Polyline addLineStringToMap(PolylineOptions polylineOptions, LineString lineString) {
        polylineOptions.addAll((Iterable)lineString.getGeometryObject());
        Polyline addedPolyline = this.mPolylines.addPolyline(polylineOptions);
        addedPolyline.setClickable(polylineOptions.isClickable());
        return addedPolyline;
    }

    private void setInlineLineStringStyle(PolylineOptions polylineOptions, KmlStyle inlineStyle) {
        PolylineOptions inlinePolylineOptions = inlineStyle.getPolylineOptions();
        if (inlineStyle.isStyleSet("outlineColor")) {
            polylineOptions.color(inlinePolylineOptions.getColor());
        }
        if (inlineStyle.isStyleSet("width")) {
            polylineOptions.width(inlinePolylineOptions.getWidth());
        }
        if (inlineStyle.isLineRandomColorMode()) {
            polylineOptions.color(KmlStyle.computeRandomColor(inlinePolylineOptions.getColor()));
        }
    }

    private Polygon addPolygonToMap(PolygonOptions polygonOptions, DataPolygon polygon) {
        polygonOptions.addAll(polygon.getOuterBoundaryCoordinates());
        List<List<LatLng>> innerBoundaries = polygon.getInnerBoundaryCoordinates();
        for (List<LatLng> innerBoundary : innerBoundaries) {
            polygonOptions.addHole(innerBoundary);
        }
        Polygon addedPolygon = this.mPolygons.addPolygon(polygonOptions);
        addedPolygon.setClickable(polygonOptions.isClickable());
        return addedPolygon;
    }

    private void setInlinePolygonStyle(PolygonOptions polygonOptions, KmlStyle inlineStyle) {
        PolygonOptions inlinePolygonOptions = inlineStyle.getPolygonOptions();
        if (inlineStyle.hasFill() && inlineStyle.isStyleSet("fillColor")) {
            polygonOptions.fillColor(inlinePolygonOptions.getFillColor());
        }
        if (inlineStyle.hasOutline()) {
            if (inlineStyle.isStyleSet("outlineColor")) {
                polygonOptions.strokeColor(inlinePolygonOptions.getStrokeColor());
            }
            if (inlineStyle.isStyleSet("width")) {
                polygonOptions.strokeWidth(inlinePolygonOptions.getStrokeWidth());
            }
        }
        if (inlineStyle.isPolyRandomColorMode()) {
            polygonOptions.fillColor(KmlStyle.computeRandomColor(inlinePolygonOptions.getFillColor()));
        }
    }

    private ArrayList<Object> addGeometryCollectionToMap(GeoJsonFeature feature, List<Geometry> geoJsonGeometries) {
        ArrayList<Object> geometries = new ArrayList<Object>();
        for (Geometry geometry : geoJsonGeometries) {
            geometries.add(this.addGeoJsonFeatureToMap(feature, geometry));
        }
        return geometries;
    }

    protected static boolean getPlacemarkVisibility(Feature feature) {
        String placemarkVisibility;
        boolean isFeatureVisible = true;
        if (feature.hasProperty("visibility") && Integer.parseInt(placemarkVisibility = feature.getProperty("visibility")) == 0) {
            isFeatureVisible = false;
        }
        return isFeatureVisible;
    }

    public void assignStyleMap(HashMap<String, String> styleMap, HashMap<String, KmlStyle> styles) {
        for (String styleMapKey : styleMap.keySet()) {
            String styleMapValue = styleMap.get(styleMapKey);
            if (!styles.containsKey(styleMapValue)) continue;
            styles.put(styleMapKey, styles.get(styleMapValue));
        }
    }

    private ArrayList<Object> addMultiGeometryToMap(KmlPlacemark placemark, KmlMultiGeometry multiGeometry, KmlStyle urlStyle, KmlStyle inlineStyle, boolean isContainerVisible) {
        ArrayList<Object> mapObjects = new ArrayList<Object>();
        List kmlObjects = multiGeometry.getGeometryObject();
        for (Geometry kmlGeometry : kmlObjects) {
            mapObjects.add(this.addKmlPlacemarkToMap(placemark, kmlGeometry, urlStyle, inlineStyle, isContainerVisible));
        }
        return mapObjects;
    }

    private ArrayList<Marker> addMultiPointToMap(GeoJsonPointStyle pointStyle, GeoJsonMultiPoint multiPoint) {
        ArrayList<Marker> markers = new ArrayList<Marker>();
        for (GeoJsonPoint geoJsonPoint : multiPoint.getPoints()) {
            markers.add(this.addPointToMap(pointStyle.toMarkerOptions(), geoJsonPoint));
        }
        return markers;
    }

    private ArrayList<Polyline> addMultiLineStringToMap(GeoJsonLineStringStyle lineStringStyle, GeoJsonMultiLineString multiLineString) {
        ArrayList<Polyline> polylines = new ArrayList<Polyline>();
        for (GeoJsonLineString geoJsonLineString : multiLineString.getLineStrings()) {
            polylines.add(this.addLineStringToMap(lineStringStyle.toPolylineOptions(), geoJsonLineString));
        }
        return polylines;
    }

    private ArrayList<Polygon> addMultiPolygonToMap(GeoJsonPolygonStyle polygonStyle, GeoJsonMultiPolygon multiPolygon) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (GeoJsonPolygon geoJsonPolygon : multiPolygon.getPolygons()) {
            polygons.add(this.addPolygonToMap(polygonStyle.toPolygonOptions(), geoJsonPolygon));
        }
        return polygons;
    }

    private void addMarkerIcons(String styleUrl, double scale, MarkerOptions markerOptions) {
        BitmapDescriptor bitmap = this.getCachedMarkerImage(styleUrl, scale);
        if (bitmap != null) {
            markerOptions.icon(bitmap);
        } else {
            this.mMarkerIconUrls.add(styleUrl);
        }
    }

    protected GroundOverlay attachGroundOverlay(GroundOverlayOptions groundOverlayOptions) {
        return this.mGroundOverlays.addGroundOverlay(groundOverlayOptions);
    }

    private void setMarkerInfoWindow(KmlStyle style2, Marker marker, KmlPlacemark placemark) {
        boolean hasName = placemark.hasProperty("name");
        boolean hasDescription = placemark.hasProperty("description");
        boolean hasBalloonOptions = style2.hasBalloonStyle();
        boolean hasBalloonText = style2.getBalloonOptions().containsKey("text");
        if (hasBalloonOptions && hasBalloonText) {
            marker.setTitle(KmlUtil.substituteProperties(style2.getBalloonOptions().get("text"), placemark));
            this.createInfoWindow();
        } else if (hasBalloonOptions && hasName) {
            marker.setTitle(placemark.getProperty("name"));
            this.createInfoWindow();
        } else if (hasName && hasDescription) {
            marker.setTitle(placemark.getProperty("name"));
            marker.setSnippet(placemark.getProperty("description"));
            this.createInfoWindow();
        } else if (hasDescription) {
            marker.setTitle(placemark.getProperty("description"));
            this.createInfoWindow();
        } else if (hasName) {
            marker.setTitle(placemark.getProperty("name"));
            this.createInfoWindow();
        }
    }

    private void createInfoWindow() {
        this.mMarkers.setInfoWindowAdapter(new GoogleMap.InfoWindowAdapter(){

            public View getInfoWindow(Marker arg0) {
                return null;
            }

            public View getInfoContents(Marker arg0) {
                View view = LayoutInflater.from((Context)Renderer.this.mContext).inflate(R.layout.amu_info_window, null);
                TextView infoWindowText = (TextView)view.findViewById(R.id.window);
                if (arg0.getSnippet() != null) {
                    infoWindowText.setText((CharSequence)Html.fromHtml((String)(arg0.getTitle() + "<br>" + arg0.getSnippet())));
                } else {
                    infoWindowText.setText((CharSequence)Html.fromHtml((String)arg0.getTitle()));
                }
                return view;
            }
        });
    }

    void setOnFeatureClickListener(final Layer.OnFeatureClickListener listener) {
        this.mPolygons.setOnPolygonClickListener(new GoogleMap.OnPolygonClickListener(){

            public void onPolygonClick(Polygon polygon) {
                if (Renderer.this.getFeature(polygon) != null) {
                    listener.onFeatureClick(Renderer.this.getFeature(polygon));
                } else if (Renderer.this.getContainerFeature(polygon) != null) {
                    listener.onFeatureClick(Renderer.this.getContainerFeature(polygon));
                } else {
                    listener.onFeatureClick(Renderer.this.getFeature(Renderer.this.multiObjectHandler(polygon)));
                }
            }
        });
        this.mMarkers.setOnMarkerClickListener(new GoogleMap.OnMarkerClickListener(){

            public boolean onMarkerClick(Marker marker) {
                if (Renderer.this.getFeature(marker) != null) {
                    listener.onFeatureClick(Renderer.this.getFeature(marker));
                } else if (Renderer.this.getContainerFeature(marker) != null) {
                    listener.onFeatureClick(Renderer.this.getContainerFeature(marker));
                } else {
                    listener.onFeatureClick(Renderer.this.getFeature(Renderer.this.multiObjectHandler(marker)));
                }
                return false;
            }
        });
        this.mPolylines.setOnPolylineClickListener(new GoogleMap.OnPolylineClickListener(){

            public void onPolylineClick(Polyline polyline) {
                if (Renderer.this.getFeature(polyline) != null) {
                    listener.onFeatureClick(Renderer.this.getFeature(polyline));
                } else if (Renderer.this.getContainerFeature(polyline) != null) {
                    listener.onFeatureClick(Renderer.this.getContainerFeature(polyline));
                } else {
                    listener.onFeatureClick(Renderer.this.getFeature(Renderer.this.multiObjectHandler(polyline)));
                }
            }
        });
    }

    private ArrayList<?> multiObjectHandler(Object mapObject) {
        for (Object value : this.getValues()) {
            ArrayList mapObjects;
            Class<?> c = value.getClass();
            if (!c.getSimpleName().equals("ArrayList") || !(mapObjects = (ArrayList)value).contains(mapObject)) continue;
            return mapObjects;
        }
        return null;
    }

    public static final class ImagesCache {
        final Map<String, Map<String, BitmapDescriptor>> markerImagesCache = new HashMap<String, Map<String, BitmapDescriptor>>();
        final Map<String, BitmapDescriptor> groundOverlayImagesCache = new HashMap<String, BitmapDescriptor>();
        final Map<String, Bitmap> bitmapCache = new HashMap<String, Bitmap>();
    }
}

