/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android;

class MathUtil {
    static final double EARTH_RADIUS = 6371009.0;

    MathUtil() {
    }

    static double clamp(double x, double low, double high) {
        return x < low ? low : (x > high ? high : x);
    }

    static double wrap(double n, double min, double max) {
        return n >= min && n < max ? n : MathUtil.mod(n - min, max - min) + min;
    }

    static double mod(double x, double m) {
        return (x % m + m) % m;
    }

    static double mercator(double lat) {
        return Math.log(Math.tan(lat * 0.5 + 0.7853981633974483));
    }

    static double inverseMercator(double y) {
        return 2.0 * Math.atan(Math.exp(y)) - 1.5707963267948966;
    }

    static double hav(double x) {
        double sinHalf = Math.sin(x * 0.5);
        return sinHalf * sinHalf;
    }

    static double arcHav(double x) {
        return 2.0 * Math.asin(Math.sqrt(x));
    }

    static double sinFromHav(double h) {
        return 2.0 * Math.sqrt(h * (1.0 - h));
    }

    static double havFromSin(double x) {
        double x2 = x * x;
        return x2 / (1.0 + Math.sqrt(1.0 - x2)) * 0.5;
    }

    static double sinSumFromHav(double x, double y) {
        double a = Math.sqrt(x * (1.0 - x));
        double b = Math.sqrt(y * (1.0 - y));
        return 2.0 * (a + b - 2.0 * (a * y + b * x));
    }

    static double havDistance(double lat1, double lat2, double dLng) {
        return MathUtil.hav(lat1 - lat2) + MathUtil.hav(dLng) * Math.cos(lat1) * Math.cos(lat2);
    }
}

