/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.rhino.jstype.EquivalenceMethod;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.ProxyObjectType;
import com.google.javascript.rhino.jstype.RelationshipVisitor;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplateTypeMapReplacer;
import com.google.javascript.rhino.jstype.Visitor;
import java.io.ObjectInputStream;
import java.util.LinkedHashSet;
import java.util.Objects;

public final class TemplatizedType
extends ProxyObjectType {
    private static final long serialVersionUID = 1L;
    private final ImmutableList<JSType> templateTypes;
    private final boolean isSpecializedOnlyWithUnknown;
    private transient TemplateTypeMapReplacer replacer;

    TemplatizedType(JSTypeRegistry registry, ObjectType objectType, ImmutableList<JSType> templateTypes) {
        super(registry, objectType, objectType.getTemplateTypeMap().addValues(templateTypes));
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean maybeIsSpecializedOnlyWithUnknown = true;
        for (TemplateType newlyFilledTemplateKey : objectType.getTemplateTypeMap().getUnfilledTemplateKeys()) {
            JSType resolvedType = this.getTemplateTypeMap().getResolvedTemplateType(newlyFilledTemplateKey);
            builder.add(resolvedType);
            maybeIsSpecializedOnlyWithUnknown = maybeIsSpecializedOnlyWithUnknown && resolvedType.isUnknownType();
        }
        this.templateTypes = builder.build();
        this.isSpecializedOnlyWithUnknown = maybeIsSpecializedOnlyWithUnknown;
        this.replacer = new TemplateTypeMapReplacer(registry, this.getTemplateTypeMap());
    }

    @Override
    public Iterable<ObjectType> getCtorImplementedInterfaces() {
        LinkedHashSet<ObjectType> resolvedImplementedInterfaces = new LinkedHashSet<ObjectType>();
        for (ObjectType obj : this.getReferencedObjTypeInternal().getCtorImplementedInterfaces()) {
            resolvedImplementedInterfaces.add(obj.visit(this.replacer).toObjectType());
        }
        return resolvedImplementedInterfaces;
    }

    @Override
    public Iterable<ObjectType> getCtorExtendedInterfaces() {
        LinkedHashSet<ObjectType> resolvedExtendedInterfaces = new LinkedHashSet<ObjectType>();
        for (ObjectType obj : this.getReferencedObjTypeInternal().getCtorExtendedInterfaces()) {
            resolvedExtendedInterfaces.add(obj.visit(this.replacer).toObjectType());
        }
        return resolvedExtendedInterfaces;
    }

    @Override
    StringBuilder appendTo(StringBuilder sb, boolean forAnnotations) {
        super.appendTo(sb, forAnnotations);
        if (!this.templateTypes.isEmpty()) {
            sb.append("<");
            int lastIndex = this.templateTypes.size() - 1;
            for (int i = 0; i < lastIndex; ++i) {
                ((JSType)this.templateTypes.get(i)).appendTo(sb, forAnnotations);
                sb.append(",");
            }
            ((JSType)this.templateTypes.get(lastIndex)).appendTo(sb, forAnnotations);
            sb.append(">");
        }
        return sb;
    }

    @Override
    int recursionUnsafeHashCode() {
        int baseHash = super.recursionUnsafeHashCode();
        if (this.isSpecializedOnlyWithUnknown) {
            return baseHash;
        }
        return Objects.hash(this.templateTypes, baseHash);
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseTemplatizedType(this);
    }

    @Override
    <T> T visit(RelationshipVisitor<T> visitor, JSType that) {
        return visitor.caseTemplatizedType(this, that);
    }

    @Override
    public TemplatizedType toMaybeTemplatizedType() {
        return this;
    }

    @Override
    public ImmutableList<JSType> getTemplateTypes() {
        return this.templateTypes;
    }

    @Override
    public JSType getPropertyType(String propertyName) {
        JSType result = super.getPropertyType(propertyName);
        return result == null ? null : result.visit(this.replacer);
    }

    @Override
    public boolean isSubtype(JSType that) {
        return this.isSubtype(that, JSType.ImplCache.create(), JSType.SubtypingMode.NORMAL);
    }

    @Override
    protected boolean isSubtype(JSType that, JSType.ImplCache implicitImplCache, JSType.SubtypingMode subtypingMode) {
        return TemplatizedType.isSubtypeHelper(this, that, implicitImplCache, subtypingMode);
    }

    boolean wrapsSameRawType(JSType that) {
        return that.isTemplatizedType() && this.getReferencedTypeInternal().isEquivalentTo(that.toMaybeTemplatizedType().getReferencedTypeInternal());
    }

    JSType getGreatestSubtypeHelper(JSType rawThat) {
        Preconditions.checkNotNull(rawThat);
        if (!this.wrapsSameRawType(rawThat)) {
            if (!rawThat.isTemplatizedType()) {
                if (this.isSubtype(rawThat)) {
                    return this;
                }
                if (rawThat.isSubtypeOf(this)) {
                    return TemplatizedType.filterNoResolvedType(rawThat);
                }
            }
            if (this.isObject() && rawThat.isObject()) {
                return this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
            }
            return this.getNativeType(JSTypeNative.NO_TYPE);
        }
        TemplatizedType that = rawThat.toMaybeTemplatizedType();
        Preconditions.checkNotNull(that);
        if (this.getTemplateTypeMap().checkEquivalenceHelper(that.getTemplateTypeMap(), EquivalenceMethod.INVARIANT, JSType.SubtypingMode.NORMAL)) {
            return this;
        }
        return this.getReferencedObjTypeInternal();
    }

    @Override
    public TemplateTypeMap getTemplateTypeMap() {
        return this.templateTypeMap;
    }

    @Override
    public boolean hasAnyTemplateTypesInternal() {
        return this.templateTypeMap.hasAnyTemplateTypesInternal();
    }

    public ObjectType getReferencedType() {
        return this.getReferencedObjTypeInternal();
    }

    @GwtIncompatible(value="ObjectInputStream")
    private void readObject(ObjectInputStream in) throws Exception {
        in.defaultReadObject();
        this.replacer = new TemplateTypeMapReplacer(this.registry, this.templateTypeMap);
    }
}

