/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ChangeVerifier;
import com.google.javascript.jscomp.CodeChangeHandler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.PerformanceTracker;
import com.google.javascript.jscomp.Tracer;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

class PhaseOptimizer
implements CompilerPass {
    private static final Logger logger = Logger.getLogger(PhaseOptimizer.class.getName());
    private final AbstractCompiler compiler;
    private final PerformanceTracker tracker;
    private final List<CompilerPass> passes;
    private boolean inLoop;
    private PassFactory validityCheck;
    private boolean printAstHashcodes = false;
    private double progress = 0.0;
    private double progressStep = 0.0;
    private ProgressRange progressRange;
    private NamedPass currentPass;
    private Map<NamedPass, Integer> lastRuns;
    private int lastChange;
    private static final int START_TIME = 0;
    private final Node jsRoot;
    private final boolean useSizeHeuristicToStopOptimizationLoop;
    private ChangeVerifier changeVerifier;
    @VisibleForTesting
    static final ImmutableList<String> OPTIMAL_ORDER = ImmutableList.of("inlineFunctions", "inlineVariables", "deadAssignmentsElimination", "collapseObjectLiterals", "removeUnusedCode", "removeUnusedPrototypeProperties", "removeUnusedClassProperties", "peepholeOptimizations", "removeUnreachableCode");
    static final ImmutableList<String> CODE_REMOVING_PASSES = ImmutableList.of("peepholeOptimizations", "removeUnreachableCode");
    static final int MAX_LOOPS = 100;
    static final String OPTIMIZE_LOOP_ERROR = "Fixed point loop exceeded the maximum number of iterations.";
    private final int optimizationLoopMaxIterations;

    PhaseOptimizer(AbstractCompiler comp, PerformanceTracker tracker) {
        this.compiler = comp;
        this.jsRoot = comp.getJsRoot();
        this.tracker = tracker;
        this.passes = new ArrayList<CompilerPass>();
        this.inLoop = false;
        this.lastChange = 0;
        this.useSizeHeuristicToStopOptimizationLoop = comp.getOptions().useSizeHeuristicToStopOptimizationLoop;
        int maxIterations = comp.getOptions().optimizationLoopMaxIterations;
        this.optimizationLoopMaxIterations = maxIterations > 0 && maxIterations <= 100 ? maxIterations : 100;
    }

    PhaseOptimizer withProgress(ProgressRange range) {
        this.progressRange = range;
        return this;
    }

    void consume(List<PassFactory> factories) {
        Loop currentLoop = new Loop();
        for (PassFactory factory : factories) {
            if (factory.isOneTimePass()) {
                if (currentLoop.isPopulated()) {
                    this.passes.add(currentLoop);
                    currentLoop = new Loop();
                }
                this.addOneTimePass(factory);
                continue;
            }
            currentLoop.addLoopedPass(factory);
        }
        if (currentLoop.isPopulated()) {
            this.passes.add(currentLoop);
        }
    }

    @VisibleForTesting
    void addOneTimePass(PassFactory factory) {
        this.passes.add(new NamedPass(factory));
    }

    Loop addFixedPointLoop() {
        Loop loop = new Loop();
        this.passes.add(loop);
        return loop;
    }

    void setValidityCheck(PassFactory validityCheck) {
        this.validityCheck = validityCheck;
        this.changeVerifier = new ChangeVerifier(this.compiler).snapshot(this.jsRoot);
    }

    void setPrintAstHashcodes(boolean printAstHashcodes) {
        this.printAstHashcodes = printAstHashcodes;
    }

    @Override
    public void process(Node externs, Node root) {
        this.progress = 0.0;
        this.progressStep = 0.0;
        if (this.progressRange != null) {
            this.progressStep = (this.progressRange.maxValue - this.progressRange.initialValue) / (double)this.passes.size();
            this.progress = this.progressRange.initialValue;
        }
        for (CompilerPass pass : this.passes) {
            if (Thread.interrupted()) {
                throw new RuntimeException(new InterruptedException());
            }
            pass.process(externs, root);
            if (!this.hasHaltingErrors()) continue;
            return;
        }
    }

    private void maybePrintAstHashcodes(String passName, Node root) {
        if (this.printAstHashcodes) {
            String hashCodeMsg = "AST hashCode after " + passName + ": " + this.compiler.toSource(root).hashCode();
            logger.info(hashCodeMsg);
        }
    }

    private void maybeRunValidityCheck(String passName, Node externs, Node root) {
        if (this.validityCheck == null) {
            return;
        }
        try {
            this.validityCheck.create(this.compiler).process(externs, root);
            this.changeVerifier.checkRecordedChanges(passName, this.jsRoot);
        }
        catch (Exception e) {
            throw new IllegalStateException("Validity checks failed for pass: " + passName, e);
        }
    }

    private boolean hasHaltingErrors() {
        return this.compiler.hasHaltingErrors();
    }

    boolean hasScopeChanged(Node n) {
        if (!this.inLoop) {
            return true;
        }
        int timeOfLastRun = this.lastRuns.get(this.currentPass);
        return timeOfLastRun == 0 || n.getChangeTime() > timeOfLastRun;
    }

    static class ProgressRange {
        public final double initialValue;
        public final double maxValue;

        public ProgressRange(double initialValue, double maxValue) {
            this.initialValue = initialValue;
            this.maxValue = maxValue;
        }
    }

    @VisibleForTesting
    class Loop
    implements CompilerPass {
        private final List<NamedPass> myPasses = new ArrayList<NamedPass>();
        private final Set<String> myNames = new HashSet<String>();
        private ScopedChangeHandler scopeHandler;
        private boolean isCodeRemovalLoop = false;
        private int howmanyIterationsUnderThreshold = 0;

        Loop() {
        }

        void addLoopedPass(PassFactory factory) {
            String name = factory.getName();
            Preconditions.checkArgument(!this.myNames.contains(name), "Already a pass with name '%s' in this loop", (Object)name);
            this.myNames.add(name);
            this.myPasses.add(new NamedPass(factory));
        }

        @Override
        public void process(Node externs, Node root) {
            int astSize;
            Preconditions.checkState(!PhaseOptimizer.this.inLoop, "Nested loops are forbidden");
            PhaseOptimizer.this.inLoop = true;
            this.optimizePasses();
            this.isCodeRemovalLoop = this.isCodeRemovalLoop();
            this.scopeHandler = new ScopedChangeHandler();
            PhaseOptimizer.this.compiler.addChangeHandler(this.scopeHandler);
            PhaseOptimizer.this.lastRuns = new HashMap();
            for (NamedPass pass : this.myPasses) {
                PhaseOptimizer.this.lastRuns.put(pass, 0);
            }
            HashSet<NamedPass> madeChanges = new HashSet<NamedPass>();
            HashSet<NamedPass> runInPrevIter = new HashSet<NamedPass>();
            State state = State.RUN_PASSES_NOT_RUN_IN_PREV_ITER;
            int count = 1;
            int previousAstSize = astSize = NodeUtil.countAstSize(root);
            try {
                while (true) {
                    if (count > PhaseOptimizer.this.optimizationLoopMaxIterations && this.isCodeRemovalLoop) {
                        return;
                    }
                    if (count > 100) {
                        PhaseOptimizer.this.compiler.throwInternalError(PhaseOptimizer.OPTIMIZE_LOOP_ERROR, null);
                    }
                    ++count;
                    boolean lastIterMadeChanges = false;
                    for (NamedPass pass : this.myPasses) {
                        if (state == State.RUN_PASSES_NOT_RUN_IN_PREV_ITER && !runInPrevIter.contains(pass) || state == State.RUN_PASSES_THAT_CHANGED_STH_IN_PREV_ITER && madeChanges.contains(pass)) {
                            PhaseOptimizer.this.compiler.incrementChangeStamp();
                            PhaseOptimizer.this.currentPass = pass;
                            pass.process(externs, root);
                            runInPrevIter.add(pass);
                            PhaseOptimizer.this.lastRuns.put(pass, PhaseOptimizer.this.compiler.getChangeStamp());
                            if (PhaseOptimizer.this.hasHaltingErrors()) {
                                return;
                            }
                            if (this.scopeHandler.hasCodeChangedSinceLastCall()) {
                                madeChanges.add(pass);
                                lastIterMadeChanges = true;
                                continue;
                            }
                            madeChanges.remove(pass);
                            continue;
                        }
                        runInPrevIter.remove(pass);
                    }
                    previousAstSize = astSize;
                    astSize = NodeUtil.countAstSize(root);
                    if (state == State.RUN_PASSES_NOT_RUN_IN_PREV_ITER) {
                        if (lastIterMadeChanges && this.isAstSufficientlyChanging(previousAstSize, astSize)) {
                            state = State.RUN_PASSES_THAT_CHANGED_STH_IN_PREV_ITER;
                            continue;
                        }
                        return;
                    }
                    Preconditions.checkState(state == State.RUN_PASSES_THAT_CHANGED_STH_IN_PREV_ITER);
                    if (lastIterMadeChanges && this.isAstSufficientlyChanging(previousAstSize, astSize)) continue;
                    state = State.RUN_PASSES_NOT_RUN_IN_PREV_ITER;
                }
            }
            finally {
                PhaseOptimizer.this.inLoop = false;
                PhaseOptimizer.this.compiler.removeChangeHandler(this.scopeHandler);
            }
        }

        private boolean isAstSufficientlyChanging(int oldAstSize, int newAstSize) {
            if (PhaseOptimizer.this.useSizeHeuristicToStopOptimizationLoop && this.isCodeRemovalLoop) {
                float percentChange = 100.0f * ((float)Math.abs(newAstSize - oldAstSize) / (float)oldAstSize);
                this.howmanyIterationsUnderThreshold = (double)percentChange < 0.05 ? ++this.howmanyIterationsUnderThreshold : 0;
                return this.howmanyIterationsUnderThreshold < 2;
            }
            return true;
        }

        private void optimizePasses() {
            ArrayList<NamedPass> optimalPasses = new ArrayList<NamedPass>();
            block0: for (String passInOptimalOrder : OPTIMAL_ORDER) {
                for (NamedPass loopablePass : this.myPasses) {
                    if (!loopablePass.name.equals(passInOptimalOrder)) continue;
                    optimalPasses.add(loopablePass);
                    continue block0;
                }
            }
            this.myPasses.removeAll(optimalPasses);
            this.myPasses.addAll(optimalPasses);
        }

        boolean isPopulated() {
            return !this.myPasses.isEmpty();
        }

        private boolean isCodeRemovalLoop() {
            for (NamedPass pass : this.myPasses) {
                if (!CODE_REMOVING_PASSES.contains(pass.name)) continue;
                return true;
            }
            return false;
        }
    }

    private class ScopedChangeHandler
    implements CodeChangeHandler {
        private int lastCodeChangeQuery;

        ScopedChangeHandler() {
            this.lastCodeChangeQuery = PhaseOptimizer.this.compiler.getChangeStamp();
        }

        @Override
        public void reportChange() {
            PhaseOptimizer.this.lastChange = PhaseOptimizer.this.compiler.getChangeStamp();
        }

        private boolean hasCodeChangedSinceLastCall() {
            boolean result = PhaseOptimizer.this.lastChange > this.lastCodeChangeQuery;
            this.lastCodeChangeQuery = PhaseOptimizer.this.compiler.getChangeStamp();
            PhaseOptimizer.this.compiler.incrementChangeStamp();
            return result;
        }
    }

    class NamedPass
    implements CompilerPass {
        final String name;
        private final PassFactory factory;
        private Tracer tracer;

        NamedPass(PassFactory factory) {
            this.name = factory.getName();
            this.factory = factory;
        }

        @Override
        public void process(Node externs, Node root) {
            if (!this.factory.featureSet().contains(PhaseOptimizer.this.compiler.getFeatureSet())) {
                logger.warning("Skipping pass " + this.name);
                logger.info("pass supports: " + this.factory.featureSet() + "\ncurrent AST contains: " + PhaseOptimizer.this.compiler.getFeatureSet());
                return;
            }
            logger.fine("Running pass " + this.name);
            if (PhaseOptimizer.this.validityCheck != null) {
                PhaseOptimizer.this.changeVerifier = new ChangeVerifier(PhaseOptimizer.this.compiler).snapshot(PhaseOptimizer.this.jsRoot);
            }
            if (PhaseOptimizer.this.tracker != null) {
                PhaseOptimizer.this.tracker.recordPassStart(this.name, this.factory.isOneTimePass());
            }
            this.tracer = new Tracer("Compiler", this.name);
            PhaseOptimizer.this.compiler.beforePass(this.name);
            this.factory.create(PhaseOptimizer.this.compiler).process(externs, root);
            PhaseOptimizer.this.compiler.afterPass(this.name);
            try {
                if (PhaseOptimizer.this.progressRange == null) {
                    PhaseOptimizer.this.compiler.setProgress(-1.0, this.name);
                } else {
                    PhaseOptimizer.this.progress = PhaseOptimizer.this.progress + PhaseOptimizer.this.progressStep;
                    PhaseOptimizer.this.compiler.setProgress(PhaseOptimizer.this.progress, this.name);
                }
                long traceRuntime = this.tracer.stop();
                if (PhaseOptimizer.this.tracker != null) {
                    PhaseOptimizer.this.tracker.recordPassStop(this.name, traceRuntime);
                }
                PhaseOptimizer.this.maybePrintAstHashcodes(this.name, root);
                PhaseOptimizer.this.maybeRunValidityCheck(this.name, externs, root);
            }
            catch (IllegalStateException e) {
                throw new RuntimeException("Validity check failed for " + this.name, e);
            }
        }

        public String toString() {
            return "pass: " + this.name;
        }
    }

    static enum State {
        RUN_PASSES_NOT_RUN_IN_PREV_ITER,
        RUN_PASSES_THAT_CHANGED_STH_IN_PREV_ITER;

    }
}

