/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Ascii;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Chars;
import com.google.javascript.jscomp.AnonymousFunctionNamingPolicy;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ComposeWarningsGuard;
import com.google.javascript.jscomp.ConformanceConfig;
import com.google.javascript.jscomp.CssRenamingMap;
import com.google.javascript.jscomp.CustomPassExecutionTime;
import com.google.javascript.jscomp.DefaultNameGenerator;
import com.google.javascript.jscomp.DependencyOptions;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticGroupWarningsGuard;
import com.google.javascript.jscomp.EmptyMessageBundle;
import com.google.javascript.jscomp.ErrorFormat;
import com.google.javascript.jscomp.ErrorHandler;
import com.google.javascript.jscomp.Instrumentation;
import com.google.javascript.jscomp.MessageBundle;
import com.google.javascript.jscomp.ModuleIdentifier;
import com.google.javascript.jscomp.NameGenerator;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PolymerExportPolicy;
import com.google.javascript.jscomp.PropertyRenamingPolicy;
import com.google.javascript.jscomp.RenamingMap;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.SourceMapInput;
import com.google.javascript.jscomp.UniqueRenamingToken;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.jscomp.VariableRenamingPolicy;
import com.google.javascript.jscomp.WarningsGuard;
import com.google.javascript.jscomp.Xid;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.jscomp.resources.ResourceLoader;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.SourcePosition;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class CompilerOptions
implements Serializable {
    static final int DEFAULT_LINE_LENGTH_THRESHOLD = 500;
    static final char[] POLYMER_PROPERTY_RESERVED_FIRST_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ$".toCharArray();
    static final char[] POLYMER_PROPERTY_RESERVED_NON_FIRST_CHARS = "_$".toCharArray();
    static final char[] ANGULAR_PROPERTY_RESERVED_FIRST_CHARS = new char[]{'$'};
    private Optional<Boolean> emitUseStrict = Optional.absent();
    private LanguageMode languageIn;
    private Optional<FeatureSet> outputFeatureSet = Optional.absent();
    private Optional<Boolean> languageOutIsDefaultStrict = Optional.absent();
    private Environment environment;
    private boolean instrumentForCoverageOnly = false;
    boolean inferConsts = true;
    private boolean assumeStrictThis = false;
    private boolean allowHotswapReplaceScript = false;
    private boolean preserveDetailedSourceInfo = false;
    private boolean continueAfterErrors = false;
    private IncrementalCheckMode incrementalCheckMode = IncrementalCheckMode.OFF;
    private Config.JsDocParsing parseJsDocDocumentation = Config.JsDocParsing.TYPES_ONLY;
    private boolean printExterns;
    boolean inferTypes;
    boolean skipNonTranspilationPasses = false;
    DevMode devMode;
    private boolean checkDeterminism = false;
    DependencyOptions dependencyOptions = new DependencyOptions();
    public MessageBundle messageBundle = null;
    public boolean checkSymbols = false;
    public boolean checkSuspiciousCode = false;
    public boolean checkTypes = false;
    public CheckLevel checkGlobalNamesLevel;
    @Deprecated
    public CheckLevel brokenClosureRequiresLevel;
    public CheckLevel checkGlobalThisLevel;
    public CheckLevel checkMissingGetCssNameLevel;
    public String checkMissingGetCssNameBlacklist = null;
    Set<String> extraAnnotationNames = null;
    boolean legacyCodeCompile = false;
    int numParallelThreads = 1;
    boolean aggressiveFusion;
    public boolean foldConstants = false;
    public boolean deadAssignmentElimination = false;
    public boolean inlineConstantVars = false;
    int maxFunctionSizeAfterInlining = -1;
    static final int UNLIMITED_FUN_SIZE_AFTER_INLINING = -1;
    boolean assumeClosuresOnlyCaptureReferences = false;
    private boolean inlineProperties = false;
    private boolean crossChunkCodeMotion = false;
    boolean crossChunkCodeMotionNoStubMethods;
    boolean parentChunkCanSeeSymbolsDeclaredInChildren = false;
    public boolean coalesceVariableNames = false;
    private boolean crossChunkMethodMotion = false;
    boolean inlineGetters = false;
    public boolean inlineVariables = false;
    boolean inlineLocalVariables = false;
    public boolean flowSensitiveInlineVariables;
    public boolean smartNameRemoval = false;
    boolean extraSmartNameRemoval = false;
    public boolean removeDeadCode = false;
    ExtractPrototypeMemberDeclarationsMode extractPrototypeMemberDeclarations;
    public boolean removeUnusedPrototypeProperties = false;
    public boolean removeUnusedPrototypePropertiesInExterns = false;
    public boolean removeUnusedClassProperties = false;
    boolean removeUnusedConstructorProperties = false;
    public boolean removeUnusedVars = false;
    public boolean removeUnusedLocalVars = false;
    public boolean collapseVariableDeclarations = false;
    public boolean collapseAnonymousFunctions = false;
    public Set<String> aliasableStrings;
    public String aliasStringsBlacklist = "";
    public boolean aliasAllStrings = false;
    boolean outputJsStringUsage = false;
    public boolean convertToDottedProperties = false;
    public boolean rewriteFunctionExpressions = false;
    public boolean optimizeCalls;
    public boolean optimizeArgumentsArray;
    boolean useTypesForLocalOptimization;
    boolean useSizeHeuristicToStopOptimizationLoop = true;
    int optimizationLoopMaxIterations;
    public VariableRenamingPolicy variableRenaming;
    PropertyRenamingPolicy propertyRenaming;
    public boolean labelRenaming = false;
    public boolean reserveRawExports;
    boolean shadowVariables = false;
    boolean preferStableNames = false;
    public boolean generatePseudoNames = false;
    public String renamePrefix = null;
    public String renamePrefixNamespace;
    boolean renamePrefixNamespaceAssumeCrossChunkNames = false;
    private PropertyCollapseLevel collapsePropertiesLevel;
    boolean collapseObjectLiterals = false;
    public boolean devirtualizePrototypeMethods = false;
    public boolean computeFunctionSideEffects = false;
    String debugFunctionSideEffectsPath = null;
    boolean disambiguatePrivateProperties;
    private boolean disambiguateProperties = false;
    private boolean ambiguateProperties = false;
    ImmutableMap<String, SourceMapInput> inputSourceMaps;
    public AnonymousFunctionNamingPolicy anonymousFunctionNaming;
    VariableMap inputAnonymousFunctionNamingMap;
    VariableMap inputVariableMap;
    VariableMap inputPropertyMap;
    public boolean exportTestFunctions = false;
    boolean declaredGlobalExternsOnWindow = true;
    NameGenerator nameGenerator;
    boolean replaceMessagesWithChromeI18n;
    String tcProjectId;
    boolean runtimeTypeCheck = false;
    String runtimeTypeCheckLogFunction = null;
    private CodingConvention codingConvention;
    @Nullable
    public String syntheticBlockStartMarker = null;
    @Nullable
    public String syntheticBlockEndMarker = null;
    public String locale = null;
    public boolean markAsCompiled = false;
    public boolean closurePass = false;
    private boolean preserveClosurePrimitives = false;
    boolean angularPass = false;
    @Nullable
    Integer polymerVersion = null;
    PolymerExportPolicy polymerExportPolicy;
    private boolean chromePass;
    boolean dartPass = false;
    J2clPassMode j2clPassMode;
    boolean removeAbstractMethods = false;
    boolean removeSuperMethods = false;
    boolean removeClosureAsserts = false;
    boolean removeJ2clAsserts = true;
    public boolean gatherCssNames;
    public Set<String> stripTypes;
    public Set<String> stripNameSuffixes;
    public Set<String> stripNamePrefixes;
    public Set<String> stripTypePrefixes;
    protected transient Multimap<CustomPassExecutionTime, CompilerPass> customPasses = null;
    public boolean markNoSideEffectCalls = false;
    private Map<String, Object> defineReplacements;
    private TweakProcessing tweakProcessing;
    private Map<String, Object> tweakReplacements;
    public boolean moveFunctionDeclarations = false;
    public Instrumentation instrumentationTemplate = null;
    String appNameStr = "";
    public boolean recordFunctionInformation = false;
    boolean checksOnly = false;
    OutputJs outputJs;
    public boolean generateExports = false;
    boolean generateExportsAfterTypeChecking = true;
    boolean exportLocalPropertyDefinitions = false;
    public CssRenamingMap cssRenamingMap = null;
    Set<String> cssRenamingWhitelist = null;
    boolean processObjectPropertyString = false;
    boolean replaceIdGenerators = true;
    ImmutableMap<String, RenamingMap> idGenerators;
    Xid.HashFunction xidHashFunction;
    String idGeneratorsMapSerialized;
    List<String> replaceStringsFunctionDescriptions;
    String replaceStringsPlaceholderToken = "";
    Set<String> replaceStringsReservedStrings;
    VariableMap replaceStringsInputMap;
    Map<String, CheckLevel> propertyInvalidationErrors;
    boolean transformAMDToCJSModules = false;
    boolean processCommonJSModules = false;
    List<String> moduleRoots = ImmutableList.of("./");
    boolean rewritePolyfills = false;
    List<String> forceLibraryInjection = ImmutableList.of();
    boolean preventLibraryInjection = false;
    boolean assumeForwardDeclaredForMissingTypes = false;
    public boolean preserveTypeAnnotations = false;
    private boolean prettyPrint = false;
    public boolean lineBreak = false;
    public boolean preferLineBreakAtEndOfFile = false;
    public boolean printInputDelimiter = false;
    public String inputDelimiter = "// Input %num%";
    private boolean quoteKeywordProperties;
    boolean preferSingleQuotes;
    boolean trustedStrings;
    private boolean allowMethodCallDecomposing;
    boolean printSourceAfterEachPass = false;
    List<String> filesToPrintAfterEachPassRegexList = ImmutableList.of();
    List<String> chunksToPrintAfterEachPassRegexList = ImmutableList.of();
    private TracerMode tracer;
    private PrintStream tracerOutput;
    private boolean colorizeErrorOutput = false;
    public ErrorFormat errorFormat;
    private ComposeWarningsGuard warningsGuard = new ComposeWarningsGuard(new WarningsGuard[0]);
    int summaryDetailLevel = 1;
    int lineLengthThreshold = 500;
    boolean useOriginalNamesInOutput = false;
    private boolean externExports = false;
    String externExportsPath;
    public String sourceMapOutputPath;
    public SourceMap.DetailLevel sourceMapDetailLevel = SourceMap.DetailLevel.ALL;
    public SourceMap.Format sourceMapFormat = SourceMap.Format.DEFAULT;
    boolean parseInlineSourceMaps = true;
    boolean applyInputSourceMaps = false;
    boolean resolveSourceMapAnnotations = true;
    public List<? extends SourceMap.LocationMapping> sourceMapLocationMappings = Collections.emptyList();
    boolean sourceMapIncludeSourcesContent = false;
    transient Charset outputCharset;
    boolean enforceAccessControlCodingConventions;
    private boolean protectHiddenSideEffects;
    private transient AliasTransformationHandler aliasHandler;
    transient ErrorHandler errorHandler = null;
    public boolean instrumentForCoverage = false;
    public boolean instrumentBranchCoverage = false;
    String instrumentationTemplateFile = "";
    private static final ImmutableList<ConformanceConfig> GLOBAL_CONFORMANCE_CONFIGS = ImmutableList.of(ResourceLoader.loadGlobalConformance(CompilerOptions.class));
    private ImmutableList<ConformanceConfig> conformanceConfigs = GLOBAL_CONFORMANCE_CONFIGS;
    boolean wrapGoogModulesForWhitespaceOnly = true;
    boolean printConfig = false;
    private Optional<Boolean> isStrictModeInput = Optional.absent();
    ModuleLoader.ResolutionMode moduleResolutionMode;
    private ImmutableMap<String, String> browserResolverPrefixReplacements;
    private ModuleLoader.PathEscaper pathEscaper;
    List<String> packageJsonEntryNames;
    private Reach inlineFunctionsLevel;
    private Es6ModuleTranspilation es6ModuleTranspilation = Es6ModuleTranspilation.COMPILE;
    static final AliasTransformationHandler NULL_ALIAS_TRANSFORMATION_HANDLER = new NullAliasTransformationHandler();

    public boolean shouldRunCrossChunkCodeMotion() {
        return this.crossChunkCodeMotion;
    }

    public boolean shouldRunCrossChunkMethodMotion() {
        return this.crossChunkMethodMotion;
    }

    public void setInstrumentForCoverageOnly(boolean instrumentForCoverageOnly) {
        this.instrumentForCoverageOnly = instrumentForCoverageOnly;
    }

    public boolean getInstrumentForCoverageOnly() {
        return this.instrumentForCoverageOnly;
    }

    @Deprecated
    public void setSkipTranspilationAndCrash(boolean value) {
    }

    public void setInputSourceMaps(ImmutableMap<String, SourceMapInput> inputSourceMaps) {
        this.inputSourceMaps = inputSourceMaps;
    }

    public void setInferConst(boolean value) {
        this.inferConsts = value;
    }

    public void setIncrementalChecks(IncrementalCheckMode value) {
        this.incrementalCheckMode = value;
        switch (value) {
            case OFF: 
            case RUN_IJS_CHECKS_LATE: {
                break;
            }
            case GENERATE_IJS: {
                this.setPreserveTypeAnnotations(true);
                this.setOutputJs(OutputJs.NORMAL);
            }
        }
    }

    public boolean shouldGenerateTypedExterns() {
        return this.incrementalCheckMode == IncrementalCheckMode.GENERATE_IJS;
    }

    public boolean shouldRunTypeSummaryChecksLate() {
        return this.incrementalCheckMode == IncrementalCheckMode.RUN_IJS_CHECKS_LATE;
    }

    void setPrintExterns(boolean printExterns) {
        this.printExterns = printExterns;
    }

    boolean shouldPrintExterns() {
        return this.printExterns || this.incrementalCheckMode == IncrementalCheckMode.GENERATE_IJS;
    }

    public void setCheckGlobalNamesLevel(CheckLevel level) {
        this.checkGlobalNamesLevel = level;
    }

    @Deprecated
    public void setBrokenClosureRequiresLevel(CheckLevel level) {
        this.brokenClosureRequiresLevel = level;
    }

    public void setCheckGlobalThisLevel(CheckLevel level) {
        this.checkGlobalThisLevel = level;
    }

    public void setCheckMissingGetCssNameLevel(CheckLevel level) {
        this.checkMissingGetCssNameLevel = level;
    }

    @Deprecated
    public void setCheckEventfulObjectDisposalPolicy(DisposalCheckingPolicy policy) {
    }

    @Deprecated
    public DisposalCheckingPolicy getCheckEventfulObjectDisposalPolicy() {
        return DisposalCheckingPolicy.OFF;
    }

    public boolean getLegacyCodeCompile() {
        return this.legacyCodeCompile;
    }

    public void setLegacyCodeCompile(boolean legacy) {
        this.legacyCodeCompile = legacy;
    }

    public void setNumParallelThreads(int parallelism) {
        this.numParallelThreads = parallelism;
    }

    void setRenamePrefixNamespaceAssumeCrossChunkNames(boolean assume) {
        this.renamePrefixNamespaceAssumeCrossChunkNames = assume;
    }

    @Deprecated
    void setRenamePrefixNamespaceAssumeCrossModuleNames(boolean assume) {
        this.setRenamePrefixNamespaceAssumeCrossChunkNames(assume);
    }

    public boolean shouldCollapseProperties() {
        return this.collapsePropertiesLevel != PropertyCollapseLevel.NONE;
    }

    public PropertyCollapseLevel getPropertyCollapseLevel() {
        return this.collapsePropertiesLevel;
    }

    public void setCollapseObjectLiterals(boolean enabled) {
        this.collapseObjectLiterals = enabled;
    }

    public boolean getCollapseObjectLiterals() {
        return this.collapseObjectLiterals;
    }

    public void setNameGenerator(NameGenerator nameGenerator) {
        this.nameGenerator = nameGenerator;
    }

    public void setReplaceMessagesWithChromeI18n(boolean replaceMessagesWithChromeI18n, String tcProjectId) {
        if (replaceMessagesWithChromeI18n && this.messageBundle != null && !(this.messageBundle instanceof EmptyMessageBundle)) {
            throw new RuntimeException("When replacing messages with chrome.i18n.getMessage, a message bundle should not be specified.");
        }
        this.replaceMessagesWithChromeI18n = replaceMessagesWithChromeI18n;
        this.tcProjectId = tcProjectId;
    }

    public void setAppNameStr(String appNameStr) {
        this.appNameStr = appNameStr;
    }

    public void setAssumeForwardDeclaredForMissingTypes(boolean assumeForwardDeclaredForMissingTypes) {
        this.assumeForwardDeclaredForMissingTypes = assumeForwardDeclaredForMissingTypes;
    }

    public void setPreferSingleQuotes(boolean enabled) {
        this.preferSingleQuotes = enabled;
    }

    public void setTrustedStrings(boolean yes) {
        this.trustedStrings = yes;
    }

    boolean allowMethodCallDecomposing() {
        return this.allowMethodCallDecomposing;
    }

    public void setAllowMethodCallDecomposing(boolean value) {
        this.allowMethodCallDecomposing = value;
    }

    public void setPrintSourceAfterEachPass(boolean printSource) {
        this.printSourceAfterEachPass = printSource;
    }

    public void setFilesToPrintAfterEachPassRegexList(List<String> filePathRegexList) {
        this.filesToPrintAfterEachPassRegexList = filePathRegexList;
    }

    public void setChunksToPrintAfterEachPassRegexList(List<String> chunkPathRegexList) {
        this.chunksToPrintAfterEachPassRegexList = chunkPathRegexList;
    }

    @Deprecated
    public void setModulesToPrintAfterEachPassRegexList(List<String> chunkPathRegexList) {
        this.chunksToPrintAfterEachPassRegexList = chunkPathRegexList;
    }

    public TracerMode getTracerMode() {
        return this.tracer;
    }

    public void setTracerMode(TracerMode mode) {
        this.tracer = mode;
    }

    PrintStream getTracerOutput() {
        return this.tracerOutput;
    }

    public void setTracerOutput(PrintStream out) {
        this.tracerOutput = out;
    }

    public void setProtectHiddenSideEffects(boolean enable) {
        this.protectHiddenSideEffects = enable;
    }

    public boolean shouldProtectHiddenSideEffects() {
        return this.protectHiddenSideEffects && !this.checksOnly && !this.allowHotswapReplaceScript;
    }

    public void setWrapGoogModulesForWhitespaceOnly(boolean enable) {
        this.wrapGoogModulesForWhitespaceOnly = enable;
    }

    public void setPrintConfig(boolean printConfig) {
        this.printConfig = printConfig;
    }

    public CompilerOptions() {
        this.languageIn = LanguageMode.ECMASCRIPT_2017;
        this.environment = Environment.BROWSER;
        this.browserResolverPrefixReplacements = ImmutableMap.of();
        this.moduleResolutionMode = ModuleLoader.ResolutionMode.BROWSER;
        this.packageJsonEntryNames = ImmutableList.of("browser", "module", "main");
        this.pathEscaper = ModuleLoader.PathEscaper.ESCAPE;
        this.devMode = DevMode.OFF;
        this.checkGlobalNamesLevel = CheckLevel.OFF;
        this.brokenClosureRequiresLevel = CheckLevel.ERROR;
        this.checkGlobalThisLevel = CheckLevel.OFF;
        this.checkMissingGetCssNameLevel = CheckLevel.OFF;
        this.inlineFunctionsLevel = Reach.NONE;
        this.extractPrototypeMemberDeclarations = ExtractPrototypeMemberDeclarationsMode.OFF;
        this.aliasableStrings = Collections.emptySet();
        this.variableRenaming = VariableRenamingPolicy.OFF;
        this.propertyRenaming = PropertyRenamingPolicy.OFF;
        this.collapsePropertiesLevel = PropertyCollapseLevel.NONE;
        this.anonymousFunctionNaming = AnonymousFunctionNamingPolicy.OFF;
        this.nameGenerator = new DefaultNameGenerator();
        this.polymerExportPolicy = PolymerExportPolicy.LEGACY;
        this.j2clPassMode = J2clPassMode.AUTO;
        this.stripTypes = Collections.emptySet();
        this.stripNameSuffixes = Collections.emptySet();
        this.stripNamePrefixes = Collections.emptySet();
        this.stripTypePrefixes = Collections.emptySet();
        this.defineReplacements = new HashMap<String, Object>();
        this.tweakProcessing = TweakProcessing.OFF;
        this.tweakReplacements = new HashMap<String, Object>();
        this.outputJs = OutputJs.NORMAL;
        this.idGenerators = ImmutableMap.of();
        this.replaceStringsFunctionDescriptions = Collections.emptyList();
        this.replaceStringsReservedStrings = Collections.emptySet();
        this.propertyInvalidationErrors = new HashMap<String, CheckLevel>();
        this.inputSourceMaps = ImmutableMap.of();
        this.tracer = TracerMode.OFF;
        this.errorFormat = ErrorFormat.SINGLELINE;
        this.aliasHandler = NULL_ALIAS_TRANSFORMATION_HANDLER;
    }

    public boolean isRemoveUnusedClassProperties() {
        return this.removeUnusedClassProperties;
    }

    public void setRemoveUnusedClassProperties(boolean removeUnusedClassProperties) {
        this.removeUnusedClassProperties = removeUnusedClassProperties;
    }

    public boolean isRemoveUnusedConstructorProperties() {
        return this.removeUnusedConstructorProperties;
    }

    public void setRemoveUnusedConstructorProperties(boolean removeUnused) {
        this.removeUnusedConstructorProperties = removeUnused;
    }

    public Map<String, Node> getDefineReplacements() {
        return CompilerOptions.getReplacementsHelper(this.defineReplacements);
    }

    public Map<String, Node> getTweakReplacements() {
        return CompilerOptions.getReplacementsHelper(this.tweakReplacements);
    }

    private static ImmutableMap<String, Node> getReplacementsHelper(Map<String, Object> source) {
        ImmutableMap.Builder<String, Node> map = ImmutableMap.builder();
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Boolean) {
                map.put(name, NodeUtil.booleanNode((Boolean)value));
                continue;
            }
            if (value instanceof Integer) {
                map.put(name, IR.number(((Integer)value).intValue()));
                continue;
            }
            if (value instanceof Double) {
                map.put(name, IR.number((Double)value));
                continue;
            }
            Preconditions.checkState(value instanceof String);
            map.put(name, IR.string((String)value));
        }
        return map.build();
    }

    public void setDefineToBooleanLiteral(String defineName, boolean value) {
        this.defineReplacements.put(defineName, value);
    }

    public void setDefineToStringLiteral(String defineName, String value) {
        this.defineReplacements.put(defineName, value);
    }

    public void setDefineToNumberLiteral(String defineName, int value) {
        this.defineReplacements.put(defineName, value);
    }

    public void setDefineToDoubleLiteral(String defineName, double value) {
        this.defineReplacements.put(defineName, value);
    }

    public void setTweakToBooleanLiteral(String tweakId, boolean value) {
        this.tweakReplacements.put(tweakId, value);
    }

    public void setTweakToStringLiteral(String tweakId, String value) {
        this.tweakReplacements.put(tweakId, value);
    }

    public void setTweakToNumberLiteral(String tweakId, int value) {
        this.tweakReplacements.put(tweakId, value);
    }

    public void setTweakToDoubleLiteral(String tweakId, double value) {
        this.tweakReplacements.put(tweakId, value);
    }

    public void skipAllCompilerPasses() {
        this.skipNonTranspilationPasses = true;
    }

    boolean enables(DiagnosticGroup type) {
        return this.warningsGuard.enables(type);
    }

    boolean disables(DiagnosticGroup type) {
        return this.warningsGuard.disables(type);
    }

    public void setWarningLevel(DiagnosticGroup type, CheckLevel level) {
        this.addWarningsGuard(new DiagnosticGroupWarningsGuard(type, level));
    }

    WarningsGuard getWarningsGuard() {
        return this.warningsGuard;
    }

    public void resetWarningsGuard() {
        this.warningsGuard = new ComposeWarningsGuard(new WarningsGuard[0]);
    }

    void useEmergencyFailSafe() {
        this.warningsGuard = this.warningsGuard.makeEmergencyFailSafeGuard();
    }

    void useNonStrictWarningsGuard() {
        this.warningsGuard = this.warningsGuard.makeNonStrict();
    }

    public void addWarningsGuard(WarningsGuard guard) {
        this.warningsGuard.addGuard(guard);
    }

    public void setRenamingPolicy(VariableRenamingPolicy newVariablePolicy, PropertyRenamingPolicy newPropertyPolicy) {
        this.variableRenaming = newVariablePolicy;
        this.propertyRenaming = newPropertyPolicy;
    }

    public void setShadowVariables(boolean shadow) {
        this.shadowVariables = shadow;
    }

    public void setProcessObjectPropertyString(boolean process) {
        this.processObjectPropertyString = process;
    }

    public void setReplaceIdGenerators(boolean replaceIdGenerators) {
        this.replaceIdGenerators = replaceIdGenerators;
    }

    public void setIdGenerators(Set<String> idGenerators) {
        UniqueRenamingToken gen = new UniqueRenamingToken();
        ImmutableMap.Builder<String, UniqueRenamingToken> builder = ImmutableMap.builder();
        for (String name : idGenerators) {
            builder.put(name, gen);
        }
        this.idGenerators = builder.build();
    }

    public void setIdGenerators(Map<String, RenamingMap> idGenerators) {
        this.idGenerators = ImmutableMap.copyOf(idGenerators);
    }

    public void setIdGeneratorsMap(String previousMappings) {
        this.idGeneratorsMapSerialized = previousMappings;
    }

    public void setXidHashFunction(Xid.HashFunction xidHashFunction) {
        this.xidHashFunction = xidHashFunction;
    }

    @Deprecated
    public void setInlineFunctions(boolean inlineFunctions) {
        this.setInlineFunctions(inlineFunctions ? Reach.ALL : Reach.NONE);
    }

    public void setInlineFunctions(Reach reach) {
        this.inlineFunctionsLevel = reach;
    }

    public Reach getInlineFunctionsLevel() {
        return this.inlineFunctionsLevel;
    }

    public void setMaxFunctionSizeAfterInlining(int funAstSize) {
        Preconditions.checkArgument(funAstSize > 0);
        this.maxFunctionSizeAfterInlining = funAstSize;
    }

    public void setInlineVariables(boolean inlineVariables) {
        this.inlineVariables = inlineVariables;
    }

    public void setInlineVariables(Reach reach) {
        switch (reach) {
            case ALL: {
                this.inlineVariables = true;
                this.inlineLocalVariables = true;
                break;
            }
            case LOCAL_ONLY: {
                this.inlineVariables = false;
                this.inlineLocalVariables = true;
                break;
            }
            case NONE: {
                this.inlineVariables = false;
                this.inlineLocalVariables = false;
                break;
            }
            default: {
                throw new IllegalStateException("unexpected");
            }
        }
    }

    public void setInlineProperties(boolean enable) {
        this.inlineProperties = enable;
    }

    public boolean shouldInlineProperties() {
        return this.inlineProperties;
    }

    public void setRemoveUnusedVariables(Reach reach) {
        switch (reach) {
            case ALL: {
                this.removeUnusedVars = true;
                this.removeUnusedLocalVars = true;
                break;
            }
            case LOCAL_ONLY: {
                this.removeUnusedVars = false;
                this.removeUnusedLocalVars = true;
                break;
            }
            case NONE: {
                this.removeUnusedVars = false;
                this.removeUnusedLocalVars = false;
                break;
            }
            default: {
                throw new IllegalStateException("unexpected");
            }
        }
    }

    public void setReplaceStringsConfiguration(String placeholderToken, List<String> functionDescriptors) {
        this.replaceStringsPlaceholderToken = placeholderToken;
        this.replaceStringsFunctionDescriptions = new ArrayList<String>(functionDescriptors);
    }

    public void setRemoveAbstractMethods(boolean remove) {
        this.removeAbstractMethods = remove;
    }

    public void setRemoveSuperMethods(boolean remove) {
        this.removeSuperMethods = remove;
    }

    public boolean getRemoveSuperMethods() {
        return this.removeSuperMethods;
    }

    public void setRemoveClosureAsserts(boolean remove) {
        this.removeClosureAsserts = remove;
    }

    public void setRemoveJ2clAsserts(boolean remove) {
        this.removeJ2clAsserts = remove;
    }

    public void setColorizeErrorOutput(boolean colorizeErrorOutput) {
        this.colorizeErrorOutput = colorizeErrorOutput;
    }

    public boolean shouldColorizeErrorOutput() {
        return this.colorizeErrorOutput;
    }

    public void enableRuntimeTypeCheck(String logFunction) {
        this.runtimeTypeCheck = true;
        this.runtimeTypeCheckLogFunction = logFunction;
    }

    public void disableRuntimeTypeCheck() {
        this.runtimeTypeCheck = false;
    }

    public void setChecksOnly(boolean checksOnly) {
        this.checksOnly = checksOnly;
    }

    public void setOutputJs(OutputJs outputJs) {
        this.outputJs = outputJs;
    }

    public void setGenerateExports(boolean generateExports) {
        this.generateExports = generateExports;
    }

    public void setExportLocalPropertyDefinitions(boolean export) {
        this.exportLocalPropertyDefinitions = export;
    }

    public boolean shouldExportLocalPropertyDefinitions() {
        return this.exportLocalPropertyDefinitions;
    }

    public void setAngularPass(boolean angularPass) {
        this.angularPass = angularPass;
    }

    public void setPolymerVersion(Integer polymerVersion) {
        Preconditions.checkArgument(polymerVersion == null || polymerVersion == 1 || polymerVersion == 2, "Invalid Polymer version:", (Object)polymerVersion);
        this.polymerVersion = polymerVersion;
    }

    public void setChromePass(boolean chromePass) {
        this.chromePass = chromePass;
    }

    public boolean isChromePassEnabled() {
        return this.chromePass;
    }

    public void setDartPass(boolean dartPass) {
        this.dartPass = dartPass;
    }

    public void setJ2clPass(J2clPassMode j2clPassMode) {
        this.j2clPassMode = j2clPassMode;
    }

    public void setCodingConvention(CodingConvention codingConvention) {
        this.codingConvention = codingConvention;
    }

    public CodingConvention getCodingConvention() {
        return this.codingConvention;
    }

    public void setDependencyOptions(DependencyOptions options) {
        this.dependencyOptions = options;
    }

    public DependencyOptions getDependencyOptions() {
        return this.dependencyOptions;
    }

    public void setManageClosureDependencies(boolean newVal) {
        this.dependencyOptions.setDependencySorting(newVal || this.dependencyOptions.shouldSortDependencies());
        this.dependencyOptions.setDependencyPruning(newVal || this.dependencyOptions.shouldPruneDependencies());
        this.dependencyOptions.setMoocherDropping(false);
    }

    public void setManageClosureDependencies(List<String> entryPoints) {
        Preconditions.checkNotNull(entryPoints);
        this.setManageClosureDependencies(true);
        ArrayList<ModuleIdentifier> normalizedEntryPoints = new ArrayList<ModuleIdentifier>();
        for (String entryPoint : entryPoints) {
            normalizedEntryPoints.add(ModuleIdentifier.forClosure(entryPoint));
        }
        this.dependencyOptions.setEntryPoints(normalizedEntryPoints);
    }

    public void setSummaryDetailLevel(int summaryDetailLevel) {
        this.summaryDetailLevel = summaryDetailLevel;
    }

    @Deprecated
    public void enableExternExports(boolean enabled) {
        this.externExports = enabled;
    }

    public void setExtraAnnotationNames(Iterable<String> extraAnnotationNames) {
        this.extraAnnotationNames = ImmutableSet.copyOf(extraAnnotationNames);
    }

    public boolean isExternExportsEnabled() {
        return this.externExports;
    }

    public void setOutputCharset(Charset charset) {
        this.outputCharset = charset;
    }

    Charset getOutputCharset() {
        return this.outputCharset;
    }

    public void setTweakProcessing(TweakProcessing tweakProcessing) {
        this.tweakProcessing = tweakProcessing;
    }

    public TweakProcessing getTweakProcessing() {
        return this.tweakProcessing;
    }

    public void setLanguage(LanguageMode language) {
        Preconditions.checkState(language != LanguageMode.NO_TRANSPILE);
        this.setLanguageIn(language);
        this.setLanguageOut(language);
    }

    public void setLanguageIn(LanguageMode languageIn) {
        Preconditions.checkState(languageIn != LanguageMode.NO_TRANSPILE);
        this.languageIn = languageIn == LanguageMode.STABLE ? LanguageMode.STABLE_IN : languageIn;
    }

    public LanguageMode getLanguageIn() {
        return this.languageIn;
    }

    public void setLanguageOut(LanguageMode languageOut) {
        if (languageOut == LanguageMode.NO_TRANSPILE) {
            this.languageOutIsDefaultStrict = Optional.absent();
            this.outputFeatureSet = Optional.absent();
        } else {
            languageOut = languageOut == LanguageMode.STABLE ? LanguageMode.STABLE_OUT : languageOut;
            this.languageOutIsDefaultStrict = Optional.of(languageOut.isDefaultStrict());
            this.setOutputFeatureSet(languageOut.toFeatureSet());
        }
    }

    public void setOutputFeatureSet(FeatureSet featureSet) {
        this.outputFeatureSet = Optional.of(featureSet);
    }

    public FeatureSet getOutputFeatureSet() {
        if (this.outputFeatureSet.isPresent()) {
            return this.outputFeatureSet.get();
        }
        return this.languageIn.toFeatureSet();
    }

    public boolean needsTranspilationFrom(FeatureSet languageLevel) {
        return this.getLanguageIn().toFeatureSet().contains(languageLevel) && !this.getOutputFeatureSet().contains(languageLevel);
    }

    public boolean needsTranspilationOf(FeatureSet.Feature feature) {
        return this.getLanguageIn().toFeatureSet().has(feature) && !this.getOutputFeatureSet().has(feature);
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setAliasTransformationHandler(AliasTransformationHandler changes) {
        this.aliasHandler = changes;
    }

    public AliasTransformationHandler getAliasTransformationHandler() {
        return this.aliasHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public void setInferTypes(boolean enable) {
        this.inferTypes = enable;
    }

    public boolean getInferTypes() {
        return this.inferTypes;
    }

    @Deprecated
    public void setNewTypeInference(boolean enable) {
    }

    public boolean isTypecheckingEnabled() {
        return this.checkTypes;
    }

    public boolean assumeStrictThis() {
        return this.assumeStrictThis;
    }

    public void setAssumeStrictThis(boolean enable) {
        this.assumeStrictThis = enable;
    }

    public boolean assumeClosuresOnlyCaptureReferences() {
        return this.assumeClosuresOnlyCaptureReferences;
    }

    public void setAssumeClosuresOnlyCaptureReferences(boolean enable) {
        this.assumeClosuresOnlyCaptureReferences = enable;
    }

    public void setPropertyInvalidationErrors(Map<String, CheckLevel> propertyInvalidationErrors) {
        this.propertyInvalidationErrors = ImmutableMap.copyOf(propertyInvalidationErrors);
    }

    @Deprecated
    public void setIdeMode(boolean ideMode) {
        this.setChecksOnly(ideMode);
        this.setContinueAfterErrors(ideMode);
        this.setAllowHotswapReplaceScript(ideMode);
        this.setPreserveDetailedSourceInfo(ideMode);
        this.setParseJsDocDocumentation(ideMode ? Config.JsDocParsing.INCLUDE_DESCRIPTIONS_NO_WHITESPACE : Config.JsDocParsing.TYPES_ONLY);
    }

    public void setAllowHotswapReplaceScript(boolean allowRecompilation) {
        this.allowHotswapReplaceScript = allowRecompilation;
    }

    boolean allowsHotswapReplaceScript() {
        return this.allowHotswapReplaceScript;
    }

    public void setPreserveDetailedSourceInfo(boolean preserveDetailedSourceInfo) {
        this.preserveDetailedSourceInfo = preserveDetailedSourceInfo;
    }

    boolean preservesDetailedSourceInfo() {
        return this.preserveDetailedSourceInfo;
    }

    public void setContinueAfterErrors(boolean continueAfterErrors) {
        this.continueAfterErrors = continueAfterErrors;
    }

    boolean canContinueAfterErrors() {
        return this.continueAfterErrors;
    }

    public void setParseJsDocDocumentation(Config.JsDocParsing parseJsDocDocumentation) {
        this.parseJsDocDocumentation = parseJsDocDocumentation;
    }

    public Config.JsDocParsing isParseJsDocDocumentation() {
        return this.parseJsDocDocumentation;
    }

    public void setSkipNonTranspilationPasses(boolean skipNonTranspilationPasses) {
        this.skipNonTranspilationPasses = skipNonTranspilationPasses;
    }

    public void setDevMode(DevMode devMode) {
        this.devMode = devMode;
    }

    public void setCheckDeterminism(boolean checkDeterminism) {
        this.checkDeterminism = checkDeterminism;
    }

    public boolean getCheckDeterminism() {
        return this.checkDeterminism;
    }

    public void setMessageBundle(MessageBundle messageBundle) {
        this.messageBundle = messageBundle;
    }

    public void setCheckSymbols(boolean checkSymbols) {
        this.checkSymbols = checkSymbols;
    }

    public void setCheckSuspiciousCode(boolean checkSuspiciousCode) {
        this.checkSuspiciousCode = checkSuspiciousCode;
    }

    public void setCheckTypes(boolean checkTypes) {
        this.checkTypes = checkTypes;
    }

    public void setCheckMissingGetCssNameBlacklist(String blackList) {
        this.checkMissingGetCssNameBlacklist = blackList;
    }

    public void setFoldConstants(boolean foldConstants) {
        this.foldConstants = foldConstants;
    }

    public void setDeadAssignmentElimination(boolean deadAssignmentElimination) {
        this.deadAssignmentElimination = deadAssignmentElimination;
    }

    public void setInlineConstantVars(boolean inlineConstantVars) {
        this.inlineConstantVars = inlineConstantVars;
    }

    public void setCrossChunkCodeMotion(boolean crossChunkCodeMotion) {
        this.crossChunkCodeMotion = crossChunkCodeMotion;
    }

    @Deprecated
    public void setCrossModuleCodeMotion(boolean crossChunkCodeMotion) {
        this.setCrossChunkCodeMotion(crossChunkCodeMotion);
    }

    public void setCrossChunkCodeMotionNoStubMethods(boolean crossChunkCodeMotionNoStubMethods) {
        this.crossChunkCodeMotionNoStubMethods = crossChunkCodeMotionNoStubMethods;
    }

    @Deprecated
    public void setCrossModuleCodeMotionNoStubMethods(boolean crossChunkCodeMotionNoStubMethods) {
        this.setCrossChunkCodeMotionNoStubMethods(crossChunkCodeMotionNoStubMethods);
    }

    public void setParentChunkCanSeeSymbolsDeclaredInChildren(boolean parentChunkCanSeeSymbolsDeclaredInChildren) {
        this.parentChunkCanSeeSymbolsDeclaredInChildren = parentChunkCanSeeSymbolsDeclaredInChildren;
    }

    @Deprecated
    public void setParentModuleCanSeeSymbolsDeclaredInChildren(boolean parentChunkCanSeeSymbolsDeclaredInChildren) {
        this.setParentChunkCanSeeSymbolsDeclaredInChildren(parentChunkCanSeeSymbolsDeclaredInChildren);
    }

    public void setCrossChunkMethodMotion(boolean crossChunkMethodMotion) {
        this.crossChunkMethodMotion = crossChunkMethodMotion;
    }

    @Deprecated
    public void setCrossModuleMethodMotion(boolean crossChunkMethodMotion) {
        this.setCrossChunkMethodMotion(crossChunkMethodMotion);
    }

    public void setCoalesceVariableNames(boolean coalesceVariableNames) {
        this.coalesceVariableNames = coalesceVariableNames;
    }

    public void setInlineLocalVariables(boolean inlineLocalVariables) {
        this.inlineLocalVariables = inlineLocalVariables;
    }

    public void setFlowSensitiveInlineVariables(boolean enabled) {
        this.flowSensitiveInlineVariables = enabled;
    }

    public void setSmartNameRemoval(boolean smartNameRemoval) {
        this.smartNameRemoval = smartNameRemoval;
        if (smartNameRemoval) {
            this.removeUnusedVars = true;
            this.removeUnusedPrototypeProperties = true;
        }
    }

    public void setExtraSmartNameRemoval(boolean smartNameRemoval) {
        this.extraSmartNameRemoval = smartNameRemoval;
    }

    public void setRemoveDeadCode(boolean removeDeadCode) {
        this.removeDeadCode = removeDeadCode;
    }

    public void setExtractPrototypeMemberDeclarations(boolean enabled) {
        this.extractPrototypeMemberDeclarations = enabled ? ExtractPrototypeMemberDeclarationsMode.USE_GLOBAL_TEMP : ExtractPrototypeMemberDeclarationsMode.OFF;
    }

    public void setExtractPrototypeMemberDeclarations(ExtractPrototypeMemberDeclarationsMode mode) {
        this.extractPrototypeMemberDeclarations = mode;
    }

    public void setRemoveUnusedPrototypeProperties(boolean enabled) {
        this.removeUnusedPrototypeProperties = enabled;
        this.inlineGetters = enabled;
    }

    public void setRemoveUnusedPrototypePropertiesInExterns(boolean enabled) {
        this.removeUnusedPrototypePropertiesInExterns = enabled;
    }

    public void setCollapseVariableDeclarations(boolean enabled) {
        this.collapseVariableDeclarations = enabled;
    }

    public void setCollapseAnonymousFunctions(boolean enabled) {
        this.collapseAnonymousFunctions = enabled;
    }

    public void setAliasableStrings(Set<String> aliasableStrings) {
        this.aliasableStrings = aliasableStrings;
    }

    public void setAliasStringsBlacklist(String aliasStringsBlacklist) {
        this.aliasStringsBlacklist = aliasStringsBlacklist;
    }

    public void setAliasAllStrings(boolean aliasAllStrings) {
        this.aliasAllStrings = aliasAllStrings;
    }

    public void setOutputJsStringUsage(boolean outputJsStringUsage) {
        this.outputJsStringUsage = outputJsStringUsage;
    }

    public void setConvertToDottedProperties(boolean convertToDottedProperties) {
        this.convertToDottedProperties = convertToDottedProperties;
    }

    public void setUseTypesForLocalOptimization(boolean useTypesForLocalOptimization) {
        this.useTypesForLocalOptimization = useTypesForLocalOptimization;
    }

    public boolean shouldUseTypesForLocalOptimization() {
        return this.useTypesForLocalOptimization;
    }

    @Deprecated
    public void setUseTypesForOptimization(boolean useTypesForOptimization) {
        if (useTypesForOptimization) {
            this.disambiguateProperties = useTypesForOptimization;
            this.ambiguateProperties = useTypesForOptimization;
            this.inlineProperties = useTypesForOptimization;
            this.useTypesForLocalOptimization = useTypesForOptimization;
        }
    }

    public void setRewriteFunctionExpressions(boolean rewriteFunctionExpressions) {
        this.rewriteFunctionExpressions = rewriteFunctionExpressions;
    }

    public void setOptimizeCalls(boolean optimizeCalls) {
        this.optimizeCalls = optimizeCalls;
    }

    public void setOptimizeArgumentsArray(boolean optimizeArgumentsArray) {
        this.optimizeArgumentsArray = optimizeArgumentsArray;
    }

    public void setVariableRenaming(VariableRenamingPolicy variableRenaming) {
        this.variableRenaming = variableRenaming;
    }

    public void setPropertyRenaming(PropertyRenamingPolicy propertyRenaming) {
        this.propertyRenaming = propertyRenaming;
    }

    public PropertyRenamingPolicy getPropertyRenaming() {
        return this.propertyRenaming;
    }

    public void setLabelRenaming(boolean labelRenaming) {
        this.labelRenaming = labelRenaming;
    }

    public void setReserveRawExports(boolean reserveRawExports) {
        this.reserveRawExports = reserveRawExports;
    }

    public void setPreferStableNames(boolean preferStableNames) {
        this.preferStableNames = preferStableNames;
    }

    public void setGeneratePseudoNames(boolean generatePseudoNames) {
        this.generatePseudoNames = generatePseudoNames;
    }

    public void setRenamePrefix(String renamePrefix) {
        this.renamePrefix = renamePrefix;
    }

    public String getRenamePrefixNamespace() {
        return this.renamePrefixNamespace;
    }

    public void setRenamePrefixNamespace(String renamePrefixNamespace) {
        this.renamePrefixNamespace = renamePrefixNamespace;
    }

    public void setCollapsePropertiesLevel(PropertyCollapseLevel level) {
        this.collapsePropertiesLevel = level;
    }

    @Deprecated
    public void setCollapseProperties(boolean fullyCollapse) {
        this.collapsePropertiesLevel = fullyCollapse ? PropertyCollapseLevel.ALL : PropertyCollapseLevel.NONE;
    }

    public void setDevirtualizePrototypeMethods(boolean devirtualizePrototypeMethods) {
        this.devirtualizePrototypeMethods = devirtualizePrototypeMethods;
    }

    public void setComputeFunctionSideEffects(boolean computeFunctionSideEffects) {
        this.computeFunctionSideEffects = computeFunctionSideEffects;
    }

    public void setDebugFunctionSideEffectsPath(String debugFunctionSideEffectsPath) {
        this.debugFunctionSideEffectsPath = debugFunctionSideEffectsPath;
    }

    public boolean isDisambiguatePrivateProperties() {
        return this.disambiguatePrivateProperties;
    }

    public void setDisambiguatePrivateProperties(boolean value) {
        this.disambiguatePrivateProperties = value;
    }

    public void setDisambiguateProperties(boolean disambiguateProperties) {
        this.disambiguateProperties = disambiguateProperties;
    }

    public boolean shouldDisambiguateProperties() {
        return this.disambiguateProperties;
    }

    public void setAmbiguateProperties(boolean ambiguateProperties) {
        this.ambiguateProperties = ambiguateProperties;
    }

    public boolean shouldAmbiguateProperties() {
        return this.ambiguateProperties;
    }

    public void setAnonymousFunctionNaming(AnonymousFunctionNamingPolicy anonymousFunctionNaming) {
        this.anonymousFunctionNaming = anonymousFunctionNaming;
    }

    public void setInputAnonymousFunctionNamingMap(VariableMap inputMap) {
        this.inputAnonymousFunctionNamingMap = inputMap;
    }

    public void setInputVariableMap(VariableMap inputVariableMap) {
        this.inputVariableMap = inputVariableMap;
    }

    public void setInputPropertyMap(VariableMap inputPropertyMap) {
        this.inputPropertyMap = inputPropertyMap;
    }

    public void setExportTestFunctions(boolean exportTestFunctions) {
        this.exportTestFunctions = exportTestFunctions;
    }

    public void setRuntimeTypeCheck(boolean runtimeTypeCheck) {
        this.runtimeTypeCheck = runtimeTypeCheck;
    }

    public void setRuntimeTypeCheckLogFunction(String runtimeTypeCheckLogFunction) {
        this.runtimeTypeCheckLogFunction = runtimeTypeCheckLogFunction;
    }

    public void setSyntheticBlockStartMarker(String syntheticBlockStartMarker) {
        this.syntheticBlockStartMarker = syntheticBlockStartMarker;
    }

    public void setSyntheticBlockEndMarker(String syntheticBlockEndMarker) {
        this.syntheticBlockEndMarker = syntheticBlockEndMarker;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setMarkAsCompiled(boolean markAsCompiled) {
        this.markAsCompiled = markAsCompiled;
    }

    public void setClosurePass(boolean closurePass) {
        this.closurePass = closurePass;
    }

    public void setPreserveClosurePrimitives(boolean preserveClosurePrimitives) {
        this.preserveClosurePrimitives = preserveClosurePrimitives;
    }

    @Deprecated
    public void setPreserveGoogProvidesAndRequires(boolean preserveGoogProvidesAndRequires) {
        this.setPreserveClosurePrimitives(preserveGoogProvidesAndRequires);
    }

    public boolean shouldPreservesGoogProvidesAndRequires() {
        return this.preserveClosurePrimitives;
    }

    public boolean shouldPreserveGoogModule() {
        return this.preserveClosurePrimitives;
    }

    public boolean shouldPreserveGoogLibraryPrimitives() {
        return this.preserveClosurePrimitives;
    }

    public void setPreserveTypeAnnotations(boolean preserveTypeAnnotations) {
        this.preserveTypeAnnotations = preserveTypeAnnotations;
    }

    public void setGatherCssNames(boolean gatherCssNames) {
        this.gatherCssNames = gatherCssNames;
    }

    public void setStripTypes(Set<String> stripTypes) {
        this.stripTypes = stripTypes;
    }

    public void setStripNameSuffixes(Set<String> stripNameSuffixes) {
        this.stripNameSuffixes = stripNameSuffixes;
    }

    public void setStripNamePrefixes(Set<String> stripNamePrefixes) {
        this.stripNamePrefixes = stripNamePrefixes;
    }

    public void setStripTypePrefixes(Set<String> stripTypePrefixes) {
        this.stripTypePrefixes = stripTypePrefixes;
    }

    public void addCustomPass(CustomPassExecutionTime time, CompilerPass customPass) {
        if (this.customPasses == null) {
            this.customPasses = LinkedHashMultimap.create();
        }
        this.customPasses.put(time, customPass);
    }

    public void setMarkNoSideEffectCalls(boolean markNoSideEffectCalls) {
        this.markNoSideEffectCalls = markNoSideEffectCalls;
    }

    public void setDefineReplacements(Map<String, Object> defineReplacements) {
        this.defineReplacements = defineReplacements;
    }

    public void setTweakReplacements(Map<String, Object> tweakReplacements) {
        this.tweakReplacements = tweakReplacements;
    }

    public void setMoveFunctionDeclarations(boolean moveFunctionDeclarations) {
        this.moveFunctionDeclarations = moveFunctionDeclarations;
    }

    public void setInstrumentationTemplate(Instrumentation instrumentationTemplate) {
        this.instrumentationTemplate = instrumentationTemplate;
    }

    public void setInstrumentationTemplateFile(String filename) {
        this.instrumentationTemplateFile = filename;
    }

    public void setRecordFunctionInformation(boolean recordFunctionInformation) {
        this.recordFunctionInformation = recordFunctionInformation;
    }

    public void setCssRenamingMap(CssRenamingMap cssRenamingMap) {
        this.cssRenamingMap = cssRenamingMap;
    }

    public void setCssRenamingWhitelist(Set<String> whitelist) {
        this.cssRenamingWhitelist = whitelist;
    }

    public void setReplaceStringsFunctionDescriptions(List<String> replaceStringsFunctionDescriptions) {
        this.replaceStringsFunctionDescriptions = replaceStringsFunctionDescriptions;
    }

    public void setReplaceStringsPlaceholderToken(String replaceStringsPlaceholderToken) {
        this.replaceStringsPlaceholderToken = replaceStringsPlaceholderToken;
    }

    public void setReplaceStringsReservedStrings(Set<String> replaceStringsReservedStrings) {
        this.replaceStringsReservedStrings = replaceStringsReservedStrings;
    }

    public void setReplaceStringsInputMap(VariableMap serializedMap) {
        this.replaceStringsInputMap = serializedMap;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setLineBreak(boolean lineBreak) {
        this.lineBreak = lineBreak;
    }

    public boolean getPreferLineBreakAtEndOfFile() {
        return this.preferLineBreakAtEndOfFile;
    }

    public void setPreferLineBreakAtEndOfFile(boolean lineBreakAtEnd) {
        this.preferLineBreakAtEndOfFile = lineBreakAtEnd;
    }

    public void setPrintInputDelimiter(boolean printInputDelimiter) {
        this.printInputDelimiter = printInputDelimiter;
    }

    public void setInputDelimiter(String inputDelimiter) {
        this.inputDelimiter = inputDelimiter;
    }

    public void setQuoteKeywordProperties(boolean quoteKeywordProperties) {
        this.quoteKeywordProperties = quoteKeywordProperties;
    }

    public boolean shouldQuoteKeywordProperties() {
        if (this.incrementalCheckMode == IncrementalCheckMode.GENERATE_IJS) {
            return false;
        }
        return this.quoteKeywordProperties || FeatureSet.ES3.contains(this.getOutputFeatureSet());
    }

    public void setErrorFormat(ErrorFormat errorFormat) {
        this.errorFormat = errorFormat;
    }

    public ErrorFormat getErrorFormat() {
        return this.errorFormat;
    }

    public void setWarningsGuard(ComposeWarningsGuard warningsGuard) {
        this.warningsGuard = warningsGuard;
    }

    public void setLineLengthThreshold(int lineLengthThreshold) {
        this.lineLengthThreshold = lineLengthThreshold;
    }

    public int getLineLengthThreshold() {
        return this.lineLengthThreshold;
    }

    public void setUseOriginalNamesInOutput(boolean useOriginalNamesInOutput) {
        this.useOriginalNamesInOutput = useOriginalNamesInOutput;
    }

    public boolean getUseOriginalNamesInOutput() {
        return this.useOriginalNamesInOutput;
    }

    public void setExternExports(boolean externExports) {
        this.externExports = externExports;
    }

    public void setExternExportsPath(String externExportsPath) {
        this.externExportsPath = externExportsPath;
    }

    public void setSourceMapOutputPath(String sourceMapOutputPath) {
        this.sourceMapOutputPath = sourceMapOutputPath;
    }

    public void setApplyInputSourceMaps(boolean applyInputSourceMaps) {
        this.applyInputSourceMaps = applyInputSourceMaps;
    }

    public void setResolveSourceMapAnnotations(boolean resolveSourceMapAnnotations) {
        this.resolveSourceMapAnnotations = resolveSourceMapAnnotations;
    }

    public void setSourceMapIncludeSourcesContent(boolean sourceMapIncludeSourcesContent) {
        this.sourceMapIncludeSourcesContent = sourceMapIncludeSourcesContent;
    }

    public void setParseInlineSourceMaps(boolean parseInlineSourceMaps) {
        this.parseInlineSourceMaps = parseInlineSourceMaps;
    }

    public void setSourceMapDetailLevel(SourceMap.DetailLevel sourceMapDetailLevel) {
        this.sourceMapDetailLevel = sourceMapDetailLevel;
    }

    public void setSourceMapFormat(SourceMap.Format sourceMapFormat) {
        this.sourceMapFormat = sourceMapFormat;
    }

    public void setSourceMapLocationMappings(List<? extends SourceMap.LocationMapping> sourceMapLocationMappings) {
        this.sourceMapLocationMappings = sourceMapLocationMappings;
    }

    public void setTransformAMDToCJSModules(boolean transformAMDToCJSModules) {
        this.transformAMDToCJSModules = transformAMDToCJSModules;
    }

    public void setProcessCommonJSModules(boolean processCommonJSModules) {
        this.processCommonJSModules = processCommonJSModules;
    }

    public void setEs6ModuleTranspilation(Es6ModuleTranspilation value) {
        this.es6ModuleTranspilation = value;
    }

    public Es6ModuleTranspilation getEs6ModuleTranspilation() {
        return this.es6ModuleTranspilation;
    }

    public void setCommonJSModulePathPrefix(String commonJSModulePathPrefix) {
        this.setModuleRoots(ImmutableList.of(commonJSModulePathPrefix));
    }

    public void setModuleRoots(List<String> moduleRoots) {
        this.moduleRoots = moduleRoots;
    }

    public void setRewritePolyfills(boolean rewritePolyfills) {
        this.rewritePolyfills = rewritePolyfills;
    }

    public boolean getRewritePolyfills() {
        return this.rewritePolyfills;
    }

    public void setForceLibraryInjection(Iterable<String> libraries) {
        this.forceLibraryInjection = ImmutableList.copyOf(libraries);
    }

    public void setPreventLibraryInjection(boolean preventLibraryInjection) {
        this.preventLibraryInjection = preventLibraryInjection;
    }

    public void setInstrumentForCoverage(boolean instrumentForCoverage) {
        this.instrumentForCoverage = instrumentForCoverage;
    }

    public void setInstrumentBranchCoverage(boolean instrumentBranchCoverage) {
        if (!this.instrumentForCoverage && instrumentBranchCoverage) {
            throw new RuntimeException("The option instrumentForCoverage must be set to true for instrumentBranchCoverage to be set to true.");
        }
        this.instrumentBranchCoverage = instrumentBranchCoverage;
    }

    public final ImmutableList<ConformanceConfig> getConformanceConfigs() {
        return this.conformanceConfigs;
    }

    @GwtIncompatible(value="Conformance")
    public void setConformanceConfig(ConformanceConfig conformanceConfig) {
        this.setConformanceConfigs(ImmutableList.of(conformanceConfig));
    }

    @GwtIncompatible(value="Conformance")
    public void setConformanceConfigs(List<ConformanceConfig> configs) {
        this.conformanceConfigs = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(ResourceLoader.loadGlobalConformance(CompilerOptions.class))).addAll(configs)).build();
    }

    public void clearConformanceConfigs() {
        this.conformanceConfigs = ImmutableList.of();
    }

    public boolean shouldEmitUseStrict() {
        return this.emitUseStrict.or(this.languageOutIsDefaultStrict).or(this.languageIn.isDefaultStrict());
    }

    public CompilerOptions setEmitUseStrict(boolean emitUseStrict) {
        this.emitUseStrict = Optional.of(emitUseStrict);
        return this;
    }

    public ModuleLoader.ResolutionMode getModuleResolutionMode() {
        return this.moduleResolutionMode;
    }

    public void setModuleResolutionMode(ModuleLoader.ResolutionMode moduleResolutionMode) {
        this.moduleResolutionMode = moduleResolutionMode;
    }

    public ImmutableMap<String, String> getBrowserResolverPrefixReplacements() {
        return this.browserResolverPrefixReplacements;
    }

    public void setBrowserResolverPrefixReplacements(ImmutableMap<String, String> browserResolverPrefixReplacements) {
        this.browserResolverPrefixReplacements = browserResolverPrefixReplacements;
    }

    public void setPathEscaper(ModuleLoader.PathEscaper pathEscaper) {
        this.pathEscaper = pathEscaper;
    }

    public ModuleLoader.PathEscaper getPathEscaper() {
        return this.pathEscaper;
    }

    public List<String> getPackageJsonEntryNames() {
        return this.packageJsonEntryNames;
    }

    public void setPackageJsonEntryNames(List<String> names) {
        this.packageJsonEntryNames = names;
    }

    public void setUseSizeHeuristicToStopOptimizationLoop(boolean mayStopEarly) {
        this.useSizeHeuristicToStopOptimizationLoop = mayStopEarly;
    }

    public void setMaxOptimizationLoopIterations(int maxIterations) {
        this.optimizationLoopMaxIterations = maxIterations;
    }

    @GwtIncompatible(value="ObjectOutputStream")
    public void serialize(OutputStream objectOutputStream) throws IOException {
        new ObjectOutputStream(objectOutputStream).writeObject(this);
    }

    @GwtIncompatible(value="ObjectInputStream")
    public static CompilerOptions deserialize(InputStream objectInputStream) throws IOException, ClassNotFoundException {
        return (CompilerOptions)new ObjectInputStream(objectInputStream).readObject();
    }

    public String toString() {
        String strValue = MoreObjects.toStringHelper(this).omitNullValues().add("aggressiveFusion", this.aggressiveFusion).add("aliasableStrings", this.aliasableStrings).add("aliasAllStrings", this.aliasAllStrings).add("aliasHandler", this.getAliasTransformationHandler()).add("aliasStringsBlacklist", this.aliasStringsBlacklist).add("allowHotswapReplaceScript", this.allowsHotswapReplaceScript()).add("ambiguateProperties", this.ambiguateProperties).add("angularPass", this.angularPass).add("anonymousFunctionNaming", (Object)this.anonymousFunctionNaming).add("appNameStr", this.appNameStr).add("assumeClosuresOnlyCaptureReferences", this.assumeClosuresOnlyCaptureReferences).add("assumeStrictThis", this.assumeStrictThis()).add("browserResolverPrefixReplacements", this.browserResolverPrefixReplacements).add("brokenClosureRequiresLevel", this.brokenClosureRequiresLevel).add("checkDeterminism", this.getCheckDeterminism()).add("checkGlobalNamesLevel", this.checkGlobalNamesLevel).add("checkGlobalThisLevel", this.checkGlobalThisLevel).add("checkMissingGetCssNameBlacklist", this.checkMissingGetCssNameBlacklist).add("checkMissingGetCssNameLevel", this.checkMissingGetCssNameLevel).add("checksOnly", this.checksOnly).add("checkSuspiciousCode", this.checkSuspiciousCode).add("checkSymbols", this.checkSymbols).add("checkTypes", this.checkTypes).add("closurePass", this.closurePass).add("coalesceVariableNames", this.coalesceVariableNames).add("codingConvention", this.getCodingConvention()).add("collapseAnonymousFunctions", this.collapseAnonymousFunctions).add("collapseObjectLiterals", this.collapseObjectLiterals).add("collapseProperties", (Object)this.collapsePropertiesLevel).add("collapseVariableDeclarations", this.collapseVariableDeclarations).add("colorizeErrorOutput", this.shouldColorizeErrorOutput()).add("computeFunctionSideEffects", this.computeFunctionSideEffects).add("conformanceConfigs", this.getConformanceConfigs()).add("continueAfterErrors", this.canContinueAfterErrors()).add("convertToDottedProperties", this.convertToDottedProperties).add("crossChunkCodeMotion", this.crossChunkCodeMotion).add("crossChunkCodeMotionNoStubMethods", this.crossChunkCodeMotionNoStubMethods).add("crossChunkMethodMotion", this.crossChunkMethodMotion).add("cssRenamingMap", this.cssRenamingMap).add("cssRenamingWhitelist", this.cssRenamingWhitelist).add("customPasses", this.customPasses).add("dartPass", this.dartPass).add("deadAssignmentElimination", this.deadAssignmentElimination).add("debugFunctionSideEffectsPath", this.debugFunctionSideEffectsPath).add("declaredGlobalExternsOnWindow", this.declaredGlobalExternsOnWindow).add("defineReplacements", this.getDefineReplacements()).add("dependencyOptions", this.dependencyOptions).add("devirtualizePrototypeMethods", this.devirtualizePrototypeMethods).add("devMode", (Object)this.devMode).add("disambiguatePrivateProperties", this.disambiguatePrivateProperties).add("disambiguateProperties", this.disambiguateProperties).add("enforceAccessControlCodingConventions", this.enforceAccessControlCodingConventions).add("environment", (Object)this.getEnvironment()).add("errorFormat", (Object)this.errorFormat).add("errorHandler", this.errorHandler).add("es6ModuleTranspilation", (Object)this.es6ModuleTranspilation).add("exportLocalPropertyDefinitions", this.exportLocalPropertyDefinitions).add("exportTestFunctions", this.exportTestFunctions).add("externExports", this.isExternExportsEnabled()).add("externExportsPath", this.externExportsPath).add("extraAnnotationNames", this.extraAnnotationNames).add("extractPrototypeMemberDeclarations", (Object)this.extractPrototypeMemberDeclarations).add("extraSmartNameRemoval", this.extraSmartNameRemoval).add("filesToPrintAfterEachPassRegexList", this.filesToPrintAfterEachPassRegexList).add("flowSensitiveInlineVariables", this.flowSensitiveInlineVariables).add("foldConstants", this.foldConstants).add("forceLibraryInjection", this.forceLibraryInjection).add("gatherCssNames", this.gatherCssNames).add("generateExportsAfterTypeChecking", this.generateExportsAfterTypeChecking).add("generateExports", this.generateExports).add("generatePseudoNames", this.generatePseudoNames).add("generateTypedExterns", this.shouldGenerateTypedExterns()).add("idGenerators", this.idGenerators).add("idGeneratorsMapSerialized", this.idGeneratorsMapSerialized).add("incrementalCheckMode", (Object)this.incrementalCheckMode).add("inferConsts", this.inferConsts).add("inferTypes", this.inferTypes).add("inlineConstantVars", this.inlineConstantVars).add("inlineFunctionsLevel", (Object)this.inlineFunctionsLevel).add("inlineGetters", this.inlineGetters).add("inlineLocalVariables", this.inlineLocalVariables).add("inlineProperties", this.inlineProperties).add("inlineVariables", this.inlineVariables).add("inputAnonymousFunctionNamingMap", this.inputAnonymousFunctionNamingMap).add("inputDelimiter", this.inputDelimiter).add("inputPropertyMap", this.inputPropertyMap).add("inputSourceMaps", this.inputSourceMaps).add("inputVariableMap", this.inputVariableMap).add("instrumentationTemplateFile", this.instrumentationTemplateFile).add("instrumentationTemplate", this.instrumentationTemplate).add("instrumentForCoverage", this.instrumentForCoverage).add("instrumentForCoverageOnly", this.instrumentForCoverageOnly).add("instrumentBranchCoverage", this.instrumentBranchCoverage).add("j2clPassMode", (Object)this.j2clPassMode).add("labelRenaming", this.labelRenaming).add("languageIn", (Object)this.getLanguageIn()).add("languageOutIsDefaultStrict", this.languageOutIsDefaultStrict).add("legacyCodeCompile", this.legacyCodeCompile).add("lineBreak", this.lineBreak).add("lineLengthThreshold", this.lineLengthThreshold).add("locale", this.locale).add("markAsCompiled", this.markAsCompiled).add("markNoSideEffectCalls", this.markNoSideEffectCalls).add("maxFunctionSizeAfterInlining", this.maxFunctionSizeAfterInlining).add("messageBundle", this.messageBundle).add("moduleRoots", this.moduleRoots).add("chunksToPrintAfterEachPassRegexList", this.chunksToPrintAfterEachPassRegexList).add("moveFunctionDeclarations", this.moveFunctionDeclarations).add("nameGenerator", this.nameGenerator).add("optimizeArgumentsArray", this.optimizeArgumentsArray).add("optimizeCalls", this.optimizeCalls).add("outputCharset", this.outputCharset).add("outputFeatureSet", this.outputFeatureSet).add("outputJs", (Object)this.outputJs).add("outputJsStringUsage", this.outputJsStringUsage).add("parentChunkCanSeeSymbolsDeclaredInChildren", this.parentChunkCanSeeSymbolsDeclaredInChildren).add("parseJsDocDocumentation", (Object)this.isParseJsDocDocumentation()).add("pathEscaper", (Object)this.pathEscaper).add("polymerVersion", this.polymerVersion).add("polymerExportPolicy", (Object)this.polymerExportPolicy).add("preferLineBreakAtEndOfFile", this.preferLineBreakAtEndOfFile).add("preferSingleQuotes", this.preferSingleQuotes).add("preferStableNames", this.preferStableNames).add("preserveDetailedSourceInfo", this.preservesDetailedSourceInfo()).add("preserveGoogProvidesAndRequires", this.preserveClosurePrimitives).add("preserveTypeAnnotations", this.preserveTypeAnnotations).add("prettyPrint", this.prettyPrint).add("preventLibraryInjection", this.preventLibraryInjection).add("printConfig", this.printConfig).add("printInputDelimiter", this.printInputDelimiter).add("printSourceAfterEachPass", this.printSourceAfterEachPass).add("processCommonJSModules", this.processCommonJSModules).add("processObjectPropertyString", this.processObjectPropertyString).add("propertyInvalidationErrors", this.propertyInvalidationErrors).add("propertyRenaming", (Object)this.propertyRenaming).add("protectHiddenSideEffects", this.protectHiddenSideEffects).add("quoteKeywordProperties", this.quoteKeywordProperties).add("recordFunctionInformation", this.recordFunctionInformation).add("removeAbstractMethods", this.removeAbstractMethods).add("removeSuperMethods", this.removeSuperMethods).add("removeClosureAsserts", this.removeClosureAsserts).add("removeJ2clAsserts", this.removeJ2clAsserts).add("removeDeadCode", this.removeDeadCode).add("removeUnusedClassProperties", this.removeUnusedClassProperties).add("removeUnusedConstructorProperties", this.removeUnusedConstructorProperties).add("removeUnusedLocalVars", this.removeUnusedLocalVars).add("removeUnusedPrototypePropertiesInExterns", this.removeUnusedPrototypePropertiesInExterns).add("removeUnusedPrototypeProperties", this.removeUnusedPrototypeProperties).add("removeUnusedVars", this.removeUnusedVars).add("renamePrefixNamespaceAssumeCrossChunkNames", this.renamePrefixNamespaceAssumeCrossChunkNames).add("renamePrefixNamespace", this.renamePrefixNamespace).add("renamePrefix", this.renamePrefix).add("replaceIdGenerators", this.replaceIdGenerators).add("replaceMessagesWithChromeI18n", this.replaceMessagesWithChromeI18n).add("replaceStringsFunctionDescriptions", this.replaceStringsFunctionDescriptions).add("replaceStringsInputMap", this.replaceStringsInputMap).add("replaceStringsPlaceholderToken", this.replaceStringsPlaceholderToken).add("replaceStringsReservedStrings", this.replaceStringsReservedStrings).add("reserveRawExports", this.reserveRawExports).add("rewriteFunctionExpressions", this.rewriteFunctionExpressions).add("rewritePolyfills", this.rewritePolyfills).add("runtimeTypeCheckLogFunction", this.runtimeTypeCheckLogFunction).add("runtimeTypeCheck", this.runtimeTypeCheck).add("shadowVariables", this.shadowVariables).add("skipNonTranspilationPasses", this.skipNonTranspilationPasses).add("smartNameRemoval", this.smartNameRemoval).add("sourceMapDetailLevel", this.sourceMapDetailLevel).add("sourceMapFormat", (Object)this.sourceMapFormat).add("sourceMapLocationMappings", this.sourceMapLocationMappings).add("sourceMapOutputPath", this.sourceMapOutputPath).add("stripNamePrefixes", this.stripNamePrefixes).add("stripNameSuffixes", this.stripNameSuffixes).add("stripTypePrefixes", this.stripTypePrefixes).add("stripTypes", this.stripTypes).add("summaryDetailLevel", this.summaryDetailLevel).add("syntheticBlockEndMarker", this.syntheticBlockEndMarker).add("syntheticBlockStartMarker", this.syntheticBlockStartMarker).add("tcProjectId", this.tcProjectId).add("tracer", (Object)this.tracer).add("transformAMDToCJSModules", this.transformAMDToCJSModules).add("trustedStrings", this.trustedStrings).add("tweakProcessing", (Object)this.getTweakProcessing()).add("tweakReplacements", this.getTweakReplacements()).add("emitUseStrict", this.emitUseStrict).add("useTypesForLocalOptimization", this.useTypesForLocalOptimization).add("variableRenaming", (Object)this.variableRenaming).add("warningsGuard", this.getWarningsGuard()).add("wrapGoogModulesForWhitespaceOnly", this.wrapGoogModulesForWhitespaceOnly).toString();
        return strValue;
    }

    public boolean expectStrictModeInput() {
        return this.isStrictModeInput.or(this.getLanguageIn().isDefaultStrict());
    }

    public CompilerOptions setStrictModeInput(boolean isStrictModeInput) {
        this.isStrictModeInput = Optional.of(isStrictModeInput);
        return this;
    }

    public char[] getPropertyReservedNamingFirstChars() {
        char[] reservedChars = this.anonymousFunctionNaming.getReservedCharacters();
        if (this.polymerVersion != null && this.polymerVersion > 1) {
            reservedChars = reservedChars == null ? POLYMER_PROPERTY_RESERVED_FIRST_CHARS : Chars.concat(reservedChars, POLYMER_PROPERTY_RESERVED_FIRST_CHARS);
        } else if (this.angularPass) {
            reservedChars = reservedChars == null ? ANGULAR_PROPERTY_RESERVED_FIRST_CHARS : Chars.concat(reservedChars, ANGULAR_PROPERTY_RESERVED_FIRST_CHARS);
        }
        return reservedChars;
    }

    public char[] getPropertyReservedNamingNonFirstChars() {
        char[] reservedChars = this.anonymousFunctionNaming.getReservedCharacters();
        if (this.polymerVersion != null && this.polymerVersion > 1) {
            reservedChars = reservedChars == null ? POLYMER_PROPERTY_RESERVED_NON_FIRST_CHARS : Chars.concat(reservedChars, POLYMER_PROPERTY_RESERVED_NON_FIRST_CHARS);
        }
        return reservedChars;
    }

    @GwtIncompatible(value="ObjectOutputStream")
    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        out.defaultWriteObject();
        out.writeObject(this.outputCharset == null ? null : this.outputCharset.name());
    }

    @GwtIncompatible(value="ObjectInputStream")
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String outputCharsetName = (String)in.readObject();
        if (outputCharsetName != null) {
            this.outputCharset = Charset.forName(outputCharsetName);
        }
    }

    boolean shouldOptimize() {
        return !this.skipNonTranspilationPasses && !this.checksOnly && !this.shouldGenerateTypedExterns() && !this.instrumentForCoverageOnly;
    }

    public static enum J2clPassMode {
        OFF,
        AUTO;


        boolean shouldAddJ2clPasses() {
            return this == AUTO;
        }
    }

    public static enum DependencyMode {
        NONE,
        LOOSE,
        STRICT;

    }

    static enum JsonStreamMode {
        NONE,
        IN,
        OUT,
        BOTH;

    }

    public static enum Environment {
        BROWSER,
        CUSTOM;

    }

    private static class NullAliasTransformationHandler
    implements AliasTransformationHandler {
        private static final AliasTransformation NULL_ALIAS_TRANSFORMATION = new NullAliasTransformation();

        private NullAliasTransformationHandler() {
        }

        @Override
        public AliasTransformation logAliasTransformation(String sourceFile, SourcePosition<AliasTransformation> position) {
            position.setItem(NULL_ALIAS_TRANSFORMATION);
            return NULL_ALIAS_TRANSFORMATION;
        }

        private static class NullAliasTransformation
        implements AliasTransformation {
            private NullAliasTransformation() {
            }

            @Override
            public void addAlias(String alias, String definition) {
            }
        }
    }

    public static interface AliasTransformation {
        public void addAlias(String var1, String var2);
    }

    public static interface AliasTransformationHandler {
        public AliasTransformation logAliasTransformation(String var1, SourcePosition<AliasTransformation> var2);
    }

    public static enum IsolationMode {
        NONE,
        IIFE;

    }

    public static enum TweakProcessing {
        OFF,
        CHECK,
        STRIP;


        public boolean isOn() {
            return this != OFF;
        }

        public boolean shouldStrip() {
            return this == STRIP;
        }
    }

    public static enum TracerMode {
        ALL,
        RAW_SIZE,
        AST_SIZE,
        TIMING_ONLY,
        OFF;


        boolean isOn() {
            return this != OFF;
        }
    }

    public static enum DevMode {
        OFF,
        START,
        START_AND_END,
        EVERY_PASS;

    }

    public static enum LanguageMode {
        ECMASCRIPT3,
        ECMASCRIPT5,
        ECMASCRIPT5_STRICT,
        ECMASCRIPT_2015,
        ECMASCRIPT6_TYPED,
        ECMASCRIPT_2016,
        ECMASCRIPT_2017,
        ECMASCRIPT_2018,
        ECMASCRIPT_NEXT,
        STABLE,
        NO_TRANSPILE;

        public static final LanguageMode STABLE_IN;
        public static final LanguageMode STABLE_OUT;

        boolean isDefaultStrict() {
            switch (this) {
                case ECMASCRIPT3: 
                case ECMASCRIPT5: {
                    return false;
                }
            }
            return true;
        }

        public static LanguageMode fromString(String value) {
            if (value == null) {
                return null;
            }
            String canonicalizedName = Ascii.toUpperCase(value.trim()).replaceFirst("^ES", "ECMASCRIPT");
            if (canonicalizedName.equals("ECMASCRIPT6") || canonicalizedName.equals("ECMASCRIPT6_STRICT")) {
                return ECMASCRIPT_2015;
            }
            try {
                return LanguageMode.valueOf(canonicalizedName);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public FeatureSet toFeatureSet() {
            switch (this) {
                case ECMASCRIPT3: {
                    return FeatureSet.ES3;
                }
                case ECMASCRIPT5: 
                case ECMASCRIPT5_STRICT: {
                    return FeatureSet.ES5;
                }
                case ECMASCRIPT_2015: {
                    return FeatureSet.ES6_MODULES;
                }
                case ECMASCRIPT_2016: {
                    return FeatureSet.ES7_MODULES;
                }
                case ECMASCRIPT_2017: {
                    return FeatureSet.ES8_MODULES;
                }
                case ECMASCRIPT_2018: {
                    return FeatureSet.ES2018_MODULES;
                }
                case ECMASCRIPT_NEXT: 
                case NO_TRANSPILE: {
                    return FeatureSet.ES_NEXT;
                }
                case ECMASCRIPT6_TYPED: {
                    return FeatureSet.TYPESCRIPT;
                }
                case STABLE: {
                    throw new UnsupportedOperationException("STABLE has different feature sets for language in and out. Use STABLE_IN or STABLE_OUT.");
                }
            }
            throw new IllegalStateException();
        }

        static {
            STABLE_IN = ECMASCRIPT_2017;
            STABLE_OUT = ECMASCRIPT5;
        }
    }

    public static enum Es6ModuleTranspilation {
        NONE,
        RELATIVIZE_IMPORT_PATHS,
        TO_COMMON_JS_LIKE_MODULES,
        COMPILE;

    }

    public static enum OutputJs {
        NONE,
        SENTINEL,
        NORMAL;

    }

    public static enum ExtractPrototypeMemberDeclarationsMode {
        OFF,
        USE_GLOBAL_TEMP,
        USE_IIFE;

    }

    @Deprecated
    public static enum DisposalCheckingPolicy {
        OFF,
        ON,
        AGGRESSIVE;

    }

    public static enum IncrementalCheckMode {
        OFF,
        GENERATE_IJS,
        RUN_IJS_CHECKS_LATE;

    }

    public static enum PropertyCollapseLevel {
        ALL,
        NONE,
        MODULE_EXPORT;

    }

    public static enum Reach {
        ALL,
        LOCAL_ONLY,
        NONE;


        public boolean isOn() {
            return this != NONE;
        }

        public boolean includesGlobals() {
            return this == ALL;
        }
    }
}

