/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerOptions;

final class CompilerOptionsPreprocessor {
    static void preprocess(CompilerOptions options) {
        if (options.checkMissingGetCssNameLevel.isOn() && (options.checkMissingGetCssNameBlacklist == null || options.checkMissingGetCssNameBlacklist.isEmpty())) {
            throw new InvalidOptionsException("Cannot check use of goog.getCssName because of empty blacklist.", new Object[0]);
        }
        if (options.removeUnusedPrototypePropertiesInExterns && !options.removeUnusedPrototypeProperties) {
            throw new InvalidOptionsException("remove_unused_prototype_properties_in_externs requires remove_unused_prototype_properties to be turned on.", new Object[0]);
        }
        if (options.getLanguageIn() != options.getLanguageOut() && !options.getLanguageIn().isEs6OrHigher() && !options.getAllowEs6Out()) {
            throw new InvalidOptionsException("Can only convert code from ES6 to a lower ECMAScript version. Cannot convert from %s to %s.", new Object[]{options.getLanguageIn(), options.getLanguageOut()});
        }
        if (options.getLanguageOut().isEs6OrHigher() && !options.getAllowEs6Out()) {
            throw new InvalidOptionsException("ES6 is only supported for transpilation to a lower ECMAScript version. Set --language_out to ES3, ES5, or ES5_strict.", new Object[0]);
        }
        if (!options.inlineFunctions && options.maxFunctionSizeAfterInlining != -1) {
            throw new InvalidOptionsException("max_function_size_after_inlining has no effect if inlining is disabled.", new Object[0]);
        }
        if (options.useNewTypeInference) {
            options.checkTypes = false;
            options.inferTypes = false;
            options.checkMissingReturn = CheckLevel.OFF;
            options.checkGlobalThisLevel = CheckLevel.OFF;
        }
        if (options.jqueryPass && options.closurePass) {
            throw new InvalidOptionsException("The jQuery pass and the Closure pass cannot both be enabled.", new Object[0]);
        }
        if (options.removeUnusedPrototypePropertiesInExterns && options.exportLocalPropertyDefinitions) {
            throw new InvalidOptionsException("remove_unused_prototype_properties_in_externs and export_local_property_definitions cannot be used together.", new Object[0]);
        }
    }

    private CompilerOptionsPreprocessor() {
    }

    public static class InvalidOptionsException
    extends RuntimeException {
        private InvalidOptionsException(String message, Object ... args) {
            super(String.format(message, args));
        }
    }
}

